/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.column;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.column.ColumnPair;
import ch.javasoft.metabolic.efm.memory.IndexableMemory;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.util.IntArray;
import java.io.IOException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdjCandidates<Col extends Column> {
    private final IndexableMemory<Col> posMemory;
    private final IndexableMemory<Col> negMemory;
    private final IntArray posIndices;
    private final IntArray negIndices;

    public AdjCandidates(IndexableMemory<Col> posMemory, IndexableMemory<Col> negMemory, int capacity) {
        this.posMemory = posMemory;
        this.negMemory = negMemory;
        this.posIndices = new IntArray(capacity);
        this.negIndices = new IntArray(capacity);
    }

    public void add(IndexableMemory<Col> memoryA, int indexA, IndexableMemory<Col> memoryB, int indexB) {
        if (memoryA == this.posMemory) {
            this.posIndices.add(indexA);
            this.negIndices.add(indexB);
        } else {
            this.posIndices.add(indexB);
            this.negIndices.add(indexA);
        }
    }

    public void add(AdjCandidates<Col> candidates, int index) {
        this.posIndices.add(candidates.posIndices.get(index));
        this.negIndices.add(candidates.negIndices.get(index));
    }

    public void addAll(AdjCandidates<Col> candidates) {
        this.posIndices.addAll(candidates.posIndices);
        this.negIndices.addAll(candidates.negIndices);
    }

    public int size() {
        return this.posIndices.length();
    }

    public int getColumnIndexPos(int pairIndex) throws IOException {
        return this.posIndices.get(pairIndex);
    }

    public int getColumnIndexNeg(int pairIndex) throws IOException {
        return this.negIndices.get(pairIndex);
    }

    public Col getColumnPos(int pairIndex) throws IOException {
        return this.posMemory.getColumn(this.posIndices.get(pairIndex));
    }

    public Col getColumnNeg(int pairIndex) throws IOException {
        return this.negMemory.getColumn(this.negIndices.get(pairIndex));
    }

    public boolean isAncestor(int pairIndex, IndexableMemory<Col> ancestorMemory, int ancestorIndex) {
        if (ancestorMemory == this.posMemory) {
            return this.posIndices.get(pairIndex) == ancestorIndex;
        }
        if (ancestorMemory == this.negMemory) {
            return this.negIndices.get(pairIndex) == ancestorIndex;
        }
        return false;
    }

    public IBitSet getIntersection(int pairIndex) throws IOException {
        Col colPos = this.getColumnPos(pairIndex);
        Col colNeg = this.getColumnNeg(pairIndex);
        return colPos.bitValues().getAnd(colNeg.bitValues());
    }

    public int getIntersectionCardinality(int pairIndex) throws IOException {
        Col colPos = this.getColumnPos(pairIndex);
        Col colNeg = this.getColumnNeg(pairIndex);
        return colPos.bitValues().getAndCardinality(colNeg.bitValues());
    }

    public boolean hasSuperSet(int pairIndex, IndexableMemory<Col> supMemory, int superIndexStart, int superIndexEnd) throws IOException {
        IBitSet setP = this.getColumnPos(pairIndex).bitValues();
        IBitSet setN = this.getColumnNeg(pairIndex).bitValues();
        int i = superIndexStart;
        while (i < superIndexEnd) {
            Col colSup;
            if (!this.isAncestor(pairIndex, supMemory, i) && (colSup = supMemory.getColumn(i)).bitValues().isSuperSetOfIntersection(setP, setN)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void swap(int pairIndexA, int pairIndexB) {
        this.posIndices.swap(pairIndexA, pairIndexB);
        this.negIndices.swap(pairIndexA, pairIndexB);
    }

    public void removeLast() {
        this.posIndices.removeLast();
        this.negIndices.removeLast();
    }

    public void removeAll() {
        this.posIndices.clear();
        this.negIndices.clear();
    }

    public <N extends Number> void appendLastColumn(ColumnHome<N, Col> columnHome, EfmModel efmModel, AdjEnumModel<Col> adjModel) throws IOException {
        int i = this.posIndices.length() - 1;
        Col colA = this.getColumnPos(i);
        Col colB = this.getColumnNeg(i);
        Col colN = colA.mergeWith(columnHome, efmModel, colB, adjModel);
        adjModel.getMemoryForNewFromAdj().appendColumn(colN);
        this.removeLast();
    }

    public <N extends Number> void appendNewColumns(ColumnHome<N, Col> columnHome, EfmModel efmModel, AdjEnumModel<Col> adjModel) throws IOException {
        int i = 0;
        while (i < this.posIndices.length()) {
            Col colA = this.getColumnPos(i);
            Col colB = this.getColumnNeg(i);
            Col colN = colA.mergeWith(columnHome, efmModel, colB, adjModel);
            adjModel.getMemoryForNewFromAdj().appendColumn(colN);
            ++i;
        }
    }

    public void appendPairsTo(Collection<ColumnPair> dst) throws IOException {
        int i = 0;
        while (i < this.posIndices.length()) {
            ColumnPair<Col> pair = new ColumnPair<Col>(this.getColumnPos(i), this.getColumnNeg(i));
            dst.add(pair);
            ++i;
        }
    }

    public void appendPairTo(Collection<ColumnPair> dst, int index) throws IOException {
        ColumnPair<Col> pair = new ColumnPair<Col>(this.getColumnPos(index), this.getColumnNeg(index));
        dst.add(pair);
    }
}

