/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.borndie.job;

import ch.javasoft.metabolic.efm.borndie.BornDieController;
import ch.javasoft.metabolic.efm.borndie.job.PairingJob;
import ch.javasoft.metabolic.efm.column.Column;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobManager<Col extends Column> {
    private final BornDieController<Col> controller;
    private final ThreadPoolExecutor service;
    private static Comparator<Runnable> JOB_PRIORITIZER = new Comparator<Runnable>(){

        @Override
        public int compare(Runnable o1, Runnable o2) {
            PairingJob job1 = (PairingJob)o1;
            PairingJob job2 = (PairingJob)o2;
            long dCnt = 0L;
            try {
                long cnt1 = (long)job1.getMemoryNeg().getColumnCount() * (long)job1.getMemoryPos().getColumnCount();
                long cnt2 = (long)job2.getMemoryNeg().getColumnCount() * (long)job2.getMemoryPos().getColumnCount();
                dCnt = cnt1 - cnt2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dCnt != 0L) {
                return dCnt < 0L ? 1 : -1;
            }
            return 0;
        }
    };

    public JobManager(BornDieController<Col> controller) {
        this(controller, 0);
    }

    public JobManager(BornDieController<Col> controller, int queueCapacity) {
        this.controller = controller;
        this.service = JobManager.createExecutorService(controller.getConfig().getMaxThreads(), queueCapacity);
    }

    private static ThreadPoolExecutor createExecutorService(int threadCount, int queueCapacity) {
        return queueCapacity == 0 ? new ThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()) : new ThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueCapacity));
    }

    public void addJob(PairingJob<Col> pairingJob) throws InterruptedException {
        this.schedule(pairingJob);
        if (this.controller.getDebugger().doDebug()) {
            this.controller.getDebugger().notifyPairingQueued(pairingJob);
        }
    }

    private void schedule(PairingJob<Col> pairingJob) {
        this.schedule((Runnable)pairingJob);
    }

    public void schedule(Runnable command) {
        try {
            this.service.execute(command);
        }
        catch (RejectedExecutionException ex) {
            if (this.controller.getException() != null) {
                throw new RejectedExecutionException(this.controller.getException());
            }
            throw ex;
        }
    }

    public void schedule(final Callable<Void> command) {
        this.schedule(new Runnable(){

            public void run() {
                try {
                    command.call();
                }
                catch (Exception e) {
                    JobManager.this.controller.handleCommandException(e);
                }
            }
        });
    }

    public void terminate() throws Exception {
        if (this.controller.getException() != null) {
            throw this.controller.getException();
        }
        this.service.awaitTermination(0L, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return "JobManager{done=" + this.service.getCompletedTaskCount() + ", active=" + this.service.getActiveCount() + ", total=" + this.service.getTaskCount() + "}";
    }
}

