/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.borndie;

import ch.javasoft.metabolic.efm.borndie.LogPkg;
import ch.javasoft.metabolic.efm.borndie.debug.Debugger;
import ch.javasoft.metabolic.efm.borndie.debug.NullDebugger;
import ch.javasoft.metabolic.efm.borndie.job.JobFailedException;
import ch.javasoft.metabolic.efm.borndie.job.JobManager;
import ch.javasoft.metabolic.efm.borndie.job.PairingJob;
import ch.javasoft.metabolic.efm.borndie.matrix.BornDieMatrix;
import ch.javasoft.metabolic.efm.borndie.matrix.ConcurrentBornDieMatrix;
import ch.javasoft.metabolic.efm.borndie.memory.ColumnDemuxAppendableMemory;
import ch.javasoft.metabolic.efm.borndie.model.BornDieEfmModel;
import ch.javasoft.metabolic.efm.borndie.range.DefaultCellRange;
import ch.javasoft.metabolic.efm.borndie.range.LowerTriangularMatrix;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.memory.ComposedIterableMemory;
import ch.javasoft.metabolic.efm.memory.IterableMemory;
import ch.javasoft.metabolic.efm.memory.MemoryFactory;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import ch.javasoft.util.logging.Loggers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BornDieController<Col extends Column> {
    private final Logger LOG = LogPkg.LOGGER;
    private final Debugger debugger;
    private final ColumnHome<?, Col> columnHome;
    private final Config config;
    private final BornDieEfmModel model;
    private final MemoryFactory memoryFactory;
    private final BornDieMatrix<Col> matrix;
    private final JobManager<Col> jobManager;
    private final AtomicReference<Exception> exception;
    private final CyclicBarrier barrier;
    private final AtomicLong time;

    public BornDieController(ColumnHome<?, Col> columnHome, Config config, BornDieEfmModel model, MemoryFactory memoryFactory) throws IOException {
        LowerTriangularMatrix tril = new LowerTriangularMatrix(model.getIterationCount() + 1);
        this.columnHome = columnHome;
        this.config = config;
        this.debugger = NullDebugger.INSTANCE;
        this.model = model;
        this.memoryFactory = memoryFactory;
        this.matrix = new ConcurrentBornDieMatrix(this, tril);
        this.jobManager = new JobManager(this);
        this.exception = new AtomicReference();
        this.barrier = new CyclicBarrier(2);
        this.time = new AtomicLong(System.currentTimeMillis());
    }

    public ColumnHome<?, Col> getColumnHome() {
        return this.columnHome;
    }

    public Config getConfig() {
        return this.config;
    }

    public NetworkEfmModel getModel() {
        return this.model;
    }

    public MemoryFactory getMemoryFactory() {
        return this.memoryFactory;
    }

    public BornDieMatrix<Col> getMatrix() {
        return this.matrix;
    }

    public int getIterationCount() {
        return this.model.getIterationCount();
    }

    public void addPairingJob(PairingJob<Col> job) {
        try {
            this.jobManager.addJob(job);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void start(IterableMemory<Col> initialColumns) throws IOException {
        ColumnDemuxAppendableMemory<Column> memory = new ColumnDemuxAppendableMemory<Column>(this, 0);
        for (Column col : initialColumns) {
            memory.appendColumn(col);
        }
        this.matrix.notifyInitialColumnComplete();
    }

    public void terminate() throws IOException {
        try {
            this.barrier.await();
            long now = System.currentTimeMillis();
            long then = this.time.getAndSet(now);
            LowerTriangularMatrix tril = this.matrix.getMatrixRange();
            int lastCol = tril.getColumnCount() - 1;
            int modeCount = this.matrix.getColumnCount(lastCol, tril.getRowTo(lastCol) - 1);
            this.LOG.info("column " + lastCol + " of [0.." + lastCol + "] complete, " + modeCount + " new feasible modes, dt=" + (now - then) + "ms.");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IterableMemory<Col> awaitTermination() throws IOException {
        try {
            this.barrier.await();
            this.jobManager.terminate();
        }
        catch (RuntimeException e) {
            if (this.debugger.doDebug()) {
                this.debugger.notifyException(e);
            }
            throw e;
        }
        catch (IOException e) {
            if (this.debugger.doDebug()) {
                this.debugger.notifyException(e);
            }
            throw e;
        }
        catch (Exception e) {
            if (this.debugger.doDebug()) {
                this.debugger.notifyException(e);
            }
            throw new RuntimeException(e);
        }
        int len = this.matrix.getMatrixRange().getLength();
        ArrayList<IterableMemory<Col>> lastRow = new ArrayList<IterableMemory<Col>>(len);
        int i = 0;
        while (i < len) {
            lastRow.add(this.matrix.getFinal(i));
            ++i;
        }
        ComposedIterableMemory res = new ComposedIterableMemory(lastRow);
        this.debugger.notifyTerminate(this.jobManager, res);
        if (Loggers.isLoggable(this.LOG, Level.FINE)) {
            this.LOG.fine(this.jobManager.toString());
        }
        return res;
    }

    public void switchColumnToBearingStage(int bornColumn) throws IOException {
        long now = System.currentTimeMillis();
        long then = this.time.getAndSet(now);
        LowerTriangularMatrix tril = this.matrix.getMatrixRange();
        int activeRows = Math.max(0, tril.getColumnHeight(bornColumn) - 2);
        int adjThreads = this.config.getMaxThreads() >>> Math.min(31 - Integer.numberOfLeadingZeros(this.config.getMaxThreads()), activeRows);
        this.model.setAdjEnumThreads(Math.max(1, adjThreads));
        int rowFrom = tril.getRowFrom(bornColumn);
        int rowTo = tril.getRowTo(bornColumn);
        int modeCountTotal = 0;
        int r = rowFrom;
        while (r < rowTo) {
            int modeCount = this.matrix.getColumnCount(bornColumn, r);
            modeCountTotal += modeCount;
            if (tril.isFinalRow(r)) {
                this.LOG.info("column " + bornColumn + " of [0.." + (tril.getColumnCount() - 1) + "] now bearing, with " + this.model.getAdjEnumThreads() + " threads and " + modeCountTotal + " modes, " + modeCount + " new feasible, dt=" + (now - then) + "ms.");
            } else if (Loggers.isLoggable(this.LOG, Level.FINEST)) {
                this.LOG.finer("cell " + new DefaultCellRange(bornColumn, r) + " has collected all modes: " + this.matrix.getColumnCount(bornColumn, r));
            }
            ++r;
        }
        r = rowFrom;
        while (r < rowTo) {
            if (!tril.isFinalRow(r)) {
                this.matrix.schedulePairingJobs(bornColumn, r, 0, bornColumn + 1);
            }
            ++r;
        }
        int c = 0;
        while (c < bornColumn) {
            int rFrom = tril.getRowFrom(bornColumn);
            int rTo = tril.getRowTo(c);
            int r2 = rFrom;
            while (r2 < rTo) {
                if (!tril.isFinalRow(r2)) {
                    this.matrix.schedulePairingJobs(c, r2, bornColumn, bornColumn + 1);
                }
                ++r2;
            }
            ++c;
        }
    }

    public void handleJobException(PairingJob<Col> job, Exception e) {
        this.handleCommandException(new JobFailedException(job, (Throwable)e));
    }

    public void handleCommandException(Exception e) {
        this.exception.compareAndSet(null, e);
        try {
            this.terminate();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Exception getException() {
        return this.exception.get();
    }

    public Debugger getDebugger() {
        return this.debugger;
    }
}

