/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree;

import ch.javasoft.metabolic.efm.adj.incore.tree.InterNode;
import ch.javasoft.metabolic.efm.adj.incore.tree.Node;
import ch.javasoft.metabolic.efm.adj.incore.tree.PoolToken;
import ch.javasoft.metabolic.efm.adj.incore.tree.Root;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnPair;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.EfmModel;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CyclicBarrier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolToken
implements PoolToken {
    private final int threadCount;
    private final Queue<Runnable> jobs = new ConcurrentLinkedQueue<Runnable>();
    private final CyclicBarrier barrier;
    private int jobCount = 0;
    private static final int MAX_LEVEL_DEPTH = 6;

    public ThreadPoolToken(EfmModel efmModel) {
        this.threadCount = efmModel.getAdjEnumThreads();
        this.barrier = new CyclicBarrier(this.threadCount);
        int i = 1;
        while (i < this.threadCount) {
            new Thread(){

                public void run() {
                    ThreadPoolToken.this.enterThreadLoop();
                }
            }.start();
            ++i;
        }
    }

    private void enterThreadLoop() {
        while (true) {
            Runnable job;
            if ((job = this.jobs.poll()) == null) {
                try {
                    this.barrier.await();
                    return;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (BrokenBarrierException brokenBarrierException) {}
                continue;
            }
            --this.jobCount;
            job.run();
        }
    }

    @Override
    public <T extends PoolToken> boolean scheduleAsJob(T token, Root<T> root, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, Node<T> nodeA, Node<T> nodeB, boolean nodeAIsPos, Queue<ColumnPair> adjacentPairs) {
        int jobsToAdd = 64 * this.threadCount - this.jobCount;
        if (jobsToAdd > 0) {
            this.jobCount += this.addToJobQueue(0, token, root, posCols, zeroCols, negCols, nodeA, nodeB, nodeAIsPos, adjacentPairs);
            if (this.barrier.getNumberWaiting() > 0) {
                this.barrier.reset();
            }
            return true;
        }
        return false;
    }

    private <T extends PoolToken> int addToJobQueue(int level, T token, Root<T> root, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, Node<T> nodeA, Node<T> nodeB, boolean nodeAIsPos, Queue<ColumnPair> adjacentPairs) {
        if (root.enterIfCandidates(token, nodeA, nodeB)) {
            int jobs = 0;
            if (level < 6) {
                ++level;
                if (nodeA instanceof InterNode && nodeB instanceof InterNode) {
                    InterNode interA = (InterNode)nodeA;
                    InterNode interB = (InterNode)nodeB;
                    jobs += this.addToJobQueue(level, token, root, posCols, zeroCols, negCols, interA.child0, interB.child0, nodeAIsPos, adjacentPairs);
                    jobs += this.addToJobQueue(level, token, root, posCols, zeroCols, negCols, interA.child1, interB.child0, nodeAIsPos, adjacentPairs);
                    jobs += this.addToJobQueue(level, token, root, posCols, zeroCols, negCols, interA.child0, interB.child1, nodeAIsPos, adjacentPairs);
                    jobs += this.addToJobQueue(level, token, root, posCols, zeroCols, negCols, interA.child1, interB.child1, nodeAIsPos, adjacentPairs);
                } else if (nodeA instanceof InterNode) {
                    InterNode interA = (InterNode)nodeA;
                    jobs += this.addToJobQueue(level, token, root, posCols, zeroCols, negCols, interA.child0, nodeB, nodeAIsPos, adjacentPairs);
                    jobs += this.addToJobQueue(level, token, root, posCols, zeroCols, negCols, interA.child1, nodeB, nodeAIsPos, adjacentPairs);
                } else if (nodeB instanceof InterNode) {
                    InterNode interB = (InterNode)nodeB;
                    jobs += this.addToJobQueue(level, token, root, posCols, zeroCols, negCols, nodeA, interB.child0, nodeAIsPos, adjacentPairs);
                    jobs += this.addToJobQueue(level, token, root, posCols, zeroCols, negCols, nodeA, interB.child1, nodeAIsPos, adjacentPairs);
                } else {
                    this.addJobToQueue(token, root, posCols, zeroCols, negCols, nodeA, nodeB, nodeAIsPos, adjacentPairs);
                    jobs = 1;
                }
            } else {
                this.addJobToQueue(token, root, posCols, zeroCols, negCols, nodeA, nodeB, nodeAIsPos, adjacentPairs);
                jobs = 1;
            }
            root.leave(token, nodeA, nodeB);
            return jobs;
        }
        return 0;
    }

    private <T extends PoolToken> void addJobToQueue(final T token, final Root<T> root, final SortableMemory<Column> posCols, final SortableMemory<Column> zeroCols, final SortableMemory<Column> negCols, final Node<T> nodeA, final Node<T> nodeB, final boolean nodeAIsPos, final Queue<ColumnPair> adjacentPairs) {
        this.jobs.add(new Runnable(){

            public void run() {
                try {
                    nodeA.addAdjacentPairs(token, root, posCols, zeroCols, negCols, nodeB, nodeAIsPos, adjacentPairs);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void execMainThread() {
        this.enterThreadLoop();
    }
}

