/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Norm;
import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.efm.ElementaryFluxModes;
import ch.javasoft.metabolic.efm.LogPkg;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.util.logging.Loggers;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PalssonTest
extends ch.javasoft.metabolic.parse.PalssonTest {
    static {
        CompressionMethod[] compression = CompressionMethod.STANDARD_NO_DUPLICATE;
        if (Config.initForJUnitTest("rankup-modpi-incore", "FewestNegPosOrMostZeros", compression, false, Arithmetic.fractional, Norm.norm2)) {
            Loggers.getRootLogger().setLevel(Level.FINER);
            Logger.getLogger("compress.data").setLevel(Level.INFO);
        }
    }

    @Override
    public void testPalsson_aureus_iMH556() throws Exception {
        super.testPalsson_aureus_iMH556();
    }

    @Override
    public void testPalsson_aureus_iSB619_xnone() throws Exception {
        super.testPalsson_aureus_iSB619_xnone();
    }

    @Override
    public void testPalsson_aureus_iSB619_xrev() throws Exception {
        super.testPalsson_aureus_iSB619_xrev();
    }

    @Override
    public void testPalsson_aureus_iSB619_xspec() throws Exception {
        super.testPalsson_aureus_iSB619_xspec();
    }

    @Override
    public void testPalsson_aureus_iSB619_opt() throws Exception {
        super.testPalsson_aureus_iSB619_opt();
    }

    @Override
    public void testPalsson_barkeri_iAF692_xspec() throws Exception {
        super.testPalsson_barkeri_iAF692_xspec();
    }

    @Override
    public void testPalsson_barkeri_iAF692_opt() throws Exception {
        super.testPalsson_barkeri_iAF692_opt();
    }

    @Override
    public void testPalsson_coli_iJR904_xnone_nobio() throws Exception {
        super.testPalsson_coli_iJR904_xnone_nobio();
    }

    @Override
    public void testPalsson_coli_iJR904_xnone() throws Exception {
        super.testPalsson_coli_iJR904_xnone();
    }

    @Override
    public void testPalsson_coli_iJR904_minimal() throws Exception {
        super.testPalsson_coli_iJR904_minimal();
    }

    @Override
    public void testPalsson_coli_iJR904_xrev() throws Exception {
        super.testPalsson_coli_iJR904_xrev();
    }

    @Override
    public void testPalsson_coli_iJR904_xspec() throws Exception {
        super.testPalsson_coli_iJR904_xspec();
    }

    @Override
    public void testPalsson_coli_iJR904_fba_reduced() throws Exception {
        super.testPalsson_coli_iJR904_fba_reduced();
    }

    @Override
    public void testPalsson_coli_iJR904_fba_reduced_ac() throws Exception {
        super.testPalsson_coli_iJR904_fba_reduced_ac();
    }

    @Override
    public void testPalsson_coli_iJR904_fba_reduced_xnone() throws Exception {
        super.testPalsson_coli_iJR904_fba_reduced_xnone();
    }

    @Override
    public void testPalsson_coli_Robert_reduced() throws Exception {
        super.testPalsson_coli_Robert_reduced();
    }

    @Override
    public void testPalsson_coli_Robert() throws Exception {
        super.testPalsson_coli_Robert();
    }

    @Override
    public void testPalsson_pylori_iIT341_xnone() throws Exception {
        super.testPalsson_pylori_iIT341_xnone();
    }

    @Override
    public void testPalsson_pylori_iIT341_redin() throws Exception {
        Config.getConfig().getReactionsToEnforce().add("mue");
        super.testPalsson_pylori_iIT341_redin();
    }

    @Override
    public void testPalsson_pylori_iIT341_xspec() throws Exception {
        super.testPalsson_pylori_iIT341_xspec();
    }

    @Override
    public void testPalsson_pylori_iIT341_glc() throws Exception {
        super.testPalsson_pylori_iIT341_glc();
    }

    @Override
    public void testPalsson_pylori_iIT341_glcmin() throws Exception {
        super.testPalsson_pylori_iIT341_glcmin();
    }

    @Override
    public void testPalsson_pylori_iIT341_aminomin() throws Exception {
        super.testPalsson_pylori_iIT341_aminomin();
    }

    public void testPalsson_pylori_iIT341_aminoGlnGly() throws Exception {
        Config.getConfig().getReactionsToEnforce().add("EX-gly(e)");
        super.testPalsson_pylori_iIT341_aminominGlnGly();
    }

    @Override
    public void testPalsson_pylori_iIT341_aminoglcmin() throws Exception {
        super.testPalsson_pylori_iIT341_aminoglcmin();
    }

    @Override
    public void testPalsson_pylori_iCS291() throws Exception {
        super.testPalsson_pylori_iCS291();
    }

    @Override
    public void testPalsson_pylori_iCS291_amino() throws Exception {
        super.testPalsson_pylori_iCS291_amino();
    }

    @Override
    public void testPalsson_pylori_iCS291_glcamino() throws Exception {
        super.testPalsson_pylori_iCS291_glcamino();
    }

    @Override
    public void testPalsson_pylori_iCS291_specamino() throws Exception {
        super.testPalsson_pylori_iCS291_specamino();
    }

    @Override
    public void testPalsson_yeastc_iLL672_unbalancedMetas() throws Exception {
        super.testPalsson_yeastc_iLL672_unbalancedMetas();
    }

    @Override
    public void testPalsson_yeastc_iLL672() throws Exception {
        super.testPalsson_yeastc_iLL672();
    }

    @Override
    public void testPalsson_yeastc_iLL672_xnone() throws Exception {
        super.testPalsson_yeastc_iLL672_xnone();
    }

    @Override
    public void testPalsson_yeastc_iND750_xnone() throws Exception {
        super.testPalsson_yeastc_iND750_xnone();
    }

    @Override
    public void testPalsson_yeastc_iND750() throws Exception {
        super.testPalsson_yeastc_iND750();
    }

    @Override
    protected void internalTestMetabolicNetwork(MetabolicNetwork network, Set<String> suppressedReactions) throws Exception {
        File outFile;
        if (suppressedReactions != null) {
            Config.getConfig().getReactionsToSuppress().addAll(suppressedReactions);
        }
        if (!(outFile = new File("/local/tmp/mnet_palsson.mat")).getParentFile().exists()) {
            throw new FileNotFoundException(outFile.getParentFile().getAbsolutePath());
        }
        ElementaryFluxModes.calculateFileMatlab(network, outFile.getParentFile(), outFile.getName());
        LogPkg.LOGGER.info("written modes to file: " + outFile.getAbsolutePath());
    }
}

