/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm;

import ch.javasoft.cdd.parser.CddParser;
import ch.javasoft.math.BigFraction;
import ch.javasoft.math.NumberMatrixConverter;
import ch.javasoft.metabolic.efm.AnneMatthias;

public class CddHelper
extends AnneMatthias {
    public static BigFraction[][] getMatrix(CddParser parser) {
        try {
            return parser.getMatrixCast(BigFraction[].class);
        }
        catch (ClassCastException e) {
            return parser.getMatrixConverted(new NumberMatrixConverter<BigFraction[]>(){

                public BigFraction[][] newMatrix(int rows, int cols) {
                    return new BigFraction[rows][cols];
                }

                public void copy(Number number, BigFraction[][] dstMatrix, int row, int col) {
                    dstMatrix[row][col] = BigFraction.valueOf(number);
                }
            });
        }
    }

    public static BigFraction[][] addSlackVariables(BigFraction[][] mx) {
        int rows = mx.length;
        int cols = rows == 0 ? 0 : mx[0].length;
        BigFraction[][] res = new BigFraction[rows][cols + rows];
        BigFraction minusOne = BigFraction.ONE.negate();
        int r = 0;
        while (r < rows) {
            System.arraycopy(mx[r], 0, res[r], 0, cols);
            int c = 0;
            while (c < rows) {
                res[r][c + cols] = r == c ? minusOne : BigFraction.ZERO;
                ++c;
            }
            ++r;
        }
        return res;
    }
}

