/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.convert;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.convert.LogPkg;
import ch.javasoft.metabolic.generate.ConfiguredGenerator;
import ch.javasoft.metabolic.parse.ConfiguredParser;
import ch.javasoft.xml.config.MissingReferableException;
import ch.javasoft.xml.config.XmlArgException;
import ch.javasoft.xml.config.XmlConfig;
import ch.javasoft.xml.config.XmlConfigException;
import ch.javasoft.xml.config.XmlNode;
import ch.javasoft.xml.config.XmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.dom4j.Element;

public class Convert {
    public static final String CONFIG_FILE = "config/convert2sbml.xml";
    private final String mConfigEntry;
    private final String mHelpName;
    private final String mUsageName;

    public Convert(String configEntry, String helpName, String usageName) {
        this.mConfigEntry = configEntry;
        this.mHelpName = helpName;
        this.mUsageName = usageName;
    }

    protected void start(String[] args) {
        try {
            InputStream in;
            String config = this.mConfigEntry;
            if (args.length >= 1 && !args[0].startsWith("-")) {
                in = new FileInputStream(args[0]);
                if (args.length >= 2 && !args[1].startsWith("-")) {
                    config = args[1];
                }
            } else {
                File file = new File(CONFIG_FILE);
                in = file.canRead() ? new FileInputStream(CONFIG_FILE) : Convert.class.getResourceAsStream("/config/convert2sbml.xml");
                if (in == null) {
                    throw new FileNotFoundException("/config/convert2sbml.xml");
                }
            }
            XmlConfig xmlConfig = XmlConfig.getXmlConfig(in, args);
            String appName = this.getClass().getSimpleName();
            xmlConfig.setAppName(appName);
            if (args.length >= 1 && ("--help".equals(args[0]) || "-?".equals(args[0]) || "?".equals(args[0]))) {
                boolean err = args.length > 1;
                this.printHelp(err ? System.err : System.out, xmlConfig);
                System.exit(err ? 1 : 0);
            }
            try {
                if (config != null) {
                    xmlConfig.setDefaultConfigName(config);
                } else {
                    config = XmlUtil.getRequiredAttributeValue(xmlConfig.getDefaultConfigElement(), XmlAttribute.name);
                }
                LogPkg.LOGGER.info(String.valueOf(appName) + " [config: " + config + "]");
                Convert.start(xmlConfig);
            }
            catch (XmlArgException ex) {
                if (ex.isOption()) {
                    System.err.println("ERROR:   missing " + ex.getOptionWithIndex() + " option");
                }
                System.err.println("DETAILS: " + ex.getLocalizedMessage());
                this.printUsage(System.err, xmlConfig);
                System.exit(2);
            }
            catch (MissingReferableException ex) {
                if (("config[" + this.mConfigEntry + "]/metabolic-parse/parse").equals(ex.getPath())) {
                    System.err.println("ERROR:   invalid input kind option '" + ex.getReferable() + "'");
                }
                System.err.println("DETAILS: " + ex.getLocalizedMessage());
                this.printUsage(System.err, xmlConfig);
                System.exit(2);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(3);
        }
    }

    private static void start(XmlConfig config) throws XmlConfigException, IOException {
        Element defConfig = config.getDefaultConfigElement();
        MetabolicNetwork net = ConfiguredParser.parseConfig(defConfig);
        ConfiguredGenerator.generateConfig(defConfig, net);
    }

    private void printHelp(PrintStream stream, XmlConfig xmlConfig) throws XmlConfigException {
        xmlConfig.printUsage(stream, this.mHelpName);
    }

    private void printUsage(PrintStream stream, XmlConfig xmlConfig) throws XmlConfigException {
        xmlConfig.printUsage(stream, this.mUsageName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlAttribute implements XmlNode
    {
        name;


        @Override
        public String getXmlName() {
            return this.name().replaceAll("_", "-");
        }
    }
}

