/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.array;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.Converter;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.array.impl.DefaultNumberArrayOperations;
import ch.javasoft.math.linalg.BasicLinAlgOperations;
import ch.javasoft.math.operator.AggregatingBinaryOperator;
import ch.javasoft.math.operator.AggregatingUnaryOperator;
import ch.javasoft.math.operator.BinaryOperator;
import ch.javasoft.math.operator.BooleanBinaryOperator;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import ch.javasoft.math.operator.ConvertingUnaryOperator;
import ch.javasoft.math.operator.DivisionSupport;
import ch.javasoft.math.operator.IntBinaryOperator;
import ch.javasoft.math.operator.IntUnaryOperator;
import ch.javasoft.math.operator.NAryOperator;
import ch.javasoft.math.operator.NullaryOperator;
import ch.javasoft.math.operator.QuaternaryOperator;
import ch.javasoft.math.operator.TernaryOperator;
import ch.javasoft.math.operator.UnaryOperator;
import ch.javasoft.math.operator.compose.BinaryBinaryOperator;
import ch.javasoft.math.operator.compose.BinaryNullaryOperator;
import ch.javasoft.math.operator.compose.BinaryUnaryOperator;
import ch.javasoft.math.operator.compose.ConcatBinaryOperator;
import ch.javasoft.math.operator.compose.ConcatNAryOperator;
import ch.javasoft.math.operator.compose.ConcatNullaryOperator;
import ch.javasoft.math.operator.compose.ConcatQuaternaryOperator;
import ch.javasoft.math.operator.compose.ConcatTernaryOperator;
import ch.javasoft.math.operator.compose.ConcatUnaryOperator;
import ch.javasoft.math.operator.compose.NAryNAryOperator;
import ch.javasoft.math.operator.compose.NullaryBinaryOperator;
import ch.javasoft.math.operator.compose.NullaryNullaryOperator;
import ch.javasoft.math.operator.compose.NullaryQuaternaryOperator;
import ch.javasoft.math.operator.compose.NullaryTernaryOperator;
import ch.javasoft.math.operator.compose.NullaryUnaryOperator;
import ch.javasoft.math.operator.compose.QuaternaryNullaryOperator;
import ch.javasoft.math.operator.compose.TernaryNullaryOperator;
import ch.javasoft.math.operator.compose.TernaryUnaryOperator;
import ch.javasoft.math.operator.compose.UnaryBinaryOperator;
import ch.javasoft.math.operator.compose.UnaryNullaryOperator;
import ch.javasoft.math.operator.compose.UnaryTernaryOperator;
import ch.javasoft.math.operator.compose.UnaryUnaryOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionComposer<N extends Number, A> {
    private final ArrayOperations<A> arrayOps;
    private final NumberOperators<N, A> operators;

    public ExpressionComposer(ArrayOperations<A> arrayOps, NumberOperators<N, A> operators) {
        this.arrayOps = arrayOps;
        this.operators = operators;
    }

    public ExpressionComposer(NumberArrayOperations<N, A> numberArrayOps) {
        this(numberArrayOps.getArrayOperations(), numberArrayOps.getNumberOperators());
    }

    public ExpressionComposer(BasicLinAlgOperations<N, A> numberArrayOps) {
        this(numberArrayOps.getArrayOperations(), numberArrayOps.getNumberOperators());
    }

    public Class<N> numberClass() {
        return this.operators.numberClass();
    }

    public Class<A> arrayClass() {
        return this.operators.arrayClass();
    }

    public DivisionSupport getDivisionSupport() {
        return this.operators.getDivisionSupport();
    }

    public ArrayOperations<A> getArrayOperations() {
        return this.arrayOps;
    }

    public NumberOperators<N, A> getNumberOperators() {
        return this.operators;
    }

    public NumberArrayOperations<N, A> getNumberArrayOperations() {
        return new DefaultNumberArrayOperations<N, A>(this.operators, this.arrayOps);
    }

    public N zero() {
        return this.operators.zero();
    }

    public N one() {
        return this.operators.one();
    }

    public NullaryOperator<N, A> constantZero() {
        return this.operators.nullary(NullaryOperator.Id.zero);
    }

    public NullaryOperator<N, A> constantOne() {
        return this.operators.nullary(NullaryOperator.Id.one);
    }

    public NullaryOperator<N, A> constant(N value) {
        return this.operators.constant(value);
    }

    public NullaryOperator<N, A> rnd() {
        return this.operators.nullary(NullaryOperator.Id.random);
    }

    public UnaryOperator<N, A> abs() {
        return this.operators.unary(UnaryOperator.Id.abs);
    }

    public UnaryOperator<N, A> neg() {
        return this.operators.unary(UnaryOperator.Id.negate);
    }

    public UnaryOperator<N, A> inv() {
        return this.operators.unary(UnaryOperator.Id.invert);
    }

    public UnaryOperator<N, A> normalize() {
        return this.operators.unary(UnaryOperator.Id.normalize);
    }

    public UnaryOperator<N, A> square() {
        return this.operators.unary(UnaryOperator.Id.square);
    }

    public UnaryOperator<N, A> identity() {
        return this.operators.unary(UnaryOperator.Id.identity);
    }

    public BooleanUnaryOperator<N, A> isZero() {
        return this.operators.booleanUnary(BooleanUnaryOperator.Id.isZero);
    }

    public BooleanUnaryOperator<N, A> isNonZero() {
        return this.operators.booleanUnary(BooleanUnaryOperator.Id.isNonZero);
    }

    public BooleanUnaryOperator<N, A> isOne() {
        return this.operators.booleanUnary(BooleanUnaryOperator.Id.isOne);
    }

    public BooleanUnaryOperator<N, A> isNegative() {
        return this.operators.booleanUnary(BooleanUnaryOperator.Id.isNegative);
    }

    public BooleanUnaryOperator<N, A> isNonNegative() {
        return this.operators.booleanUnary(BooleanUnaryOperator.Id.isNonNegative);
    }

    public BooleanUnaryOperator<N, A> isPositive() {
        return this.operators.booleanUnary(BooleanUnaryOperator.Id.isPositive);
    }

    public BooleanUnaryOperator<N, A> isNonPositive() {
        return this.operators.booleanUnary(BooleanUnaryOperator.Id.isNonPositive);
    }

    public BooleanBinaryOperator<N, A> isEqual() {
        return this.operators.booleanBinary(BooleanBinaryOperator.Id.equal);
    }

    public BooleanBinaryOperator<N, A> isUnequal() {
        return this.operators.booleanBinary(BooleanBinaryOperator.Id.unequal);
    }

    public BooleanBinaryOperator<N, A> isGreaterOrEqual() {
        return this.operators.booleanBinary(BooleanBinaryOperator.Id.greaterOrEqual);
    }

    public BooleanBinaryOperator<N, A> isGreater() {
        return this.operators.booleanBinary(BooleanBinaryOperator.Id.greater);
    }

    public BooleanBinaryOperator<N, A> isLessOrEqual() {
        return this.operators.booleanBinary(BooleanBinaryOperator.Id.lessOrEqual);
    }

    public BooleanBinaryOperator<N, A> isLess() {
        return this.operators.booleanBinary(BooleanBinaryOperator.Id.less);
    }

    public IntUnaryOperator<N, A> sign() {
        return this.operators.intUnary(IntUnaryOperator.Id.signum);
    }

    public IntBinaryOperator<N, A> comparator() {
        return this.operators.intBinary(IntBinaryOperator.Id.compare);
    }

    public ConvertingUnaryOperator<Number, Number[], N, A> converter() {
        return this.operators.converter();
    }

    public <IN extends Number, IA> Converter<IN, IA, N, A> converterFrom(NumberArrayOperations<IN, IA> fromOps) {
        return this.getNumberArrayOperations().getConverterFrom(fromOps);
    }

    public <RN extends Number, RA> Converter<N, A, RN, RA> converterTo(NumberArrayOperations<RN, RA> toOps) {
        return this.getNumberArrayOperations().getConverterTo(toOps);
    }

    public AggregatingUnaryOperator<N, A> vectorMin() {
        return this.operators.aggregatingUnary(AggregatingUnaryOperator.Id.min);
    }

    public AggregatingUnaryOperator<N, A> vectorMax() {
        return this.operators.aggregatingUnary(AggregatingUnaryOperator.Id.max);
    }

    public AggregatingUnaryOperator<N, A> vectorSum() {
        return this.operators.aggregatingUnary(AggregatingUnaryOperator.Id.sum);
    }

    public AggregatingUnaryOperator<N, A> vectorSumSquared() {
        return this.operators.aggregatingUnary(AggregatingUnaryOperator.Id.sumSquared);
    }

    public AggregatingUnaryOperator<N, A> vectorNormDivisor() {
        return this.operators.aggregatingUnary(AggregatingUnaryOperator.Id.normDivisor);
    }

    public AggregatingUnaryOperator<N, A> vectorSqueezeDivisor() {
        return this.operators.aggregatingUnary(AggregatingUnaryOperator.Id.squeezeDivisor);
    }

    public AggregatingBinaryOperator<N, A> vectorInnerProduct() {
        return this.operators.aggregatingBinary(AggregatingBinaryOperator.Id.innerProduct);
    }

    public NullaryOperator<N, A> abs(NullaryOperator<N, A> op) {
        return this.concat(this.abs(), op);
    }

    public NullaryOperator<N, A> neg(NullaryOperator<N, A> op) {
        return this.concat(this.neg(), op);
    }

    public NullaryOperator<N, A> inv(NullaryOperator<N, A> op) {
        return this.concat(this.inv(), op);
    }

    public NullaryOperator<N, A> normalize(NullaryOperator<N, A> op) {
        return this.concat(this.normalize(), op);
    }

    public NullaryOperator<N, A> square(NullaryOperator<N, A> op) {
        return this.concat(this.square(), op);
    }

    public UnaryOperator<N, A> abs(UnaryOperator<N, A> op) {
        return this.concat(this.abs(), op);
    }

    public UnaryOperator<N, A> neg(UnaryOperator<N, A> op) {
        return this.concat(this.neg(), op);
    }

    public UnaryOperator<N, A> inv(UnaryOperator<N, A> op) {
        return this.concat(this.inv(), op);
    }

    public UnaryOperator<N, A> normalize(UnaryOperator<N, A> op) {
        return this.concat(this.normalize(), op);
    }

    public UnaryOperator<N, A> square(UnaryOperator<N, A> op) {
        return this.concat(this.square(), op);
    }

    public BinaryOperator<N, A> abs(BinaryOperator<N, A> op) {
        return this.concat(this.abs(), op);
    }

    public BinaryOperator<N, A> neg(BinaryOperator<N, A> op) {
        return this.concat(this.neg(), op);
    }

    public BinaryOperator<N, A> inv(BinaryOperator<N, A> op) {
        return this.concat(this.inv(), op);
    }

    public BinaryOperator<N, A> normalize(BinaryOperator<N, A> op) {
        return this.concat(this.normalize(), op);
    }

    public BinaryOperator<N, A> square(BinaryOperator<N, A> op) {
        return this.concat(this.square(), op);
    }

    public TernaryOperator<N, A> abs(TernaryOperator<N, A> op) {
        return this.concat(this.abs(), op);
    }

    public TernaryOperator<N, A> neg(TernaryOperator<N, A> op) {
        return this.concat(this.neg(), op);
    }

    public TernaryOperator<N, A> inv(TernaryOperator<N, A> op) {
        return this.concat(this.inv(), op);
    }

    public TernaryOperator<N, A> normalize(TernaryOperator<N, A> op) {
        return this.concat(this.normalize(), op);
    }

    public TernaryOperator<N, A> square(TernaryOperator<N, A> op) {
        return this.concat(this.square(), op);
    }

    public QuaternaryOperator<N, A> abs(QuaternaryOperator<N, A> op) {
        return this.concat(this.abs(), op);
    }

    public QuaternaryOperator<N, A> neg(QuaternaryOperator<N, A> op) {
        return this.concat(this.neg(), op);
    }

    public QuaternaryOperator<N, A> inv(QuaternaryOperator<N, A> op) {
        return this.concat(this.inv(), op);
    }

    public QuaternaryOperator<N, A> normalize(QuaternaryOperator<N, A> op) {
        return this.concat(this.normalize(), op);
    }

    public QuaternaryOperator<N, A> square(QuaternaryOperator<N, A> op) {
        return this.concat(this.square(), op);
    }

    public NAryOperator<N, A> abs(NAryOperator<N, A> op) {
        return this.concat(this.abs(), op);
    }

    public NAryOperator<N, A> neg(NAryOperator<N, A> op) {
        return this.concat(this.neg(), op);
    }

    public NAryOperator<N, A> inv(NAryOperator<N, A> op) {
        return this.concat(this.inv(), op);
    }

    public NAryOperator<N, A> normalize(NAryOperator<N, A> op) {
        return this.concat(this.normalize(), op);
    }

    public NAryOperator<N, A> square(NAryOperator<N, A> op) {
        return this.concat(this.square(), op);
    }

    public BinaryOperator<N, A> add() {
        return this.operators.binary(BinaryOperator.Id.add);
    }

    public BinaryOperator<N, A> sub() {
        return this.operators.binary(BinaryOperator.Id.subtract);
    }

    public BinaryOperator<N, A> mul() {
        return this.operators.binary(BinaryOperator.Id.multiply);
    }

    public BinaryOperator<N, A> div() {
        return this.operators.binary(BinaryOperator.Id.divide);
    }

    public BinaryOperator<N, A> min() {
        return this.operators.binary(BinaryOperator.Id.min);
    }

    public BinaryOperator<N, A> max() {
        return this.operators.binary(BinaryOperator.Id.max);
    }

    public UnaryOperator<N, A> add(NullaryOperator<N, A> op) {
        return this.concat(this.add(), op, this.identity());
    }

    public UnaryOperator<N, A> mul(NullaryOperator<N, A> op) {
        return this.concat(this.mul(), op, this.identity());
    }

    public UnaryOperator<N, A> min(NullaryOperator<N, A> op) {
        return this.concat(this.min(), op, this.identity());
    }

    public UnaryOperator<N, A> max(NullaryOperator<N, A> op) {
        return this.concat(this.max(), op, this.identity());
    }

    public UnaryOperator<N, A> subFreeFrom(NullaryOperator<N, A> op) {
        return this.concat(this.sub(), op, this.identity());
    }

    public UnaryOperator<N, A> subFromFree(NullaryOperator<N, A> op) {
        return this.concat(this.sub(), this.identity(), op);
    }

    public UnaryOperator<N, A> divFreeBy(NullaryOperator<N, A> op) {
        return this.concat(this.div(), this.identity(), op);
    }

    public UnaryOperator<N, A> divByFree(NullaryOperator<N, A> op) {
        return this.concat(this.div(), op, this.identity());
    }

    public BinaryOperator<N, A> addToFree(UnaryOperator<N, A> op) {
        return this.concat(this.add(), this.identity(), op);
    }

    public BinaryOperator<N, A> addFreeTo(UnaryOperator<N, A> op) {
        return this.concat(this.add(), op, this.identity());
    }

    public BinaryOperator<N, A> mulFreeBy(UnaryOperator<N, A> op) {
        return this.concat(this.mul(), this.identity(), op);
    }

    public BinaryOperator<N, A> mulByFree(UnaryOperator<N, A> op) {
        return this.concat(this.mul(), op, this.identity());
    }

    public BinaryOperator<N, A> minFreeWith(UnaryOperator<N, A> op) {
        return this.concat(this.min(), this.identity(), op);
    }

    public BinaryOperator<N, A> minWithFree(UnaryOperator<N, A> op) {
        return this.concat(this.min(), op, this.identity());
    }

    public BinaryOperator<N, A> maxFreeWith(UnaryOperator<N, A> op) {
        return this.concat(this.max(), this.identity(), op);
    }

    public BinaryOperator<N, A> maxWithFree(UnaryOperator<N, A> op) {
        return this.concat(this.max(), op, this.identity());
    }

    public BinaryOperator<N, A> subFreeFrom(UnaryOperator<N, A> op) {
        return this.concat(this.sub(), op, this.identity());
    }

    public BinaryOperator<N, A> subFromFree(UnaryOperator<N, A> op) {
        return this.concat(this.sub(), this.identity(), op);
    }

    public BinaryOperator<N, A> divFreeBy(UnaryOperator<N, A> op) {
        return this.concat(this.div(), this.identity(), op);
    }

    public BinaryOperator<N, A> divByFree(UnaryOperator<N, A> op) {
        return this.concat(this.div(), op, this.identity());
    }

    public TernaryOperator<N, A> addToFree(BinaryOperator<N, A> op) {
        return this.concat(this.add(), this.identity(), op);
    }

    public TernaryOperator<N, A> addFreeTo(BinaryOperator<N, A> op) {
        return this.concat(this.add(), op, this.identity());
    }

    public TernaryOperator<N, A> mulFreeBy(BinaryOperator<N, A> op) {
        return this.concat(this.mul(), this.identity(), op);
    }

    public TernaryOperator<N, A> mulByFree(BinaryOperator<N, A> op) {
        return this.concat(this.mul(), op, this.identity());
    }

    public TernaryOperator<N, A> minFreeWith(BinaryOperator<N, A> op) {
        return this.concat(this.min(), this.identity(), op);
    }

    public TernaryOperator<N, A> minWithFree(BinaryOperator<N, A> op) {
        return this.concat(this.min(), op, this.identity());
    }

    public TernaryOperator<N, A> maxFreeWith(BinaryOperator<N, A> op) {
        return this.concat(this.max(), this.identity(), op);
    }

    public TernaryOperator<N, A> maxWithFree(BinaryOperator<N, A> op) {
        return this.concat(this.max(), op, this.identity());
    }

    public TernaryOperator<N, A> subFreeFrom(BinaryOperator<N, A> op) {
        return this.concat(this.sub(), op, this.identity());
    }

    public TernaryOperator<N, A> subFromFree(BinaryOperator<N, A> op) {
        return this.concat(this.sub(), this.identity(), op);
    }

    public TernaryOperator<N, A> divFreeBy(BinaryOperator<N, A> op) {
        return this.concat(this.div(), this.identity(), op);
    }

    public TernaryOperator<N, A> divByFree(BinaryOperator<N, A> op) {
        return this.concat(this.div(), op, this.identity());
    }

    public QuaternaryOperator<N, A> addToFree(TernaryOperator<N, A> op) {
        return this.concat(this.add(), this.identity(), op);
    }

    public QuaternaryOperator<N, A> addFreeTo(TernaryOperator<N, A> op) {
        return this.concat(this.add(), op, this.identity());
    }

    public QuaternaryOperator<N, A> mulFreeBy(TernaryOperator<N, A> op) {
        return this.concat(this.mul(), this.identity(), op);
    }

    public QuaternaryOperator<N, A> mulByFree(TernaryOperator<N, A> op) {
        return this.concat(this.mul(), op, this.identity());
    }

    public QuaternaryOperator<N, A> minFreeWith(TernaryOperator<N, A> op) {
        return this.concat(this.min(), this.identity(), op);
    }

    public QuaternaryOperator<N, A> minWithFree(TernaryOperator<N, A> op) {
        return this.concat(this.min(), op, this.identity());
    }

    public QuaternaryOperator<N, A> maxFreeWith(TernaryOperator<N, A> op) {
        return this.concat(this.max(), this.identity(), op);
    }

    public QuaternaryOperator<N, A> maxWithFree(TernaryOperator<N, A> op) {
        return this.concat(this.max(), op, this.identity());
    }

    public QuaternaryOperator<N, A> subFreeFrom(TernaryOperator<N, A> op) {
        return this.concat(this.sub(), op, this.identity());
    }

    public QuaternaryOperator<N, A> subFromFree(TernaryOperator<N, A> op) {
        return this.concat(this.sub(), this.identity(), op);
    }

    public QuaternaryOperator<N, A> divFreeBy(TernaryOperator<N, A> op) {
        return this.concat(this.div(), this.identity(), op);
    }

    public QuaternaryOperator<N, A> divByFree(TernaryOperator<N, A> op) {
        return this.concat(this.div(), op, this.identity());
    }

    public NAryOperator<N, A> addToFree(NAryOperator<N, A> op) {
        return this.concat(this.add(), this.identity(), op);
    }

    public NAryOperator<N, A> addFreeTo(NAryOperator<N, A> op) {
        return this.concat(this.add(), op, this.identity());
    }

    public NAryOperator<N, A> mullFreeBy(NAryOperator<N, A> op) {
        return this.concat(this.mul(), this.identity(), op);
    }

    public NAryOperator<N, A> mulByFree(NAryOperator<N, A> op) {
        return this.concat(this.mul(), op, this.identity());
    }

    public NAryOperator<N, A> minFreeWith(NAryOperator<N, A> op) {
        return this.concat(this.min(), this.identity(), op);
    }

    public NAryOperator<N, A> minWithFree(NAryOperator<N, A> op) {
        return this.concat(this.min(), op, this.identity());
    }

    public NAryOperator<N, A> maxFreeWith(NAryOperator<N, A> op) {
        return this.concat(this.max(), this.identity(), op);
    }

    public NAryOperator<N, A> maxWithFree(NAryOperator<N, A> op) {
        return this.concat(this.max(), op, this.identity());
    }

    public NAryOperator<N, A> subFreeFrom(NAryOperator<N, A> op) {
        return this.concat(this.sub(), op, this.identity());
    }

    public NAryOperator<N, A> subFromFree(NAryOperator<N, A> op) {
        return this.concat(this.sub(), this.identity(), op);
    }

    public NAryOperator<N, A> divFreeBy(NAryOperator<N, A> op) {
        return this.concat(this.div(), this.identity(), op);
    }

    public NAryOperator<N, A> divByFree(NAryOperator<N, A> op) {
        return this.concat(this.div(), op, this.identity());
    }

    public NullaryOperator<N, A> add(NullaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.add(), op1, op2);
    }

    public NullaryOperator<N, A> sub(NullaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.sub(), op1, op2);
    }

    public NullaryOperator<N, A> mul(NullaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.mul(), op1, op2);
    }

    public NullaryOperator<N, A> div(NullaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.div(), op1, op2);
    }

    public NullaryOperator<N, A> min(NullaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.min(), op1, op2);
    }

    public NullaryOperator<N, A> max(NullaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.max(), op1, op2);
    }

    public UnaryOperator<N, A> add(NullaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.add(), op1, op2);
    }

    public UnaryOperator<N, A> sub(NullaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.sub(), op1, op2);
    }

    public UnaryOperator<N, A> mul(NullaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.mul(), op1, op2);
    }

    public UnaryOperator<N, A> div(NullaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.div(), op1, op2);
    }

    public UnaryOperator<N, A> min(NullaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.min(), op1, op2);
    }

    public UnaryOperator<N, A> max(NullaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.max(), op1, op2);
    }

    public UnaryOperator<N, A> add(UnaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.add(), op1, op2);
    }

    public UnaryOperator<N, A> sub(UnaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.sub(), op1, op2);
    }

    public UnaryOperator<N, A> mul(UnaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.mul(), op1, op2);
    }

    public UnaryOperator<N, A> div(UnaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.div(), op1, op2);
    }

    public UnaryOperator<N, A> min(UnaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.min(), op1, op2);
    }

    public UnaryOperator<N, A> max(UnaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.max(), op1, op2);
    }

    public BinaryOperator<N, A> add(UnaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.add(), op1, op2);
    }

    public BinaryOperator<N, A> sub(UnaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.sub(), op1, op2);
    }

    public BinaryOperator<N, A> mul(UnaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.mul(), op1, op2);
    }

    public BinaryOperator<N, A> div(UnaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.div(), op1, op2);
    }

    public BinaryOperator<N, A> min(UnaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.min(), op1, op2);
    }

    public BinaryOperator<N, A> max(UnaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.max(), op1, op2);
    }

    public BinaryOperator<N, A> add(NullaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.add(), op1, op2);
    }

    public BinaryOperator<N, A> sub(NullaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.sub(), op1, op2);
    }

    public BinaryOperator<N, A> mul(NullaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.mul(), op1, op2);
    }

    public BinaryOperator<N, A> div(NullaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.div(), op1, op2);
    }

    public BinaryOperator<N, A> min(NullaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.min(), op1, op2);
    }

    public BinaryOperator<N, A> max(NullaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.max(), op1, op2);
    }

    public BinaryOperator<N, A> add(BinaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.add(), op1, op2);
    }

    public BinaryOperator<N, A> sub(BinaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.sub(), op1, op2);
    }

    public BinaryOperator<N, A> mul(BinaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.mul(), op1, op2);
    }

    public BinaryOperator<N, A> div(BinaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.div(), op1, op2);
    }

    public BinaryOperator<N, A> min(BinaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.min(), op1, op2);
    }

    public BinaryOperator<N, A> max(BinaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.max(), op1, op2);
    }

    public TernaryOperator<N, A> add(UnaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.add(), op1, op2);
    }

    public TernaryOperator<N, A> sub(UnaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.sub(), op1, op2);
    }

    public TernaryOperator<N, A> mul(UnaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.mul(), op1, op2);
    }

    public TernaryOperator<N, A> div(UnaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.div(), op1, op2);
    }

    public TernaryOperator<N, A> min(UnaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.min(), op1, op2);
    }

    public NAryOperator<N, A> max(UnaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.max(), op1, op2);
    }

    public TernaryOperator<N, A> add(BinaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.add(), op1, op2);
    }

    public TernaryOperator<N, A> sub(BinaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.sub(), op1, op2);
    }

    public TernaryOperator<N, A> mul(BinaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.mul(), op1, op2);
    }

    public TernaryOperator<N, A> div(BinaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.div(), op1, op2);
    }

    public TernaryOperator<N, A> min(BinaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.min(), op1, op2);
    }

    public NAryOperator<N, A> max(BinaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.max(), op1, op2);
    }

    public TernaryOperator<N, A> add(NullaryOperator<N, A> op1, TernaryOperator<N, A> op2) {
        return this.concat(this.add(), op1, op2);
    }

    public TernaryOperator<N, A> sub(NullaryOperator<N, A> op1, TernaryOperator<N, A> op2) {
        return this.concat(this.sub(), op1, op2);
    }

    public TernaryOperator<N, A> mul(NullaryOperator<N, A> op1, TernaryOperator<N, A> op2) {
        return this.concat(this.mul(), op1, op2);
    }

    public TernaryOperator<N, A> div(NullaryOperator<N, A> op1, TernaryOperator<N, A> op2) {
        return this.concat(this.div(), op1, op2);
    }

    public TernaryOperator<N, A> min(NullaryOperator<N, A> op1, TernaryOperator<N, A> op2) {
        return this.concat(this.min(), op1, op2);
    }

    public TernaryOperator<N, A> max(NullaryOperator<N, A> op1, TernaryOperator<N, A> op2) {
        return this.concat(this.max(), op1, op2);
    }

    public TernaryOperator<N, A> add(TernaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.add(), op1, op2);
    }

    public TernaryOperator<N, A> sub(TernaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.sub(), op1, op2);
    }

    public TernaryOperator<N, A> mul(TernaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.mul(), op1, op2);
    }

    public TernaryOperator<N, A> div(TernaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.div(), op1, op2);
    }

    public TernaryOperator<N, A> min(TernaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.min(), op1, op2);
    }

    public TernaryOperator<N, A> max(TernaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.max(), op1, op2);
    }

    public QuaternaryOperator<N, A> add(BinaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.add(), op1, op2);
    }

    public QuaternaryOperator<N, A> sub(BinaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.sub(), op1, op2);
    }

    public QuaternaryOperator<N, A> mul(BinaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.mul(), op1, op2);
    }

    public QuaternaryOperator<N, A> div(BinaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.div(), op1, op2);
    }

    public QuaternaryOperator<N, A> min(BinaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.min(), op1, op2);
    }

    public QuaternaryOperator<N, A> max(BinaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return this.concat(this.max(), op1, op2);
    }

    public QuaternaryOperator<N, A> add(UnaryOperator<N, A> op1, TernaryOperator<N, A> op2) {
        return this.concat(this.add(), op1, op2);
    }

    public QuaternaryOperator<N, A> sub(UnaryOperator<N, A> op1, TernaryOperator<N, A> op2) {
        return this.concat(this.sub(), op1, op2);
    }

    public QuaternaryOperator<N, A> mul(UnaryOperator<N, A> op1, TernaryOperator<N, A> op2) {
        return this.concat(this.mul(), op1, op2);
    }

    public QuaternaryOperator<N, A> div(UnaryOperator<N, A> op1, TernaryOperator<N, A> op2) {
        return this.concat(this.div(), op1, op2);
    }

    public QuaternaryOperator<N, A> min(UnaryOperator<N, A> op1, TernaryOperator<N, A> op2) {
        return this.concat(this.min(), op1, op2);
    }

    public QuaternaryOperator<N, A> max(UnaryOperator<N, A> op1, TernaryOperator<N, A> op2) {
        return this.concat(this.max(), op1, op2);
    }

    public QuaternaryOperator<N, A> add(TernaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.add(), op1, op2);
    }

    public QuaternaryOperator<N, A> sub(TernaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.sub(), op1, op2);
    }

    public QuaternaryOperator<N, A> mul(TernaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.mul(), op1, op2);
    }

    public QuaternaryOperator<N, A> div(TernaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.div(), op1, op2);
    }

    public QuaternaryOperator<N, A> min(TernaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.min(), op1, op2);
    }

    public QuaternaryOperator<N, A> max(TernaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return this.concat(this.max(), op1, op2);
    }

    public QuaternaryOperator<N, A> add(NullaryOperator<N, A> op1, QuaternaryOperator<N, A> op2) {
        return this.concat(this.add(), op1, op2);
    }

    public QuaternaryOperator<N, A> sub(NullaryOperator<N, A> op1, QuaternaryOperator<N, A> op2) {
        return this.concat(this.sub(), op1, op2);
    }

    public QuaternaryOperator<N, A> mul(NullaryOperator<N, A> op1, QuaternaryOperator<N, A> op2) {
        return this.concat(this.mul(), op1, op2);
    }

    public QuaternaryOperator<N, A> div(NullaryOperator<N, A> op1, QuaternaryOperator<N, A> op2) {
        return this.concat(this.div(), op1, op2);
    }

    public QuaternaryOperator<N, A> min(NullaryOperator<N, A> op1, QuaternaryOperator<N, A> op2) {
        return this.concat(this.min(), op1, op2);
    }

    public QuaternaryOperator<N, A> max(NullaryOperator<N, A> op1, QuaternaryOperator<N, A> op2) {
        return this.concat(this.max(), op1, op2);
    }

    public QuaternaryOperator<N, A> add(QuaternaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.add(), op1, op2);
    }

    public QuaternaryOperator<N, A> sub(QuaternaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.sub(), op1, op2);
    }

    public QuaternaryOperator<N, A> mul(QuaternaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.mul(), op1, op2);
    }

    public QuaternaryOperator<N, A> div(QuaternaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.div(), op1, op2);
    }

    public QuaternaryOperator<N, A> min(QuaternaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.min(), op1, op2);
    }

    public QuaternaryOperator<N, A> max(QuaternaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return this.concat(this.max(), op1, op2);
    }

    public NAryOperator<N, A> add(NAryOperator<N, A> op1, NAryOperator<N, A> op2) {
        return this.concat(this.add(), op1, op2);
    }

    public NAryOperator<N, A> sub(NAryOperator<N, A> op1, NAryOperator<N, A> op2) {
        return this.concat(this.sub(), op1, op2);
    }

    public NAryOperator<N, A> mul(NAryOperator<N, A> op1, NAryOperator<N, A> op2) {
        return this.concat(this.mul(), op1, op2);
    }

    public NAryOperator<N, A> div(NAryOperator<N, A> op1, NAryOperator<N, A> op2) {
        return this.concat(this.div(), op1, op2);
    }

    public NAryOperator<N, A> min(NAryOperator<N, A> op1, NAryOperator<N, A> op2) {
        return this.concat(this.min(), op1, op2);
    }

    public NAryOperator<N, A> max(NAryOperator<N, A> op1, NAryOperator<N, A> op2) {
        return this.concat(this.max(), op1, op2);
    }

    public NullaryOperator<N, A> concat(UnaryOperator<N, A> op, NullaryOperator<N, A> operand) {
        return new ConcatNullaryOperator<N, A>(op, operand);
    }

    public UnaryOperator<N, A> concat(UnaryOperator<N, A> op, UnaryOperator<N, A> operand) {
        return new ConcatUnaryOperator<N, A>(op, operand);
    }

    public BinaryOperator<N, A> concat(UnaryOperator<N, A> op, BinaryOperator<N, A> operand) {
        return new ConcatBinaryOperator<N, A>(op, operand);
    }

    public TernaryOperator<N, A> concat(UnaryOperator<N, A> op, TernaryOperator<N, A> operand) {
        return new ConcatTernaryOperator<N, A>(op, operand);
    }

    public QuaternaryOperator<N, A> concat(UnaryOperator<N, A> op, QuaternaryOperator<N, A> operand) {
        return new ConcatQuaternaryOperator<N, A>(op, operand);
    }

    public NAryOperator<N, A> concat(UnaryOperator<N, A> op, NAryOperator<N, A> operand) {
        return new ConcatNAryOperator<N, A>(op, operand);
    }

    public NullaryOperator<N, A> concat(BinaryOperator<N, A> op, NullaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return new NullaryNullaryOperator<N, A>(this.arrayOps, op, op1, op2);
    }

    public UnaryOperator<N, A> concat(BinaryOperator<N, A> op, NullaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return new NullaryUnaryOperator<N, A>(this.arrayOps, op, op1, op2);
    }

    public UnaryOperator<N, A> concat(BinaryOperator<N, A> op, UnaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return new UnaryNullaryOperator<N, A>(this.arrayOps, op, op1, op2);
    }

    public BinaryOperator<N, A> concat(BinaryOperator<N, A> op, UnaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return new UnaryUnaryOperator<N, A>(this.arrayOps, op, op1, op2);
    }

    public BinaryOperator<N, A> concat(BinaryOperator<N, A> op, NullaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return new NullaryBinaryOperator<N, A>(this.arrayOps, op, op1, op2);
    }

    public BinaryOperator<N, A> concat(BinaryOperator<N, A> op, BinaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return new BinaryNullaryOperator<N, A>(this.arrayOps, op, op1, op2);
    }

    public TernaryOperator<N, A> concat(BinaryOperator<N, A> op, UnaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return new UnaryBinaryOperator<N, A>(this.arrayOps, op, op1, op2);
    }

    public TernaryOperator<N, A> concat(BinaryOperator<N, A> op, BinaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return new BinaryUnaryOperator<N, A>(this.arrayOps, op, op1, op2);
    }

    public TernaryOperator<N, A> concat(BinaryOperator<N, A> op, NullaryOperator<N, A> op1, TernaryOperator<N, A> op2) {
        return new NullaryTernaryOperator<N, A>(this.arrayOps, op, op1, op2);
    }

    public TernaryOperator<N, A> concat(BinaryOperator<N, A> op, TernaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return new TernaryNullaryOperator<N, A>(this.arrayOps, op, op1, op2);
    }

    public QuaternaryOperator<N, A> concat(BinaryOperator<N, A> op, BinaryOperator<N, A> op1, BinaryOperator<N, A> op2) {
        return new BinaryBinaryOperator<N, A>(this.arrayOps, op, op1, op2);
    }

    public QuaternaryOperator<N, A> concat(BinaryOperator<N, A> op, UnaryOperator<N, A> op1, TernaryOperator<N, A> op2) {
        return new UnaryTernaryOperator<N, A>(this.arrayOps, op, op1, op2);
    }

    public QuaternaryOperator<N, A> concat(BinaryOperator<N, A> op, TernaryOperator<N, A> op1, UnaryOperator<N, A> op2) {
        return new TernaryUnaryOperator<N, A>(this.arrayOps, op, op1, op2);
    }

    public QuaternaryOperator<N, A> concat(BinaryOperator<N, A> op, NullaryOperator<N, A> op1, QuaternaryOperator<N, A> op2) {
        return new NullaryQuaternaryOperator<N, A>(this.arrayOps, op, op1, op2);
    }

    public QuaternaryOperator<N, A> concat(BinaryOperator<N, A> op, QuaternaryOperator<N, A> op1, NullaryOperator<N, A> op2) {
        return new QuaternaryNullaryOperator<N, A>(this.arrayOps, op, op1, op2);
    }

    public NAryOperator<N, A> concat(BinaryOperator<N, A> op, NAryOperator<N, A> op1, NAryOperator<N, A> op2) {
        return new NAryNAryOperator<N, A>(this.arrayOps, op, op1, op2);
    }
}

