/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jsmat.variable;

import ch.javasoft.jsmat.common.MatClass;
import ch.javasoft.jsmat.common.MatType;
import ch.javasoft.jsmat.primitive.MatPrimitive;
import ch.javasoft.jsmat.variable.MatReserved;
import java.io.DataOutput;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MatReservedMatrix<A>
extends MatReserved {
    private final MatType mMatType;

    public MatReservedMatrix(MatClass matClass, MatType matType, int[] dims) {
        super(matClass, dims);
        this.mMatType = matType;
        this.checkRawDataSizeOverflow(matType.size);
    }

    @Override
    public int getRawDataSize() {
        return this.mMatType.size * this.getDimLength();
    }

    @Override
    public void writeDataBlockStart(String name, DataOutput out) throws IOException {
        this.writeStart(name, out);
        MatPrimitive.writeStart(this.mMatType, out, this.getRawDataSize());
    }

    public abstract int appendData(DataOutput var1, A var2) throws IOException;

    @Override
    public void writeDataBlockEnd(DataOutput out) throws IOException {
        MatPrimitive.writeEnd(this.mMatType, out, this.getRawDataSize());
    }

    public static MatReservedMatrix<double[]> createDoubleMatrix(int rows, int cols) {
        return MatReservedMatrix.createDoubleMatrix(new int[]{rows, cols});
    }

    public static MatReservedMatrix<double[]> createDoubleMatrix(int[] dims) {
        return new MatReservedMatrix<double[]>(MatClass.DOUBLE, MatType.DOUBLE, dims){

            @Override
            public int appendData(DataOutput out, double[] data) throws IOException {
                int i = 0;
                while (i < data.length) {
                    out.writeDouble(data[i]);
                    ++i;
                }
                return data.length;
            }
        };
    }

    public static MatReservedMatrix<int[]> createInt32Matrix(int rows, int cols) {
        return MatReservedMatrix.createInt32Matrix(new int[]{rows, cols});
    }

    public static MatReservedMatrix<int[]> createInt32Matrix(int[] dims) {
        return new MatReservedMatrix<int[]>(MatClass.INT32, MatType.INT32, dims){

            @Override
            public int appendData(DataOutput out, int[] data) throws IOException {
                int i = 0;
                while (i < data.length) {
                    out.writeInt(data[i]);
                    ++i;
                }
                return data.length;
            }
        };
    }

    public static MatReservedMatrix<int[]> createUInt32Matrix(int rows, int cols) {
        return MatReservedMatrix.createUInt32Matrix(new int[]{rows, cols});
    }

    public static MatReservedMatrix<int[]> createUInt32Matrix(int[] dims) {
        return new MatReservedMatrix<int[]>(MatClass.UINT32, MatType.UINT32, dims){

            @Override
            public int appendData(DataOutput out, int[] data) throws IOException {
                int i = 0;
                while (i < data.length) {
                    out.writeInt(data[i]);
                    ++i;
                }
                return data.length;
            }
        };
    }

    public static MatReservedMatrix<int[]> createInt8Matrix(int rows, int cols) {
        return MatReservedMatrix.createInt8Matrix(new int[]{rows, cols});
    }

    public static MatReservedMatrix<int[]> createInt8Matrix(int[] dims) {
        return new MatReservedMatrix<int[]>(MatClass.INT8, MatType.INT8, dims){

            @Override
            public int appendData(DataOutput out, int[] data) throws IOException {
                int i = 0;
                while (i < data.length) {
                    out.writeByte((byte)data[i]);
                    ++i;
                }
                return data.length;
            }
        };
    }

    public static MatReservedMatrix<int[]> createUInt8Matrix(int rows, int cols) {
        return MatReservedMatrix.createUInt8Matrix(new int[]{rows, cols});
    }

    public static MatReservedMatrix<int[]> createUInt8Matrix(int[] dims) {
        return new MatReservedMatrix<int[]>(MatClass.UINT8, MatType.UINT8, dims){

            @Override
            public int appendData(DataOutput out, int[] data) throws IOException {
                int i = 0;
                while (i < data.length) {
                    out.writeByte(data[i]);
                    ++i;
                }
                return data.length;
            }
        };
    }
}

