/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jbase;

import ch.javasoft.jbase.BufferedRandomAccessPersister;
import ch.javasoft.jbase.ByteArray;
import ch.javasoft.jbase.EntityMarshaller;
import ch.javasoft.jbase.FixedTableRow;
import ch.javasoft.jbase.FixedWidthTable;
import ch.javasoft.jbase.RandomAccessFilePersistor;
import ch.javasoft.jbase.RandomAccessPersister;
import ch.javasoft.jbase.Table;
import ch.javasoft.jbase.concurrent.Stateful;
import ch.javasoft.jbase.util.UnsupportedOperationException;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableWidthTable<E>
implements Table<E>,
Stateful {
    private final File folder;
    private final String fileName;
    private final EntityMarshaller<E> entityMarshaller;
    private final int cacheTableSize;
    private final int cacheEntrySize;
    private volatile FixedWidthTable<FixedTableRow> primaryTable;
    private final Map<File, FixedWidthTable<FixedTableRow>> secondaryTables;
    private final ByteArray byteBuffer;

    protected VariableWidthTable(File folder, String fileName, EntityMarshaller<E> entityMarshaller, int cacheTableSize, int cacheEntrySize) {
        this.folder = folder;
        this.fileName = fileName;
        this.entityMarshaller = entityMarshaller;
        this.cacheTableSize = cacheTableSize;
        this.cacheEntrySize = cacheEntrySize;
        this.secondaryTables = new ConcurrentHashMap<File, FixedWidthTable<FixedTableRow>>();
        this.byteBuffer = new ByteArray();
    }

    public static <En> VariableWidthTable<En> open(File folder, String fileName, EntityMarshaller<En> entityMarshaller, int cacheTableSize, int cacheEntrySize) throws IOException {
        VariableWidthTable<En> tbl = new VariableWidthTable<En>(folder, fileName, entityMarshaller, cacheTableSize, cacheEntrySize);
        tbl.primaryTable = super.openPrimaryTable();
        return tbl;
    }

    public static <En> VariableWidthTable<En> create(File folder, String fileName, int firstTableByteWidth, EntityMarshaller<En> entityMarshaller, int cacheTableSize, int cacheEntrySize) throws IOException {
        VariableWidthTable<En> tbl = new VariableWidthTable<En>(folder, fileName, entityMarshaller, cacheTableSize, cacheEntrySize);
        VariableWidthTable.eraseTableFiles(folder, fileName);
        tbl.primaryTable = super.createPrimaryTable(firstTableByteWidth);
        return tbl;
    }

    private static void eraseTableFiles(File folder, String fileName) {
        File[] files;
        final String prefix = VariableWidthTable.getFileNamePrefix(fileName);
        final String postfix = VariableWidthTable.getFileNamePostfix(fileName);
        File[] fileArray = files = folder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(prefix) && name.endsWith(postfix);
            }
        });
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    private FixedWidthTable<FixedTableRow> openPrimaryTable() throws IOException {
        return this.openTableFile(0, -1, false);
    }

    private FixedWidthTable<FixedTableRow> createPrimaryTable(int rawByteWidth) throws IOException {
        int byteWidth = VariableWidthTable.getTableByteWidth(0, rawByteWidth);
        return this.openTableFile(0, byteWidth, true);
    }

    private FixedWidthTable<FixedTableRow> openSecondaryTable(int rawByteWidth, boolean createIfNeeded) throws IOException {
        int byteWidth = VariableWidthTable.getTableByteWidth(1, rawByteWidth);
        File file = this.getTableFile(1, byteWidth);
        FixedWidthTable<FixedTableRow> tbl = this.secondaryTables.get(file);
        if (tbl == null) {
            tbl = this.openTableFile(1, byteWidth, createIfNeeded);
            this.secondaryTables.put(file, tbl);
        }
        return tbl;
    }

    private RandomAccessPersister createRandomAccessPersister(File file) throws FileNotFoundException {
        if (this.cacheTableSize > 0 && this.cacheEntrySize > 0) {
            return new BufferedRandomAccessPersister(file, this.cacheTableSize, this.cacheEntrySize);
        }
        return new RandomAccessFilePersistor(file);
    }

    protected FixedWidthTable<FixedTableRow> openTableFile(int tableIndex, int byteWidth, boolean createIfNeeded) throws IOException {
        File file = this.getTableFile(tableIndex, byteWidth);
        if (file.exists()) {
            RandomAccessPersister rap = this.createRandomAccessPersister(file);
            int width = FixedWidthTable.readByteWidth(rap);
            if (byteWidth >= 0 && width != VariableWidthTable.getTotalByteWidth(tableIndex, byteWidth)) {
                throw new IOException("table file has unexpected byte width, expected " + VariableWidthTable.getTotalByteWidth(tableIndex, byteWidth) + " but found " + width + " for file " + file.getAbsolutePath());
            }
            FixedTableRow row = FixedTableRow.getByTotalByteWidth(width, VariableWidthTable.getTableIndexCount(tableIndex));
            return FixedWidthTable.open(rap, row);
        }
        if (createIfNeeded) {
            RandomAccessPersister rap = this.createRandomAccessPersister(file);
            int width = byteWidth;
            FixedTableRow row = FixedTableRow.getByByteArrayLength(width, VariableWidthTable.getTableIndexCount(tableIndex));
            FixedWidthTable<FixedTableRow> tbl = FixedWidthTable.create(rap, row);
            tbl.flush();
            return tbl;
        }
        throw new IOException("no such table: " + file.getAbsolutePath());
    }

    protected static String getFileNamePrefix(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        return lastDot < 0 ? fileName : fileName.substring(0, lastDot);
    }

    protected static String getFileNamePostfix(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        return lastDot < 0 ? "" : fileName.substring(lastDot);
    }

    protected File getTableFile(int tableIndex, int byteWidth) {
        if (tableIndex == 0) {
            return new File(this.folder, this.fileName);
        }
        int lastDot = this.fileName.lastIndexOf(46);
        if (lastDot < 0) {
            return new File(this.folder, String.valueOf(this.fileName) + byteWidth);
        }
        return new File(this.folder, String.valueOf(this.fileName.substring(0, lastDot)) + byteWidth + this.fileName.substring(lastDot));
    }

    protected static int getTotalByteWidth(int tableIndex, int byteWidth) {
        return byteWidth + 4 * VariableWidthTable.getTableIndexCount(tableIndex);
    }

    protected static int getTableIndexCount(int tableIndex) {
        return tableIndex == 0 ? 2 : 1;
    }

    protected static int getTableByteWidth(int tableIndex, int rawByteWidth) throws IOException {
        int width;
        if (tableIndex == 0) {
            width = 4 * ((rawByteWidth + 3) / 4);
        } else {
            width = 4;
            while (width < rawByteWidth && width > 0) {
                width <<= 1;
            }
        }
        if (width < rawByteWidth) {
            throw new IOException("table width overflow: " + rawByteWidth);
        }
        return width;
    }

    @Override
    public int add(E entity) throws IOException {
        if (this.primaryTable == null) {
            throw new IOException("table already closed");
        }
        this.byteBuffer.reset();
        DataOutputStream das = this.byteBuffer.getDataOutputStream();
        this.entityMarshaller.writeTo(entity, das);
        das.flush();
        FixedTableRow row0 = (FixedTableRow)this.primaryTable.getEntityMarshaller();
        row0.getBytesFrom(this.byteBuffer);
        int remainingBytes = this.byteBuffer.getLength();
        if (remainingBytes != 0) {
            FixedWidthTable<FixedTableRow> secondaryTable = this.openSecondaryTable(remainingBytes, true);
            FixedTableRow row1 = (FixedTableRow)secondaryTable.getEntityMarshaller();
            row1.getBytesFrom(this.byteBuffer);
            row1.setInt(0, this.primaryTable.size());
            if (!this.byteBuffer.isEmpty()) {
                throw new IOException("internal error, buffer not empty after flushing to secondary table");
            }
            int index1 = secondaryTable.size();
            secondaryTable.add(row1);
            row0.setInt(0, row1.getByteArrayLength());
            row0.setInt(1, index1);
        } else {
            row0.setInt(0, 0);
            row0.setInt(1, 0);
        }
        return this.primaryTable.add(row0);
    }

    @Override
    public void close(boolean erase) throws IOException {
        if (this.primaryTable != null) {
            for (FixedWidthTable<FixedTableRow> tbl : this.secondaryTables.values()) {
                tbl.close(erase);
            }
            this.primaryTable.close(erase);
            this.secondaryTables.clear();
            this.primaryTable = null;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.primaryTable == null) {
            throw new IOException("table already closed");
        }
        for (FixedWidthTable<FixedTableRow> tbl : this.secondaryTables.values()) {
            tbl.flush();
        }
        this.primaryTable.flush();
    }

    protected void finalize() throws Throwable {
        this.close(false);
    }

    private EntityMarshaller<E> createReadCopyMarshaller(ReadWriteLock lock) throws IOException {
        return this.entityMarshaller instanceof Stateful ? (EntityMarshaller)((Stateful)((Object)this.entityMarshaller)).createReadCopy(lock) : this.entityMarshaller;
    }

    @Override
    public VariableWidthTable<E> createReadCopy(final ReadWriteLock lock) throws IOException {
        EntityMarshaller<E> marshaller = this.createReadCopyMarshaller(lock);
        VariableWidthTable tbl = new VariableWidthTable<E>(this.folder, this.fileName, marshaller, this.cacheTableSize, this.cacheEntrySize){

            @Override
            protected FixedWidthTable<FixedTableRow> openTableFile(int tableIndex, int byteWidth, boolean createIfNeeded) throws IOException {
                if (createIfNeeded) {
                    throw new IOException("internal error: read only table");
                }
                boolean refetchReadLock = false;
                try {
                    lock.readLock().unlock();
                    refetchReadLock = true;
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    // empty catch block
                }
                lock.writeLock().lock();
                try {
                    VariableWidthTable.this.flush();
                    FixedWidthTable main = tableIndex == 0 ? VariableWidthTable.this.primaryTable : VariableWidthTable.this.openSecondaryTable(byteWidth, false);
                    Object object = main.createReadCopy(lock);
                    return object;
                }
                finally {
                    lock.writeLock().unlock();
                    if (refetchReadLock) {
                        lock.readLock().lock();
                    }
                }
            }

            private void sync() throws IOException {
                if (VariableWidthTable.this.primaryTable == null) {
                    this.close(false);
                    throw new IOException("table already closed");
                }
            }

            @Override
            public E get(int index) throws IOException {
                this.sync();
                return super.get(index);
            }

            @Override
            public int size() throws IOException {
                this.sync();
                return super.size();
            }

            @Override
            public int add(E entity) throws IOException {
                throw new IOException("unmodifyable read copy table");
            }

            @Override
            public void set(int index, E entity) throws IOException {
                throw new IOException("unmodifyable read copy table");
            }

            @Override
            public void swap(int indexA, int indexB) throws IOException {
                throw new IOException("unmodifyable read copy table");
            }

            @Override
            public void remove(int index) throws IOException {
                throw new IOException("unmodifyable read copy table");
            }

            @Override
            public void removeAll() throws IOException {
                throw new IOException("unmodifyable read copy table");
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close(boolean erase) throws IOException {
                if (erase) {
                    throw new UnsupportedOperationException("unmodifyable read copy table");
                }
                super.close(false);
            }

            @Override
            protected void finalize() throws Throwable {
                this.close(false);
            }
        };
        tbl.primaryTable = super.openPrimaryTable();
        return tbl;
    }

    @Override
    public E get(int index) throws IOException {
        if (this.primaryTable == null) {
            throw new IOException("table already closed");
        }
        this.byteBuffer.reset();
        FixedTableRow row0 = this.primaryTable.get(index);
        row0.putBytesTo(this.byteBuffer);
        int tbl1 = row0.getInt(0);
        int ind1 = row0.getInt(1);
        if (tbl1 != 0) {
            FixedWidthTable<FixedTableRow> secondaryTable = this.openSecondaryTable(tbl1, false);
            FixedTableRow row1 = secondaryTable.get(ind1);
            row1.putBytesTo(this.byteBuffer);
        }
        return this.entityMarshaller.readFrom(this.byteBuffer.getDataInputStream());
    }

    @Override
    public void remove(int index) throws IOException {
        if (this.primaryTable == null) {
            throw new IOException("table already closed");
        }
        FixedWidthTable<FixedTableRow> fwt0 = this.primaryTable;
        int ind0 = index;
        FixedTableRow row0 = (FixedTableRow)fwt0.getEntityMarshaller();
        row0.setIndexOnlyMode(true);
        try {
            row0 = fwt0.get(ind0);
        }
        finally {
            row0.setIndexOnlyMode(false);
        }
        int tbl1 = row0.getInt(0);
        int ind1 = row0.getInt(1);
        fwt0.remove(ind0);
        int last0 = this.primaryTable.size();
        if (ind0 != last0) {
            row0.setIndexOnlyMode(true);
            try {
                row0 = fwt0.get(ind0);
            }
            finally {
                row0.setIndexOnlyMode(false);
            }
            int tbl2 = row0.getInt(0);
            int ind2 = row0.getInt(1);
            if (tbl2 != 0) {
                FixedWidthTable<FixedTableRow> fwt2 = this.openSecondaryTable(tbl2, false);
                FixedTableRow row2 = (FixedTableRow)fwt2.getEntityMarshaller();
                row2.setIndexOnlyMode(true);
                try {
                    row2.setInt(0, ind0);
                    fwt2.set(ind2, row2);
                }
                finally {
                    row2.setIndexOnlyMode(false);
                }
            }
        }
        if (tbl1 != 0) {
            FixedWidthTable<FixedTableRow> fwt1 = this.openSecondaryTable(tbl1, false);
            fwt1.remove(ind1);
            int last1 = fwt1.size();
            if (ind1 != last1) {
                FixedTableRow row1 = (FixedTableRow)fwt1.getEntityMarshaller();
                row1.setIndexOnlyMode(true);
                try {
                    row1 = fwt1.get(ind1);
                }
                finally {
                    row1.setIndexOnlyMode(false);
                }
                int ind0b = row1.getInt(0);
                row0.setIndexOnlyMode(true);
                try {
                    row0.setInt(0, tbl1);
                    row0.setInt(1, ind1);
                    fwt0.set(ind0b, row0);
                }
                finally {
                    row0.setIndexOnlyMode(false);
                }
            }
            if (fwt1.size() == 0) {
                fwt1.close(true);
                File file = this.getTableFile(1, tbl1);
                file.delete();
                if (this.secondaryTables.remove(file) != fwt1) {
                    throw new IOException("internal error, should have deleted file of current table: " + file.getAbsolutePath());
                }
            }
        }
    }

    @Override
    public void removeAll() throws IOException {
        int primaryByteWidth = this.primaryTable.getByteWidth() - 8;
        this.close(true);
        VariableWidthTable.eraseTableFiles(this.folder, this.fileName);
        this.primaryTable = this.createPrimaryTable(primaryByteWidth);
    }

    @Override
    public void set(int index, E entity) throws IOException {
        if (this.primaryTable == null) {
            throw new IOException("table already closed");
        }
        this.add(entity);
        this.remove(index);
    }

    @Override
    public void swap(int indexA, int indexB) throws IOException {
        if (this.primaryTable == null) {
            throw new IOException("table already closed");
        }
        if (indexA == indexB) {
            return;
        }
        this.byteBuffer.reset();
        FixedTableRow row = (FixedTableRow)this.primaryTable.getEntityMarshaller();
        row = this.primaryTable.get(indexA);
        int tblA = row.getInt(0);
        int indA = row.getInt(1);
        row.putBytesTo(this.byteBuffer);
        row = this.primaryTable.get(indexB);
        int tblB = row.getInt(0);
        int indB = row.getInt(1);
        this.primaryTable.set(indexA, row);
        row.getBytesFrom(this.byteBuffer);
        row.setInt(0, tblA);
        row.setInt(1, indA);
        this.primaryTable.set(indexB, row);
        if (tblA != 0) {
            FixedWidthTable<FixedTableRow> secA = this.openSecondaryTable(tblA, false);
            FixedTableRow rowA = secA.get(indA);
            rowA.setIndexOnlyMode(true);
            try {
                rowA.setInt(0, indexB);
                secA.set(indA, rowA);
            }
            finally {
                rowA.setIndexOnlyMode(false);
            }
        }
        if (tblB != 0) {
            FixedWidthTable<FixedTableRow> secB = this.openSecondaryTable(tblB, false);
            FixedTableRow rowB = secB.get(indB);
            rowB.setIndexOnlyMode(true);
            try {
                rowB.setInt(0, indexA);
                secB.set(indB, rowB);
            }
            finally {
                rowB.setIndexOnlyMode(false);
            }
        }
    }

    @Override
    public int size() throws IOException {
        if (this.primaryTable == null) {
            throw new IOException("table already closed");
        }
        return this.primaryTable.size();
    }
}

