/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.cdd.parser;

import ch.javasoft.cdd.parser.CddFileType;
import ch.javasoft.cdd.parser.CddNumberFormat;
import ch.javasoft.math.NumberMatrixConverter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CddParser {
    private final Object[] matrix;
    private final CddFileType fileType;
    private final CddNumberFormat numberFormat;

    public CddParser(File file) throws FileNotFoundException, IOException {
        this(new FileInputStream(file));
    }

    public CddParser(InputStream in) throws IOException {
        this(new InputStreamReader(in));
    }

    public CddParser(Reader reader) throws IOException {
        this(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader));
    }

    public CddParser(BufferedReader reader) throws IOException {
        CddNumberFormat numberFormat;
        String line;
        CddFileType fileType = null;
        int lineNo = 0;
        while ((line = reader.readLine()) != null && (fileType = CddFileType.parsePreamble(line)) == null) {
            ++lineNo;
        }
        if (fileType != null) {
            line = reader.readLine();
            ++lineNo;
        } else {
            throw CddParser.createIOException(String.valueOf(CddFileType.Ine.preamble) + " or " + CddFileType.Ext.preamble + " expected", lineNo, line);
        }
        if (line != null && Keyword.begin.matches(line)) {
            line = reader.readLine();
            ++lineNo;
        } else {
            throw CddParser.createIOException((Object)((Object)Keyword.begin) + " expected", lineNo, line);
        }
        Matcher matcher = Pattern.compile("\\s*([0-9]+)\\s+([0-9]+)\\s+(\\w+)\\s*").matcher(line);
        if (!matcher.matches()) {
            throw CddParser.createIOException("preamble syntax error", lineNo, line);
        }
        int m = Integer.parseInt(matcher.group(1));
        int dims = Integer.parseInt(matcher.group(2));
        String sFormat = matcher.group(3);
        try {
            numberFormat = CddNumberFormat.valueOf(sFormat);
        }
        catch (Exception ex) {
            throw CddParser.createIOException("unsupported format in preamble, e=" + ex, lineNo, line);
        }
        this.matrix = numberFormat.newMatrix(m, dims);
        int row = 0;
        int col = 0;
        while ((line = reader.readLine()) != null && !Keyword.end.matches(line)) {
            ++lineNo;
            String[] parts = line.trim().split("\\s+");
            int i = 0;
            while (i < parts.length) {
                try {
                    numberFormat.parseAndSet(this.matrix, row, col, parts[i]);
                }
                catch (Exception ex) {
                    throw CddParser.createIOException("cannot parse number value \"" + parts[i] + "\", e=" + ex, lineNo, line);
                }
                if (++col == dims) {
                    col = 0;
                    ++row;
                }
                ++i;
            }
        }
        if (!Keyword.end.matches(line)) {
            throw CddParser.createIOException("unexpected end of file, " + (Object)((Object)Keyword.end) + " keyword expected", lineNo, line);
        }
        this.fileType = fileType;
        this.numberFormat = numberFormat;
    }

    private static IOException createIOException(String msg, int lineNo, String line) {
        return new IOException("[" + lineNo + "] " + msg + ": " + (line == null ? "<end of file>" : line));
    }

    public Object[] getMatrix() {
        return this.matrix;
    }

    public <A> A[] getMatrixCast(Class<A> arrayClass) throws ClassCastException {
        return CddNumberFormat.castMatrix(arrayClass, this.matrix);
    }

    public <A> A[] getMatrixConverted(NumberMatrixConverter<A> converter) throws ClassCastException {
        int rows = this.matrix.length;
        int cols = this.numberFormat.getColumnCount(this.matrix);
        A[] dst = converter.newMatrix(rows, cols);
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                Number val = this.numberFormat.getNumber(this.matrix, r, c);
                converter.copy(val, dst, r, c);
                ++c;
            }
            ++r;
        }
        return dst;
    }

    public CddFileType getFileType() {
        return this.fileType;
    }

    public CddNumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public String toString() {
        int rows = this.matrix.length;
        int cols = this.numberFormat.getColumnCount(this.matrix);
        StringBuilder sb = new StringBuilder();
        sb.append("cdd data, P = { ");
        sb.append((Object)this.fileType).append(":");
        sb.append(rows).append('x').append(cols);
        sb.append(" (").append((Object)this.numberFormat).append(")");
        sb.append(" }");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Keyword {
        begin,
        end;


        public boolean matches(String line) {
            if (line == null) {
                return false;
            }
            return line.startsWith(this.name()) && line.substring(this.name().length()).trim().length() == 0;
        }
    }
}

