/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.bitset.search.tree;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.bitset.search.tree.LeafNode;
import ch.javasoft.bitset.search.tree.Node;

public class InterNode
implements Node {
    private final int bit;
    private final IBitSet union;
    private final IBitSet inter;
    private Node left;
    private Node right;

    public InterNode(int bit, Node left, Node right, IBitSet union, IBitSet inter) {
        this.bit = bit;
        this.left = left;
        this.right = right;
        this.union = union;
        this.inter = inter;
    }

    public InterNode(int bit, LeafNode left, LeafNode right) {
        this(bit, left, right, left.set.getOr(right.set), left.set.getAnd(right.set));
    }

    public static InterNode create(LeafNode leaf1, LeafNode leaf2, int bit) {
        boolean val1 = leaf1.set.get(bit);
        boolean val2 = leaf2.set.get(bit);
        while (val1 == val2) {
            val1 = leaf1.set.get(++bit);
            val2 = leaf2.set.get(bit);
        }
        return new InterNode(bit, val1 ? leaf2 : leaf1, val1 ? leaf1 : leaf2);
    }

    public IBitSet union() {
        return this.union;
    }

    public IBitSet inter() {
        return this.inter;
    }

    public Node add(IBitSet set, int bit) {
        while (bit < this.bit) {
            boolean uni;
            boolean val = set.get(bit);
            if (val != (uni = this.union.get(bit))) {
                Node left = val ? this : new LeafNode(set);
                Node right = val ? new LeafNode(set) : this;
                IBitSet union = this.union.getOr(set);
                IBitSet inter = this.inter.getAnd(set);
                return new InterNode(bit, left, right, union, inter);
            }
            ++bit;
        }
        assert (bit == this.bit);
        if (bit != this.bit) {
            throw new RuntimeException("assert: bitIndex == this.bitIndex");
        }
        if (set.get(bit)) {
            Node node = this.right.add(set, bit + 1);
            if (node != null) {
                this.right = node;
                this.union.or(set);
                this.inter.and(set);
                return this;
            }
            return null;
        }
        Node node = this.left.add(set, bit + 1);
        if (node != null) {
            this.left = node;
            this.union.or(set);
            this.inter.and(set);
            return this;
        }
        return null;
    }

    public Node remove(IBitSet set) {
        if (set.isSubSetOf(this.union) && this.inter.isSubSetOf(set)) {
            Node node = this.left.remove(set);
            if (node != null) {
                if (Node.EMPTY.equals(node)) {
                    return this.right;
                }
                IBitSet union = node.union().getOr(this.right.union());
                IBitSet inter = node.inter().getAnd(this.right.inter());
                return new InterNode(this.bit, node, this.right, union, inter);
            }
            node = this.right.remove(set);
            if (node != null) {
                if (Node.EMPTY.equals(node)) {
                    return this.left;
                }
                IBitSet union = node.union().getOr(this.left.union());
                IBitSet inter = node.inter().getAnd(this.left.inter());
                return new InterNode(this.bit, this.left, node, union, inter);
            }
        }
        return null;
    }

    public IBitSet findSuperSet(IBitSet of) {
        if (of.isSubSetOf(this.union)) {
            IBitSet set = this.left.findSuperSet(of);
            return set == null ? this.right.findSuperSet(of) : set;
        }
        return null;
    }

    public IBitSet findSuperSet(IBitSet of, IBitSet after) {
        if (of.isSubSetOf(this.union) && this.union.compareTo(after) > 0) {
            IBitSet set = this.left.findSuperSet(of, after);
            return set == null ? this.right.findSuperSet(of, after) : set;
        }
        return null;
    }

    public IBitSet findSubSet(IBitSet of) {
        if (this.inter.isSubSetOf(of)) {
            IBitSet set = this.left.findSubSet(of);
            return set == null ? this.right.findSubSet(of) : set;
        }
        return null;
    }

    public IBitSet findSubSet(IBitSet of, IBitSet after) {
        if (this.inter.isSubSetOf(of) && this.union.compareTo(after) > 0) {
            IBitSet set = this.left.findSubSet(of, after);
            return set == null ? this.right.findSubSet(of, after) : set;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('{');
        sb.append(this.bit);
        sb.append(", U=").append(this.union);
        sb.append(", I=").append(this.inter);
        sb.append(", L=").append(this.left);
        sb.append(", R=").append(this.right);
        return sb.append('}').toString();
    }
}

