/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  var define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
"b6134971a2": function _(e,s,o){Object.defineProperty(o,"__esModule",{value:!0});const t=e("tslib").__importStar(e("515b1a12fc"));o.AwesomePanelExtensions=t,e("@bokehjs/base").register_models(t)},
"515b1a12fc": function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0});var t=e("5c604c9068");o.WebComponent=t.WebComponent},
"5c604c9068": function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const o=e("tslib"),s=e("@bokehjs/core/dom"),i=o.__importStar(e("@bokehjs/core/properties")),r=e("@bokehjs/models/layouts/html_box"),a=e("@bokehjs/styles/widgets/inputs");function l(e){return(new DOMParser).parseFromString(e,"text/html").documentElement.textContent}class h extends r.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,()=>this.handleNameChange()),this.connect(this.model.properties.innerHTML.change,()=>this.render()),this.connect(this.model.properties.attributesLastChange.change,()=>this.handleAttributesLastChangeChange()),this.connect(this.model.properties.propertiesLastChange.change,()=>this.handlePropertiesLastChangeChange()),this.connect(this.model.properties.columnDataSource.change,()=>this.handleColumnDataSourceChange())}handleNameChange(){this.label_el&&(this.label_el.textContent=this.model.name)}render(){super.render(),this.el.innerHTML!==this.model.innerHTML&&this.createOrUpdateWebComponentElement()}after_layout(){"after_layout"in this.webComponentElement&&this.webComponentElement.after_layout()}createOrUpdateWebComponentElement(){this.webComponentElement&&(this.webComponentElement.onchange=null);const e=this.model.name;"inputgroup"===this.model.componentType&&e?(this.group_el=s.div({class:a.bk_input_group},this.label_el),this.group_el.innerHTML=l(this.model.innerHTML),this.webComponentElement=this.group_el.firstElementChild,this.label_el=s.label({style:{display:0==e.length?"none":""}},e),this.group_el.insertBefore(this.label_el,this.webComponentElement),this.el.appendChild(this.group_el)):(this.el.innerHTML=l(this.model.innerHTML),this.webComponentElement=this.el.firstElementChild),this.activate_scripts(this.webComponentElement.parentNode),this.initPropertyValues(),this.handlePropertiesLastChangeChange(),this.handleColumnDataSourceChange(),this.webComponentElement.onchange=e=>this.handlePropertiesChange(e),this.addEventListeners(),this.addAttributesMutationObserver()}addAttributesMutationObserver(){if(!this.model.attributesToWatch)return;let e={childList:!1,attributes:!0,characterData:!1,subtree:!1,attributeFilter:Object.keys(this.model.attributesToWatch),attributeOldValue:!1,characterDataOldValue:!1};new MutationObserver(e=>{let t=new Object;for(let e in this.model.attributesToWatch){const n=this.webComponentElement.getAttribute(e);t[e]=n}this.model.attributesLastChange!==t&&(this.model.attributesLastChange=t)}).observe(this.webComponentElement,e)}addEventListeners(){this.eventsCount={};for(let e in this.model.eventsToWatch)this.eventsCount[e]=0,this.webComponentElement.addEventListener(e,e=>this.eventHandler(e),!1)}transform_cds_to_records(e){const t=[],n=e.columns(),o=e.get_length();if(0===n.length||null===o)return[];for(let s=0;s<o;s++){const o={};for(const t of n){let n=e.get_array(t);const i=null==n[0].shape?null:n[0].shape;null!=i&&i.length>1&&"number"==typeof i[0]?o[t]=n.slice(s*i[1],s*i[1]+i[1]):o[t]=n[s]}t.push(o)}return t}isFunction(e){if(e){const t={}.toString.call(e);return"[object Function]"===t||"[object AsyncFunction]"===t}return!1}handleColumnDataSourceChange(){if(this.model.columnDataSource){let e;e="records"===this.model.columnDataSourceOrient?this.transform_cds_to_records(this.model.columnDataSource):this.model.columnDataSource.data;const t=this.model.columnDataSourceLoadFunction.toString(),n=this.webComponentElement[t];this.isFunction(n)?this.webComponentElement[t](e):this.webComponentElement[t]=e}}activate_scripts(e){Array.from(e.querySelectorAll("script")).forEach(e=>{const t=document.createElement("script");Array.from(e.attributes).forEach(e=>t.setAttribute(e.name,e.value)),t.appendChild(document.createTextNode(e.innerHTML)),e.parentNode&&e.parentNode.replaceChild(t,e)})}get_nested_property(e,t){let n=(t=(t=t.replace(/\[(\w+)\]/g,".$1")).replace(/^\./,"")).split(".");for(let t=0,o=n.length;t<o;++t){let o=n[t];if(!(o in e))return"";e=e[o]}return e}set_nested_property(e,t,n){const o=t.split(".");if(1===o.length)e[t]=n;else{const t=o.length;for(let n=0;n<t-1;n++){const t=o[n];e[t]||(e[t]={}),e=e[t]}e[o[t-1]]=n}}eventHandler(e){let t=e.type;this.eventsCount[t]+=1;let n={};n[t]=this.eventsCount[t],this.model.eventsCountLastChange=n,this.checkIfPropertiesChanged()}checkIfPropertiesChanged(){const e={};for(const t in this.model.propertiesToWatch){const n=this.propertyValues[t],o=this.get_nested_property(this.webComponentElement,t);n!=o&&(e[t]=o,this.propertyValues[t]=o)}Object.keys(e).length&&(this.model.propertiesLastChange=e)}handlePropertiesChange(e){const t=new Object;for(const n in this.model.propertiesToWatch)e.detail&&n in e.detail?(t[n]=e.detail[n],this.propertyValues[n]=e.detail[n]):e.target&&n in e.target&&(t[n]=e.target[n],this.propertyValues[n]=e.target[n]);Object.keys(t).length&&(this.model.propertiesLastChange=t)}initPropertyValues(){if(this.propertyValues=new Object,this.webComponentElement)for(let e in this.model.propertiesToWatch){let t=this.propertyValues[e],n=this.get_nested_property(this.webComponentElement,e);n!==t&&(this.propertyValues[e]=n)}}handleAttributesLastChangeChange(){if(!this.webComponentElement)return;let e=this.model.attributesLastChange;for(let t in this.model.attributesLastChange)if(t in this.model.attributesToWatch){let n=this.webComponentElement.getAttribute(t),o=e[t];n!==o&&(null===o?this.webComponentElement.removeAttribute(t):this.webComponentElement.setAttribute(t,o))}}handlePropertiesLastChangeChange(){if(!this.webComponentElement)return;let e=this.model.propertiesLastChange;for(let t in this.model.propertiesLastChange)if(t in this.model.propertiesToWatch){let n=e[t];this.set_nested_property(this.webComponentElement,t,n)}}}n.WebComponentView=h,h.__name__="WebComponentView";class p extends r.HTMLBox{constructor(e){super(e)}static init_WebComponent(){this.prototype.default_view=h,this.define({componentType:[i.String,"htmlbox"],innerHTML:[i.String,""],attributesToWatch:[i.Any],attributesLastChange:[i.Any],propertiesToWatch:[i.Any],propertiesLastChange:[i.Any],eventsToWatch:[i.Any],eventsCountLastChange:[i.Any],columnDataSource:[i.Any],columnDataSourceOrient:[i.Any],columnDataSourceLoadFunction:[i.Any]})}}n.WebComponent=p,p.__name__="WebComponent",p.__module__="awesome_panel_extensions.bokeh_extensions.web_component",p.init_WebComponent()},
}, "b6134971a2", {"index":"b6134971a2","bokeh_extensions/index":"515b1a12fc","bokeh_extensions/web_component":"5c604c9068"}, {});
})

