"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const spot_interrupt_handler_1 = require("./spot-interrupt-handler");
function renderUserData(clusterName, autoScalingGroup, options = {}) {
    const stack = core_1.Stack.of(autoScalingGroup);
    // determine logical id of ASG so we can signal cloudformation
    const cfn = autoScalingGroup.node.defaultChild;
    const asgLogicalId = cfn.logicalId;
    const extraArgs = new Array();
    extraArgs.push(`--use-max-pods ${options.useMaxPods === undefined ? true : options.useMaxPods}`);
    if (options.awsApiRetryAttempts) {
        extraArgs.push(`--aws-api-retry-attempts ${options.awsApiRetryAttempts}`);
    }
    if (options.enableDockerBridge) {
        extraArgs.push(`--enable-docker-bridge`);
    }
    if (options.dockerConfigJson) {
        extraArgs.push(`--docker-config-json '${options.dockerConfigJson}'`);
    }
    if (options.additionalArgs) {
        extraArgs.push(options.additionalArgs);
    }
    const commandLineSuffix = extraArgs.join(' ');
    const kubeletExtraArgsSuffix = options.kubeletExtraArgs || '';
    // determine lifecycle label based on whether the ASG has a spot price.
    const lifecycleLabel = autoScalingGroup.spotPrice ? spot_interrupt_handler_1.LifecycleLabel.SPOT : spot_interrupt_handler_1.LifecycleLabel.ON_DEMAND;
    const withTaints = autoScalingGroup.spotPrice ? '--register-with-taints=spotInstance=true:PreferNoSchedule' : '';
    const kubeletExtraArgs = `--node-labels lifecycle=${lifecycleLabel} ${withTaints} ${kubeletExtraArgsSuffix}`.trim();
    return [
        `set -o xtrace`,
        `/etc/eks/bootstrap.sh ${clusterName} --kubelet-extra-args "${kubeletExtraArgs}" ${commandLineSuffix}`.trim(),
        `/opt/aws/bin/cfn-signal --exit-code $? --stack ${stack.stackName} --resource ${asgLogicalId} --region ${stack.region}`
    ];
}
exports.renderUserData = renderUserData;
//# sourceMappingURL=data:application/json;base64,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