from __future__ import annotations

from datetime import datetime
from typing import AsyncIterator, Iterable, Protocol, Optional

from .models import Account, Order, OrderReplaceRequest, OrderSubmitRequest, Position, Quote, Bar


class BrokerAdapter(Protocol):
    # --- Execution ---
    def get_account(self) -> Account: ...
    def get_positions(self) -> list[Position]: ...
    def submit_order(self, req: OrderSubmitRequest) -> Order: ...
    def get_order(self, order_id: str) -> Order: ...
    def cancel_order(self, order_id: str) -> Order: ...
    def replace_order(self, order_id: str, req: OrderReplaceRequest) -> Order: ...
    def stream_quotes(self, symbols: Iterable[str]) -> AsyncIterator[Quote]: ...

    # --- Data (new) ---
    def get_quotes(self, symbols: list[str]) -> list[Quote]: ...
    def get_historical_data(
        self,
        symbol: str,
        timeframe: str,
        limit: int = 100,
        start: Optional[datetime] = None,
        end: Optional[datetime] = None,
    ) -> list[Bar]: ...
