# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tagup']

package_data = \
{'': ['*']}

install_requires = \
['lark-parser>=0.8.5,<0.9.0']

setup_kwargs = {
    'name': 'tagup',
    'version': '0.2.1',
    'description': 'Reference implementation of the Tagup Language',
    'long_description': '![Travis (.org) branch](https://img.shields.io/travis/Foxbud/tagup/master?label=master&style=flat-square)\n&nbsp;\n![Codecov branch](https://img.shields.io/codecov/c/github/Foxbud/tagup/master?style=flat-square)\n\n# tagup\n\n**tagup** is a Python module which provides a reference implementation of the [Tagup Language](https://fairburn.dev/tagup/).\n\nThis module currently implements [version 1.0.0](https://fairburn.dev/tagup/1.0.0/) of the Tagup Language.\n\n## Changelog\n\n**v0.2.1**\n\n- Added tag prefetching.\n\n**v0.2.0**\n\n- Renamed "Renderer" to "BaseRenderer."\n- Refactored "BaseRenderer" to use method overriding for "get_tag" instead of providing "get_tag_callback" to constructor.\n- Removed "cache_tag_ast_callback" from "BaseRenderer" constructor.\n- Removed "trim_args" from "BaseRenderer" constructor.\n- Added a node pre and post processing hook system.\n- Added test cases.\n- Various internal optimizations.\n\n**v0.1.3**\n\n- Fixed bug where the "trim_args" option didn\'t properly remove leading and trailing whitespace in some situations.\n\n**v0.1.2**\n\n- Fixed bug where code called "trim()" rather than "strip()."\n\n**v0.1.1**\n\n- Added non-standard option to trim whitespace from arguments before tag evaluation.\n- Fixed bug where whitespace was considered when specifying a name/position for argument substitution.\n\n**v0.1.0**\n\n- Initial release.\n',
    'author': 'Garrett Fairburn',
    'author_email': 'garrett@fairburn.dev',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://fairburn.dev/tagup/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
