import { HttpRouteIntegrationBindOptions, HttpRouteIntegrationConfig } from '@aws-cdk/aws-apigatewayv2-alpha';
import * as elbv2 from 'aws-cdk-lib/aws-elasticloadbalancingv2';
import { HttpPrivateIntegrationOptions } from './base-types';
import { HttpPrivateIntegration } from './private/integration';
/**
 * (experimental) Properties to initialize `HttpNlbIntegration`.
 *
 * @experimental
 */
export interface HttpNlbIntegrationProps extends HttpPrivateIntegrationOptions {
}
/**
 * (experimental) The Network Load Balancer integration resource for HTTP API.
 *
 * @experimental
 */
export declare class HttpNlbIntegration extends HttpPrivateIntegration {
    private readonly listener;
    private readonly props;
    /**
     * @param id id of the underlying integration construct.
     * @param listener the ELB network listener.
     * @param props properties to configure the integration.
     * @experimental
     */
    constructor(id: string, listener: elbv2.INetworkListener, props?: HttpNlbIntegrationProps);
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options: HttpRouteIntegrationBindOptions): HttpRouteIntegrationConfig;
}
