# Generated by Django 2.2.24 on 2022-01-17 12:50

import django.db.models.deletion
from django.db import migrations, models

import caluma.caluma_core.models


class Migration(migrations.Migration):

    dependencies = [
        ("caluma_workflow", "0027_add_modified_by_user_group"),
    ]

    operations = [
        migrations.AddField(
            model_name="historicaltaskflow",
            name="redoable",
            field=models.TextField(
                blank=True,
                help_text="jexl returning what tasks can be redone from this taskflow.",
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="taskflow",
            name="redoable",
            field=models.TextField(
                blank=True,
                help_text="jexl returning what tasks can be redone from this taskflow.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="historicalworkitem",
            name="status",
            field=caluma.caluma_core.models.ChoicesCharField(
                choices=[
                    ("ready", "Work item is ready to be processed."),
                    ("completed", "Work item is done."),
                    ("canceled", "Work item is canceled."),
                    ("skipped", "Work item is skipped."),
                    ("suspended", "Work item is suspended."),
                    ("redo", "Work item has been marked for redo."),
                ],
                db_index=True,
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="taskflow",
            name="flow",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="task_flows",
                to="caluma_workflow.Flow",
            ),
        ),
        migrations.AlterField(
            model_name="workitem",
            name="status",
            field=caluma.caluma_core.models.ChoicesCharField(
                choices=[
                    ("ready", "Work item is ready to be processed."),
                    ("completed", "Work item is done."),
                    ("canceled", "Work item is canceled."),
                    ("skipped", "Work item is skipped."),
                    ("suspended", "Work item is suspended."),
                    ("redo", "Work item has been marked for redo."),
                ],
                db_index=True,
                max_length=50,
            ),
        ),
    ]
