# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['vcfstats']

package_data = \
{'': ['*']}

install_requires = \
['cyvcf2<1.0.0',
 'datar>=0.8,<0.9',
 'lark-parser>=0.12,<0.13',
 'numpy>=1.22,<2.0',
 'plotnine-prism>=0.0,<0.1',
 'plotnine>=0.8,<0.9',
 'py>=1.10,<2.0',
 'pyparam>=0.5,<0.6',
 'python-slugify>=6,<7',
 'rich>=12,<13']

entry_points = \
{'console_scripts': ['vcfstats = vcfstats.cli:main']}

setup_kwargs = {
    'name': 'vcfstats',
    'version': '0.4.1',
    'description': 'Powerful statistics for VCF files',
    'long_description': '# vcfstats - powerful statistics for VCF files\n\n[![Pypi][1]][2] [![Github][3]][4] [![PythonVers][5]][2] [![docs][6]][13] ![github action][7] [![Codacy][9]][10] [![Codacy coverage][11]][10]\n\n[Documentation][13] | [CHANGELOG][12]\n\n## Motivation\nThere are a couple of tools that can plot some statistics of VCF files, including [`bcftools`][14] and [`jvarkit`][15]. However, none of them could:\n1. plot specific metrics\n2. customize the plots\n3. focus on variants with certain filters\n\nR package [`vcfR`][19] can do some of the above. However, it has to load entire VCF into memory, which is not friendly to large VCF files.\n\n## Installation\n```shell\npip install -U vcfstats\n```\n\nOr run with docker or singularity:\n```shell\ndocker run --rm justold/vcfstats:latest vcfstats\n# or\nsingularity run docker://justold/vcfstats:latest vcfstats\n```\n\n## Gallery\n\n### Number of variants on each chromosome\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1) ~ CONTIG\' \\\n\t--title \'Number of variants on each chromosome\' \\\n\t--config examples/config.toml\n```\n\n![Number of variants on each chromosome](examples/number-of-variants-on-each-chromosome.col.png)\n\n#### Changing labels and ticks\n\n`vcfstats` uses [`plotnine`][17] for plotting, read more about it on how to specify `--ggs` to modify the plots.\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1) ~ CONTIG\' \\\n\t--title \'Number of variants on each chromosome (modified)\' \\\n\t--config examples/config.toml \\\n\t--ggs \'scale_x_discrete(name ="Chromosome", \\\n\t\tlimits=["1","2","3","4","5","6","7","8","9","10","X"]); \\\n\t\tylab("# Variants")\'\n```\n\n![Number of variants on each chromosome (modified)](examples/number-of-variants-on-each-chromosome-modified.col.png)\n\n#### Number of variants on first 5 chromosome\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1) ~ CONTIG[1,2,3,4,5]\' \\\n\t--title \'Number of variants on each chromosome (first 5)\' \\\n\t--config examples/config.toml\n# or\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1) ~ CONTIG[1-5]\' \\\n\t--title \'Number of variants on each chromosome (first 5)\' \\\n\t--config examples/config.toml\n# or\n# require vcf file to be tabix-indexed.\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1) ~ CONTIG\' \\\n\t--title \'Number of variants on each chromosome (first 5)\' \\\n\t--config examples/config.toml -r 1 2 3 4 5\n```\n\n![Number of variants on each chromosome (first 5)](examples/number-of-variants-on-each-chromosome-first-5.col.png)\n\n### Number of substitutions of SNPs\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1, VARTYPE[snp]) ~ SUBST[A>T,A>G,A>C,T>A,T>G,T>C,G>A,G>T,G>C,C>A,C>T,C>G]\' \\\n\t--title \'Number of substitutions of SNPs\' \\\n\t--config examples/config.toml\n```\n![Number of substitutions of SNPs](examples/number-of-substitutions-of-snps.col.png)\n\n#### Only with SNPs PASS all filters\n\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1, VARTYPE[snp]) ~ SUBST[A>T,A>G,A>C,T>A,T>G,T>C,G>A,G>T,G>C,C>A,C>T,C>G]\' \\\n\t--title \'Number of substitutions of SNPs (passed)\' \\\n\t--config examples/config.toml \\\n\t--passed\n```\n\n![Number of substitutions of SNPs (passed)](examples/number-of-substitutions-of-snps-passed.col.png)\n\n### Alternative allele frequency on each chromosome\n```shell\n# using a dark theme\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'AAF ~ CONTIG\' \\\n\t--title \'Allele frequency on each chromosome\' \\\n\t--config examples/config.toml --ggs \'theme_dark()\'\n```\n\n![Allele frequency on each chromosome](examples/allele-frequency-on-each-chromosome.violin.png)\n\n#### Using boxplot\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'AAF ~ CONTIG\' \\\n\t--title \'Allele frequency on each chromosome (boxplot)\' \\\n\t--config examples/config.toml \\\n\t--figtype boxplot\n```\n\n![Allele frequency on each chromosome](examples/allele-frequency-on-each-chromosome.boxplot.png)\n\n#### Using density plot/histogram to investigate the distribution:\nYou can plot the distribution, using density plot or histogram\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'AAF ~ CONTIG[1,2]\' \\\n\t--title \'Allele frequency on chromosome 1,2\' \\\n\t--config examples/config.toml \\\n\t--figtype density\n```\n![Allele frequency on chromosome 1,2](examples/allele-frequency-on-chromosome-1-2.density.png)\n\n### Overall distribution of allele frequency\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'AAF ~ 1\' \\\n\t--title \'Overall allele frequency distribution\' \\\n\t--config examples/config.toml\n```\n![Overall allele frequency distribution](examples/overall-allele-frequency-distribution.histogram.png)\n\n#### Excluding some low/high frequency variants\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'AAF[0.05, 0.95] ~ 1\' \\\n\t--title \'Overall allele frequency distribution (0.05-0.95)\' \\\n\t--config examples/config.toml\n```\n![Overall allele frequency distribution](examples/overall-allele-frequency-distribution-0-05-0-95.histogram.png)\n\n### Counting types of variants on each chromosome\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1, group=VARTYPE) ~ CHROM\' \\\n\t# or simply\n\t# --formula \'VARTYPE ~ CHROM\' \\\n\t--title \'Types of variants on each chromosome\' \\\n\t--config examples/config.toml\n```\n\n![Types of variants on each chromosome](examples/types-of-variants-on-each-chromosome.col.png)\n\n#### Using bar chart if there is only one chromosome\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'COUNT(1, group=VARTYPE) ~ CHROM[1]\' \\\n\t# or simply\n\t# --formula \'VARTYPE ~ CHROM[1]\' \\\n\t--title \'Types of variants on chromosome 1\' \\\n\t--config examples/config.toml \\\n\t--figtype pie\n```\n![Types of variants on chromosome 1](examples/types-of-variants-on-chromosome-1.pie.png)\n\n#### Counting variant types on whole genome\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t# or simply\n\t# --formula \'VARTYPE ~ 1\' \\\n\t--formula \'COUNT(1, group=VARTYPE) ~ 1\' \\\n\t--title \'Types of variants on whole genome\' \\\n\t--config examples/config.toml\n```\n![Types of variants on whole genome](examples/types-of-variants-on-whole-genome.col.png)\n\n### Counting type of mutant genotypes (HET, HOM_ALT) for sample 1 on each chromosome\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t# or simply\n\t# --formula \'GTTYPEs[HET,HOM_ALT]{0} ~ CHROM\' \\\n\t--formula \'COUNT(1, group=GTTYPEs[HET,HOM_ALT]{0}) ~ CHROM\' \\\n\t--title \'Mutant genotypes on each chromosome (sample 1)\' \\\n\t--config examples/config.toml\n```\n\n![Mutant genotypes on each chromosome](examples/mutant-genotypes-on-each-chromosome-sample-1.col.png)\n\n\n### Exploration of mean(genotype quality) and mean(depth) on each chromosome for sample 1\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'MEAN(GQs{0}) ~ MEAN(DEPTHs{0}, group=CHROM)\' \\\n\t--title \'GQ vs depth (sample 1)\' \\\n\t--config examples/config.toml\n```\n![GQ vs depth (sample 1)](examples/gq-vs-depth-sample-1.scatter.png)\n\n### Exploration of depths for sample 1,2\n```shell\nvcfstats --vcf examples/sample.vcf \\\n\t--outdir examples/ \\\n\t--formula \'DEPTHs{0} ~ DEPTHs{1}\' \\\n\t--title \'Depths between sample 1 and 2\' \\\n\t--config examples/config.toml\n```\n![Depths between sample 1 and 2](examples/depths-between-sample-1-and-2.scatter.png)\n\n\nSee more examples:\n\nhttps://github.com/pwwang/vcfstats/issues/15#issuecomment-1029367903\n\n[1]: https://img.shields.io/pypi/v/vcfstats?style=flat-square\n[2]: https://pypi.org/project/vcfstats/\n[3]: https://img.shields.io/github/v/tag/pwwang/vcfstats?style=flat-square\n[4]: https://github.com/pwwang/vcfstats\n[5]: https://img.shields.io/pypi/pyversions/vcfstats?style=flat-square\n[6]: https://img.shields.io/github/workflow/status/pwwang/vcfstats/Build%20Docs?label=docs&style=flat-square\n[7]: https://img.shields.io/github/workflow/status/pwwang/vcfstats/Build%20and%20Deploy?style=flat-square\n[8]: https://travis-ci.org/pwwang/vcfstats\n[9]: https://img.shields.io/codacy/grade/c8c8bfa8c5e9443bbf268a0a7c6f206d?style=flat-square\n[10]: https://app.codacy.com/gh/pwwang/vcfstats/\n[11]: https://img.shields.io/codacy/coverage/c8c8bfa8c5e9443bbf268a0a7c6f206d?style=flat-square\n[12]: https://pwwang.github.io/vcfstats/CHANGELOG/\n[13]: https://pwwang.github.io/vcfstats/\n[14]: https://samtools.github.io/bcftools/bcftools.html#stats\n[15]: http://lindenb.github.io/jvarkit/VcfStatsJfx.html\n[16]: https://www.r-project.org/\n[17]: https://plotnine.readthedocs.io/en/stable/\n[18]: https://cran.r-project.org/web/packages/ggrepel/vignettes/ggrepel.html\n[19]: https://knausb.github.io/vcfR_documentation/visualization_1.html\n',
    'author': 'pwwang',
    'author_email': 'pwwang@pwwang.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/pwwang/vcfstats',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
