# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/01_utils.ipynb (unless otherwise specified).

__all__ = ['xla_imported', 'print_aten_ops']

# Internal Cell
try:
    import torch_xla
except ImportError:
    pass

# Cell
import sys

def xla_imported():
    "Check whether the `torch_xla` module has been successfully imported"
    return 'torch_xla' in sys.modules

# Internal Cell
if xla_imported():
    import torch_xla.debug.metrics as met

# Cell
def print_aten_ops():
    "print out xla aten operations (from xla debug metrics report `torch_xla.debug.metrics`)"
    # import torch_xla.debug.metrics as met
    from io import StringIO
    import sys

    class Capturing(list):
        def __enter__(self):
            self._stdout = sys.stdout
            sys.stdout = self._stringio = StringIO()
            return self
        def __exit__(self, *args):
            self.extend(self._stringio.getvalue().splitlines())
            del self._stringio    # free up some memory
            sys.stdout = self._stdout

    out = met.metrics_report()
    if out.find("aten::"):
        print_now=False
        lines = out.split("\n")
        for l in lines:
            if print_now:
                print_now=False
                print(l)
            if l.find("aten::")>-1:
                print("needs lowering:", l)
                print_now=True