"""Add AuditLog model to workspaces

Revision ID: f3784e0c8524
Revises: 46fa2e6c46f7
Create Date: 2022-06-20 09:12:14.136072

"""
import sqlalchemy as sa
from alembic import op

import fief

# revision identifiers, used by Alembic.
revision = "f3784e0c8524"
down_revision = "46fa2e6c46f7"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "fief_audit_logs",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "timestamp",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            nullable=False,
        ),
        sa.Column("level", sa.String(length=255), nullable=False),
        sa.Column("message", sa.Text(), nullable=False),
        sa.Column("extra", sa.JSON(), nullable=True),
        sa.Column("author_user_id", fief.models.generics.GUID(), nullable=True),
        sa.Column("subject_user_id", fief.models.generics.GUID(), nullable=True),
        sa.ForeignKeyConstraint(
            ["author_user_id"], ["fief_users.id"], ondelete="SET NULL"
        ),
        sa.ForeignKeyConstraint(
            ["subject_user_id"], ["fief_users.id"], ondelete="SET NULL"
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_fief_audit_logs_level"), "fief_audit_logs", ["level"], unique=False
    )
    op.create_index(
        op.f("ix_fief_audit_logs_message"), "fief_audit_logs", ["message"], unique=False
    )
    op.create_index(
        op.f("ix_fief_audit_logs_timestamp"),
        "fief_audit_logs",
        ["timestamp"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_fief_audit_logs_timestamp"), table_name="fief_audit_logs")
    op.drop_index(op.f("ix_fief_audit_logs_message"), table_name="fief_audit_logs")
    op.drop_index(op.f("ix_fief_audit_logs_level"), table_name="fief_audit_logs")
    op.drop_table("fief_audit_logs")
    # ### end Alembic commands ###
