# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
def get_provider_info():
    return {
        'package-name': 'apache-airflow-providers-apache-hdfs',
        'name': 'Apache HDFS',
        'description': '`Hadoop Distributed File System (HDFS) <https://hadoop.apache.org/docs/r1.2.1/hdfs_design.html>`__\nand `WebHDFS <https://hadoop.apache.org/docs/current/hadoop-project-dist/hadoop-hdfs/WebHDFS.html>`__.\n',
        'versions': ['1.0.0'],
        'integrations': [
            {
                'integration-name': 'Hadoop Distributed File System (HDFS)',
                'external-doc-url': 'https://hadoop.apache.org/docs/r1.2.1/hdfs_design.html',
                'tags': ['apache'],
            },
            {
                'integration-name': 'WebHDFS',
                'external-doc-url': 'https://hadoop.apache.org/docs/current/hadoop-project-dist/hadoop-hdfs/WebHDFS.html',
                'tags': ['apache'],
            },
        ],
        'sensors': [
            {
                'integration-name': 'Hadoop Distributed File System (HDFS)',
                'python-modules': ['airflow.providers.apache.hdfs.sensors.hdfs'],
            },
            {
                'integration-name': 'WebHDFS',
                'python-modules': ['airflow.providers.apache.hdfs.sensors.web_hdfs'],
            },
        ],
        'hooks': [
            {
                'integration-name': 'Hadoop Distributed File System (HDFS)',
                'python-modules': ['airflow.providers.apache.hdfs.hooks.hdfs'],
            },
            {
                'integration-name': 'WebHDFS',
                'python-modules': ['airflow.providers.apache.hdfs.hooks.webhdfs'],
            },
        ],
        'hook-class-names': ['airflow.providers.apache.hdfs.hooks.hdfs.HDFSHook'],
    }
