# Generated by Django 2.2.17 on 2021-04-27 11:42

from django.db import migrations, models


def delete_user_file_entries(apps, schema_editor):
    # UserFiles table is just a cache of generated Data Product URIs for files
    # in directory listings.  We can wipe it out safely.  The existing entries
    # need to be deleted because this migration adds a new non-nullable field,
    # file_resource_id, and there's no good default for existing entries.
    UserFiles = apps.get_model('airavata_django_portal_sdk', 'UserFiles')
    UserFiles.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('airavata_django_portal_sdk', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(delete_user_file_entries, migrations.RunPython.noop),
        migrations.AddField(
            model_name='userfiles',
            name='file_resource_id',
            field=models.CharField(default='default', max_length=255),
            preserve_default=False,
        ),
    ]
