# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../../nbs/11_markdown.obisidian.personal.authors.ipynb.

# %% auto 0
__all__ = ['just_last_name', 'find_author_file']

# %% ../../../../nbs/11_markdown.obisidian.personal.authors.ipynb 2
import os 
from os import PathLike
from pathlib import Path
from typing import Union

# %% ../../../../nbs/11_markdown.obisidian.personal.authors.ipynb 4
def just_last_name(author_name) -> bool:
    """Return `True` if the author's name is formatted to only
    have the last name.
    """
    return '_' not in author_name

# %% ../../../../nbs/11_markdown.obisidian.personal.authors.ipynb 5
# TODO: This method seems redundant because the `all_note_paths_by_name` and `note_name_from_path` functions in `
def find_author_file(
        vault: PathLike,
        author_name: str, # Either just the last name, e.g. `"serre"` or formatted as `"{family_name}_{given_name}_{middle or other initial}"`, e.g.  `"little_john_b"`, `"lockhart_paul"`. In the former case, the mathematician's last name must be unique in the vault. In the latter case, the str must identically match the mathematician's file name in the vault.
        author_folder: str = 'mathematicians' # The directory where the author files are found in, relative to `vault`.
        ) -> Union[PathLike, None]: # Relative to `vault / author_folder`. `None` if no such author file exists.
    """Return path to the file for the specified author.

    **Raises**
    - AssertionError
        - If `author_folder` does not exist in `vault` or 
        if the requirements of `author_name` are not met.
    """
    author_location = Path(vault) / author_folder
    assert os.path.exists(author_location),\
        f"The following path does not exist:{author_location}"
    if just_last_name(author_name):
        notes_of_name = author_location.glob(f'**/{author_name}_*.md')
    else:
        notes_of_name = author_location.glob(f'**/{author_name}.md')
    if notes_of_name:
        assert len(notes_of_name) <= 1,\
            f'Author file is not unique: {author_name}'
        return notes_of_name[0]
    else:
        return None

