# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ScanConfig']


class ScanConfig(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[pulumi.InputType['AuthenticationArgs']]] = None,
                 blacklist_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 latest_run: Optional[pulumi.Input[pulumi.InputType['ScanRunArgs']]] = None,
                 max_qps: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 scan_configs_id: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[pulumi.InputType['ScheduleArgs']]] = None,
                 starting_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_platforms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_agent: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a new ScanConfig.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AuthenticationArgs']] authentication: The authentication configuration. If specified, service will use the authentication configuration during scanning.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blacklist_patterns: The excluded URL patterns as described in https://cloud.google.com/security-command-center/docs/how-to-use-web-security-scanner#excluding_urls
        :param pulumi.Input[str] display_name: Required. The user provided display name of the ScanConfig.
        :param pulumi.Input[pulumi.InputType['ScanRunArgs']] latest_run: Latest ScanRun if available.
        :param pulumi.Input[int] max_qps: The maximum QPS during scanning. A valid value ranges from 5 to 20 inclusively. If the field is unspecified or its value is set 0, server will default to 15. Other values outside of [5, 20] range will be rejected with INVALID_ARGUMENT error.
        :param pulumi.Input[str] name: The resource name of the ScanConfig. The name follows the format of 'projects/{projectId}/scanConfigs/{scanConfigId}'. The ScanConfig IDs are generated by the system.
        :param pulumi.Input[pulumi.InputType['ScheduleArgs']] schedule: The schedule of the ScanConfig.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] starting_urls: Required. The starting URLs from which the scanner finds site pages.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_platforms: Set of Google Cloud platforms targeted by the scan. If empty, APP_ENGINE will be used as a default.
        :param pulumi.Input[str] user_agent: The user agent used during scanning.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['authentication'] = authentication
            __props__['blacklist_patterns'] = blacklist_patterns
            __props__['display_name'] = display_name
            __props__['latest_run'] = latest_run
            __props__['max_qps'] = max_qps
            __props__['name'] = name
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__['projects_id'] = projects_id
            if scan_configs_id is None and not opts.urn:
                raise TypeError("Missing required property 'scan_configs_id'")
            __props__['scan_configs_id'] = scan_configs_id
            __props__['schedule'] = schedule
            __props__['starting_urls'] = starting_urls
            __props__['target_platforms'] = target_platforms
            __props__['user_agent'] = user_agent
        super(ScanConfig, __self__).__init__(
            'gcp-native:websecurityscanner/v1alpha:ScanConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ScanConfig':
        """
        Get an existing ScanConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["authentication"] = None
        __props__["blacklist_patterns"] = None
        __props__["display_name"] = None
        __props__["latest_run"] = None
        __props__["max_qps"] = None
        __props__["name"] = None
        __props__["schedule"] = None
        __props__["starting_urls"] = None
        __props__["target_platforms"] = None
        __props__["user_agent"] = None
        return ScanConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Output['outputs.AuthenticationResponse']:
        """
        The authentication configuration. If specified, service will use the authentication configuration during scanning.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="blacklistPatterns")
    def blacklist_patterns(self) -> pulumi.Output[Sequence[str]]:
        """
        The excluded URL patterns as described in https://cloud.google.com/security-command-center/docs/how-to-use-web-security-scanner#excluding_urls
        """
        return pulumi.get(self, "blacklist_patterns")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Required. The user provided display name of the ScanConfig.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="latestRun")
    def latest_run(self) -> pulumi.Output['outputs.ScanRunResponse']:
        """
        Latest ScanRun if available.
        """
        return pulumi.get(self, "latest_run")

    @property
    @pulumi.getter(name="maxQps")
    def max_qps(self) -> pulumi.Output[int]:
        """
        The maximum QPS during scanning. A valid value ranges from 5 to 20 inclusively. If the field is unspecified or its value is set 0, server will default to 15. Other values outside of [5, 20] range will be rejected with INVALID_ARGUMENT error.
        """
        return pulumi.get(self, "max_qps")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the ScanConfig. The name follows the format of 'projects/{projectId}/scanConfigs/{scanConfigId}'. The ScanConfig IDs are generated by the system.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output['outputs.ScheduleResponse']:
        """
        The schedule of the ScanConfig.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="startingUrls")
    def starting_urls(self) -> pulumi.Output[Sequence[str]]:
        """
        Required. The starting URLs from which the scanner finds site pages.
        """
        return pulumi.get(self, "starting_urls")

    @property
    @pulumi.getter(name="targetPlatforms")
    def target_platforms(self) -> pulumi.Output[Sequence[str]]:
        """
        Set of Google Cloud platforms targeted by the scan. If empty, APP_ENGINE will be used as a default.
        """
        return pulumi.get(self, "target_platforms")

    @property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> pulumi.Output[str]:
        """
        The user agent used during scanning.
        """
        return pulumi.get(self, "user_agent")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

