# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = [
    'AndroidAppInfoArgs',
    'AndroidInstrumentationTestArgs',
    'AndroidRoboTestArgs',
    'AndroidTestArgs',
    'AndroidTestLoopArgs',
    'AnyArgs',
    'BasicPerfSampleSeriesArgs',
    'DurationArgs',
    'FailureDetailArgs',
    'FileReferenceArgs',
    'InconclusiveDetailArgs',
    'IndividualOutcomeArgs',
    'IosAppInfoArgs',
    'IosRoboTestArgs',
    'IosTestArgs',
    'IosTestLoopArgs',
    'IosXcTestArgs',
    'MatrixDimensionDefinitionArgs',
    'MultiStepArgs',
    'OutcomeArgs',
    'PrimaryStepArgs',
    'SkippedDetailArgs',
    'SpecificationArgs',
    'StackTraceArgs',
    'StepDimensionValueEntryArgs',
    'StepLabelsEntryArgs',
    'SuccessDetailArgs',
    'TestCaseReferenceArgs',
    'TestExecutionStepArgs',
    'TestIssueArgs',
    'TestSuiteOverviewArgs',
    'TestTimingArgs',
    'TimestampArgs',
    'ToolExecutionArgs',
    'ToolExecutionStepArgs',
    'ToolExitCodeArgs',
    'ToolOutputReferenceArgs',
]

@pulumi.input_type
class AndroidAppInfoArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 package_name: Optional[pulumi.Input[str]] = None,
                 version_code: Optional[pulumi.Input[str]] = None,
                 version_name: Optional[pulumi.Input[str]] = None):
        """
        Android app information.
        :param pulumi.Input[str] name: The name of the app. Optional
        :param pulumi.Input[str] package_name: The package name of the app. Required.
        :param pulumi.Input[str] version_code: The internal version code of the app. Optional.
        :param pulumi.Input[str] version_name: The version name of the app. Optional.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if package_name is not None:
            pulumi.set(__self__, "package_name", package_name)
        if version_code is not None:
            pulumi.set(__self__, "version_code", version_code)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the app. Optional
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="packageName")
    def package_name(self) -> Optional[pulumi.Input[str]]:
        """
        The package name of the app. Required.
        """
        return pulumi.get(self, "package_name")

    @package_name.setter
    def package_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_name", value)

    @property
    @pulumi.getter(name="versionCode")
    def version_code(self) -> Optional[pulumi.Input[str]]:
        """
        The internal version code of the app. Optional.
        """
        return pulumi.get(self, "version_code")

    @version_code.setter
    def version_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_code", value)

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[str]]:
        """
        The version name of the app. Optional.
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_name", value)


@pulumi.input_type
class AndroidInstrumentationTestArgs:
    def __init__(__self__, *,
                 test_package_id: Optional[pulumi.Input[str]] = None,
                 test_runner_class: Optional[pulumi.Input[str]] = None,
                 test_targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_orchestrator: Optional[pulumi.Input[bool]] = None):
        """
        A test of an Android application that can control an Android component independently of its normal lifecycle. See for more information on types of Android tests.
        :param pulumi.Input[str] test_package_id: The java package for the test to be executed. Required
        :param pulumi.Input[str] test_runner_class: The InstrumentationTestRunner class. Required
        :param pulumi.Input[Sequence[pulumi.Input[str]]] test_targets: Each target must be fully qualified with the package name or class name, in one of these formats: - "package package_name" - "class package_name.class_name" - "class package_name.class_name#method_name" If empty, all targets in the module will be run.
        :param pulumi.Input[bool] use_orchestrator: The flag indicates whether Android Test Orchestrator will be used to run test or not.
        """
        if test_package_id is not None:
            pulumi.set(__self__, "test_package_id", test_package_id)
        if test_runner_class is not None:
            pulumi.set(__self__, "test_runner_class", test_runner_class)
        if test_targets is not None:
            pulumi.set(__self__, "test_targets", test_targets)
        if use_orchestrator is not None:
            pulumi.set(__self__, "use_orchestrator", use_orchestrator)

    @property
    @pulumi.getter(name="testPackageId")
    def test_package_id(self) -> Optional[pulumi.Input[str]]:
        """
        The java package for the test to be executed. Required
        """
        return pulumi.get(self, "test_package_id")

    @test_package_id.setter
    def test_package_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "test_package_id", value)

    @property
    @pulumi.getter(name="testRunnerClass")
    def test_runner_class(self) -> Optional[pulumi.Input[str]]:
        """
        The InstrumentationTestRunner class. Required
        """
        return pulumi.get(self, "test_runner_class")

    @test_runner_class.setter
    def test_runner_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "test_runner_class", value)

    @property
    @pulumi.getter(name="testTargets")
    def test_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Each target must be fully qualified with the package name or class name, in one of these formats: - "package package_name" - "class package_name.class_name" - "class package_name.class_name#method_name" If empty, all targets in the module will be run.
        """
        return pulumi.get(self, "test_targets")

    @test_targets.setter
    def test_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "test_targets", value)

    @property
    @pulumi.getter(name="useOrchestrator")
    def use_orchestrator(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag indicates whether Android Test Orchestrator will be used to run test or not.
        """
        return pulumi.get(self, "use_orchestrator")

    @use_orchestrator.setter
    def use_orchestrator(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_orchestrator", value)


@pulumi.input_type
class AndroidRoboTestArgs:
    def __init__(__self__, *,
                 app_initial_activity: Optional[pulumi.Input[str]] = None,
                 bootstrap_package_id: Optional[pulumi.Input[str]] = None,
                 bootstrap_runner_class: Optional[pulumi.Input[str]] = None,
                 max_depth: Optional[pulumi.Input[int]] = None,
                 max_steps: Optional[pulumi.Input[int]] = None):
        """
        A test of an android application that explores the application on a virtual or physical Android device, finding culprits and crashes as it goes.
        :param pulumi.Input[str] app_initial_activity: The initial activity that should be used to start the app. Optional
        :param pulumi.Input[str] bootstrap_package_id: The java package for the bootstrap. Optional
        :param pulumi.Input[str] bootstrap_runner_class: The runner class for the bootstrap. Optional
        :param pulumi.Input[int] max_depth: The max depth of the traversal stack Robo can explore. Optional
        :param pulumi.Input[int] max_steps: The max number of steps/actions Robo can execute. Default is no limit (0). Optional
        """
        if app_initial_activity is not None:
            pulumi.set(__self__, "app_initial_activity", app_initial_activity)
        if bootstrap_package_id is not None:
            pulumi.set(__self__, "bootstrap_package_id", bootstrap_package_id)
        if bootstrap_runner_class is not None:
            pulumi.set(__self__, "bootstrap_runner_class", bootstrap_runner_class)
        if max_depth is not None:
            pulumi.set(__self__, "max_depth", max_depth)
        if max_steps is not None:
            pulumi.set(__self__, "max_steps", max_steps)

    @property
    @pulumi.getter(name="appInitialActivity")
    def app_initial_activity(self) -> Optional[pulumi.Input[str]]:
        """
        The initial activity that should be used to start the app. Optional
        """
        return pulumi.get(self, "app_initial_activity")

    @app_initial_activity.setter
    def app_initial_activity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_initial_activity", value)

    @property
    @pulumi.getter(name="bootstrapPackageId")
    def bootstrap_package_id(self) -> Optional[pulumi.Input[str]]:
        """
        The java package for the bootstrap. Optional
        """
        return pulumi.get(self, "bootstrap_package_id")

    @bootstrap_package_id.setter
    def bootstrap_package_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_package_id", value)

    @property
    @pulumi.getter(name="bootstrapRunnerClass")
    def bootstrap_runner_class(self) -> Optional[pulumi.Input[str]]:
        """
        The runner class for the bootstrap. Optional
        """
        return pulumi.get(self, "bootstrap_runner_class")

    @bootstrap_runner_class.setter
    def bootstrap_runner_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_runner_class", value)

    @property
    @pulumi.getter(name="maxDepth")
    def max_depth(self) -> Optional[pulumi.Input[int]]:
        """
        The max depth of the traversal stack Robo can explore. Optional
        """
        return pulumi.get(self, "max_depth")

    @max_depth.setter
    def max_depth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_depth", value)

    @property
    @pulumi.getter(name="maxSteps")
    def max_steps(self) -> Optional[pulumi.Input[int]]:
        """
        The max number of steps/actions Robo can execute. Default is no limit (0). Optional
        """
        return pulumi.get(self, "max_steps")

    @max_steps.setter
    def max_steps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_steps", value)


@pulumi.input_type
class AndroidTestArgs:
    def __init__(__self__, *,
                 android_app_info: Optional[pulumi.Input['AndroidAppInfoArgs']] = None,
                 android_instrumentation_test: Optional[pulumi.Input['AndroidInstrumentationTestArgs']] = None,
                 android_robo_test: Optional[pulumi.Input['AndroidRoboTestArgs']] = None,
                 android_test_loop: Optional[pulumi.Input['AndroidTestLoopArgs']] = None,
                 test_timeout: Optional[pulumi.Input['DurationArgs']] = None):
        """
        An Android mobile test specification.
        :param pulumi.Input['AndroidAppInfoArgs'] android_app_info: Information about the application under test.
        :param pulumi.Input['AndroidInstrumentationTestArgs'] android_instrumentation_test: An Android instrumentation test.
        :param pulumi.Input['AndroidRoboTestArgs'] android_robo_test: An Android robo test.
        :param pulumi.Input['AndroidTestLoopArgs'] android_test_loop: An Android test loop.
        :param pulumi.Input['DurationArgs'] test_timeout: Max time a test is allowed to run before it is automatically cancelled.
        """
        if android_app_info is not None:
            pulumi.set(__self__, "android_app_info", android_app_info)
        if android_instrumentation_test is not None:
            pulumi.set(__self__, "android_instrumentation_test", android_instrumentation_test)
        if android_robo_test is not None:
            pulumi.set(__self__, "android_robo_test", android_robo_test)
        if android_test_loop is not None:
            pulumi.set(__self__, "android_test_loop", android_test_loop)
        if test_timeout is not None:
            pulumi.set(__self__, "test_timeout", test_timeout)

    @property
    @pulumi.getter(name="androidAppInfo")
    def android_app_info(self) -> Optional[pulumi.Input['AndroidAppInfoArgs']]:
        """
        Information about the application under test.
        """
        return pulumi.get(self, "android_app_info")

    @android_app_info.setter
    def android_app_info(self, value: Optional[pulumi.Input['AndroidAppInfoArgs']]):
        pulumi.set(self, "android_app_info", value)

    @property
    @pulumi.getter(name="androidInstrumentationTest")
    def android_instrumentation_test(self) -> Optional[pulumi.Input['AndroidInstrumentationTestArgs']]:
        """
        An Android instrumentation test.
        """
        return pulumi.get(self, "android_instrumentation_test")

    @android_instrumentation_test.setter
    def android_instrumentation_test(self, value: Optional[pulumi.Input['AndroidInstrumentationTestArgs']]):
        pulumi.set(self, "android_instrumentation_test", value)

    @property
    @pulumi.getter(name="androidRoboTest")
    def android_robo_test(self) -> Optional[pulumi.Input['AndroidRoboTestArgs']]:
        """
        An Android robo test.
        """
        return pulumi.get(self, "android_robo_test")

    @android_robo_test.setter
    def android_robo_test(self, value: Optional[pulumi.Input['AndroidRoboTestArgs']]):
        pulumi.set(self, "android_robo_test", value)

    @property
    @pulumi.getter(name="androidTestLoop")
    def android_test_loop(self) -> Optional[pulumi.Input['AndroidTestLoopArgs']]:
        """
        An Android test loop.
        """
        return pulumi.get(self, "android_test_loop")

    @android_test_loop.setter
    def android_test_loop(self, value: Optional[pulumi.Input['AndroidTestLoopArgs']]):
        pulumi.set(self, "android_test_loop", value)

    @property
    @pulumi.getter(name="testTimeout")
    def test_timeout(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        Max time a test is allowed to run before it is automatically cancelled.
        """
        return pulumi.get(self, "test_timeout")

    @test_timeout.setter
    def test_timeout(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "test_timeout", value)


@pulumi.input_type
class AndroidTestLoopArgs:
    def __init__(__self__):
        """
        Test Loops are tests that can be launched by the app itself, determining when to run by listening for an intent.
        """
        pass


@pulumi.input_type
class AnyArgs:
    def __init__(__self__, *,
                 type_url: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
         `Any` contains an arbitrary serialized protocol buffer message along with a URL that describes the type of the serialized message. Protobuf library provides support to pack/unpack Any values in the form of utility functions or additional generated methods of the Any type. Example 1: Pack and unpack a message in C++. Foo foo = ...; Any any; any.PackFrom(foo); ... if (any.UnpackTo(&foo)) { ... } Example 2: Pack and unpack a message in Java. Foo foo = ...; Any any = Any.pack(foo); ... if (any.is(Foo.class)) { foo = any.unpack(Foo.class); } Example 3: Pack and unpack a message in Python. foo = Foo(...) any = Any() any.Pack(foo) ... if any.Is(Foo.DESCRIPTOR): any.Unpack(foo) ... Example 4: Pack and unpack a message in Go foo := &pb.Foo{...} any, err := ptypes.MarshalAny(foo) ... foo := &pb.Foo{} if err := ptypes.UnmarshalAny(any, foo); err != nil { ... } The pack methods provided by protobuf library will by default use 'type.googleapis.com/full.type.name' as the type URL and the unpack methods only use the fully qualified type name after the last '/' in the type URL, for example "foo.bar.com/x/y.z" will yield type name "y.z". # JSON The JSON representation of an `Any` value uses the regular representation of the deserialized, embedded message, with an additional field `@type` which contains the type URL. Example: package google.profile; message Person { string first_name = 1; string last_name = 2; } { "@type": "type.googleapis.com/google.profile.Person", "firstName": , "lastName": } If the embedded message type is well-known and has a custom JSON representation, that representation will be embedded adding a field `value` which holds the custom JSON in addition to the `@type` field. Example (for message google.protobuf.Duration): { "@type": "type.googleapis.com/google.protobuf.Duration", "value": "1.212s" }
        :param pulumi.Input[str] type_url: A URL/resource name that uniquely identifies the type of the serialized protocol buffer message. This string must contain at least one "/" character. The last segment of the URL's path must represent the fully qualified name of the type (as in `path/google.protobuf.Duration`). The name should be in a canonical form (e.g., leading "." is not accepted). In practice, teams usually precompile into the binary all types that they expect it to use in the context of Any. However, for URLs which use the scheme `http`, `https`, or no scheme, one can optionally set up a type server that maps type URLs to message definitions as follows: * If no scheme is provided, `https` is assumed. * An HTTP GET on the URL must yield a google.protobuf.Type value in binary format, or produce an error. * Applications are allowed to cache lookup results based on the URL, or have them precompiled into a binary to avoid any lookup. Therefore, binary compatibility needs to be preserved on changes to types. (Use versioned type names to manage breaking changes.) Note: this functionality is not currently available in the official protobuf release, and it is not used for type URLs beginning with type.googleapis.com. Schemes other than `http`, `https` (or the empty scheme) might be used with implementation specific semantics.
        :param pulumi.Input[str] value: Must be a valid serialized protocol buffer of the above specified type.
        """
        if type_url is not None:
            pulumi.set(__self__, "type_url", type_url)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="typeUrl")
    def type_url(self) -> Optional[pulumi.Input[str]]:
        """
        A URL/resource name that uniquely identifies the type of the serialized protocol buffer message. This string must contain at least one "/" character. The last segment of the URL's path must represent the fully qualified name of the type (as in `path/google.protobuf.Duration`). The name should be in a canonical form (e.g., leading "." is not accepted). In practice, teams usually precompile into the binary all types that they expect it to use in the context of Any. However, for URLs which use the scheme `http`, `https`, or no scheme, one can optionally set up a type server that maps type URLs to message definitions as follows: * If no scheme is provided, `https` is assumed. * An HTTP GET on the URL must yield a google.protobuf.Type value in binary format, or produce an error. * Applications are allowed to cache lookup results based on the URL, or have them precompiled into a binary to avoid any lookup. Therefore, binary compatibility needs to be preserved on changes to types. (Use versioned type names to manage breaking changes.) Note: this functionality is not currently available in the official protobuf release, and it is not used for type URLs beginning with type.googleapis.com. Schemes other than `http`, `https` (or the empty scheme) might be used with implementation specific semantics.
        """
        return pulumi.get(self, "type_url")

    @type_url.setter
    def type_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type_url", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Must be a valid serialized protocol buffer of the above specified type.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class BasicPerfSampleSeriesArgs:
    def __init__(__self__, *,
                 perf_metric_type: Optional[pulumi.Input[str]] = None,
                 perf_unit: Optional[pulumi.Input[str]] = None,
                 sample_series_label: Optional[pulumi.Input[str]] = None):
        """
        Encapsulates the metadata for basic sample series represented by a line chart
        """
        if perf_metric_type is not None:
            pulumi.set(__self__, "perf_metric_type", perf_metric_type)
        if perf_unit is not None:
            pulumi.set(__self__, "perf_unit", perf_unit)
        if sample_series_label is not None:
            pulumi.set(__self__, "sample_series_label", sample_series_label)

    @property
    @pulumi.getter(name="perfMetricType")
    def perf_metric_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "perf_metric_type")

    @perf_metric_type.setter
    def perf_metric_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "perf_metric_type", value)

    @property
    @pulumi.getter(name="perfUnit")
    def perf_unit(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "perf_unit")

    @perf_unit.setter
    def perf_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "perf_unit", value)

    @property
    @pulumi.getter(name="sampleSeriesLabel")
    def sample_series_label(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "sample_series_label")

    @sample_series_label.setter
    def sample_series_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sample_series_label", value)


@pulumi.input_type
class DurationArgs:
    def __init__(__self__, *,
                 nanos: Optional[pulumi.Input[int]] = None,
                 seconds: Optional[pulumi.Input[str]] = None):
        """
         A Duration represents a signed, fixed-length span of time represented as a count of seconds and fractions of seconds at nanosecond resolution. It is independent of any calendar and concepts like "day" or "month". It is related to Timestamp in that the difference between two Timestamp values is a Duration and it can be added or subtracted from a Timestamp. Range is approximately +-10,000 years.
        :param pulumi.Input[int] nanos: Signed fractions of a second at nanosecond resolution of the span of time. Durations less than one second are represented with a 0 `seconds` field and a positive or negative `nanos` field. For durations of one second or more, a non-zero value for the `nanos` field must be of the same sign as the `seconds` field. Must be from -999,999,999 to +999,999,999 inclusive.
        :param pulumi.Input[str] seconds: Signed seconds of the span of time. Must be from -315,576,000,000 to +315,576,000,000 inclusive. Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
        """
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[pulumi.Input[int]]:
        """
        Signed fractions of a second at nanosecond resolution of the span of time. Durations less than one second are represented with a 0 `seconds` field and a positive or negative `nanos` field. For durations of one second or more, a non-zero value for the `nanos` field must be of the same sign as the `seconds` field. Must be from -999,999,999 to +999,999,999 inclusive.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def seconds(self) -> Optional[pulumi.Input[str]]:
        """
        Signed seconds of the span of time. Must be from -315,576,000,000 to +315,576,000,000 inclusive. Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "seconds", value)


@pulumi.input_type
class FailureDetailArgs:
    def __init__(__self__, *,
                 crashed: Optional[pulumi.Input[bool]] = None,
                 device_out_of_memory: Optional[pulumi.Input[bool]] = None,
                 failed_roboscript: Optional[pulumi.Input[bool]] = None,
                 not_installed: Optional[pulumi.Input[bool]] = None,
                 other_native_crash: Optional[pulumi.Input[bool]] = None,
                 timed_out: Optional[pulumi.Input[bool]] = None,
                 unable_to_crawl: Optional[pulumi.Input[bool]] = None):
        """
        Details for an outcome with a FAILURE outcome summary.
        :param pulumi.Input[bool] crashed: If the failure was severe because the system (app) under test crashed.
        :param pulumi.Input[bool] device_out_of_memory: If the device ran out of memory during a test, causing the test to crash.
        :param pulumi.Input[bool] failed_roboscript: If the Roboscript failed to complete successfully, e.g., because a Roboscript action or assertion failed or a Roboscript action could not be matched during the entire crawl.
        :param pulumi.Input[bool] not_installed: If an app is not installed and thus no test can be run with the app. This might be caused by trying to run a test on an unsupported platform.
        :param pulumi.Input[bool] other_native_crash: If a native process (including any other than the app) crashed.
        :param pulumi.Input[bool] timed_out: If the test overran some time limit, and that is why it failed.
        :param pulumi.Input[bool] unable_to_crawl: If the robo was unable to crawl the app; perhaps because the app did not start.
        """
        if crashed is not None:
            pulumi.set(__self__, "crashed", crashed)
        if device_out_of_memory is not None:
            pulumi.set(__self__, "device_out_of_memory", device_out_of_memory)
        if failed_roboscript is not None:
            pulumi.set(__self__, "failed_roboscript", failed_roboscript)
        if not_installed is not None:
            pulumi.set(__self__, "not_installed", not_installed)
        if other_native_crash is not None:
            pulumi.set(__self__, "other_native_crash", other_native_crash)
        if timed_out is not None:
            pulumi.set(__self__, "timed_out", timed_out)
        if unable_to_crawl is not None:
            pulumi.set(__self__, "unable_to_crawl", unable_to_crawl)

    @property
    @pulumi.getter
    def crashed(self) -> Optional[pulumi.Input[bool]]:
        """
        If the failure was severe because the system (app) under test crashed.
        """
        return pulumi.get(self, "crashed")

    @crashed.setter
    def crashed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "crashed", value)

    @property
    @pulumi.getter(name="deviceOutOfMemory")
    def device_out_of_memory(self) -> Optional[pulumi.Input[bool]]:
        """
        If the device ran out of memory during a test, causing the test to crash.
        """
        return pulumi.get(self, "device_out_of_memory")

    @device_out_of_memory.setter
    def device_out_of_memory(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "device_out_of_memory", value)

    @property
    @pulumi.getter(name="failedRoboscript")
    def failed_roboscript(self) -> Optional[pulumi.Input[bool]]:
        """
        If the Roboscript failed to complete successfully, e.g., because a Roboscript action or assertion failed or a Roboscript action could not be matched during the entire crawl.
        """
        return pulumi.get(self, "failed_roboscript")

    @failed_roboscript.setter
    def failed_roboscript(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "failed_roboscript", value)

    @property
    @pulumi.getter(name="notInstalled")
    def not_installed(self) -> Optional[pulumi.Input[bool]]:
        """
        If an app is not installed and thus no test can be run with the app. This might be caused by trying to run a test on an unsupported platform.
        """
        return pulumi.get(self, "not_installed")

    @not_installed.setter
    def not_installed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "not_installed", value)

    @property
    @pulumi.getter(name="otherNativeCrash")
    def other_native_crash(self) -> Optional[pulumi.Input[bool]]:
        """
        If a native process (including any other than the app) crashed.
        """
        return pulumi.get(self, "other_native_crash")

    @other_native_crash.setter
    def other_native_crash(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "other_native_crash", value)

    @property
    @pulumi.getter(name="timedOut")
    def timed_out(self) -> Optional[pulumi.Input[bool]]:
        """
        If the test overran some time limit, and that is why it failed.
        """
        return pulumi.get(self, "timed_out")

    @timed_out.setter
    def timed_out(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "timed_out", value)

    @property
    @pulumi.getter(name="unableToCrawl")
    def unable_to_crawl(self) -> Optional[pulumi.Input[bool]]:
        """
        If the robo was unable to crawl the app; perhaps because the app did not start.
        """
        return pulumi.get(self, "unable_to_crawl")

    @unable_to_crawl.setter
    def unable_to_crawl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unable_to_crawl", value)


@pulumi.input_type
class FileReferenceArgs:
    def __init__(__self__, *,
                 file_uri: Optional[pulumi.Input[str]] = None):
        """
        A reference to a file.
        :param pulumi.Input[str] file_uri: The URI of a file stored in Google Cloud Storage. For example: http://storage.googleapis.com/mybucket/path/to/test.xml or in gsutil format: gs://mybucket/path/to/test.xml with version-specific info, gs://mybucket/path/to/test.xml#1360383693690000 An INVALID_ARGUMENT error will be returned if the URI format is not supported. - In response: always set - In create/update request: always set
        """
        if file_uri is not None:
            pulumi.set(__self__, "file_uri", file_uri)

    @property
    @pulumi.getter(name="fileUri")
    def file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of a file stored in Google Cloud Storage. For example: http://storage.googleapis.com/mybucket/path/to/test.xml or in gsutil format: gs://mybucket/path/to/test.xml with version-specific info, gs://mybucket/path/to/test.xml#1360383693690000 An INVALID_ARGUMENT error will be returned if the URI format is not supported. - In response: always set - In create/update request: always set
        """
        return pulumi.get(self, "file_uri")

    @file_uri.setter
    def file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_uri", value)


@pulumi.input_type
class InconclusiveDetailArgs:
    def __init__(__self__, *,
                 aborted_by_user: Optional[pulumi.Input[bool]] = None,
                 has_error_logs: Optional[pulumi.Input[bool]] = None,
                 infrastructure_failure: Optional[pulumi.Input[bool]] = None):
        """
        Details for an outcome with an INCONCLUSIVE outcome summary.
        :param pulumi.Input[bool] aborted_by_user: If the end user aborted the test execution before a pass or fail could be determined. For example, the user pressed ctrl-c which sent a kill signal to the test runner while the test was running.
        :param pulumi.Input[bool] has_error_logs: If results are being provided to the user in certain cases of infrastructure failures
        :param pulumi.Input[bool] infrastructure_failure: If the test runner could not determine success or failure because the test depends on a component other than the system under test which failed. For example, a mobile test requires provisioning a device where the test executes, and that provisioning can fail.
        """
        if aborted_by_user is not None:
            pulumi.set(__self__, "aborted_by_user", aborted_by_user)
        if has_error_logs is not None:
            pulumi.set(__self__, "has_error_logs", has_error_logs)
        if infrastructure_failure is not None:
            pulumi.set(__self__, "infrastructure_failure", infrastructure_failure)

    @property
    @pulumi.getter(name="abortedByUser")
    def aborted_by_user(self) -> Optional[pulumi.Input[bool]]:
        """
        If the end user aborted the test execution before a pass or fail could be determined. For example, the user pressed ctrl-c which sent a kill signal to the test runner while the test was running.
        """
        return pulumi.get(self, "aborted_by_user")

    @aborted_by_user.setter
    def aborted_by_user(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aborted_by_user", value)

    @property
    @pulumi.getter(name="hasErrorLogs")
    def has_error_logs(self) -> Optional[pulumi.Input[bool]]:
        """
        If results are being provided to the user in certain cases of infrastructure failures
        """
        return pulumi.get(self, "has_error_logs")

    @has_error_logs.setter
    def has_error_logs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_error_logs", value)

    @property
    @pulumi.getter(name="infrastructureFailure")
    def infrastructure_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        If the test runner could not determine success or failure because the test depends on a component other than the system under test which failed. For example, a mobile test requires provisioning a device where the test executes, and that provisioning can fail.
        """
        return pulumi.get(self, "infrastructure_failure")

    @infrastructure_failure.setter
    def infrastructure_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "infrastructure_failure", value)


@pulumi.input_type
class IndividualOutcomeArgs:
    def __init__(__self__, *,
                 multistep_number: Optional[pulumi.Input[int]] = None,
                 outcome_summary: Optional[pulumi.Input[str]] = None,
                 run_duration: Optional[pulumi.Input['DurationArgs']] = None,
                 step_id: Optional[pulumi.Input[str]] = None):
        """
        Step Id and outcome of each individual step that was run as a group with other steps with the same configuration.
        :param pulumi.Input[int] multistep_number: Unique int given to each step. Ranges from 0(inclusive) to total number of steps(exclusive). The primary step is 0.
        :param pulumi.Input['DurationArgs'] run_duration: How long it took for this step to run.
        """
        if multistep_number is not None:
            pulumi.set(__self__, "multistep_number", multistep_number)
        if outcome_summary is not None:
            pulumi.set(__self__, "outcome_summary", outcome_summary)
        if run_duration is not None:
            pulumi.set(__self__, "run_duration", run_duration)
        if step_id is not None:
            pulumi.set(__self__, "step_id", step_id)

    @property
    @pulumi.getter(name="multistepNumber")
    def multistep_number(self) -> Optional[pulumi.Input[int]]:
        """
        Unique int given to each step. Ranges from 0(inclusive) to total number of steps(exclusive). The primary step is 0.
        """
        return pulumi.get(self, "multistep_number")

    @multistep_number.setter
    def multistep_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "multistep_number", value)

    @property
    @pulumi.getter(name="outcomeSummary")
    def outcome_summary(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "outcome_summary")

    @outcome_summary.setter
    def outcome_summary(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "outcome_summary", value)

    @property
    @pulumi.getter(name="runDuration")
    def run_duration(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        How long it took for this step to run.
        """
        return pulumi.get(self, "run_duration")

    @run_duration.setter
    def run_duration(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "run_duration", value)

    @property
    @pulumi.getter(name="stepId")
    def step_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "step_id")

    @step_id.setter
    def step_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step_id", value)


@pulumi.input_type
class IosAppInfoArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        iOS app information
        :param pulumi.Input[str] name: The name of the app. Required
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the app. Required
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class IosRoboTestArgs:
    def __init__(__self__):
        """
        A Robo test for an iOS application.
        """
        pass


@pulumi.input_type
class IosTestArgs:
    def __init__(__self__, *,
                 ios_app_info: Optional[pulumi.Input['IosAppInfoArgs']] = None,
                 ios_robo_test: Optional[pulumi.Input['IosRoboTestArgs']] = None,
                 ios_test_loop: Optional[pulumi.Input['IosTestLoopArgs']] = None,
                 ios_xc_test: Optional[pulumi.Input['IosXcTestArgs']] = None,
                 test_timeout: Optional[pulumi.Input['DurationArgs']] = None):
        """
        A iOS mobile test specification
        :param pulumi.Input['IosAppInfoArgs'] ios_app_info: Information about the application under test.
        :param pulumi.Input['IosRoboTestArgs'] ios_robo_test: An iOS Robo test.
        :param pulumi.Input['IosTestLoopArgs'] ios_test_loop: An iOS test loop.
        :param pulumi.Input['IosXcTestArgs'] ios_xc_test: An iOS XCTest.
        :param pulumi.Input['DurationArgs'] test_timeout: Max time a test is allowed to run before it is automatically cancelled.
        """
        if ios_app_info is not None:
            pulumi.set(__self__, "ios_app_info", ios_app_info)
        if ios_robo_test is not None:
            pulumi.set(__self__, "ios_robo_test", ios_robo_test)
        if ios_test_loop is not None:
            pulumi.set(__self__, "ios_test_loop", ios_test_loop)
        if ios_xc_test is not None:
            pulumi.set(__self__, "ios_xc_test", ios_xc_test)
        if test_timeout is not None:
            pulumi.set(__self__, "test_timeout", test_timeout)

    @property
    @pulumi.getter(name="iosAppInfo")
    def ios_app_info(self) -> Optional[pulumi.Input['IosAppInfoArgs']]:
        """
        Information about the application under test.
        """
        return pulumi.get(self, "ios_app_info")

    @ios_app_info.setter
    def ios_app_info(self, value: Optional[pulumi.Input['IosAppInfoArgs']]):
        pulumi.set(self, "ios_app_info", value)

    @property
    @pulumi.getter(name="iosRoboTest")
    def ios_robo_test(self) -> Optional[pulumi.Input['IosRoboTestArgs']]:
        """
        An iOS Robo test.
        """
        return pulumi.get(self, "ios_robo_test")

    @ios_robo_test.setter
    def ios_robo_test(self, value: Optional[pulumi.Input['IosRoboTestArgs']]):
        pulumi.set(self, "ios_robo_test", value)

    @property
    @pulumi.getter(name="iosTestLoop")
    def ios_test_loop(self) -> Optional[pulumi.Input['IosTestLoopArgs']]:
        """
        An iOS test loop.
        """
        return pulumi.get(self, "ios_test_loop")

    @ios_test_loop.setter
    def ios_test_loop(self, value: Optional[pulumi.Input['IosTestLoopArgs']]):
        pulumi.set(self, "ios_test_loop", value)

    @property
    @pulumi.getter(name="iosXcTest")
    def ios_xc_test(self) -> Optional[pulumi.Input['IosXcTestArgs']]:
        """
        An iOS XCTest.
        """
        return pulumi.get(self, "ios_xc_test")

    @ios_xc_test.setter
    def ios_xc_test(self, value: Optional[pulumi.Input['IosXcTestArgs']]):
        pulumi.set(self, "ios_xc_test", value)

    @property
    @pulumi.getter(name="testTimeout")
    def test_timeout(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        Max time a test is allowed to run before it is automatically cancelled.
        """
        return pulumi.get(self, "test_timeout")

    @test_timeout.setter
    def test_timeout(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "test_timeout", value)


@pulumi.input_type
class IosTestLoopArgs:
    def __init__(__self__, *,
                 bundle_id: Optional[pulumi.Input[str]] = None):
        """
        A game loop test of an iOS application.
        :param pulumi.Input[str] bundle_id: Bundle ID of the app.
        """
        if bundle_id is not None:
            pulumi.set(__self__, "bundle_id", bundle_id)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        Bundle ID of the app.
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bundle_id", value)


@pulumi.input_type
class IosXcTestArgs:
    def __init__(__self__, *,
                 bundle_id: Optional[pulumi.Input[str]] = None,
                 xcode_version: Optional[pulumi.Input[str]] = None):
        """
        A test of an iOS application that uses the XCTest framework.
        :param pulumi.Input[str] bundle_id: Bundle ID of the app.
        :param pulumi.Input[str] xcode_version: Xcode version that the test was run with.
        """
        if bundle_id is not None:
            pulumi.set(__self__, "bundle_id", bundle_id)
        if xcode_version is not None:
            pulumi.set(__self__, "xcode_version", xcode_version)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        Bundle ID of the app.
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bundle_id", value)

    @property
    @pulumi.getter(name="xcodeVersion")
    def xcode_version(self) -> Optional[pulumi.Input[str]]:
        """
        Xcode version that the test was run with.
        """
        return pulumi.get(self, "xcode_version")

    @xcode_version.setter
    def xcode_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "xcode_version", value)


@pulumi.input_type
class MatrixDimensionDefinitionArgs:
    def __init__(__self__):
        """
        One dimension of the matrix of different runs of a step.
        """
        pass


@pulumi.input_type
class MultiStepArgs:
    def __init__(__self__, *,
                 multistep_number: Optional[pulumi.Input[int]] = None,
                 primary_step: Optional[pulumi.Input['PrimaryStepArgs']] = None,
                 primary_step_id: Optional[pulumi.Input[str]] = None):
        """
        Details when multiple steps are run with the same configuration as a group.
        :param pulumi.Input[int] multistep_number: Unique int given to each step. Ranges from 0(inclusive) to total number of steps(exclusive). The primary step is 0.
        :param pulumi.Input['PrimaryStepArgs'] primary_step: Present if it is a primary (original) step.
        :param pulumi.Input[str] primary_step_id: Step Id of the primary (original) step, which might be this step.
        """
        if multistep_number is not None:
            pulumi.set(__self__, "multistep_number", multistep_number)
        if primary_step is not None:
            pulumi.set(__self__, "primary_step", primary_step)
        if primary_step_id is not None:
            pulumi.set(__self__, "primary_step_id", primary_step_id)

    @property
    @pulumi.getter(name="multistepNumber")
    def multistep_number(self) -> Optional[pulumi.Input[int]]:
        """
        Unique int given to each step. Ranges from 0(inclusive) to total number of steps(exclusive). The primary step is 0.
        """
        return pulumi.get(self, "multistep_number")

    @multistep_number.setter
    def multistep_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "multistep_number", value)

    @property
    @pulumi.getter(name="primaryStep")
    def primary_step(self) -> Optional[pulumi.Input['PrimaryStepArgs']]:
        """
        Present if it is a primary (original) step.
        """
        return pulumi.get(self, "primary_step")

    @primary_step.setter
    def primary_step(self, value: Optional[pulumi.Input['PrimaryStepArgs']]):
        pulumi.set(self, "primary_step", value)

    @property
    @pulumi.getter(name="primaryStepId")
    def primary_step_id(self) -> Optional[pulumi.Input[str]]:
        """
        Step Id of the primary (original) step, which might be this step.
        """
        return pulumi.get(self, "primary_step_id")

    @primary_step_id.setter
    def primary_step_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_step_id", value)


@pulumi.input_type
class OutcomeArgs:
    def __init__(__self__, *,
                 failure_detail: Optional[pulumi.Input['FailureDetailArgs']] = None,
                 inconclusive_detail: Optional[pulumi.Input['InconclusiveDetailArgs']] = None,
                 skipped_detail: Optional[pulumi.Input['SkippedDetailArgs']] = None,
                 success_detail: Optional[pulumi.Input['SuccessDetailArgs']] = None,
                 summary: Optional[pulumi.Input[str]] = None):
        """
        Interprets a result so that humans and machines can act on it.
        :param pulumi.Input['FailureDetailArgs'] failure_detail: More information about a FAILURE outcome. Returns INVALID_ARGUMENT if this field is set but the summary is not FAILURE. Optional
        :param pulumi.Input['InconclusiveDetailArgs'] inconclusive_detail: More information about an INCONCLUSIVE outcome. Returns INVALID_ARGUMENT if this field is set but the summary is not INCONCLUSIVE. Optional
        :param pulumi.Input['SkippedDetailArgs'] skipped_detail: More information about a SKIPPED outcome. Returns INVALID_ARGUMENT if this field is set but the summary is not SKIPPED. Optional
        :param pulumi.Input['SuccessDetailArgs'] success_detail: More information about a SUCCESS outcome. Returns INVALID_ARGUMENT if this field is set but the summary is not SUCCESS. Optional
        :param pulumi.Input[str] summary: The simplest way to interpret a result. Required
        """
        if failure_detail is not None:
            pulumi.set(__self__, "failure_detail", failure_detail)
        if inconclusive_detail is not None:
            pulumi.set(__self__, "inconclusive_detail", inconclusive_detail)
        if skipped_detail is not None:
            pulumi.set(__self__, "skipped_detail", skipped_detail)
        if success_detail is not None:
            pulumi.set(__self__, "success_detail", success_detail)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)

    @property
    @pulumi.getter(name="failureDetail")
    def failure_detail(self) -> Optional[pulumi.Input['FailureDetailArgs']]:
        """
        More information about a FAILURE outcome. Returns INVALID_ARGUMENT if this field is set but the summary is not FAILURE. Optional
        """
        return pulumi.get(self, "failure_detail")

    @failure_detail.setter
    def failure_detail(self, value: Optional[pulumi.Input['FailureDetailArgs']]):
        pulumi.set(self, "failure_detail", value)

    @property
    @pulumi.getter(name="inconclusiveDetail")
    def inconclusive_detail(self) -> Optional[pulumi.Input['InconclusiveDetailArgs']]:
        """
        More information about an INCONCLUSIVE outcome. Returns INVALID_ARGUMENT if this field is set but the summary is not INCONCLUSIVE. Optional
        """
        return pulumi.get(self, "inconclusive_detail")

    @inconclusive_detail.setter
    def inconclusive_detail(self, value: Optional[pulumi.Input['InconclusiveDetailArgs']]):
        pulumi.set(self, "inconclusive_detail", value)

    @property
    @pulumi.getter(name="skippedDetail")
    def skipped_detail(self) -> Optional[pulumi.Input['SkippedDetailArgs']]:
        """
        More information about a SKIPPED outcome. Returns INVALID_ARGUMENT if this field is set but the summary is not SKIPPED. Optional
        """
        return pulumi.get(self, "skipped_detail")

    @skipped_detail.setter
    def skipped_detail(self, value: Optional[pulumi.Input['SkippedDetailArgs']]):
        pulumi.set(self, "skipped_detail", value)

    @property
    @pulumi.getter(name="successDetail")
    def success_detail(self) -> Optional[pulumi.Input['SuccessDetailArgs']]:
        """
        More information about a SUCCESS outcome. Returns INVALID_ARGUMENT if this field is set but the summary is not SUCCESS. Optional
        """
        return pulumi.get(self, "success_detail")

    @success_detail.setter
    def success_detail(self, value: Optional[pulumi.Input['SuccessDetailArgs']]):
        pulumi.set(self, "success_detail", value)

    @property
    @pulumi.getter
    def summary(self) -> Optional[pulumi.Input[str]]:
        """
        The simplest way to interpret a result. Required
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "summary", value)


@pulumi.input_type
class PrimaryStepArgs:
    def __init__(__self__, *,
                 individual_outcome: Optional[pulumi.Input[Sequence[pulumi.Input['IndividualOutcomeArgs']]]] = None,
                 roll_up: Optional[pulumi.Input[str]] = None):
        """
        Stores rollup test status of multiple steps that were run as a group and outcome of each individual step.
        :param pulumi.Input[Sequence[pulumi.Input['IndividualOutcomeArgs']]] individual_outcome: Step Id and outcome of each individual step.
        :param pulumi.Input[str] roll_up: Rollup test status of multiple steps that were run with the same configuration as a group.
        """
        if individual_outcome is not None:
            pulumi.set(__self__, "individual_outcome", individual_outcome)
        if roll_up is not None:
            pulumi.set(__self__, "roll_up", roll_up)

    @property
    @pulumi.getter(name="individualOutcome")
    def individual_outcome(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndividualOutcomeArgs']]]]:
        """
        Step Id and outcome of each individual step.
        """
        return pulumi.get(self, "individual_outcome")

    @individual_outcome.setter
    def individual_outcome(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndividualOutcomeArgs']]]]):
        pulumi.set(self, "individual_outcome", value)

    @property
    @pulumi.getter(name="rollUp")
    def roll_up(self) -> Optional[pulumi.Input[str]]:
        """
        Rollup test status of multiple steps that were run with the same configuration as a group.
        """
        return pulumi.get(self, "roll_up")

    @roll_up.setter
    def roll_up(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "roll_up", value)


@pulumi.input_type
class SkippedDetailArgs:
    def __init__(__self__, *,
                 incompatible_app_version: Optional[pulumi.Input[bool]] = None,
                 incompatible_architecture: Optional[pulumi.Input[bool]] = None,
                 incompatible_device: Optional[pulumi.Input[bool]] = None):
        """
        Details for an outcome with a SKIPPED outcome summary.
        :param pulumi.Input[bool] incompatible_app_version: If the App doesn't support the specific API level.
        :param pulumi.Input[bool] incompatible_architecture: If the App doesn't run on the specific architecture, for example, x86.
        :param pulumi.Input[bool] incompatible_device: If the requested OS version doesn't run on the specific device model.
        """
        if incompatible_app_version is not None:
            pulumi.set(__self__, "incompatible_app_version", incompatible_app_version)
        if incompatible_architecture is not None:
            pulumi.set(__self__, "incompatible_architecture", incompatible_architecture)
        if incompatible_device is not None:
            pulumi.set(__self__, "incompatible_device", incompatible_device)

    @property
    @pulumi.getter(name="incompatibleAppVersion")
    def incompatible_app_version(self) -> Optional[pulumi.Input[bool]]:
        """
        If the App doesn't support the specific API level.
        """
        return pulumi.get(self, "incompatible_app_version")

    @incompatible_app_version.setter
    def incompatible_app_version(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "incompatible_app_version", value)

    @property
    @pulumi.getter(name="incompatibleArchitecture")
    def incompatible_architecture(self) -> Optional[pulumi.Input[bool]]:
        """
        If the App doesn't run on the specific architecture, for example, x86.
        """
        return pulumi.get(self, "incompatible_architecture")

    @incompatible_architecture.setter
    def incompatible_architecture(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "incompatible_architecture", value)

    @property
    @pulumi.getter(name="incompatibleDevice")
    def incompatible_device(self) -> Optional[pulumi.Input[bool]]:
        """
        If the requested OS version doesn't run on the specific device model.
        """
        return pulumi.get(self, "incompatible_device")

    @incompatible_device.setter
    def incompatible_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "incompatible_device", value)


@pulumi.input_type
class SpecificationArgs:
    def __init__(__self__, *,
                 android_test: Optional[pulumi.Input['AndroidTestArgs']] = None,
                 ios_test: Optional[pulumi.Input['IosTestArgs']] = None):
        """
        The details about how to run the execution.
        :param pulumi.Input['AndroidTestArgs'] android_test: An Android mobile test execution specification.
        :param pulumi.Input['IosTestArgs'] ios_test: An iOS mobile test execution specification.
        """
        if android_test is not None:
            pulumi.set(__self__, "android_test", android_test)
        if ios_test is not None:
            pulumi.set(__self__, "ios_test", ios_test)

    @property
    @pulumi.getter(name="androidTest")
    def android_test(self) -> Optional[pulumi.Input['AndroidTestArgs']]:
        """
        An Android mobile test execution specification.
        """
        return pulumi.get(self, "android_test")

    @android_test.setter
    def android_test(self, value: Optional[pulumi.Input['AndroidTestArgs']]):
        pulumi.set(self, "android_test", value)

    @property
    @pulumi.getter(name="iosTest")
    def ios_test(self) -> Optional[pulumi.Input['IosTestArgs']]:
        """
        An iOS mobile test execution specification.
        """
        return pulumi.get(self, "ios_test")

    @ios_test.setter
    def ios_test(self, value: Optional[pulumi.Input['IosTestArgs']]):
        pulumi.set(self, "ios_test", value)


@pulumi.input_type
class StackTraceArgs:
    def __init__(__self__, *,
                 exception: Optional[pulumi.Input[str]] = None):
        """
        A stacktrace.
        :param pulumi.Input[str] exception: The stack trace message. Required
        """
        if exception is not None:
            pulumi.set(__self__, "exception", exception)

    @property
    @pulumi.getter
    def exception(self) -> Optional[pulumi.Input[str]]:
        """
        The stack trace message. Required
        """
        return pulumi.get(self, "exception")

    @exception.setter
    def exception(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exception", value)


@pulumi.input_type
class StepDimensionValueEntryArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class StepLabelsEntryArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class SuccessDetailArgs:
    def __init__(__self__, *,
                 other_native_crash: Optional[pulumi.Input[bool]] = None):
        """
        Details for an outcome with a SUCCESS outcome summary. LINT.IfChange
        :param pulumi.Input[bool] other_native_crash: If a native process other than the app crashed.
        """
        if other_native_crash is not None:
            pulumi.set(__self__, "other_native_crash", other_native_crash)

    @property
    @pulumi.getter(name="otherNativeCrash")
    def other_native_crash(self) -> Optional[pulumi.Input[bool]]:
        """
        If a native process other than the app crashed.
        """
        return pulumi.get(self, "other_native_crash")

    @other_native_crash.setter
    def other_native_crash(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "other_native_crash", value)


@pulumi.input_type
class TestCaseReferenceArgs:
    def __init__(__self__, *,
                 class_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 test_suite_name: Optional[pulumi.Input[str]] = None):
        """
        A reference to a test case. Test case references are canonically ordered lexicographically by these three factors: * First, by test_suite_name. * Second, by class_name. * Third, by name.
        :param pulumi.Input[str] class_name: The name of the class.
        :param pulumi.Input[str] name: The name of the test case. Required.
        :param pulumi.Input[str] test_suite_name: The name of the test suite to which this test case belongs.
        """
        if class_name is not None:
            pulumi.set(__self__, "class_name", class_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if test_suite_name is not None:
            pulumi.set(__self__, "test_suite_name", test_suite_name)

    @property
    @pulumi.getter(name="className")
    def class_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the class.
        """
        return pulumi.get(self, "class_name")

    @class_name.setter
    def class_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "class_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the test case. Required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="testSuiteName")
    def test_suite_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the test suite to which this test case belongs.
        """
        return pulumi.get(self, "test_suite_name")

    @test_suite_name.setter
    def test_suite_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "test_suite_name", value)


@pulumi.input_type
class TestExecutionStepArgs:
    def __init__(__self__, *,
                 test_issues: Optional[pulumi.Input[Sequence[pulumi.Input['TestIssueArgs']]]] = None,
                 test_suite_overviews: Optional[pulumi.Input[Sequence[pulumi.Input['TestSuiteOverviewArgs']]]] = None,
                 test_timing: Optional[pulumi.Input['TestTimingArgs']] = None,
                 tool_execution: Optional[pulumi.Input['ToolExecutionArgs']] = None):
        """
        A step that represents running tests. It accepts ant-junit xml files which will be parsed into structured test results by the service. Xml file paths are updated in order to append more files, however they can't be deleted. Users can also add test results manually by using the test_result field.
        :param pulumi.Input[Sequence[pulumi.Input['TestIssueArgs']]] test_issues: Issues observed during the test execution. For example, if the mobile app under test crashed during the test, the error message and the stack trace content can be recorded here to assist debugging. - In response: present if set by create or update - In create/update request: optional
        :param pulumi.Input[Sequence[pulumi.Input['TestSuiteOverviewArgs']]] test_suite_overviews: List of test suite overview contents. This could be parsed from xUnit XML log by server, or uploaded directly by user. This references should only be called when test suites are fully parsed or uploaded. The maximum allowed number of test suite overviews per step is 1000. - In response: always set - In create request: optional - In update request: never (use publishXunitXmlFiles custom method instead)
        :param pulumi.Input['TestTimingArgs'] test_timing: The timing break down of the test execution. - In response: present if set by create or update - In create/update request: optional
        :param pulumi.Input['ToolExecutionArgs'] tool_execution: Represents the execution of the test runner. The exit code of this tool will be used to determine if the test passed. - In response: always set - In create/update request: optional
        """
        if test_issues is not None:
            pulumi.set(__self__, "test_issues", test_issues)
        if test_suite_overviews is not None:
            pulumi.set(__self__, "test_suite_overviews", test_suite_overviews)
        if test_timing is not None:
            pulumi.set(__self__, "test_timing", test_timing)
        if tool_execution is not None:
            pulumi.set(__self__, "tool_execution", tool_execution)

    @property
    @pulumi.getter(name="testIssues")
    def test_issues(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TestIssueArgs']]]]:
        """
        Issues observed during the test execution. For example, if the mobile app under test crashed during the test, the error message and the stack trace content can be recorded here to assist debugging. - In response: present if set by create or update - In create/update request: optional
        """
        return pulumi.get(self, "test_issues")

    @test_issues.setter
    def test_issues(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TestIssueArgs']]]]):
        pulumi.set(self, "test_issues", value)

    @property
    @pulumi.getter(name="testSuiteOverviews")
    def test_suite_overviews(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TestSuiteOverviewArgs']]]]:
        """
        List of test suite overview contents. This could be parsed from xUnit XML log by server, or uploaded directly by user. This references should only be called when test suites are fully parsed or uploaded. The maximum allowed number of test suite overviews per step is 1000. - In response: always set - In create request: optional - In update request: never (use publishXunitXmlFiles custom method instead)
        """
        return pulumi.get(self, "test_suite_overviews")

    @test_suite_overviews.setter
    def test_suite_overviews(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TestSuiteOverviewArgs']]]]):
        pulumi.set(self, "test_suite_overviews", value)

    @property
    @pulumi.getter(name="testTiming")
    def test_timing(self) -> Optional[pulumi.Input['TestTimingArgs']]:
        """
        The timing break down of the test execution. - In response: present if set by create or update - In create/update request: optional
        """
        return pulumi.get(self, "test_timing")

    @test_timing.setter
    def test_timing(self, value: Optional[pulumi.Input['TestTimingArgs']]):
        pulumi.set(self, "test_timing", value)

    @property
    @pulumi.getter(name="toolExecution")
    def tool_execution(self) -> Optional[pulumi.Input['ToolExecutionArgs']]:
        """
        Represents the execution of the test runner. The exit code of this tool will be used to determine if the test passed. - In response: always set - In create/update request: optional
        """
        return pulumi.get(self, "tool_execution")

    @tool_execution.setter
    def tool_execution(self, value: Optional[pulumi.Input['ToolExecutionArgs']]):
        pulumi.set(self, "tool_execution", value)


@pulumi.input_type
class TestIssueArgs:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[str]] = None,
                 error_message: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 stack_trace: Optional[pulumi.Input['StackTraceArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 warning: Optional[pulumi.Input['AnyArgs']] = None):
        """
        An issue detected occurring during a test execution.
        :param pulumi.Input[str] category: Category of issue. Required.
        :param pulumi.Input[str] error_message: A brief human-readable message describing the issue. Required.
        :param pulumi.Input[str] severity: Severity of issue. Required.
        :param pulumi.Input['StackTraceArgs'] stack_trace: Deprecated in favor of stack trace fields inside specific warnings.
        :param pulumi.Input[str] type: Type of issue. Required.
        :param pulumi.Input['AnyArgs'] warning: Warning message with additional details of the issue. Should always be a message from com.google.devtools.toolresults.v1.warnings
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if stack_trace is not None:
            pulumi.set(__self__, "stack_trace", stack_trace)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        Category of issue. Required.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[pulumi.Input[str]]:
        """
        A brief human-readable message describing the issue. Required.
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_message", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[str]]:
        """
        Severity of issue. Required.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter(name="stackTrace")
    def stack_trace(self) -> Optional[pulumi.Input['StackTraceArgs']]:
        """
        Deprecated in favor of stack trace fields inside specific warnings.
        """
        return pulumi.get(self, "stack_trace")

    @stack_trace.setter
    def stack_trace(self, value: Optional[pulumi.Input['StackTraceArgs']]):
        pulumi.set(self, "stack_trace", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of issue. Required.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def warning(self) -> Optional[pulumi.Input['AnyArgs']]:
        """
        Warning message with additional details of the issue. Should always be a message from com.google.devtools.toolresults.v1.warnings
        """
        return pulumi.get(self, "warning")

    @warning.setter
    def warning(self, value: Optional[pulumi.Input['AnyArgs']]):
        pulumi.set(self, "warning", value)


@pulumi.input_type
class TestSuiteOverviewArgs:
    def __init__(__self__, *,
                 elapsed_time: Optional[pulumi.Input['DurationArgs']] = None,
                 error_count: Optional[pulumi.Input[int]] = None,
                 failure_count: Optional[pulumi.Input[int]] = None,
                 flaky_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 skipped_count: Optional[pulumi.Input[int]] = None,
                 total_count: Optional[pulumi.Input[int]] = None,
                 xml_source: Optional[pulumi.Input['FileReferenceArgs']] = None):
        """
        A summary of a test suite result either parsed from XML or uploaded directly by a user. Note: the API related comments are for StepService only. This message is also being used in ExecutionService in a read only mode for the corresponding step.
        :param pulumi.Input['DurationArgs'] elapsed_time: Elapsed time of test suite.
        :param pulumi.Input[int] error_count: Number of test cases in error, typically set by the service by parsing the xml_source. - In create/response: always set - In update request: never
        :param pulumi.Input[int] failure_count: Number of failed test cases, typically set by the service by parsing the xml_source. May also be set by the user. - In create/response: always set - In update request: never
        :param pulumi.Input[int] flaky_count: Number of flaky test cases, set by the service by rolling up flaky test attempts. Present only for rollup test suite overview at environment level. A step cannot have flaky test cases.
        :param pulumi.Input[str] name: The name of the test suite. - In create/response: always set - In update request: never
        :param pulumi.Input[int] skipped_count: Number of test cases not run, typically set by the service by parsing the xml_source. - In create/response: always set - In update request: never
        :param pulumi.Input[int] total_count: Number of test cases, typically set by the service by parsing the xml_source. - In create/response: always set - In update request: never
        :param pulumi.Input['FileReferenceArgs'] xml_source: If this test suite was parsed from XML, this is the URI where the original XML file is stored. Note: Multiple test suites can share the same xml_source Returns INVALID_ARGUMENT if the uri format is not supported. - In create/response: optional - In update request: never
        """
        if elapsed_time is not None:
            pulumi.set(__self__, "elapsed_time", elapsed_time)
        if error_count is not None:
            pulumi.set(__self__, "error_count", error_count)
        if failure_count is not None:
            pulumi.set(__self__, "failure_count", failure_count)
        if flaky_count is not None:
            pulumi.set(__self__, "flaky_count", flaky_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if skipped_count is not None:
            pulumi.set(__self__, "skipped_count", skipped_count)
        if total_count is not None:
            pulumi.set(__self__, "total_count", total_count)
        if xml_source is not None:
            pulumi.set(__self__, "xml_source", xml_source)

    @property
    @pulumi.getter(name="elapsedTime")
    def elapsed_time(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        Elapsed time of test suite.
        """
        return pulumi.get(self, "elapsed_time")

    @elapsed_time.setter
    def elapsed_time(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "elapsed_time", value)

    @property
    @pulumi.getter(name="errorCount")
    def error_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of test cases in error, typically set by the service by parsing the xml_source. - In create/response: always set - In update request: never
        """
        return pulumi.get(self, "error_count")

    @error_count.setter
    def error_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "error_count", value)

    @property
    @pulumi.getter(name="failureCount")
    def failure_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of failed test cases, typically set by the service by parsing the xml_source. May also be set by the user. - In create/response: always set - In update request: never
        """
        return pulumi.get(self, "failure_count")

    @failure_count.setter
    def failure_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_count", value)

    @property
    @pulumi.getter(name="flakyCount")
    def flaky_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of flaky test cases, set by the service by rolling up flaky test attempts. Present only for rollup test suite overview at environment level. A step cannot have flaky test cases.
        """
        return pulumi.get(self, "flaky_count")

    @flaky_count.setter
    def flaky_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "flaky_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the test suite. - In create/response: always set - In update request: never
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="skippedCount")
    def skipped_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of test cases not run, typically set by the service by parsing the xml_source. - In create/response: always set - In update request: never
        """
        return pulumi.get(self, "skipped_count")

    @skipped_count.setter
    def skipped_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "skipped_count", value)

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of test cases, typically set by the service by parsing the xml_source. - In create/response: always set - In update request: never
        """
        return pulumi.get(self, "total_count")

    @total_count.setter
    def total_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_count", value)

    @property
    @pulumi.getter(name="xmlSource")
    def xml_source(self) -> Optional[pulumi.Input['FileReferenceArgs']]:
        """
        If this test suite was parsed from XML, this is the URI where the original XML file is stored. Note: Multiple test suites can share the same xml_source Returns INVALID_ARGUMENT if the uri format is not supported. - In create/response: optional - In update request: never
        """
        return pulumi.get(self, "xml_source")

    @xml_source.setter
    def xml_source(self, value: Optional[pulumi.Input['FileReferenceArgs']]):
        pulumi.set(self, "xml_source", value)


@pulumi.input_type
class TestTimingArgs:
    def __init__(__self__, *,
                 test_process_duration: Optional[pulumi.Input['DurationArgs']] = None):
        """
        Testing timing break down to know phases.
        :param pulumi.Input['DurationArgs'] test_process_duration: How long it took to run the test process. - In response: present if previously set. - In create/update request: optional
        """
        if test_process_duration is not None:
            pulumi.set(__self__, "test_process_duration", test_process_duration)

    @property
    @pulumi.getter(name="testProcessDuration")
    def test_process_duration(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        How long it took to run the test process. - In response: present if previously set. - In create/update request: optional
        """
        return pulumi.get(self, "test_process_duration")

    @test_process_duration.setter
    def test_process_duration(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "test_process_duration", value)


@pulumi.input_type
class TimestampArgs:
    def __init__(__self__, *,
                 nanos: Optional[pulumi.Input[int]] = None,
                 seconds: Optional[pulumi.Input[str]] = None):
        """
        A Timestamp represents a point in time independent of any time zone or local calendar, encoded as a count of seconds and fractions of seconds at nanosecond resolution. The count is relative to an epoch at UTC midnight on January 1, 1970, in the proleptic Gregorian calendar which extends the Gregorian calendar backwards to year one. All minutes are 60 seconds long. Leap seconds are "smeared" so that no leap second table is needed for interpretation, using a [24-hour linear smear](https://developers.google.com/time/smear). The range is from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59.999999999Z. By restricting to that range, we ensure that we can convert to and from [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) date strings.
        :param pulumi.Input[int] nanos: Non-negative fractions of a second at nanosecond resolution. Negative second values with fractions must still have non-negative nanos values that count forward in time. Must be from 0 to 999,999,999 inclusive.
        :param pulumi.Input[str] seconds: Represents seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive.
        """
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[pulumi.Input[int]]:
        """
        Non-negative fractions of a second at nanosecond resolution. Negative second values with fractions must still have non-negative nanos values that count forward in time. Must be from 0 to 999,999,999 inclusive.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def seconds(self) -> Optional[pulumi.Input[str]]:
        """
        Represents seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive.
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "seconds", value)


@pulumi.input_type
class ToolExecutionArgs:
    def __init__(__self__, *,
                 command_line_arguments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exit_code: Optional[pulumi.Input['ToolExitCodeArgs']] = None,
                 tool_logs: Optional[pulumi.Input[Sequence[pulumi.Input['FileReferenceArgs']]]] = None,
                 tool_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ToolOutputReferenceArgs']]]] = None):
        """
        An execution of an arbitrary tool. It could be a test runner or a tool copying artifacts or deploying code.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command_line_arguments: The full tokenized command line including the program name (equivalent to argv in a C program). - In response: present if set by create request - In create request: optional - In update request: never set
        :param pulumi.Input['ToolExitCodeArgs'] exit_code: Tool execution exit code. This field will be set once the tool has exited. - In response: present if set by create/update request - In create request: optional - In update request: optional, a FAILED_PRECONDITION error will be returned if an exit_code is already set.
        :param pulumi.Input[Sequence[pulumi.Input['FileReferenceArgs']]] tool_logs: References to any plain text logs output the tool execution. This field can be set before the tool has exited in order to be able to have access to a live view of the logs while the tool is running. The maximum allowed number of tool logs per step is 1000. - In response: present if set by create/update request - In create request: optional - In update request: optional, any value provided will be appended to the existing list
        :param pulumi.Input[Sequence[pulumi.Input['ToolOutputReferenceArgs']]] tool_outputs: References to opaque files of any format output by the tool execution. The maximum allowed number of tool outputs per step is 1000. - In response: present if set by create/update request - In create request: optional - In update request: optional, any value provided will be appended to the existing list
        """
        if command_line_arguments is not None:
            pulumi.set(__self__, "command_line_arguments", command_line_arguments)
        if exit_code is not None:
            pulumi.set(__self__, "exit_code", exit_code)
        if tool_logs is not None:
            pulumi.set(__self__, "tool_logs", tool_logs)
        if tool_outputs is not None:
            pulumi.set(__self__, "tool_outputs", tool_outputs)

    @property
    @pulumi.getter(name="commandLineArguments")
    def command_line_arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The full tokenized command line including the program name (equivalent to argv in a C program). - In response: present if set by create request - In create request: optional - In update request: never set
        """
        return pulumi.get(self, "command_line_arguments")

    @command_line_arguments.setter
    def command_line_arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command_line_arguments", value)

    @property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> Optional[pulumi.Input['ToolExitCodeArgs']]:
        """
        Tool execution exit code. This field will be set once the tool has exited. - In response: present if set by create/update request - In create request: optional - In update request: optional, a FAILED_PRECONDITION error will be returned if an exit_code is already set.
        """
        return pulumi.get(self, "exit_code")

    @exit_code.setter
    def exit_code(self, value: Optional[pulumi.Input['ToolExitCodeArgs']]):
        pulumi.set(self, "exit_code", value)

    @property
    @pulumi.getter(name="toolLogs")
    def tool_logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileReferenceArgs']]]]:
        """
        References to any plain text logs output the tool execution. This field can be set before the tool has exited in order to be able to have access to a live view of the logs while the tool is running. The maximum allowed number of tool logs per step is 1000. - In response: present if set by create/update request - In create request: optional - In update request: optional, any value provided will be appended to the existing list
        """
        return pulumi.get(self, "tool_logs")

    @tool_logs.setter
    def tool_logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileReferenceArgs']]]]):
        pulumi.set(self, "tool_logs", value)

    @property
    @pulumi.getter(name="toolOutputs")
    def tool_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ToolOutputReferenceArgs']]]]:
        """
        References to opaque files of any format output by the tool execution. The maximum allowed number of tool outputs per step is 1000. - In response: present if set by create/update request - In create request: optional - In update request: optional, any value provided will be appended to the existing list
        """
        return pulumi.get(self, "tool_outputs")

    @tool_outputs.setter
    def tool_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ToolOutputReferenceArgs']]]]):
        pulumi.set(self, "tool_outputs", value)


@pulumi.input_type
class ToolExecutionStepArgs:
    def __init__(__self__, *,
                 tool_execution: Optional[pulumi.Input['ToolExecutionArgs']] = None):
        """
        Generic tool step to be used for binaries we do not explicitly support. For example: running cp to copy artifacts from one location to another.
        :param pulumi.Input['ToolExecutionArgs'] tool_execution: A Tool execution. - In response: present if set by create/update request - In create/update request: optional
        """
        if tool_execution is not None:
            pulumi.set(__self__, "tool_execution", tool_execution)

    @property
    @pulumi.getter(name="toolExecution")
    def tool_execution(self) -> Optional[pulumi.Input['ToolExecutionArgs']]:
        """
        A Tool execution. - In response: present if set by create/update request - In create/update request: optional
        """
        return pulumi.get(self, "tool_execution")

    @tool_execution.setter
    def tool_execution(self, value: Optional[pulumi.Input['ToolExecutionArgs']]):
        pulumi.set(self, "tool_execution", value)


@pulumi.input_type
class ToolExitCodeArgs:
    def __init__(__self__, *,
                 number: Optional[pulumi.Input[int]] = None):
        """
        Exit code from a tool execution.
        :param pulumi.Input[int] number: Tool execution exit code. A value of 0 means that the execution was successful. - In response: always set - In create/update request: always set
        """
        if number is not None:
            pulumi.set(__self__, "number", number)

    @property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[int]]:
        """
        Tool execution exit code. A value of 0 means that the execution was successful. - In response: always set - In create/update request: always set
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number", value)


@pulumi.input_type
class ToolOutputReferenceArgs:
    def __init__(__self__, *,
                 creation_time: Optional[pulumi.Input['TimestampArgs']] = None,
                 output: Optional[pulumi.Input['FileReferenceArgs']] = None,
                 test_case: Optional[pulumi.Input['TestCaseReferenceArgs']] = None):
        """
        A reference to a ToolExecution output file.
        :param pulumi.Input['TimestampArgs'] creation_time: The creation time of the file. - In response: present if set by create/update request - In create/update request: optional
        :param pulumi.Input['FileReferenceArgs'] output: A FileReference to an output file. - In response: always set - In create/update request: always set
        :param pulumi.Input['TestCaseReferenceArgs'] test_case: The test case to which this output file belongs. - In response: present if set by create/update request - In create/update request: optional
        """
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if output is not None:
            pulumi.set(__self__, "output", output)
        if test_case is not None:
            pulumi.set(__self__, "test_case", test_case)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input['TimestampArgs']]:
        """
        The creation time of the file. - In response: present if set by create/update request - In create/update request: optional
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input['TimestampArgs']]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def output(self) -> Optional[pulumi.Input['FileReferenceArgs']]:
        """
        A FileReference to an output file. - In response: always set - In create/update request: always set
        """
        return pulumi.get(self, "output")

    @output.setter
    def output(self, value: Optional[pulumi.Input['FileReferenceArgs']]):
        pulumi.set(self, "output", value)

    @property
    @pulumi.getter(name="testCase")
    def test_case(self) -> Optional[pulumi.Input['TestCaseReferenceArgs']]:
        """
        The test case to which this output file belongs. - In response: present if set by create/update request - In create/update request: optional
        """
        return pulumi.get(self, "test_case")

    @test_case.setter
    def test_case(self, value: Optional[pulumi.Input['TestCaseReferenceArgs']]):
        pulumi.set(self, "test_case", value)


