# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = [
    'BucketAccessControlResponse',
    'ObjectAccessControlResponse',
]

@pulumi.output_type
class BucketAccessControlResponse(dict):
    """
    An access-control entry.
    """
    def __init__(__self__, *,
                 bucket: str,
                 domain: str,
                 email: str,
                 entity: str,
                 entity_id: str,
                 etag: str,
                 kind: str,
                 project_team: Mapping[str, str],
                 role: str,
                 self_link: str):
        """
        An access-control entry.
        :param str bucket: The name of the bucket.
        :param str domain: The domain associated with the entity, if any.
        :param str email: The email address associated with the entity, if any.
        :param str entity: The entity holding the permission, in one of the following forms: 
               - user-userId 
               - user-email 
               - group-groupId 
               - group-email 
               - domain-domain 
               - project-team-projectId 
               - allUsers 
               - allAuthenticatedUsers Examples: 
               - The user liz@example.com would be user-liz@example.com. 
               - The group example@googlegroups.com would be group-example@googlegroups.com. 
               - To refer to all members of the Google Apps for Business domain example.com, the entity would be domain-example.com.
        :param str entity_id: The ID for the entity, if any.
        :param str etag: HTTP 1.1 Entity tag for the access-control entry.
        :param str kind: The kind of item this is. For bucket access control entries, this is always storage#bucketAccessControl.
        :param Mapping[str, str] project_team: The project team associated with the entity, if any.
        :param str role: The access permission for the entity.
        :param str self_link: The link to this access-control entry.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "entity", entity)
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "project_team", project_team)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "self_link", self_link)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain associated with the entity, if any.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email address associated with the entity, if any.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def entity(self) -> str:
        """
        The entity holding the permission, in one of the following forms: 
        - user-userId 
        - user-email 
        - group-groupId 
        - group-email 
        - domain-domain 
        - project-team-projectId 
        - allUsers 
        - allAuthenticatedUsers Examples: 
        - The user liz@example.com would be user-liz@example.com. 
        - The group example@googlegroups.com would be group-example@googlegroups.com. 
        - To refer to all members of the Google Apps for Business domain example.com, the entity would be domain-example.com.
        """
        return pulumi.get(self, "entity")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> str:
        """
        The ID for the entity, if any.
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        HTTP 1.1 Entity tag for the access-control entry.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The kind of item this is. For bucket access control entries, this is always storage#bucketAccessControl.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="projectTeam")
    def project_team(self) -> Mapping[str, str]:
        """
        The project team associated with the entity, if any.
        """
        return pulumi.get(self, "project_team")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The access permission for the entity.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        The link to this access-control entry.
        """
        return pulumi.get(self, "self_link")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ObjectAccessControlResponse(dict):
    """
    An access-control entry.
    """
    def __init__(__self__, *,
                 bucket: str,
                 domain: str,
                 email: str,
                 entity: str,
                 entity_id: str,
                 etag: str,
                 generation: str,
                 kind: str,
                 object: str,
                 project_team: Mapping[str, str],
                 role: str,
                 self_link: str):
        """
        An access-control entry.
        :param str bucket: The name of the bucket.
        :param str domain: The domain associated with the entity, if any.
        :param str email: The email address associated with the entity, if any.
        :param str entity: The entity holding the permission, in one of the following forms: 
               - user-userId 
               - user-email 
               - group-groupId 
               - group-email 
               - domain-domain 
               - project-team-projectId 
               - allUsers 
               - allAuthenticatedUsers Examples: 
               - The user liz@example.com would be user-liz@example.com. 
               - The group example@googlegroups.com would be group-example@googlegroups.com. 
               - To refer to all members of the Google Apps for Business domain example.com, the entity would be domain-example.com.
        :param str entity_id: The ID for the entity, if any.
        :param str etag: HTTP 1.1 Entity tag for the access-control entry.
        :param str generation: The content generation of the object, if applied to an object.
        :param str kind: The kind of item this is. For object access control entries, this is always storage#objectAccessControl.
        :param str object: The name of the object, if applied to an object.
        :param Mapping[str, str] project_team: The project team associated with the entity, if any.
        :param str role: The access permission for the entity.
        :param str self_link: The link to this access-control entry.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "entity", entity)
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "project_team", project_team)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "self_link", self_link)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain associated with the entity, if any.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email address associated with the entity, if any.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def entity(self) -> str:
        """
        The entity holding the permission, in one of the following forms: 
        - user-userId 
        - user-email 
        - group-groupId 
        - group-email 
        - domain-domain 
        - project-team-projectId 
        - allUsers 
        - allAuthenticatedUsers Examples: 
        - The user liz@example.com would be user-liz@example.com. 
        - The group example@googlegroups.com would be group-example@googlegroups.com. 
        - To refer to all members of the Google Apps for Business domain example.com, the entity would be domain-example.com.
        """
        return pulumi.get(self, "entity")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> str:
        """
        The ID for the entity, if any.
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        HTTP 1.1 Entity tag for the access-control entry.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def generation(self) -> str:
        """
        The content generation of the object, if applied to an object.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The kind of item this is. For object access control entries, this is always storage#objectAccessControl.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The name of the object, if applied to an object.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="projectTeam")
    def project_team(self) -> Mapping[str, str]:
        """
        The project team associated with the entity, if any.
        """
        return pulumi.get(self, "project_team")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The access permission for the entity.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        The link to this access-control entry.
        """
        return pulumi.get(self, "self_link")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


