# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs

__all__ = [
    'AptSettingsResponse',
    'ExecStepConfigResponse',
    'ExecStepResponse',
    'FixedOrPercentResponse',
    'GcsObjectResponse',
    'GooSettingsResponse',
    'MonthlyScheduleResponse',
    'OneTimeScheduleResponse',
    'PatchConfigResponse',
    'PatchInstanceFilterGroupLabelResponse',
    'PatchInstanceFilterResponse',
    'PatchRolloutResponse',
    'RecurringScheduleResponse',
    'TimeOfDayResponse',
    'TimeZoneResponse',
    'WeekDayOfMonthResponse',
    'WeeklyScheduleResponse',
    'WindowsUpdateSettingsResponse',
    'YumSettingsResponse',
    'ZypperSettingsResponse',
]

@pulumi.output_type
class AptSettingsResponse(dict):
    """
    Apt patching is completed by executing `apt-get update && apt-get upgrade`. Additional options can be set to control how this is executed.
    """
    def __init__(__self__, *,
                 excludes: Sequence[str],
                 exclusive_packages: Sequence[str],
                 type: str):
        """
        Apt patching is completed by executing `apt-get update && apt-get upgrade`. Additional options can be set to control how this is executed.
        :param Sequence[str] excludes: List of packages to exclude from update. These packages will be excluded
        :param Sequence[str] exclusive_packages: An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field cannot be specified with any other patch configuration fields.
        :param str type: By changing the type to DIST, the patching is performed using `apt-get dist-upgrade` instead.
        """
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "exclusive_packages", exclusive_packages)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        List of packages to exclude from update. These packages will be excluded
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="exclusivePackages")
    def exclusive_packages(self) -> Sequence[str]:
        """
        An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field cannot be specified with any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_packages")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        By changing the type to DIST, the patching is performed using `apt-get dist-upgrade` instead.
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ExecStepConfigResponse(dict):
    """
    Common configurations for an ExecStep.
    """
    def __init__(__self__, *,
                 allowed_success_codes: Sequence[int],
                 gcs_object: 'outputs.GcsObjectResponse',
                 interpreter: str,
                 local_path: str):
        """
        Common configurations for an ExecStep.
        :param Sequence[int] allowed_success_codes: Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        :param 'GcsObjectResponseArgs' gcs_object: A Cloud Storage object containing the executable.
        :param str interpreter: The script interpreter to use to run the script. If no interpreter is specified the script will be executed directly, which will likely only succeed for scripts with [shebang lines] (https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
        :param str local_path: An absolute path to the executable on the VM.
        """
        pulumi.set(__self__, "allowed_success_codes", allowed_success_codes)
        pulumi.set(__self__, "gcs_object", gcs_object)
        pulumi.set(__self__, "interpreter", interpreter)
        pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedSuccessCodes")
    def allowed_success_codes(self) -> Sequence[int]:
        """
        Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        """
        return pulumi.get(self, "allowed_success_codes")

    @property
    @pulumi.getter(name="gcsObject")
    def gcs_object(self) -> 'outputs.GcsObjectResponse':
        """
        A Cloud Storage object containing the executable.
        """
        return pulumi.get(self, "gcs_object")

    @property
    @pulumi.getter
    def interpreter(self) -> str:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script will be executed directly, which will likely only succeed for scripts with [shebang lines] (https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
        """
        return pulumi.get(self, "interpreter")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        An absolute path to the executable on the VM.
        """
        return pulumi.get(self, "local_path")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ExecStepResponse(dict):
    """
    A step that runs an executable for a PatchJob.
    """
    def __init__(__self__, *,
                 linux_exec_step_config: 'outputs.ExecStepConfigResponse',
                 windows_exec_step_config: 'outputs.ExecStepConfigResponse'):
        """
        A step that runs an executable for a PatchJob.
        :param 'ExecStepConfigResponseArgs' linux_exec_step_config: The ExecStepConfig for all Linux VMs targeted by the PatchJob.
        :param 'ExecStepConfigResponseArgs' windows_exec_step_config: The ExecStepConfig for all Windows VMs targeted by the PatchJob.
        """
        pulumi.set(__self__, "linux_exec_step_config", linux_exec_step_config)
        pulumi.set(__self__, "windows_exec_step_config", windows_exec_step_config)

    @property
    @pulumi.getter(name="linuxExecStepConfig")
    def linux_exec_step_config(self) -> 'outputs.ExecStepConfigResponse':
        """
        The ExecStepConfig for all Linux VMs targeted by the PatchJob.
        """
        return pulumi.get(self, "linux_exec_step_config")

    @property
    @pulumi.getter(name="windowsExecStepConfig")
    def windows_exec_step_config(self) -> 'outputs.ExecStepConfigResponse':
        """
        The ExecStepConfig for all Windows VMs targeted by the PatchJob.
        """
        return pulumi.get(self, "windows_exec_step_config")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class FixedOrPercentResponse(dict):
    """
    Message encapsulating a value that can be either absolute ("fixed") or relative ("percent") to a value.
    """
    def __init__(__self__, *,
                 fixed: int,
                 percent: int):
        """
        Message encapsulating a value that can be either absolute ("fixed") or relative ("percent") to a value.
        :param int fixed: Specifies a fixed value.
        :param int percent: Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        pulumi.set(__self__, "fixed", fixed)
        pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def fixed(self) -> int:
        """
        Specifies a fixed value.
        """
        return pulumi.get(self, "fixed")

    @property
    @pulumi.getter
    def percent(self) -> int:
        """
        Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        return pulumi.get(self, "percent")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GcsObjectResponse(dict):
    """
    Cloud Storage object representation.
    """
    def __init__(__self__, *,
                 bucket: str,
                 generation_number: str,
                 object: str):
        """
        Cloud Storage object representation.
        :param str bucket: Required. Bucket of the Cloud Storage object.
        :param str generation_number: Required. Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        :param str object: Required. Name of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation_number", generation_number)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Required. Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="generationNumber")
    def generation_number(self) -> str:
        """
        Required. Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        """
        return pulumi.get(self, "generation_number")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Required. Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GooSettingsResponse(dict):
    """
    Googet patching is performed by running `googet update`.
    """
    def __init__(__self__):
        """
        Googet patching is performed by running `googet update`.
        """
        pass

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class MonthlyScheduleResponse(dict):
    """
    Represents a monthly schedule. An example of a valid monthly schedule is "on the third Tuesday of the month" or "on the 15th of the month".
    """
    def __init__(__self__, *,
                 month_day: int,
                 week_day_of_month: 'outputs.WeekDayOfMonthResponse'):
        """
        Represents a monthly schedule. An example of a valid monthly schedule is "on the third Tuesday of the month" or "on the 15th of the month".
        :param int month_day: Required. One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month. Months without the target day will be skipped. For example, a schedule to run "every month on the 31st" will not run in February, April, June, etc.
        :param 'WeekDayOfMonthResponseArgs' week_day_of_month: Required. Week day in a month.
        """
        pulumi.set(__self__, "month_day", month_day)
        pulumi.set(__self__, "week_day_of_month", week_day_of_month)

    @property
    @pulumi.getter(name="monthDay")
    def month_day(self) -> int:
        """
        Required. One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month. Months without the target day will be skipped. For example, a schedule to run "every month on the 31st" will not run in February, April, June, etc.
        """
        return pulumi.get(self, "month_day")

    @property
    @pulumi.getter(name="weekDayOfMonth")
    def week_day_of_month(self) -> 'outputs.WeekDayOfMonthResponse':
        """
        Required. Week day in a month.
        """
        return pulumi.get(self, "week_day_of_month")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OneTimeScheduleResponse(dict):
    """
    Sets the time for a one time patch deployment. Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    """
    def __init__(__self__, *,
                 execute_time: str):
        """
        Sets the time for a one time patch deployment. Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        :param str execute_time: Required. The desired patch job execution time.
        """
        pulumi.set(__self__, "execute_time", execute_time)

    @property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> str:
        """
        Required. The desired patch job execution time.
        """
        return pulumi.get(self, "execute_time")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PatchConfigResponse(dict):
    """
    Patch configuration specifications. Contains details on how to apply the patch(es) to a VM instance.
    """
    def __init__(__self__, *,
                 apt: 'outputs.AptSettingsResponse',
                 goo: 'outputs.GooSettingsResponse',
                 post_step: 'outputs.ExecStepResponse',
                 pre_step: 'outputs.ExecStepResponse',
                 reboot_config: str,
                 windows_update: 'outputs.WindowsUpdateSettingsResponse',
                 yum: 'outputs.YumSettingsResponse',
                 zypper: 'outputs.ZypperSettingsResponse'):
        """
        Patch configuration specifications. Contains details on how to apply the patch(es) to a VM instance.
        :param 'AptSettingsResponseArgs' apt: Apt update settings. Use this setting to override the default `apt` patch rules.
        :param 'GooSettingsResponseArgs' goo: Goo update settings. Use this setting to override the default `goo` patch rules.
        :param 'ExecStepResponseArgs' post_step: The `ExecStep` to run after the patch update.
        :param 'ExecStepResponseArgs' pre_step: The `ExecStep` to run before the patch update.
        :param str reboot_config: Post-patch reboot settings.
        :param 'WindowsUpdateSettingsResponseArgs' windows_update: Windows update settings. Use this override the default windows patch rules.
        :param 'YumSettingsResponseArgs' yum: Yum update settings. Use this setting to override the default `yum` patch rules.
        :param 'ZypperSettingsResponseArgs' zypper: Zypper update settings. Use this setting to override the default `zypper` patch rules.
        """
        pulumi.set(__self__, "apt", apt)
        pulumi.set(__self__, "goo", goo)
        pulumi.set(__self__, "post_step", post_step)
        pulumi.set(__self__, "pre_step", pre_step)
        pulumi.set(__self__, "reboot_config", reboot_config)
        pulumi.set(__self__, "windows_update", windows_update)
        pulumi.set(__self__, "yum", yum)
        pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> 'outputs.AptSettingsResponse':
        """
        Apt update settings. Use this setting to override the default `apt` patch rules.
        """
        return pulumi.get(self, "apt")

    @property
    @pulumi.getter
    def goo(self) -> 'outputs.GooSettingsResponse':
        """
        Goo update settings. Use this setting to override the default `goo` patch rules.
        """
        return pulumi.get(self, "goo")

    @property
    @pulumi.getter(name="postStep")
    def post_step(self) -> 'outputs.ExecStepResponse':
        """
        The `ExecStep` to run after the patch update.
        """
        return pulumi.get(self, "post_step")

    @property
    @pulumi.getter(name="preStep")
    def pre_step(self) -> 'outputs.ExecStepResponse':
        """
        The `ExecStep` to run before the patch update.
        """
        return pulumi.get(self, "pre_step")

    @property
    @pulumi.getter(name="rebootConfig")
    def reboot_config(self) -> str:
        """
        Post-patch reboot settings.
        """
        return pulumi.get(self, "reboot_config")

    @property
    @pulumi.getter(name="windowsUpdate")
    def windows_update(self) -> 'outputs.WindowsUpdateSettingsResponse':
        """
        Windows update settings. Use this override the default windows patch rules.
        """
        return pulumi.get(self, "windows_update")

    @property
    @pulumi.getter
    def yum(self) -> 'outputs.YumSettingsResponse':
        """
        Yum update settings. Use this setting to override the default `yum` patch rules.
        """
        return pulumi.get(self, "yum")

    @property
    @pulumi.getter
    def zypper(self) -> 'outputs.ZypperSettingsResponse':
        """
        Zypper update settings. Use this setting to override the default `zypper` patch rules.
        """
        return pulumi.get(self, "zypper")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PatchInstanceFilterGroupLabelResponse(dict):
    """
    Targets a group of VM instances by using their [assigned labels](https://cloud.google.com/compute/docs/labeling-resources). Labels are key-value pairs. A `GroupLabel` is a combination of labels that is used to target VMs for a patch job. For example, a patch job can target VMs that have the following `GroupLabel`: `{"env":"test", "app":"web"}`. This means that the patch job is applied to VMs that have both the labels `env=test` and `app=web`.
    """
    def __init__(__self__, *,
                 labels: Mapping[str, str]):
        """
        Targets a group of VM instances by using their [assigned labels](https://cloud.google.com/compute/docs/labeling-resources). Labels are key-value pairs. A `GroupLabel` is a combination of labels that is used to target VMs for a patch job. For example, a patch job can target VMs that have the following `GroupLabel`: `{"env":"test", "app":"web"}`. This means that the patch job is applied to VMs that have both the labels `env=test` and `app=web`.
        :param Mapping[str, str] labels: Compute Engine instance labels that must be present for a VM instance to be targeted by this filter.
        """
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Compute Engine instance labels that must be present for a VM instance to be targeted by this filter.
        """
        return pulumi.get(self, "labels")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PatchInstanceFilterResponse(dict):
    """
    A filter to target VM instances for patching. The targeted VMs must meet all criteria specified. So if both labels and zones are specified, the patch job targets only VMs with those labels and in those zones.
    """
    def __init__(__self__, *,
                 all: bool,
                 group_labels: Sequence['outputs.PatchInstanceFilterGroupLabelResponse'],
                 instance_name_prefixes: Sequence[str],
                 instances: Sequence[str],
                 zones: Sequence[str]):
        """
        A filter to target VM instances for patching. The targeted VMs must meet all criteria specified. So if both labels and zones are specified, the patch job targets only VMs with those labels and in those zones.
        :param bool all: Target all VM instances in the project. If true, no other criteria is permitted.
        :param Sequence['PatchInstanceFilterGroupLabelResponseArgs'] group_labels: Targets VM instances matching ANY of these GroupLabels. This allows targeting of disparate groups of VM instances.
        :param Sequence[str] instance_name_prefixes: Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group VMs when targeting configs, for example prefix="prod-".
        :param Sequence[str] instances: Targets any of the VM instances specified. Instances are specified by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`, `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`
        :param Sequence[str] zones: Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
        """
        pulumi.set(__self__, "all", all)
        pulumi.set(__self__, "group_labels", group_labels)
        pulumi.set(__self__, "instance_name_prefixes", instance_name_prefixes)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def all(self) -> bool:
        """
        Target all VM instances in the project. If true, no other criteria is permitted.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="groupLabels")
    def group_labels(self) -> Sequence['outputs.PatchInstanceFilterGroupLabelResponse']:
        """
        Targets VM instances matching ANY of these GroupLabels. This allows targeting of disparate groups of VM instances.
        """
        return pulumi.get(self, "group_labels")

    @property
    @pulumi.getter(name="instanceNamePrefixes")
    def instance_name_prefixes(self) -> Sequence[str]:
        """
        Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group VMs when targeting configs, for example prefix="prod-".
        """
        return pulumi.get(self, "instance_name_prefixes")

    @property
    @pulumi.getter
    def instances(self) -> Sequence[str]:
        """
        Targets any of the VM instances specified. Instances are specified by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`, `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def zones(self) -> Sequence[str]:
        """
        Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
        """
        return pulumi.get(self, "zones")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PatchRolloutResponse(dict):
    """
    Patch rollout configuration specifications. Contains details on the concurrency control when applying patch(es) to all targeted VMs.
    """
    def __init__(__self__, *,
                 disruption_budget: 'outputs.FixedOrPercentResponse',
                 mode: str):
        """
        Patch rollout configuration specifications. Contains details on the concurrency control when applying patch(es) to all targeted VMs.
        :param 'FixedOrPercentResponseArgs' disruption_budget: The maximum number (or percentage) of VMs per zone to disrupt at any given moment. The number of VMs calculated from multiplying the percentage by the total number of VMs in a zone is rounded up. During patching, a VM is considered disrupted from the time the agent is notified to begin until patching has completed. This disruption time includes the time to complete reboot and any post-patch steps. A VM contributes to the disruption budget if its patching operation fails either when applying the patches, running pre or post patch steps, or if it fails to respond with a success notification before timing out. VMs that are not running or do not have an active agent do not count toward this disruption budget. For zone-by-zone rollouts, if the disruption budget in a zone is exceeded, the patch job stops, because continuing to the next zone requires completion of the patch process in the previous zone. For example, if the disruption budget has a fixed value of `10`, and 8 VMs fail to patch in the current zone, the patch job continues to patch 2 VMs at a time until the zone is completed. When that zone is completed successfully, patching begins with 10 VMs at a time in the next zone. If 10 VMs in the next zone fail to patch, the patch job stops.
        :param str mode: Mode of the patch rollout.
        """
        pulumi.set(__self__, "disruption_budget", disruption_budget)
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="disruptionBudget")
    def disruption_budget(self) -> 'outputs.FixedOrPercentResponse':
        """
        The maximum number (or percentage) of VMs per zone to disrupt at any given moment. The number of VMs calculated from multiplying the percentage by the total number of VMs in a zone is rounded up. During patching, a VM is considered disrupted from the time the agent is notified to begin until patching has completed. This disruption time includes the time to complete reboot and any post-patch steps. A VM contributes to the disruption budget if its patching operation fails either when applying the patches, running pre or post patch steps, or if it fails to respond with a success notification before timing out. VMs that are not running or do not have an active agent do not count toward this disruption budget. For zone-by-zone rollouts, if the disruption budget in a zone is exceeded, the patch job stops, because continuing to the next zone requires completion of the patch process in the previous zone. For example, if the disruption budget has a fixed value of `10`, and 8 VMs fail to patch in the current zone, the patch job continues to patch 2 VMs at a time until the zone is completed. When that zone is completed successfully, patching begins with 10 VMs at a time in the next zone. If 10 VMs in the next zone fail to patch, the patch job stops.
        """
        return pulumi.get(self, "disruption_budget")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Mode of the patch rollout.
        """
        return pulumi.get(self, "mode")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class RecurringScheduleResponse(dict):
    """
    Sets the time for recurring patch deployments.
    """
    def __init__(__self__, *,
                 end_time: str,
                 frequency: str,
                 last_execute_time: str,
                 monthly: 'outputs.MonthlyScheduleResponse',
                 next_execute_time: str,
                 start_time: str,
                 time_of_day: 'outputs.TimeOfDayResponse',
                 time_zone: 'outputs.TimeZoneResponse',
                 weekly: 'outputs.WeeklyScheduleResponse'):
        """
        Sets the time for recurring patch deployments.
        :param str end_time: Optional. The end time at which a recurring patch deployment schedule is no longer active.
        :param str frequency: Required. The frequency unit of this recurring schedule.
        :param str last_execute_time: The time the last patch job ran successfully.
        :param 'MonthlyScheduleResponseArgs' monthly: Required. Schedule with monthly executions.
        :param str next_execute_time: The time the next patch job is scheduled to run.
        :param str start_time: Optional. The time that the recurring schedule becomes effective. Defaults to `create_time` of the patch deployment.
        :param 'TimeOfDayResponseArgs' time_of_day: Required. Time of the day to run a recurring deployment.
        :param 'TimeZoneResponseArgs' time_zone: Required. Defines the time zone that `time_of_day` is relative to. The rules for daylight saving time are determined by the chosen time zone.
        :param 'WeeklyScheduleResponseArgs' weekly: Required. Schedule with weekly executions.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "last_execute_time", last_execute_time)
        pulumi.set(__self__, "monthly", monthly)
        pulumi.set(__self__, "next_execute_time", next_execute_time)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "time_of_day", time_of_day)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "weekly", weekly)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Optional. The end time at which a recurring patch deployment schedule is no longer active.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def frequency(self) -> str:
        """
        Required. The frequency unit of this recurring schedule.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="lastExecuteTime")
    def last_execute_time(self) -> str:
        """
        The time the last patch job ran successfully.
        """
        return pulumi.get(self, "last_execute_time")

    @property
    @pulumi.getter
    def monthly(self) -> 'outputs.MonthlyScheduleResponse':
        """
        Required. Schedule with monthly executions.
        """
        return pulumi.get(self, "monthly")

    @property
    @pulumi.getter(name="nextExecuteTime")
    def next_execute_time(self) -> str:
        """
        The time the next patch job is scheduled to run.
        """
        return pulumi.get(self, "next_execute_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Optional. The time that the recurring schedule becomes effective. Defaults to `create_time` of the patch deployment.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="timeOfDay")
    def time_of_day(self) -> 'outputs.TimeOfDayResponse':
        """
        Required. Time of the day to run a recurring deployment.
        """
        return pulumi.get(self, "time_of_day")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> 'outputs.TimeZoneResponse':
        """
        Required. Defines the time zone that `time_of_day` is relative to. The rules for daylight saving time are determined by the chosen time zone.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def weekly(self) -> 'outputs.WeeklyScheduleResponse':
        """
        Required. Schedule with weekly executions.
        """
        return pulumi.get(self, "weekly")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TimeOfDayResponse(dict):
    """
    Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
    """
    def __init__(__self__, *,
                 hours: int,
                 minutes: int,
                 nanos: int,
                 seconds: int):
        """
        Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
        :param int hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param int seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> int:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> int:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TimeZoneResponse(dict):
    """
    Represents a time zone from the [IANA Time Zone Database](https://www.iana.org/time-zones).
    """
    def __init__(__self__, *,
                 version: str):
        """
        Represents a time zone from the [IANA Time Zone Database](https://www.iana.org/time-zones).
        :param str version: Optional. IANA Time Zone Database version number, e.g. "2019a".
        """
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Optional. IANA Time Zone Database version number, e.g. "2019a".
        """
        return pulumi.get(self, "version")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class WeekDayOfMonthResponse(dict):
    """
    Represents one week day in a month. An example is "the 4th Sunday".
    """
    def __init__(__self__, *,
                 day_of_week: str,
                 week_ordinal: int):
        """
        Represents one week day in a month. An example is "the 4th Sunday".
        :param str day_of_week: Required. A day of the week.
        :param int week_ordinal: Required. Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "week_ordinal", week_ordinal)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> str:
        """
        Required. A day of the week.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="weekOrdinal")
    def week_ordinal(self) -> int:
        """
        Required. Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
        """
        return pulumi.get(self, "week_ordinal")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class WeeklyScheduleResponse(dict):
    """
    Represents a weekly schedule.
    """
    def __init__(__self__, *,
                 day_of_week: str):
        """
        Represents a weekly schedule.
        :param str day_of_week: Required. Day of the week.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> str:
        """
        Required. Day of the week.
        """
        return pulumi.get(self, "day_of_week")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class WindowsUpdateSettingsResponse(dict):
    """
    Windows patching is performed using the Windows Update Agent.
    """
    def __init__(__self__, *,
                 classifications: Sequence[str],
                 excludes: Sequence[str],
                 exclusive_patches: Sequence[str]):
        """
        Windows patching is performed using the Windows Update Agent.
        :param Sequence[str] classifications: Only apply updates of these windows update classifications. If empty, all updates are applied.
        :param Sequence[str] excludes: List of KBs to exclude from update.
        :param Sequence[str] exclusive_patches: An exclusive list of kbs to be updated. These are the only patches that will be updated. This field must not be used with other patch configurations.
        """
        pulumi.set(__self__, "classifications", classifications)
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "exclusive_patches", exclusive_patches)

    @property
    @pulumi.getter
    def classifications(self) -> Sequence[str]:
        """
        Only apply updates of these windows update classifications. If empty, all updates are applied.
        """
        return pulumi.get(self, "classifications")

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        List of KBs to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="exclusivePatches")
    def exclusive_patches(self) -> Sequence[str]:
        """
        An exclusive list of kbs to be updated. These are the only patches that will be updated. This field must not be used with other patch configurations.
        """
        return pulumi.get(self, "exclusive_patches")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class YumSettingsResponse(dict):
    """
    Yum patching is performed by executing `yum update`. Additional options can be set to control how this is executed. Note that not all settings are supported on all platforms.
    """
    def __init__(__self__, *,
                 excludes: Sequence[str],
                 exclusive_packages: Sequence[str],
                 minimal: bool,
                 security: bool):
        """
        Yum patching is performed by executing `yum update`. Additional options can be set to control how this is executed. Note that not all settings are supported on all platforms.
        :param Sequence[str] excludes: List of packages to exclude from update. These packages are excluded by using the yum `--exclude` flag.
        :param Sequence[str] exclusive_packages: An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field must not be specified with any other patch configuration fields.
        :param bool minimal: Will cause patch to run `yum update-minimal` instead.
        :param bool security: Adds the `--security` flag to `yum update`. Not supported on all platforms.
        """
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "exclusive_packages", exclusive_packages)
        pulumi.set(__self__, "minimal", minimal)
        pulumi.set(__self__, "security", security)

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        List of packages to exclude from update. These packages are excluded by using the yum `--exclude` flag.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="exclusivePackages")
    def exclusive_packages(self) -> Sequence[str]:
        """
        An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field must not be specified with any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_packages")

    @property
    @pulumi.getter
    def minimal(self) -> bool:
        """
        Will cause patch to run `yum update-minimal` instead.
        """
        return pulumi.get(self, "minimal")

    @property
    @pulumi.getter
    def security(self) -> bool:
        """
        Adds the `--security` flag to `yum update`. Not supported on all platforms.
        """
        return pulumi.get(self, "security")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ZypperSettingsResponse(dict):
    """
    Zypper patching is performed by running `zypper patch`. See also https://en.opensuse.org/SDB:Zypper_manual.
    """
    def __init__(__self__, *,
                 categories: Sequence[str],
                 excludes: Sequence[str],
                 exclusive_patches: Sequence[str],
                 severities: Sequence[str],
                 with_optional: bool,
                 with_update: bool):
        """
        Zypper patching is performed by running `zypper patch`. See also https://en.opensuse.org/SDB:Zypper_manual.
        :param Sequence[str] categories: Install only patches with these categories. Common categories include security, recommended, and feature.
        :param Sequence[str] excludes: List of patches to exclude from update.
        :param Sequence[str] exclusive_patches: An exclusive list of patches to be updated. These are the only patches that will be installed using 'zypper patch patch:' command. This field must not be used with any other patch configuration fields.
        :param Sequence[str] severities: Install only patches with these severities. Common severities include critical, important, moderate, and low.
        :param bool with_optional: Adds the `--with-optional` flag to `zypper patch`.
        :param bool with_update: Adds the `--with-update` flag, to `zypper patch`.
        """
        pulumi.set(__self__, "categories", categories)
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "exclusive_patches", exclusive_patches)
        pulumi.set(__self__, "severities", severities)
        pulumi.set(__self__, "with_optional", with_optional)
        pulumi.set(__self__, "with_update", with_update)

    @property
    @pulumi.getter
    def categories(self) -> Sequence[str]:
        """
        Install only patches with these categories. Common categories include security, recommended, and feature.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        List of patches to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="exclusivePatches")
    def exclusive_patches(self) -> Sequence[str]:
        """
        An exclusive list of patches to be updated. These are the only patches that will be installed using 'zypper patch patch:' command. This field must not be used with any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_patches")

    @property
    @pulumi.getter
    def severities(self) -> Sequence[str]:
        """
        Install only patches with these severities. Common severities include critical, important, moderate, and low.
        """
        return pulumi.get(self, "severities")

    @property
    @pulumi.getter(name="withOptional")
    def with_optional(self) -> bool:
        """
        Adds the `--with-optional` flag to `zypper patch`.
        """
        return pulumi.get(self, "with_optional")

    @property
    @pulumi.getter(name="withUpdate")
    def with_update(self) -> bool:
        """
        Adds the `--with-update` flag, to `zypper patch`.
        """
        return pulumi.get(self, "with_update")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


