# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Service']


class Service(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_engine: Optional[pulumi.Input[pulumi.InputType['AppEngineArgs']]] = None,
                 cloud_endpoints: Optional[pulumi.Input[pulumi.InputType['CloudEndpointsArgs']]] = None,
                 cluster_istio: Optional[pulumi.Input[pulumi.InputType['ClusterIstioArgs']]] = None,
                 custom: Optional[pulumi.Input[pulumi.InputType['CustomArgs']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 istio_canonical_service: Optional[pulumi.Input[pulumi.InputType['IstioCanonicalServiceArgs']]] = None,
                 mesh_istio: Optional[pulumi.Input[pulumi.InputType['MeshIstioArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 services_id: Optional[pulumi.Input[str]] = None,
                 telemetry: Optional[pulumi.Input[pulumi.InputType['TelemetryArgs']]] = None,
                 v3_id: Optional[pulumi.Input[str]] = None,
                 v3_id1: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a Service.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AppEngineArgs']] app_engine: Type used for App Engine services.
        :param pulumi.Input[pulumi.InputType['CloudEndpointsArgs']] cloud_endpoints: Type used for Cloud Endpoints services.
        :param pulumi.Input[pulumi.InputType['ClusterIstioArgs']] cluster_istio: Type used for Istio services that live in a Kubernetes cluster.
        :param pulumi.Input[pulumi.InputType['CustomArgs']] custom: Custom service type.
        :param pulumi.Input[str] display_name: Name used for UI elements listing this Service.
        :param pulumi.Input[pulumi.InputType['IstioCanonicalServiceArgs']] istio_canonical_service: Type used for canonical services scoped to an Istio mesh. Metrics for Istio are documented here (https://istio.io/latest/docs/reference/config/metrics/)
        :param pulumi.Input[pulumi.InputType['MeshIstioArgs']] mesh_istio: Type used for Istio services scoped to an Istio mesh.
        :param pulumi.Input[str] name: Resource name for this Service. The format is: projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID] 
        :param pulumi.Input[pulumi.InputType['TelemetryArgs']] telemetry: Configuration for how to query telemetry on a Service.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['app_engine'] = app_engine
            __props__['cloud_endpoints'] = cloud_endpoints
            __props__['cluster_istio'] = cluster_istio
            __props__['custom'] = custom
            __props__['display_name'] = display_name
            __props__['istio_canonical_service'] = istio_canonical_service
            __props__['mesh_istio'] = mesh_istio
            __props__['name'] = name
            if services_id is None and not opts.urn:
                raise TypeError("Missing required property 'services_id'")
            __props__['services_id'] = services_id
            __props__['telemetry'] = telemetry
            if v3_id is None and not opts.urn:
                raise TypeError("Missing required property 'v3_id'")
            __props__['v3_id'] = v3_id
            if v3_id1 is None and not opts.urn:
                raise TypeError("Missing required property 'v3_id1'")
            __props__['v3_id1'] = v3_id1
        super(Service, __self__).__init__(
            'gcp-native:monitoring/v3:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["app_engine"] = None
        __props__["cloud_endpoints"] = None
        __props__["cluster_istio"] = None
        __props__["custom"] = None
        __props__["display_name"] = None
        __props__["istio_canonical_service"] = None
        __props__["mesh_istio"] = None
        __props__["name"] = None
        __props__["telemetry"] = None
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appEngine")
    def app_engine(self) -> pulumi.Output['outputs.AppEngineResponse']:
        """
        Type used for App Engine services.
        """
        return pulumi.get(self, "app_engine")

    @property
    @pulumi.getter(name="cloudEndpoints")
    def cloud_endpoints(self) -> pulumi.Output['outputs.CloudEndpointsResponse']:
        """
        Type used for Cloud Endpoints services.
        """
        return pulumi.get(self, "cloud_endpoints")

    @property
    @pulumi.getter(name="clusterIstio")
    def cluster_istio(self) -> pulumi.Output['outputs.ClusterIstioResponse']:
        """
        Type used for Istio services that live in a Kubernetes cluster.
        """
        return pulumi.get(self, "cluster_istio")

    @property
    @pulumi.getter
    def custom(self) -> pulumi.Output['outputs.CustomResponse']:
        """
        Custom service type.
        """
        return pulumi.get(self, "custom")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Name used for UI elements listing this Service.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="istioCanonicalService")
    def istio_canonical_service(self) -> pulumi.Output['outputs.IstioCanonicalServiceResponse']:
        """
        Type used for canonical services scoped to an Istio mesh. Metrics for Istio are documented here (https://istio.io/latest/docs/reference/config/metrics/)
        """
        return pulumi.get(self, "istio_canonical_service")

    @property
    @pulumi.getter(name="meshIstio")
    def mesh_istio(self) -> pulumi.Output['outputs.MeshIstioResponse']:
        """
        Type used for Istio services scoped to an Istio mesh.
        """
        return pulumi.get(self, "mesh_istio")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name for this Service. The format is: projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID] 
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def telemetry(self) -> pulumi.Output['outputs.TelemetryResponse']:
        """
        Configuration for how to query telemetry on a Service.
        """
        return pulumi.get(self, "telemetry")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

