# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = [
    'AliasContextArgs',
    'ArtifactArgs',
    'ArtifactHashesArgs',
    'ArtifactRuleArgs',
    'AttestationArgs',
    'AuthorityArgs',
    'BasisArgs',
    'BindingArgs',
    'BuildArgs',
    'BuildProvenanceArgs',
    'BuildSignatureArgs',
    'ByProductsArgs',
    'CVSSv3Args',
    'CloudRepoSourceContextArgs',
    'CommandArgs',
    'DeployableArgs',
    'DeploymentArgs',
    'DerivedArgs',
    'DetailArgs',
    'DetailsArgs',
    'DiscoveredArgs',
    'DiscoveryArgs',
    'DistributionArgs',
    'EnvironmentArgs',
    'ExprArgs',
    'FingerprintArgs',
    'GenericSignedAttestationArgs',
    'GerritSourceContextArgs',
    'GitSourceContextArgs',
    'GrafeasV1beta1BuildDetailsArgs',
    'GrafeasV1beta1DeploymentDetailsArgs',
    'GrafeasV1beta1DiscoveryDetailsArgs',
    'GrafeasV1beta1ImageDetailsArgs',
    'GrafeasV1beta1IntotoArtifactArgs',
    'GrafeasV1beta1IntotoDetailsArgs',
    'GrafeasV1beta1IntotoSignatureArgs',
    'GrafeasV1beta1PackageDetailsArgs',
    'GrafeasV1beta1VulnerabilityDetailsArgs',
    'HashArgs',
    'HintArgs',
    'InTotoArgs',
    'InstallationArgs',
    'KnowledgeBaseArgs',
    'LayerArgs',
    'LinkArgs',
    'LocationArgs',
    'PackageArgs',
    'PackageIssueArgs',
    'PgpSignedAttestationArgs',
    'ProjectRepoIdArgs',
    'RelatedUrlArgs',
    'RepoIdArgs',
    'ResourceArgs',
    'SignatureArgs',
    'SigningKeyArgs',
    'SourceArgs',
    'SourceContextArgs',
    'StatusArgs',
    'VersionArgs',
    'VulnerabilityArgs',
    'VulnerabilityLocationArgs',
    'WindowsDetailArgs',
]

@pulumi.input_type
class AliasContextArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        An alias to a repo revision.
        :param pulumi.Input[str] kind: The alias kind.
        :param pulumi.Input[str] name: The alias name.
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        The alias kind.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The alias name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ArtifactArgs:
    def __init__(__self__, *,
                 checksum: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Artifact describes a build product.
        :param pulumi.Input[str] checksum: Hash or checksum value of a binary, or Docker Registry 2.0 digest of a container.
        :param pulumi.Input[str] id: Artifact ID, if any; for container images, this will be a URL by digest like `gcr.io/projectID/imagename@sha256:123456`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] names: Related artifact names. This may be the path to a binary or jar file, or in the case of a container build, the name used to push the container image to Google Container Registry, as presented to `docker push`. Note that a single Artifact ID can have multiple names, for example if two tags are applied to one image.
        """
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[str]]:
        """
        Hash or checksum value of a binary, or Docker Registry 2.0 digest of a container.
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checksum", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Artifact ID, if any; for container images, this will be a URL by digest like `gcr.io/projectID/imagename@sha256:123456`.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Related artifact names. This may be the path to a binary or jar file, or in the case of a container build, the name used to push the container image to Google Container Registry, as presented to `docker push`. Note that a single Artifact ID can have multiple names, for example if two tags are applied to one image.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "names", value)


@pulumi.input_type
class ArtifactHashesArgs:
    def __init__(__self__, *,
                 sha256: Optional[pulumi.Input[str]] = None):
        """
        Defines a hash object for use in Materials and Products.
        """
        if sha256 is not None:
            pulumi.set(__self__, "sha256", sha256)

    @property
    @pulumi.getter
    def sha256(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "sha256")

    @sha256.setter
    def sha256(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sha256", value)


@pulumi.input_type
class ArtifactRuleArgs:
    def __init__(__self__, *,
                 artifact_rule: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Defines an object to declare an in-toto artifact rule
        """
        if artifact_rule is not None:
            pulumi.set(__self__, "artifact_rule", artifact_rule)

    @property
    @pulumi.getter(name="artifactRule")
    def artifact_rule(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "artifact_rule")

    @artifact_rule.setter
    def artifact_rule(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "artifact_rule", value)


@pulumi.input_type
class AttestationArgs:
    def __init__(__self__, *,
                 generic_signed_attestation: Optional[pulumi.Input['GenericSignedAttestationArgs']] = None,
                 pgp_signed_attestation: Optional[pulumi.Input['PgpSignedAttestationArgs']] = None):
        """
        Occurrence that represents a single "attestation". The authenticity of an attestation can be verified using the attached signature. If the verifier trusts the public key of the signer, then verifying the signature is sufficient to establish trust. In this circumstance, the authority to which this attestation is attached is primarily useful for look-up (how to find this attestation if you already know the authority and artifact to be verified) and intent (which authority was this attestation intended to sign for).
        :param pulumi.Input['PgpSignedAttestationArgs'] pgp_signed_attestation: A PGP signed attestation.
        """
        if generic_signed_attestation is not None:
            pulumi.set(__self__, "generic_signed_attestation", generic_signed_attestation)
        if pgp_signed_attestation is not None:
            pulumi.set(__self__, "pgp_signed_attestation", pgp_signed_attestation)

    @property
    @pulumi.getter(name="genericSignedAttestation")
    def generic_signed_attestation(self) -> Optional[pulumi.Input['GenericSignedAttestationArgs']]:
        return pulumi.get(self, "generic_signed_attestation")

    @generic_signed_attestation.setter
    def generic_signed_attestation(self, value: Optional[pulumi.Input['GenericSignedAttestationArgs']]):
        pulumi.set(self, "generic_signed_attestation", value)

    @property
    @pulumi.getter(name="pgpSignedAttestation")
    def pgp_signed_attestation(self) -> Optional[pulumi.Input['PgpSignedAttestationArgs']]:
        """
        A PGP signed attestation.
        """
        return pulumi.get(self, "pgp_signed_attestation")

    @pgp_signed_attestation.setter
    def pgp_signed_attestation(self, value: Optional[pulumi.Input['PgpSignedAttestationArgs']]):
        pulumi.set(self, "pgp_signed_attestation", value)


@pulumi.input_type
class AuthorityArgs:
    def __init__(__self__, *,
                 hint: Optional[pulumi.Input['HintArgs']] = None):
        """
        Note kind that represents a logical attestation "role" or "authority". For example, an organization might have one `Authority` for "QA" and one for "build". This note is intended to act strictly as a grouping mechanism for the attached occurrences (Attestations). This grouping mechanism also provides a security boundary, since IAM ACLs gate the ability for a principle to attach an occurrence to a given note. It also provides a single point of lookup to find all attached attestation occurrences, even if they don't all live in the same project.
        :param pulumi.Input['HintArgs'] hint: Hint hints at the purpose of the attestation authority.
        """
        if hint is not None:
            pulumi.set(__self__, "hint", hint)

    @property
    @pulumi.getter
    def hint(self) -> Optional[pulumi.Input['HintArgs']]:
        """
        Hint hints at the purpose of the attestation authority.
        """
        return pulumi.get(self, "hint")

    @hint.setter
    def hint(self, value: Optional[pulumi.Input['HintArgs']]):
        pulumi.set(self, "hint", value)


@pulumi.input_type
class BasisArgs:
    def __init__(__self__, *,
                 fingerprint: Optional[pulumi.Input['FingerprintArgs']] = None,
                 resource_url: Optional[pulumi.Input[str]] = None):
        """
        Basis describes the base image portion (Note) of the DockerImage relationship. Linked occurrences are derived from this or an equivalent image via: FROM Or an equivalent reference, e.g. a tag of the resource_url.
        :param pulumi.Input['FingerprintArgs'] fingerprint: Required. Immutable. The fingerprint of the base image.
        :param pulumi.Input[str] resource_url: Required. Immutable. The resource_url for the resource representing the basis of associated occurrence images.
        """
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if resource_url is not None:
            pulumi.set(__self__, "resource_url", resource_url)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input['FingerprintArgs']]:
        """
        Required. Immutable. The fingerprint of the base image.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input['FingerprintArgs']]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="resourceUrl")
    def resource_url(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Immutable. The resource_url for the resource representing the basis of associated occurrence images.
        """
        return pulumi.get(self, "resource_url")

    @resource_url.setter
    def resource_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_url", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members` with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class BuildArgs:
    def __init__(__self__, *,
                 builder_version: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input['BuildSignatureArgs']] = None):
        """
        Note holding the version of the provider's builder and the signature of the provenance message in the build details occurrence.
        :param pulumi.Input[str] builder_version: Required. Immutable. Version of the builder which produced this build.
        :param pulumi.Input['BuildSignatureArgs'] signature: Signature of the build in occurrences pointing to this build note containing build details.
        """
        if builder_version is not None:
            pulumi.set(__self__, "builder_version", builder_version)
        if signature is not None:
            pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="builderVersion")
    def builder_version(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Immutable. Version of the builder which produced this build.
        """
        return pulumi.get(self, "builder_version")

    @builder_version.setter
    def builder_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "builder_version", value)

    @property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input['BuildSignatureArgs']]:
        """
        Signature of the build in occurrences pointing to this build note containing build details.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input['BuildSignatureArgs']]):
        pulumi.set(self, "signature", value)


@pulumi.input_type
class BuildProvenanceArgs:
    def __init__(__self__, *,
                 build_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 builder_version: Optional[pulumi.Input[str]] = None,
                 built_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactArgs']]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input['CommandArgs']]]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 creator: Optional[pulumi.Input[str]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 logs_uri: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 source_provenance: Optional[pulumi.Input['SourceArgs']] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 trigger_id: Optional[pulumi.Input[str]] = None):
        """
        Provenance of a build. Contains all information needed to verify the full details about the build from source to completion.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] build_options: Special options applied to this build. This is a catch-all field where build providers can enter any desired additional details.
        :param pulumi.Input[str] builder_version: Version string of the builder at the time this build was executed.
        :param pulumi.Input[Sequence[pulumi.Input['ArtifactArgs']]] built_artifacts: Output of the build.
        :param pulumi.Input[Sequence[pulumi.Input['CommandArgs']]] commands: Commands requested by the build.
        :param pulumi.Input[str] create_time: Time at which the build was created.
        :param pulumi.Input[str] creator: E-mail address of the user who initiated this build. Note that this was the user's e-mail address at the time the build was initiated; this address may not represent the same end-user for all time.
        :param pulumi.Input[str] end_time: Time at which execution of the build was finished.
        :param pulumi.Input[str] id: Required. Unique identifier of the build.
        :param pulumi.Input[str] logs_uri: URI where any logs for this provenance were written.
        :param pulumi.Input[str] project_id: ID of the project.
        :param pulumi.Input['SourceArgs'] source_provenance: Details of the Source input to the build.
        :param pulumi.Input[str] start_time: Time at which execution of the build was started.
        :param pulumi.Input[str] trigger_id: Trigger identifier if the build was triggered automatically; empty if not.
        """
        if build_options is not None:
            pulumi.set(__self__, "build_options", build_options)
        if builder_version is not None:
            pulumi.set(__self__, "builder_version", builder_version)
        if built_artifacts is not None:
            pulumi.set(__self__, "built_artifacts", built_artifacts)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if logs_uri is not None:
            pulumi.set(__self__, "logs_uri", logs_uri)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if source_provenance is not None:
            pulumi.set(__self__, "source_provenance", source_provenance)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if trigger_id is not None:
            pulumi.set(__self__, "trigger_id", trigger_id)

    @property
    @pulumi.getter(name="buildOptions")
    def build_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Special options applied to this build. This is a catch-all field where build providers can enter any desired additional details.
        """
        return pulumi.get(self, "build_options")

    @build_options.setter
    def build_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "build_options", value)

    @property
    @pulumi.getter(name="builderVersion")
    def builder_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version string of the builder at the time this build was executed.
        """
        return pulumi.get(self, "builder_version")

    @builder_version.setter
    def builder_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "builder_version", value)

    @property
    @pulumi.getter(name="builtArtifacts")
    def built_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactArgs']]]]:
        """
        Output of the build.
        """
        return pulumi.get(self, "built_artifacts")

    @built_artifacts.setter
    def built_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactArgs']]]]):
        pulumi.set(self, "built_artifacts", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CommandArgs']]]]:
        """
        Commands requested by the build.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CommandArgs']]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which the build was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[str]]:
        """
        E-mail address of the user who initiated this build. Note that this was the user's e-mail address at the time the build was initiated; this address may not represent the same end-user for all time.
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creator", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which execution of the build was finished.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Unique identifier of the build.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="logsUri")
    def logs_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI where any logs for this provenance were written.
        """
        return pulumi.get(self, "logs_uri")

    @logs_uri.setter
    def logs_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logs_uri", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="sourceProvenance")
    def source_provenance(self) -> Optional[pulumi.Input['SourceArgs']]:
        """
        Details of the Source input to the build.
        """
        return pulumi.get(self, "source_provenance")

    @source_provenance.setter
    def source_provenance(self, value: Optional[pulumi.Input['SourceArgs']]):
        pulumi.set(self, "source_provenance", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which execution of the build was started.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> Optional[pulumi.Input[str]]:
        """
        Trigger identifier if the build was triggered automatically; empty if not.
        """
        return pulumi.get(self, "trigger_id")

    @trigger_id.setter
    def trigger_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger_id", value)


@pulumi.input_type
class BuildSignatureArgs:
    def __init__(__self__, *,
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input[str]] = None):
        """
        Message encapsulating the signature of the verified build.
        :param pulumi.Input[str] key_id: An ID for the key used to sign. This could be either an ID for the key stored in `public_key` (such as the ID or fingerprint for a PGP key, or the CN for a cert), or a reference to an external key (such as a reference to a key in Cloud Key Management Service).
        :param pulumi.Input[str] key_type: The type of the key, either stored in `public_key` or referenced in `key_id`.
        :param pulumi.Input[str] public_key: Public key of the builder which can be used to verify that the related findings are valid and unchanged. If `key_type` is empty, this defaults to PEM encoded public keys. This field may be empty if `key_id` references an external key. For Cloud Build based signatures, this is a PEM encoded public key. To verify the Cloud Build signature, place the contents of this field into a file (public.pem). The signature field is base64-decoded into its binary representation in signature.bin, and the provenance bytes from `BuildDetails` are base64-decoded into a binary representation in signed.bin. OpenSSL can then verify the signature: `openssl sha256 -verify public.pem -signature signature.bin signed.bin`
        :param pulumi.Input[str] signature: Required. Signature of the related `BuildProvenance`. In JSON, this is base-64 encoded.
        """
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if signature is not None:
            pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        An ID for the key used to sign. This could be either an ID for the key stored in `public_key` (such as the ID or fingerprint for a PGP key, or the CN for a cert), or a reference to an external key (such as a reference to a key in Cloud Key Management Service).
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the key, either stored in `public_key` or referenced in `key_id`.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Public key of the builder which can be used to verify that the related findings are valid and unchanged. If `key_type` is empty, this defaults to PEM encoded public keys. This field may be empty if `key_id` references an external key. For Cloud Build based signatures, this is a PEM encoded public key. To verify the Cloud Build signature, place the contents of this field into a file (public.pem). The signature field is base64-decoded into its binary representation in signature.bin, and the provenance bytes from `BuildDetails` are base64-decoded into a binary representation in signed.bin. OpenSSL can then verify the signature: `openssl sha256 -verify public.pem -signature signature.bin signed.bin`
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Signature of the related `BuildProvenance`. In JSON, this is base-64 encoded.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature", value)


@pulumi.input_type
class ByProductsArgs:
    def __init__(__self__, *,
                 custom_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Defines an object for the byproducts field in in-toto links. The suggested fields are "stderr", "stdout", and "return-value".
        """
        if custom_values is not None:
            pulumi.set(__self__, "custom_values", custom_values)

    @property
    @pulumi.getter(name="customValues")
    def custom_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "custom_values")

    @custom_values.setter
    def custom_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "custom_values", value)


@pulumi.input_type
class CVSSv3Args:
    def __init__(__self__, *,
                 attack_complexity: Optional[pulumi.Input[str]] = None,
                 attack_vector: Optional[pulumi.Input[str]] = None,
                 availability_impact: Optional[pulumi.Input[str]] = None,
                 base_score: Optional[pulumi.Input[float]] = None,
                 confidentiality_impact: Optional[pulumi.Input[str]] = None,
                 exploitability_score: Optional[pulumi.Input[float]] = None,
                 impact_score: Optional[pulumi.Input[float]] = None,
                 integrity_impact: Optional[pulumi.Input[str]] = None,
                 privileges_required: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 user_interaction: Optional[pulumi.Input[str]] = None):
        """
        Common Vulnerability Scoring System version 3. For details, see https://www.first.org/cvss/specification-document
        :param pulumi.Input[str] attack_vector: Base Metrics Represents the intrinsic characteristics of a vulnerability that are constant over time and across user environments.
        :param pulumi.Input[float] base_score: The base score is a function of the base metric scores.
        """
        if attack_complexity is not None:
            pulumi.set(__self__, "attack_complexity", attack_complexity)
        if attack_vector is not None:
            pulumi.set(__self__, "attack_vector", attack_vector)
        if availability_impact is not None:
            pulumi.set(__self__, "availability_impact", availability_impact)
        if base_score is not None:
            pulumi.set(__self__, "base_score", base_score)
        if confidentiality_impact is not None:
            pulumi.set(__self__, "confidentiality_impact", confidentiality_impact)
        if exploitability_score is not None:
            pulumi.set(__self__, "exploitability_score", exploitability_score)
        if impact_score is not None:
            pulumi.set(__self__, "impact_score", impact_score)
        if integrity_impact is not None:
            pulumi.set(__self__, "integrity_impact", integrity_impact)
        if privileges_required is not None:
            pulumi.set(__self__, "privileges_required", privileges_required)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if user_interaction is not None:
            pulumi.set(__self__, "user_interaction", user_interaction)

    @property
    @pulumi.getter(name="attackComplexity")
    def attack_complexity(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "attack_complexity")

    @attack_complexity.setter
    def attack_complexity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attack_complexity", value)

    @property
    @pulumi.getter(name="attackVector")
    def attack_vector(self) -> Optional[pulumi.Input[str]]:
        """
        Base Metrics Represents the intrinsic characteristics of a vulnerability that are constant over time and across user environments.
        """
        return pulumi.get(self, "attack_vector")

    @attack_vector.setter
    def attack_vector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attack_vector", value)

    @property
    @pulumi.getter(name="availabilityImpact")
    def availability_impact(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "availability_impact")

    @availability_impact.setter
    def availability_impact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_impact", value)

    @property
    @pulumi.getter(name="baseScore")
    def base_score(self) -> Optional[pulumi.Input[float]]:
        """
        The base score is a function of the base metric scores.
        """
        return pulumi.get(self, "base_score")

    @base_score.setter
    def base_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "base_score", value)

    @property
    @pulumi.getter(name="confidentialityImpact")
    def confidentiality_impact(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "confidentiality_impact")

    @confidentiality_impact.setter
    def confidentiality_impact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "confidentiality_impact", value)

    @property
    @pulumi.getter(name="exploitabilityScore")
    def exploitability_score(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "exploitability_score")

    @exploitability_score.setter
    def exploitability_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "exploitability_score", value)

    @property
    @pulumi.getter(name="impactScore")
    def impact_score(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "impact_score")

    @impact_score.setter
    def impact_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "impact_score", value)

    @property
    @pulumi.getter(name="integrityImpact")
    def integrity_impact(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "integrity_impact")

    @integrity_impact.setter
    def integrity_impact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "integrity_impact", value)

    @property
    @pulumi.getter(name="privilegesRequired")
    def privileges_required(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "privileges_required")

    @privileges_required.setter
    def privileges_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "privileges_required", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="userInteraction")
    def user_interaction(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_interaction")

    @user_interaction.setter
    def user_interaction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_interaction", value)


@pulumi.input_type
class CloudRepoSourceContextArgs:
    def __init__(__self__, *,
                 alias_context: Optional[pulumi.Input['AliasContextArgs']] = None,
                 repo_id: Optional[pulumi.Input['RepoIdArgs']] = None,
                 revision_id: Optional[pulumi.Input[str]] = None):
        """
        A CloudRepoSourceContext denotes a particular revision in a Google Cloud Source Repo.
        :param pulumi.Input['AliasContextArgs'] alias_context: An alias, which may be a branch or tag.
        :param pulumi.Input['RepoIdArgs'] repo_id: The ID of the repo.
        :param pulumi.Input[str] revision_id: A revision ID.
        """
        if alias_context is not None:
            pulumi.set(__self__, "alias_context", alias_context)
        if repo_id is not None:
            pulumi.set(__self__, "repo_id", repo_id)
        if revision_id is not None:
            pulumi.set(__self__, "revision_id", revision_id)

    @property
    @pulumi.getter(name="aliasContext")
    def alias_context(self) -> Optional[pulumi.Input['AliasContextArgs']]:
        """
        An alias, which may be a branch or tag.
        """
        return pulumi.get(self, "alias_context")

    @alias_context.setter
    def alias_context(self, value: Optional[pulumi.Input['AliasContextArgs']]):
        pulumi.set(self, "alias_context", value)

    @property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> Optional[pulumi.Input['RepoIdArgs']]:
        """
        The ID of the repo.
        """
        return pulumi.get(self, "repo_id")

    @repo_id.setter
    def repo_id(self, value: Optional[pulumi.Input['RepoIdArgs']]):
        pulumi.set(self, "repo_id", value)

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[pulumi.Input[str]]:
        """
        A revision ID.
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_id", value)


@pulumi.input_type
class CommandArgs:
    def __init__(__self__, *,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dir: Optional[pulumi.Input[str]] = None,
                 env: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 wait_for: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Command describes a step performed as part of the build pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Command-line arguments used when executing this command.
        :param pulumi.Input[str] dir: Working directory (relative to project source root) used when running this command.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] env: Environment variables set before running this command.
        :param pulumi.Input[str] id: Optional unique identifier for this command, used in wait_for to reference this command as a dependency.
        :param pulumi.Input[str] name: Required. Name of the command, as presented on the command line, or if the command is packaged as a Docker container, as presented to `docker pull`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] wait_for: The ID(s) of the command(s) that this command depends on.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if wait_for is not None:
            pulumi.set(__self__, "wait_for", wait_for)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Command-line arguments used when executing this command.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def dir(self) -> Optional[pulumi.Input[str]]:
        """
        Working directory (relative to project source root) used when running this command.
        """
        return pulumi.get(self, "dir")

    @dir.setter
    def dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dir", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Environment variables set before running this command.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional unique identifier for this command, used in wait_for to reference this command as a dependency.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Name of the command, as presented on the command line, or if the command is packaged as a Docker container, as presented to `docker pull`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="waitFor")
    def wait_for(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID(s) of the command(s) that this command depends on.
        """
        return pulumi.get(self, "wait_for")

    @wait_for.setter
    def wait_for(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "wait_for", value)


@pulumi.input_type
class DeployableArgs:
    def __init__(__self__, *,
                 resource_uri: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        An artifact that can be deployed in some runtime.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_uri: Required. Resource URI for the artifact being deployed.
        """
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required. Resource URI for the artifact being deployed.
        """
        return pulumi.get(self, "resource_uri")

    @resource_uri.setter
    def resource_uri(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_uri", value)


@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[str]] = None,
                 deploy_time: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 resource_uri: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 undeploy_time: Optional[pulumi.Input[str]] = None,
                 user_email: Optional[pulumi.Input[str]] = None):
        """
        The period during which some deployable was active in a runtime.
        :param pulumi.Input[str] address: Address of the runtime element hosting this deployment.
        :param pulumi.Input[str] config: Configuration used to create this deployment.
        :param pulumi.Input[str] deploy_time: Required. Beginning of the lifetime of this deployment.
        :param pulumi.Input[str] platform: Platform hosting this deployment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_uri: Resource URI for the artifact being deployed taken from the deployable field with the same name.
        :param pulumi.Input[str] undeploy_time: End of the lifetime of this deployment.
        :param pulumi.Input[str] user_email: Identity of the user that triggered this deployment.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if deploy_time is not None:
            pulumi.set(__self__, "deploy_time", deploy_time)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)
        if undeploy_time is not None:
            pulumi.set(__self__, "undeploy_time", undeploy_time)
        if user_email is not None:
            pulumi.set(__self__, "user_email", user_email)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Address of the runtime element hosting this deployment.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration used to create this deployment.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="deployTime")
    def deploy_time(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Beginning of the lifetime of this deployment.
        """
        return pulumi.get(self, "deploy_time")

    @deploy_time.setter
    def deploy_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_time", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        Platform hosting this deployment.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Resource URI for the artifact being deployed taken from the deployable field with the same name.
        """
        return pulumi.get(self, "resource_uri")

    @resource_uri.setter
    def resource_uri(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_uri", value)

    @property
    @pulumi.getter(name="undeployTime")
    def undeploy_time(self) -> Optional[pulumi.Input[str]]:
        """
        End of the lifetime of this deployment.
        """
        return pulumi.get(self, "undeploy_time")

    @undeploy_time.setter
    def undeploy_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "undeploy_time", value)

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> Optional[pulumi.Input[str]]:
        """
        Identity of the user that triggered this deployment.
        """
        return pulumi.get(self, "user_email")

    @user_email.setter
    def user_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_email", value)


@pulumi.input_type
class DerivedArgs:
    def __init__(__self__, *,
                 base_resource_url: Optional[pulumi.Input[str]] = None,
                 distance: Optional[pulumi.Input[int]] = None,
                 fingerprint: Optional[pulumi.Input['FingerprintArgs']] = None,
                 layer_info: Optional[pulumi.Input[Sequence[pulumi.Input['LayerArgs']]]] = None):
        """
        Derived describes the derived image portion (Occurrence) of the DockerImage relationship. This image would be produced from a Dockerfile with FROM .
        :param pulumi.Input[str] base_resource_url: This contains the base image URL for the derived image occurrence.
        :param pulumi.Input[int] distance: The number of layers by which this image differs from the associated image basis.
        :param pulumi.Input['FingerprintArgs'] fingerprint: Required. The fingerprint of the derived image.
        :param pulumi.Input[Sequence[pulumi.Input['LayerArgs']]] layer_info: This contains layer-specific metadata, if populated it has length "distance" and is ordered with [distance] being the layer immediately following the base image and [1] being the final layer.
        """
        if base_resource_url is not None:
            pulumi.set(__self__, "base_resource_url", base_resource_url)
        if distance is not None:
            pulumi.set(__self__, "distance", distance)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if layer_info is not None:
            pulumi.set(__self__, "layer_info", layer_info)

    @property
    @pulumi.getter(name="baseResourceUrl")
    def base_resource_url(self) -> Optional[pulumi.Input[str]]:
        """
        This contains the base image URL for the derived image occurrence.
        """
        return pulumi.get(self, "base_resource_url")

    @base_resource_url.setter
    def base_resource_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_resource_url", value)

    @property
    @pulumi.getter
    def distance(self) -> Optional[pulumi.Input[int]]:
        """
        The number of layers by which this image differs from the associated image basis.
        """
        return pulumi.get(self, "distance")

    @distance.setter
    def distance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "distance", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input['FingerprintArgs']]:
        """
        Required. The fingerprint of the derived image.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input['FingerprintArgs']]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="layerInfo")
    def layer_info(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LayerArgs']]]]:
        """
        This contains layer-specific metadata, if populated it has length "distance" and is ordered with [distance] being the layer immediately following the base image and [1] being the final layer.
        """
        return pulumi.get(self, "layer_info")

    @layer_info.setter
    def layer_info(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LayerArgs']]]]):
        pulumi.set(self, "layer_info", value)


@pulumi.input_type
class DetailArgs:
    def __init__(__self__, *,
                 cpe_uri: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fixed_location: Optional[pulumi.Input['VulnerabilityLocationArgs']] = None,
                 is_obsolete: Optional[pulumi.Input[bool]] = None,
                 max_affected_version: Optional[pulumi.Input['VersionArgs']] = None,
                 min_affected_version: Optional[pulumi.Input['VersionArgs']] = None,
                 package: Optional[pulumi.Input[str]] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 severity_name: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_update_time: Optional[pulumi.Input[str]] = None,
                 vendor: Optional[pulumi.Input[str]] = None):
        """
        Identifies all appearances of this vulnerability in the package for a specific distro/location. For example: glibc in cpe:/o:debian:debian_linux:8 for versions 2.1 - 2.2
        :param pulumi.Input[str] cpe_uri: Required. The CPE URI in [cpe format](https://cpe.mitre.org/specification/) in which the vulnerability manifests. Examples include distro or storage location for vulnerable jar.
        :param pulumi.Input[str] description: A vendor-specific description of this note.
        :param pulumi.Input['VulnerabilityLocationArgs'] fixed_location: The fix for this specific package version.
        :param pulumi.Input[bool] is_obsolete: Whether this detail is obsolete. Occurrences are expected not to point to obsolete details.
        :param pulumi.Input['VersionArgs'] max_affected_version: The max version of the package in which the vulnerability exists.
        :param pulumi.Input['VersionArgs'] min_affected_version: The min version of the package in which the vulnerability exists.
        :param pulumi.Input[str] package: Required. The name of the package where the vulnerability was found.
        :param pulumi.Input[str] package_type: The type of package; whether native or non native(ruby gems, node.js packages etc).
        :param pulumi.Input[str] severity_name: The severity (eg: distro assigned severity) for this vulnerability.
        :param pulumi.Input[str] source: The source from which the information in this Detail was obtained.
        :param pulumi.Input[str] source_update_time: The time this information was last changed at the source. This is an upstream timestamp from the underlying information source - e.g. Ubuntu security tracker.
        :param pulumi.Input[str] vendor: The name of the vendor of the product.
        """
        if cpe_uri is not None:
            pulumi.set(__self__, "cpe_uri", cpe_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fixed_location is not None:
            pulumi.set(__self__, "fixed_location", fixed_location)
        if is_obsolete is not None:
            pulumi.set(__self__, "is_obsolete", is_obsolete)
        if max_affected_version is not None:
            pulumi.set(__self__, "max_affected_version", max_affected_version)
        if min_affected_version is not None:
            pulumi.set(__self__, "min_affected_version", min_affected_version)
        if package is not None:
            pulumi.set(__self__, "package", package)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if severity_name is not None:
            pulumi.set(__self__, "severity_name", severity_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_update_time is not None:
            pulumi.set(__self__, "source_update_time", source_update_time)
        if vendor is not None:
            pulumi.set(__self__, "vendor", vendor)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The CPE URI in [cpe format](https://cpe.mitre.org/specification/) in which the vulnerability manifests. Examples include distro or storage location for vulnerable jar.
        """
        return pulumi.get(self, "cpe_uri")

    @cpe_uri.setter
    def cpe_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpe_uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A vendor-specific description of this note.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fixedLocation")
    def fixed_location(self) -> Optional[pulumi.Input['VulnerabilityLocationArgs']]:
        """
        The fix for this specific package version.
        """
        return pulumi.get(self, "fixed_location")

    @fixed_location.setter
    def fixed_location(self, value: Optional[pulumi.Input['VulnerabilityLocationArgs']]):
        pulumi.set(self, "fixed_location", value)

    @property
    @pulumi.getter(name="isObsolete")
    def is_obsolete(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this detail is obsolete. Occurrences are expected not to point to obsolete details.
        """
        return pulumi.get(self, "is_obsolete")

    @is_obsolete.setter
    def is_obsolete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_obsolete", value)

    @property
    @pulumi.getter(name="maxAffectedVersion")
    def max_affected_version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        The max version of the package in which the vulnerability exists.
        """
        return pulumi.get(self, "max_affected_version")

    @max_affected_version.setter
    def max_affected_version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "max_affected_version", value)

    @property
    @pulumi.getter(name="minAffectedVersion")
    def min_affected_version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        The min version of the package in which the vulnerability exists.
        """
        return pulumi.get(self, "min_affected_version")

    @min_affected_version.setter
    def min_affected_version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "min_affected_version", value)

    @property
    @pulumi.getter
    def package(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The name of the package where the vulnerability was found.
        """
        return pulumi.get(self, "package")

    @package.setter
    def package(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package", value)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of package; whether native or non native(ruby gems, node.js packages etc).
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter(name="severityName")
    def severity_name(self) -> Optional[pulumi.Input[str]]:
        """
        The severity (eg: distro assigned severity) for this vulnerability.
        """
        return pulumi.get(self, "severity_name")

    @severity_name.setter
    def severity_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity_name", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The source from which the information in this Detail was obtained.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceUpdateTime")
    def source_update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time this information was last changed at the source. This is an upstream timestamp from the underlying information source - e.g. Ubuntu security tracker.
        """
        return pulumi.get(self, "source_update_time")

    @source_update_time.setter
    def source_update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_update_time", value)

    @property
    @pulumi.getter
    def vendor(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the vendor of the product.
        """
        return pulumi.get(self, "vendor")

    @vendor.setter
    def vendor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vendor", value)


@pulumi.input_type
class DetailsArgs:
    def __init__(__self__, *,
                 attestation: Optional[pulumi.Input['AttestationArgs']] = None):
        """
        Details of an attestation occurrence.
        :param pulumi.Input['AttestationArgs'] attestation: Required. Attestation for the resource.
        """
        if attestation is not None:
            pulumi.set(__self__, "attestation", attestation)

    @property
    @pulumi.getter
    def attestation(self) -> Optional[pulumi.Input['AttestationArgs']]:
        """
        Required. Attestation for the resource.
        """
        return pulumi.get(self, "attestation")

    @attestation.setter
    def attestation(self, value: Optional[pulumi.Input['AttestationArgs']]):
        pulumi.set(self, "attestation", value)


@pulumi.input_type
class DiscoveredArgs:
    def __init__(__self__, *,
                 analysis_status: Optional[pulumi.Input[str]] = None,
                 analysis_status_error: Optional[pulumi.Input['StatusArgs']] = None,
                 continuous_analysis: Optional[pulumi.Input[str]] = None,
                 last_analysis_time: Optional[pulumi.Input[str]] = None):
        """
        Provides information about the analysis status of a discovered resource.
        :param pulumi.Input[str] analysis_status: The status of discovery for the resource.
        :param pulumi.Input['StatusArgs'] analysis_status_error: When an error is encountered this will contain a LocalizedMessage under details to show to the user. The LocalizedMessage is output only and populated by the API.
        :param pulumi.Input[str] continuous_analysis: Whether the resource is continuously analyzed.
        :param pulumi.Input[str] last_analysis_time: The last time continuous analysis was done for this resource. Deprecated, do not use.
        """
        if analysis_status is not None:
            pulumi.set(__self__, "analysis_status", analysis_status)
        if analysis_status_error is not None:
            pulumi.set(__self__, "analysis_status_error", analysis_status_error)
        if continuous_analysis is not None:
            pulumi.set(__self__, "continuous_analysis", continuous_analysis)
        if last_analysis_time is not None:
            pulumi.set(__self__, "last_analysis_time", last_analysis_time)

    @property
    @pulumi.getter(name="analysisStatus")
    def analysis_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of discovery for the resource.
        """
        return pulumi.get(self, "analysis_status")

    @analysis_status.setter
    def analysis_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analysis_status", value)

    @property
    @pulumi.getter(name="analysisStatusError")
    def analysis_status_error(self) -> Optional[pulumi.Input['StatusArgs']]:
        """
        When an error is encountered this will contain a LocalizedMessage under details to show to the user. The LocalizedMessage is output only and populated by the API.
        """
        return pulumi.get(self, "analysis_status_error")

    @analysis_status_error.setter
    def analysis_status_error(self, value: Optional[pulumi.Input['StatusArgs']]):
        pulumi.set(self, "analysis_status_error", value)

    @property
    @pulumi.getter(name="continuousAnalysis")
    def continuous_analysis(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the resource is continuously analyzed.
        """
        return pulumi.get(self, "continuous_analysis")

    @continuous_analysis.setter
    def continuous_analysis(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "continuous_analysis", value)

    @property
    @pulumi.getter(name="lastAnalysisTime")
    def last_analysis_time(self) -> Optional[pulumi.Input[str]]:
        """
        The last time continuous analysis was done for this resource. Deprecated, do not use.
        """
        return pulumi.get(self, "last_analysis_time")

    @last_analysis_time.setter
    def last_analysis_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_analysis_time", value)


@pulumi.input_type
class DiscoveryArgs:
    def __init__(__self__, *,
                 analysis_kind: Optional[pulumi.Input[str]] = None):
        """
        A note that indicates a type of analysis a provider would perform. This note exists in a provider's project. A `Discovery` occurrence is created in a consumer's project at the start of analysis.
        :param pulumi.Input[str] analysis_kind: Required. Immutable. The kind of analysis that is handled by this discovery.
        """
        if analysis_kind is not None:
            pulumi.set(__self__, "analysis_kind", analysis_kind)

    @property
    @pulumi.getter(name="analysisKind")
    def analysis_kind(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Immutable. The kind of analysis that is handled by this discovery.
        """
        return pulumi.get(self, "analysis_kind")

    @analysis_kind.setter
    def analysis_kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analysis_kind", value)


@pulumi.input_type
class DistributionArgs:
    def __init__(__self__, *,
                 architecture: Optional[pulumi.Input[str]] = None,
                 cpe_uri: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 latest_version: Optional[pulumi.Input['VersionArgs']] = None,
                 maintainer: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        This represents a particular channel of distribution for a given package. E.g., Debian's jessie-backports dpkg mirror.
        :param pulumi.Input[str] architecture: The CPU architecture for which packages in this distribution channel were built.
        :param pulumi.Input[str] cpe_uri: Required. The cpe_uri in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        :param pulumi.Input[str] description: The distribution channel-specific description of this package.
        :param pulumi.Input['VersionArgs'] latest_version: The latest available version of this package in this distribution channel.
        :param pulumi.Input[str] maintainer: A freeform string denoting the maintainer of this package.
        :param pulumi.Input[str] url: The distribution channel-specific homepage for this package.
        """
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if cpe_uri is not None:
            pulumi.set(__self__, "cpe_uri", cpe_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if latest_version is not None:
            pulumi.set(__self__, "latest_version", latest_version)
        if maintainer is not None:
            pulumi.set(__self__, "maintainer", maintainer)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[str]]:
        """
        The CPU architecture for which packages in this distribution channel were built.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The cpe_uri in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        """
        return pulumi.get(self, "cpe_uri")

    @cpe_uri.setter
    def cpe_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpe_uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The distribution channel-specific description of this package.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        The latest available version of this package in this distribution channel.
        """
        return pulumi.get(self, "latest_version")

    @latest_version.setter
    def latest_version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "latest_version", value)

    @property
    @pulumi.getter
    def maintainer(self) -> Optional[pulumi.Input[str]]:
        """
        A freeform string denoting the maintainer of this package.
        """
        return pulumi.get(self, "maintainer")

    @maintainer.setter
    def maintainer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintainer", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The distribution channel-specific homepage for this package.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class EnvironmentArgs:
    def __init__(__self__, *,
                 custom_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Defines an object for the environment field in in-toto links. The suggested fields are "variables", "filesystem", and "workdir".
        """
        if custom_values is not None:
            pulumi.set(__self__, "custom_values", custom_values)

    @property
    @pulumi.getter(name="customValues")
    def custom_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "custom_values")

    @custom_values.setter
    def custom_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "custom_values", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class FingerprintArgs:
    def __init__(__self__, *,
                 v1_name: Optional[pulumi.Input[str]] = None,
                 v2_blob: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 v2_name: Optional[pulumi.Input[str]] = None):
        """
        A set of properties that uniquely identify a given Docker image.
        :param pulumi.Input[str] v1_name: Required. The layer ID of the final layer in the Docker image's v1 representation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] v2_blob: Required. The ordered list of v2 blobs that represent a given image.
        :param pulumi.Input[str] v2_name: The name of the image's v2 blobs computed via: [bottom] := v2_blobbottom := sha256(v2_blob[N] + " " + v2_name[N+1]) Only the name of the final blob is kept.
        """
        if v1_name is not None:
            pulumi.set(__self__, "v1_name", v1_name)
        if v2_blob is not None:
            pulumi.set(__self__, "v2_blob", v2_blob)
        if v2_name is not None:
            pulumi.set(__self__, "v2_name", v2_name)

    @property
    @pulumi.getter(name="v1Name")
    def v1_name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The layer ID of the final layer in the Docker image's v1 representation.
        """
        return pulumi.get(self, "v1_name")

    @v1_name.setter
    def v1_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "v1_name", value)

    @property
    @pulumi.getter(name="v2Blob")
    def v2_blob(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required. The ordered list of v2 blobs that represent a given image.
        """
        return pulumi.get(self, "v2_blob")

    @v2_blob.setter
    def v2_blob(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "v2_blob", value)

    @property
    @pulumi.getter(name="v2Name")
    def v2_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the image's v2 blobs computed via: [bottom] := v2_blobbottom := sha256(v2_blob[N] + " " + v2_name[N+1]) Only the name of the final blob is kept.
        """
        return pulumi.get(self, "v2_name")

    @v2_name.setter
    def v2_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "v2_name", value)


@pulumi.input_type
class GenericSignedAttestationArgs:
    def __init__(__self__, *,
                 content_type: Optional[pulumi.Input[str]] = None,
                 serialized_payload: Optional[pulumi.Input[str]] = None,
                 signatures: Optional[pulumi.Input[Sequence[pulumi.Input['SignatureArgs']]]] = None):
        """
        An attestation wrapper that uses the Grafeas `Signature` message. This attestation must define the `serialized_payload` that the `signatures` verify and any metadata necessary to interpret that plaintext. The signatures should always be over the `serialized_payload` bytestring.
        :param pulumi.Input[str] content_type: Type (for example schema) of the attestation payload that was signed. The verifier must ensure that the provided type is one that the verifier supports, and that the attestation payload is a valid instantiation of that type (for example by validating a JSON schema).
        :param pulumi.Input[str] serialized_payload: The serialized payload that is verified by one or more `signatures`. The encoding and semantic meaning of this payload must match what is set in `content_type`.
        :param pulumi.Input[Sequence[pulumi.Input['SignatureArgs']]] signatures: One or more signatures over `serialized_payload`. Verifier implementations should consider this attestation message verified if at least one `signature` verifies `serialized_payload`. See `Signature` in common.proto for more details on signature structure and verification.
        """
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if serialized_payload is not None:
            pulumi.set(__self__, "serialized_payload", serialized_payload)
        if signatures is not None:
            pulumi.set(__self__, "signatures", signatures)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type (for example schema) of the attestation payload that was signed. The verifier must ensure that the provided type is one that the verifier supports, and that the attestation payload is a valid instantiation of that type (for example by validating a JSON schema).
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="serializedPayload")
    def serialized_payload(self) -> Optional[pulumi.Input[str]]:
        """
        The serialized payload that is verified by one or more `signatures`. The encoding and semantic meaning of this payload must match what is set in `content_type`.
        """
        return pulumi.get(self, "serialized_payload")

    @serialized_payload.setter
    def serialized_payload(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serialized_payload", value)

    @property
    @pulumi.getter
    def signatures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SignatureArgs']]]]:
        """
        One or more signatures over `serialized_payload`. Verifier implementations should consider this attestation message verified if at least one `signature` verifies `serialized_payload`. See `Signature` in common.proto for more details on signature structure and verification.
        """
        return pulumi.get(self, "signatures")

    @signatures.setter
    def signatures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SignatureArgs']]]]):
        pulumi.set(self, "signatures", value)


@pulumi.input_type
class GerritSourceContextArgs:
    def __init__(__self__, *,
                 alias_context: Optional[pulumi.Input['AliasContextArgs']] = None,
                 gerrit_project: Optional[pulumi.Input[str]] = None,
                 host_uri: Optional[pulumi.Input[str]] = None,
                 revision_id: Optional[pulumi.Input[str]] = None):
        """
        A SourceContext referring to a Gerrit project.
        :param pulumi.Input['AliasContextArgs'] alias_context: An alias, which may be a branch or tag.
        :param pulumi.Input[str] gerrit_project: The full project name within the host. Projects may be nested, so "project/subproject" is a valid project name. The "repo name" is the hostURI/project.
        :param pulumi.Input[str] host_uri: The URI of a running Gerrit instance.
        :param pulumi.Input[str] revision_id: A revision (commit) ID.
        """
        if alias_context is not None:
            pulumi.set(__self__, "alias_context", alias_context)
        if gerrit_project is not None:
            pulumi.set(__self__, "gerrit_project", gerrit_project)
        if host_uri is not None:
            pulumi.set(__self__, "host_uri", host_uri)
        if revision_id is not None:
            pulumi.set(__self__, "revision_id", revision_id)

    @property
    @pulumi.getter(name="aliasContext")
    def alias_context(self) -> Optional[pulumi.Input['AliasContextArgs']]:
        """
        An alias, which may be a branch or tag.
        """
        return pulumi.get(self, "alias_context")

    @alias_context.setter
    def alias_context(self, value: Optional[pulumi.Input['AliasContextArgs']]):
        pulumi.set(self, "alias_context", value)

    @property
    @pulumi.getter(name="gerritProject")
    def gerrit_project(self) -> Optional[pulumi.Input[str]]:
        """
        The full project name within the host. Projects may be nested, so "project/subproject" is a valid project name. The "repo name" is the hostURI/project.
        """
        return pulumi.get(self, "gerrit_project")

    @gerrit_project.setter
    def gerrit_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gerrit_project", value)

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of a running Gerrit instance.
        """
        return pulumi.get(self, "host_uri")

    @host_uri.setter
    def host_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_uri", value)

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[pulumi.Input[str]]:
        """
        A revision (commit) ID.
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_id", value)


@pulumi.input_type
class GitSourceContextArgs:
    def __init__(__self__, *,
                 revision_id: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        A GitSourceContext denotes a particular revision in a third party Git repository (e.g., GitHub).
        :param pulumi.Input[str] revision_id: Git commit hash.
        :param pulumi.Input[str] url: Git repository URL.
        """
        if revision_id is not None:
            pulumi.set(__self__, "revision_id", revision_id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[pulumi.Input[str]]:
        """
        Git commit hash.
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_id", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Git repository URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class GrafeasV1beta1BuildDetailsArgs:
    def __init__(__self__, *,
                 provenance: Optional[pulumi.Input['BuildProvenanceArgs']] = None,
                 provenance_bytes: Optional[pulumi.Input[str]] = None):
        """
        Details of a build occurrence.
        :param pulumi.Input['BuildProvenanceArgs'] provenance: Required. The actual provenance for the build.
        :param pulumi.Input[str] provenance_bytes: Serialized JSON representation of the provenance, used in generating the build signature in the corresponding build note. After verifying the signature, `provenance_bytes` can be unmarshalled and compared to the provenance to confirm that it is unchanged. A base64-encoded string representation of the provenance bytes is used for the signature in order to interoperate with openssl which expects this format for signature verification. The serialized form is captured both to avoid ambiguity in how the provenance is marshalled to json as well to prevent incompatibilities with future changes.
        """
        if provenance is not None:
            pulumi.set(__self__, "provenance", provenance)
        if provenance_bytes is not None:
            pulumi.set(__self__, "provenance_bytes", provenance_bytes)

    @property
    @pulumi.getter
    def provenance(self) -> Optional[pulumi.Input['BuildProvenanceArgs']]:
        """
        Required. The actual provenance for the build.
        """
        return pulumi.get(self, "provenance")

    @provenance.setter
    def provenance(self, value: Optional[pulumi.Input['BuildProvenanceArgs']]):
        pulumi.set(self, "provenance", value)

    @property
    @pulumi.getter(name="provenanceBytes")
    def provenance_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        Serialized JSON representation of the provenance, used in generating the build signature in the corresponding build note. After verifying the signature, `provenance_bytes` can be unmarshalled and compared to the provenance to confirm that it is unchanged. A base64-encoded string representation of the provenance bytes is used for the signature in order to interoperate with openssl which expects this format for signature verification. The serialized form is captured both to avoid ambiguity in how the provenance is marshalled to json as well to prevent incompatibilities with future changes.
        """
        return pulumi.get(self, "provenance_bytes")

    @provenance_bytes.setter
    def provenance_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provenance_bytes", value)


@pulumi.input_type
class GrafeasV1beta1DeploymentDetailsArgs:
    def __init__(__self__, *,
                 deployment: Optional[pulumi.Input['DeploymentArgs']] = None):
        """
        Details of a deployment occurrence.
        :param pulumi.Input['DeploymentArgs'] deployment: Required. Deployment history for the resource.
        """
        if deployment is not None:
            pulumi.set(__self__, "deployment", deployment)

    @property
    @pulumi.getter
    def deployment(self) -> Optional[pulumi.Input['DeploymentArgs']]:
        """
        Required. Deployment history for the resource.
        """
        return pulumi.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: Optional[pulumi.Input['DeploymentArgs']]):
        pulumi.set(self, "deployment", value)


@pulumi.input_type
class GrafeasV1beta1DiscoveryDetailsArgs:
    def __init__(__self__, *,
                 discovered: Optional[pulumi.Input['DiscoveredArgs']] = None):
        """
        Details of a discovery occurrence.
        :param pulumi.Input['DiscoveredArgs'] discovered: Required. Analysis status for the discovered resource.
        """
        if discovered is not None:
            pulumi.set(__self__, "discovered", discovered)

    @property
    @pulumi.getter
    def discovered(self) -> Optional[pulumi.Input['DiscoveredArgs']]:
        """
        Required. Analysis status for the discovered resource.
        """
        return pulumi.get(self, "discovered")

    @discovered.setter
    def discovered(self, value: Optional[pulumi.Input['DiscoveredArgs']]):
        pulumi.set(self, "discovered", value)


@pulumi.input_type
class GrafeasV1beta1ImageDetailsArgs:
    def __init__(__self__, *,
                 derived_image: Optional[pulumi.Input['DerivedArgs']] = None):
        """
        Details of an image occurrence.
        :param pulumi.Input['DerivedArgs'] derived_image: Required. Immutable. The child image derived from the base image.
        """
        if derived_image is not None:
            pulumi.set(__self__, "derived_image", derived_image)

    @property
    @pulumi.getter(name="derivedImage")
    def derived_image(self) -> Optional[pulumi.Input['DerivedArgs']]:
        """
        Required. Immutable. The child image derived from the base image.
        """
        return pulumi.get(self, "derived_image")

    @derived_image.setter
    def derived_image(self, value: Optional[pulumi.Input['DerivedArgs']]):
        pulumi.set(self, "derived_image", value)


@pulumi.input_type
class GrafeasV1beta1IntotoArtifactArgs:
    def __init__(__self__, *,
                 hashes: Optional[pulumi.Input['ArtifactHashesArgs']] = None,
                 resource_uri: Optional[pulumi.Input[str]] = None):
        if hashes is not None:
            pulumi.set(__self__, "hashes", hashes)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter
    def hashes(self) -> Optional[pulumi.Input['ArtifactHashesArgs']]:
        return pulumi.get(self, "hashes")

    @hashes.setter
    def hashes(self, value: Optional[pulumi.Input['ArtifactHashesArgs']]):
        pulumi.set(self, "hashes", value)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_uri")

    @resource_uri.setter
    def resource_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_uri", value)


@pulumi.input_type
class GrafeasV1beta1IntotoDetailsArgs:
    def __init__(__self__, *,
                 signatures: Optional[pulumi.Input[Sequence[pulumi.Input['GrafeasV1beta1IntotoSignatureArgs']]]] = None,
                 signed: Optional[pulumi.Input['LinkArgs']] = None):
        """
        This corresponds to a signed in-toto link - it is made up of one or more signatures and the in-toto link itself. This is used for occurrences of a Grafeas in-toto note.
        """
        if signatures is not None:
            pulumi.set(__self__, "signatures", signatures)
        if signed is not None:
            pulumi.set(__self__, "signed", signed)

    @property
    @pulumi.getter
    def signatures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GrafeasV1beta1IntotoSignatureArgs']]]]:
        return pulumi.get(self, "signatures")

    @signatures.setter
    def signatures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GrafeasV1beta1IntotoSignatureArgs']]]]):
        pulumi.set(self, "signatures", value)

    @property
    @pulumi.getter
    def signed(self) -> Optional[pulumi.Input['LinkArgs']]:
        return pulumi.get(self, "signed")

    @signed.setter
    def signed(self, value: Optional[pulumi.Input['LinkArgs']]):
        pulumi.set(self, "signed", value)


@pulumi.input_type
class GrafeasV1beta1IntotoSignatureArgs:
    def __init__(__self__, *,
                 keyid: Optional[pulumi.Input[str]] = None,
                 sig: Optional[pulumi.Input[str]] = None):
        """
        A signature object consists of the KeyID used and the signature itself.
        """
        if keyid is not None:
            pulumi.set(__self__, "keyid", keyid)
        if sig is not None:
            pulumi.set(__self__, "sig", sig)

    @property
    @pulumi.getter
    def keyid(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "keyid")

    @keyid.setter
    def keyid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keyid", value)

    @property
    @pulumi.getter
    def sig(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "sig")

    @sig.setter
    def sig(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sig", value)


@pulumi.input_type
class GrafeasV1beta1PackageDetailsArgs:
    def __init__(__self__, *,
                 installation: Optional[pulumi.Input['InstallationArgs']] = None):
        """
        Details of a package occurrence.
        :param pulumi.Input['InstallationArgs'] installation: Required. Where the package was installed.
        """
        if installation is not None:
            pulumi.set(__self__, "installation", installation)

    @property
    @pulumi.getter
    def installation(self) -> Optional[pulumi.Input['InstallationArgs']]:
        """
        Required. Where the package was installed.
        """
        return pulumi.get(self, "installation")

    @installation.setter
    def installation(self, value: Optional[pulumi.Input['InstallationArgs']]):
        pulumi.set(self, "installation", value)


@pulumi.input_type
class GrafeasV1beta1VulnerabilityDetailsArgs:
    def __init__(__self__, *,
                 cvss_score: Optional[pulumi.Input[float]] = None,
                 effective_severity: Optional[pulumi.Input[str]] = None,
                 long_description: Optional[pulumi.Input[str]] = None,
                 package_issue: Optional[pulumi.Input[Sequence[pulumi.Input['PackageIssueArgs']]]] = None,
                 related_urls: Optional[pulumi.Input[Sequence[pulumi.Input['RelatedUrlArgs']]]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 short_description: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Details of a vulnerability Occurrence.
        :param pulumi.Input[float] cvss_score: The CVSS score of this vulnerability. CVSS score is on a scale of 0-10 where 0 indicates low severity and 10 indicates high severity.
        :param pulumi.Input[str] effective_severity: The distro assigned severity for this vulnerability when it is available, and note provider assigned severity when distro has not yet assigned a severity for this vulnerability.
        :param pulumi.Input[str] long_description: A detailed description of this vulnerability.
        :param pulumi.Input[Sequence[pulumi.Input['PackageIssueArgs']]] package_issue: Required. The set of affected locations and their fixes (if available) within the associated resource.
        :param pulumi.Input[Sequence[pulumi.Input['RelatedUrlArgs']]] related_urls: URLs related to this vulnerability.
        :param pulumi.Input[str] severity: The note provider assigned Severity of the vulnerability.
        :param pulumi.Input[str] short_description: A one sentence description of this vulnerability.
        :param pulumi.Input[str] type: The type of package; whether native or non native(ruby gems, node.js packages etc)
        """
        if cvss_score is not None:
            pulumi.set(__self__, "cvss_score", cvss_score)
        if effective_severity is not None:
            pulumi.set(__self__, "effective_severity", effective_severity)
        if long_description is not None:
            pulumi.set(__self__, "long_description", long_description)
        if package_issue is not None:
            pulumi.set(__self__, "package_issue", package_issue)
        if related_urls is not None:
            pulumi.set(__self__, "related_urls", related_urls)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if short_description is not None:
            pulumi.set(__self__, "short_description", short_description)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cvssScore")
    def cvss_score(self) -> Optional[pulumi.Input[float]]:
        """
        The CVSS score of this vulnerability. CVSS score is on a scale of 0-10 where 0 indicates low severity and 10 indicates high severity.
        """
        return pulumi.get(self, "cvss_score")

    @cvss_score.setter
    def cvss_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cvss_score", value)

    @property
    @pulumi.getter(name="effectiveSeverity")
    def effective_severity(self) -> Optional[pulumi.Input[str]]:
        """
        The distro assigned severity for this vulnerability when it is available, and note provider assigned severity when distro has not yet assigned a severity for this vulnerability.
        """
        return pulumi.get(self, "effective_severity")

    @effective_severity.setter
    def effective_severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_severity", value)

    @property
    @pulumi.getter(name="longDescription")
    def long_description(self) -> Optional[pulumi.Input[str]]:
        """
        A detailed description of this vulnerability.
        """
        return pulumi.get(self, "long_description")

    @long_description.setter
    def long_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "long_description", value)

    @property
    @pulumi.getter(name="packageIssue")
    def package_issue(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PackageIssueArgs']]]]:
        """
        Required. The set of affected locations and their fixes (if available) within the associated resource.
        """
        return pulumi.get(self, "package_issue")

    @package_issue.setter
    def package_issue(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PackageIssueArgs']]]]):
        pulumi.set(self, "package_issue", value)

    @property
    @pulumi.getter(name="relatedUrls")
    def related_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RelatedUrlArgs']]]]:
        """
        URLs related to this vulnerability.
        """
        return pulumi.get(self, "related_urls")

    @related_urls.setter
    def related_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RelatedUrlArgs']]]]):
        pulumi.set(self, "related_urls", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[str]]:
        """
        The note provider assigned Severity of the vulnerability.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> Optional[pulumi.Input[str]]:
        """
        A one sentence description of this vulnerability.
        """
        return pulumi.get(self, "short_description")

    @short_description.setter
    def short_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "short_description", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of package; whether native or non native(ruby gems, node.js packages etc)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class HashArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Container message for hash values.
        :param pulumi.Input[str] type: Required. The type of hash that was performed.
        :param pulumi.Input[str] value: Required. The hash value.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The type of hash that was performed.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The hash value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class HintArgs:
    def __init__(__self__, *,
                 human_readable_name: Optional[pulumi.Input[str]] = None):
        """
        This submessage provides human-readable hints about the purpose of the authority. Because the name of a note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should not be used to look up authorities in security sensitive contexts, such as when looking up attestations to verify.
        :param pulumi.Input[str] human_readable_name: Required. The human readable name of this attestation authority, for example "qa".
        """
        if human_readable_name is not None:
            pulumi.set(__self__, "human_readable_name", human_readable_name)

    @property
    @pulumi.getter(name="humanReadableName")
    def human_readable_name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The human readable name of this attestation authority, for example "qa".
        """
        return pulumi.get(self, "human_readable_name")

    @human_readable_name.setter
    def human_readable_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "human_readable_name", value)


@pulumi.input_type
class InTotoArgs:
    def __init__(__self__, *,
                 expected_command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 expected_materials: Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactRuleArgs']]]] = None,
                 expected_products: Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactRuleArgs']]]] = None,
                 signing_keys: Optional[pulumi.Input[Sequence[pulumi.Input['SigningKeyArgs']]]] = None,
                 step_name: Optional[pulumi.Input[str]] = None,
                 threshold: Optional[pulumi.Input[str]] = None):
        """
        This contains the fields corresponding to the definition of a software supply chain step in an in-toto layout. This information goes into a Grafeas note.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expected_command: This field contains the expected command used to perform the step.
        :param pulumi.Input[Sequence[pulumi.Input['ArtifactRuleArgs']]] expected_materials: The following fields contain in-toto artifact rules identifying the artifacts that enter this supply chain step, and exit the supply chain step, i.e. materials and products of the step.
        :param pulumi.Input[Sequence[pulumi.Input['SigningKeyArgs']]] signing_keys: This field contains the public keys that can be used to verify the signatures on the step metadata.
        :param pulumi.Input[str] step_name: This field identifies the name of the step in the supply chain.
        :param pulumi.Input[str] threshold: This field contains a value that indicates the minimum number of keys that need to be used to sign the step's in-toto link.
        """
        if expected_command is not None:
            pulumi.set(__self__, "expected_command", expected_command)
        if expected_materials is not None:
            pulumi.set(__self__, "expected_materials", expected_materials)
        if expected_products is not None:
            pulumi.set(__self__, "expected_products", expected_products)
        if signing_keys is not None:
            pulumi.set(__self__, "signing_keys", signing_keys)
        if step_name is not None:
            pulumi.set(__self__, "step_name", step_name)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="expectedCommand")
    def expected_command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This field contains the expected command used to perform the step.
        """
        return pulumi.get(self, "expected_command")

    @expected_command.setter
    def expected_command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "expected_command", value)

    @property
    @pulumi.getter(name="expectedMaterials")
    def expected_materials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactRuleArgs']]]]:
        """
        The following fields contain in-toto artifact rules identifying the artifacts that enter this supply chain step, and exit the supply chain step, i.e. materials and products of the step.
        """
        return pulumi.get(self, "expected_materials")

    @expected_materials.setter
    def expected_materials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactRuleArgs']]]]):
        pulumi.set(self, "expected_materials", value)

    @property
    @pulumi.getter(name="expectedProducts")
    def expected_products(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactRuleArgs']]]]:
        return pulumi.get(self, "expected_products")

    @expected_products.setter
    def expected_products(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactRuleArgs']]]]):
        pulumi.set(self, "expected_products", value)

    @property
    @pulumi.getter(name="signingKeys")
    def signing_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SigningKeyArgs']]]]:
        """
        This field contains the public keys that can be used to verify the signatures on the step metadata.
        """
        return pulumi.get(self, "signing_keys")

    @signing_keys.setter
    def signing_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SigningKeyArgs']]]]):
        pulumi.set(self, "signing_keys", value)

    @property
    @pulumi.getter(name="stepName")
    def step_name(self) -> Optional[pulumi.Input[str]]:
        """
        This field identifies the name of the step in the supply chain.
        """
        return pulumi.get(self, "step_name")

    @step_name.setter
    def step_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step_name", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[str]]:
        """
        This field contains a value that indicates the minimum number of keys that need to be used to sign the step's in-toto link.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "threshold", value)


@pulumi.input_type
class InstallationArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[Sequence[pulumi.Input['LocationArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        This represents how a particular software package may be installed on a system.
        :param pulumi.Input[Sequence[pulumi.Input['LocationArgs']]] location: Required. All of the places within the filesystem versions of this package have been found.
        :param pulumi.Input[str] name: The name of the installed package.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LocationArgs']]]]:
        """
        Required. All of the places within the filesystem versions of this package have been found.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LocationArgs']]]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the installed package.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class KnowledgeBaseArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The KB name (generally of the form KB[0-9]+ i.e. KB123456).
        :param pulumi.Input[str] url: A link to the KB in the Windows update catalog - https://www.catalog.update.microsoft.com/
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The KB name (generally of the form KB[0-9]+ i.e. KB123456).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        A link to the KB in the Windows update catalog - https://www.catalog.update.microsoft.com/
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class LayerArgs:
    def __init__(__self__, *,
                 arguments: Optional[pulumi.Input[str]] = None,
                 directive: Optional[pulumi.Input[str]] = None):
        """
        Layer holds metadata specific to a layer of a Docker image.
        :param pulumi.Input[str] arguments: The recovered arguments to the Dockerfile directive.
        :param pulumi.Input[str] directive: Required. The recovered Dockerfile directive used to construct this layer.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if directive is not None:
            pulumi.set(__self__, "directive", directive)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[str]]:
        """
        The recovered arguments to the Dockerfile directive.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter
    def directive(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The recovered Dockerfile directive used to construct this layer.
        """
        return pulumi.get(self, "directive")

    @directive.setter
    def directive(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "directive", value)


@pulumi.input_type
class LinkArgs:
    def __init__(__self__, *,
                 byproducts: Optional[pulumi.Input['ByProductsArgs']] = None,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 environment: Optional[pulumi.Input['EnvironmentArgs']] = None,
                 materials: Optional[pulumi.Input[Sequence[pulumi.Input['GrafeasV1beta1IntotoArtifactArgs']]]] = None,
                 products: Optional[pulumi.Input[Sequence[pulumi.Input['GrafeasV1beta1IntotoArtifactArgs']]]] = None):
        """
        This corresponds to an in-toto link.
        :param pulumi.Input['ByProductsArgs'] byproducts: ByProducts are data generated as part of a software supply chain step, but are not the actual result of the step.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: This field contains the full command executed for the step. This can also be empty if links are generated for operations that aren't directly mapped to a specific command. Each term in the command is an independent string in the list. An example of a command in the in-toto metadata field is: "command": ["git", "clone", "https://github.com/in-toto/demo-project.git"]
        :param pulumi.Input['EnvironmentArgs'] environment: This is a field that can be used to capture information about the environment. It is suggested for this field to contain information that details environment variables, filesystem information, and the present working directory. The recommended structure of this field is: "environment": { "custom_values": { "variables": "", "filesystem": "", "workdir": "", "": "..." } }
        :param pulumi.Input[Sequence[pulumi.Input['GrafeasV1beta1IntotoArtifactArgs']]] materials: Materials are the supply chain artifacts that go into the step and are used for the operation performed. The key of the map is the path of the artifact and the structure contains the recorded hash information. An example is: "materials": [ { "resource_uri": "foo/bar", "hashes": { "sha256": "ebebf...", : } } ]
        :param pulumi.Input[Sequence[pulumi.Input['GrafeasV1beta1IntotoArtifactArgs']]] products: Products are the supply chain artifacts generated as a result of the step. The structure is identical to that of materials.
        """
        if byproducts is not None:
            pulumi.set(__self__, "byproducts", byproducts)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if materials is not None:
            pulumi.set(__self__, "materials", materials)
        if products is not None:
            pulumi.set(__self__, "products", products)

    @property
    @pulumi.getter
    def byproducts(self) -> Optional[pulumi.Input['ByProductsArgs']]:
        """
        ByProducts are data generated as part of a software supply chain step, but are not the actual result of the step.
        """
        return pulumi.get(self, "byproducts")

    @byproducts.setter
    def byproducts(self, value: Optional[pulumi.Input['ByProductsArgs']]):
        pulumi.set(self, "byproducts", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This field contains the full command executed for the step. This can also be empty if links are generated for operations that aren't directly mapped to a specific command. Each term in the command is an independent string in the list. An example of a command in the in-toto metadata field is: "command": ["git", "clone", "https://github.com/in-toto/demo-project.git"]
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['EnvironmentArgs']]:
        """
        This is a field that can be used to capture information about the environment. It is suggested for this field to contain information that details environment variables, filesystem information, and the present working directory. The recommended structure of this field is: "environment": { "custom_values": { "variables": "", "filesystem": "", "workdir": "", "": "..." } }
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['EnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def materials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GrafeasV1beta1IntotoArtifactArgs']]]]:
        """
        Materials are the supply chain artifacts that go into the step and are used for the operation performed. The key of the map is the path of the artifact and the structure contains the recorded hash information. An example is: "materials": [ { "resource_uri": "foo/bar", "hashes": { "sha256": "ebebf...", : } } ]
        """
        return pulumi.get(self, "materials")

    @materials.setter
    def materials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GrafeasV1beta1IntotoArtifactArgs']]]]):
        pulumi.set(self, "materials", value)

    @property
    @pulumi.getter
    def products(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GrafeasV1beta1IntotoArtifactArgs']]]]:
        """
        Products are the supply chain artifacts generated as a result of the step. The structure is identical to that of materials.
        """
        return pulumi.get(self, "products")

    @products.setter
    def products(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GrafeasV1beta1IntotoArtifactArgs']]]]):
        pulumi.set(self, "products", value)


@pulumi.input_type
class LocationArgs:
    def __init__(__self__, *,
                 cpe_uri: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input['VersionArgs']] = None):
        """
        An occurrence of a particular package installation found within a system's filesystem. E.g., glibc was found in `/var/lib/dpkg/status`.
        :param pulumi.Input[str] cpe_uri: Required. The CPE URI in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        :param pulumi.Input[str] path: The path from which we gathered that this package/version is installed.
        :param pulumi.Input['VersionArgs'] version: The version installed at this location.
        """
        if cpe_uri is not None:
            pulumi.set(__self__, "cpe_uri", cpe_uri)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The CPE URI in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        """
        return pulumi.get(self, "cpe_uri")

    @cpe_uri.setter
    def cpe_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpe_uri", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path from which we gathered that this package/version is installed.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        The version installed at this location.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class PackageArgs:
    def __init__(__self__, *,
                 distribution: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        This represents a particular package that is distributed over various channels. E.g., glibc (aka libc6) is distributed by many, at various versions.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionArgs']]] distribution: The various channels by which a package is distributed.
        :param pulumi.Input[str] name: Required. Immutable. The name of the package.
        """
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def distribution(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionArgs']]]]:
        """
        The various channels by which a package is distributed.
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionArgs']]]]):
        pulumi.set(self, "distribution", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Immutable. The name of the package.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class PackageIssueArgs:
    def __init__(__self__, *,
                 affected_location: Optional[pulumi.Input['VulnerabilityLocationArgs']] = None,
                 fixed_location: Optional[pulumi.Input['VulnerabilityLocationArgs']] = None,
                 severity_name: Optional[pulumi.Input[str]] = None):
        """
        This message wraps a location affected by a vulnerability and its associated fix (if one is available).
        :param pulumi.Input['VulnerabilityLocationArgs'] affected_location: Required. The location of the vulnerability.
        :param pulumi.Input['VulnerabilityLocationArgs'] fixed_location: The location of the available fix for vulnerability.
        :param pulumi.Input[str] severity_name: Deprecated, use Details.effective_severity instead The severity (e.g., distro assigned severity) for this vulnerability.
        """
        if affected_location is not None:
            pulumi.set(__self__, "affected_location", affected_location)
        if fixed_location is not None:
            pulumi.set(__self__, "fixed_location", fixed_location)
        if severity_name is not None:
            pulumi.set(__self__, "severity_name", severity_name)

    @property
    @pulumi.getter(name="affectedLocation")
    def affected_location(self) -> Optional[pulumi.Input['VulnerabilityLocationArgs']]:
        """
        Required. The location of the vulnerability.
        """
        return pulumi.get(self, "affected_location")

    @affected_location.setter
    def affected_location(self, value: Optional[pulumi.Input['VulnerabilityLocationArgs']]):
        pulumi.set(self, "affected_location", value)

    @property
    @pulumi.getter(name="fixedLocation")
    def fixed_location(self) -> Optional[pulumi.Input['VulnerabilityLocationArgs']]:
        """
        The location of the available fix for vulnerability.
        """
        return pulumi.get(self, "fixed_location")

    @fixed_location.setter
    def fixed_location(self, value: Optional[pulumi.Input['VulnerabilityLocationArgs']]):
        pulumi.set(self, "fixed_location", value)

    @property
    @pulumi.getter(name="severityName")
    def severity_name(self) -> Optional[pulumi.Input[str]]:
        """
        Deprecated, use Details.effective_severity instead The severity (e.g., distro assigned severity) for this vulnerability.
        """
        return pulumi.get(self, "severity_name")

    @severity_name.setter
    def severity_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity_name", value)


@pulumi.input_type
class PgpSignedAttestationArgs:
    def __init__(__self__, *,
                 content_type: Optional[pulumi.Input[str]] = None,
                 pgp_key_id: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input[str]] = None):
        """
        An attestation wrapper with a PGP-compatible signature. This message only supports `ATTACHED` signatures, where the payload that is signed is included alongside the signature itself in the same file.
        :param pulumi.Input[str] content_type: Type (for example schema) of the attestation payload that was signed. The verifier must ensure that the provided type is one that the verifier supports, and that the attestation payload is a valid instantiation of that type (for example by validating a JSON schema).
        :param pulumi.Input[str] pgp_key_id: The cryptographic fingerprint of the key used to generate the signature, as output by, e.g. `gpg --list-keys`. This should be the version 4, full 160-bit fingerprint, expressed as a 40 character hexidecimal string. See https://tools.ietf.org/html/rfc4880#section-12.2 for details. Implementations may choose to acknowledge "LONG", "SHORT", or other abbreviated key IDs, but only the full fingerprint is guaranteed to work. In gpg, the full fingerprint can be retrieved from the `fpr` field returned when calling --list-keys with --with-colons. For example: ``` gpg --with-colons --with-fingerprint --force-v4-certs \ --list-keys attester@example.com tru::1:1513631572:0:3:1:5 pub:...... fpr:::::::::24FF6481B76AC91E66A00AC657A93A81EF3AE6FB: ``` Above, the fingerprint is `24FF6481B76AC91E66A00AC657A93A81EF3AE6FB`.
        :param pulumi.Input[str] signature: Required. The raw content of the signature, as output by GNU Privacy Guard (GPG) or equivalent. Since this message only supports attached signatures, the payload that was signed must be attached. While the signature format supported is dependent on the verification implementation, currently only ASCII-armored (`--armor` to gpg), non-clearsigned (`--sign` rather than `--clearsign` to gpg) are supported. Concretely, `gpg --sign --armor --output=signature.gpg payload.json` will create the signature content expected in this field in `signature.gpg` for the `payload.json` attestation payload.
        """
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if pgp_key_id is not None:
            pulumi.set(__self__, "pgp_key_id", pgp_key_id)
        if signature is not None:
            pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type (for example schema) of the attestation payload that was signed. The verifier must ensure that the provided type is one that the verifier supports, and that the attestation payload is a valid instantiation of that type (for example by validating a JSON schema).
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="pgpKeyId")
    def pgp_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The cryptographic fingerprint of the key used to generate the signature, as output by, e.g. `gpg --list-keys`. This should be the version 4, full 160-bit fingerprint, expressed as a 40 character hexidecimal string. See https://tools.ietf.org/html/rfc4880#section-12.2 for details. Implementations may choose to acknowledge "LONG", "SHORT", or other abbreviated key IDs, but only the full fingerprint is guaranteed to work. In gpg, the full fingerprint can be retrieved from the `fpr` field returned when calling --list-keys with --with-colons. For example: ``` gpg --with-colons --with-fingerprint --force-v4-certs \ --list-keys attester@example.com tru::1:1513631572:0:3:1:5 pub:...... fpr:::::::::24FF6481B76AC91E66A00AC657A93A81EF3AE6FB: ``` Above, the fingerprint is `24FF6481B76AC91E66A00AC657A93A81EF3AE6FB`.
        """
        return pulumi.get(self, "pgp_key_id")

    @pgp_key_id.setter
    def pgp_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pgp_key_id", value)

    @property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The raw content of the signature, as output by GNU Privacy Guard (GPG) or equivalent. Since this message only supports attached signatures, the payload that was signed must be attached. While the signature format supported is dependent on the verification implementation, currently only ASCII-armored (`--armor` to gpg), non-clearsigned (`--sign` rather than `--clearsign` to gpg) are supported. Concretely, `gpg --sign --armor --output=signature.gpg payload.json` will create the signature content expected in this field in `signature.gpg` for the `payload.json` attestation payload.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature", value)


@pulumi.input_type
class ProjectRepoIdArgs:
    def __init__(__self__, *,
                 project_id: Optional[pulumi.Input[str]] = None,
                 repo_name: Optional[pulumi.Input[str]] = None):
        """
        Selects a repo using a Google Cloud Platform project ID (e.g., winged-cargo-31) and a repo name within that project.
        :param pulumi.Input[str] project_id: The ID of the project.
        :param pulumi.Input[str] repo_name: The name of the repo. Leave empty for the default repo.
        """
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the repo. Leave empty for the default repo.
        """
        return pulumi.get(self, "repo_name")

    @repo_name.setter
    def repo_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo_name", value)


@pulumi.input_type
class RelatedUrlArgs:
    def __init__(__self__, *,
                 label: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Metadata for any related URL information.
        :param pulumi.Input[str] label: Label to describe usage of the URL.
        :param pulumi.Input[str] url: Specific URL associated with the resource.
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Label to describe usage of the URL.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Specific URL associated with the resource.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class RepoIdArgs:
    def __init__(__self__, *,
                 project_repo_id: Optional[pulumi.Input['ProjectRepoIdArgs']] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        A unique identifier for a Cloud Repo.
        :param pulumi.Input['ProjectRepoIdArgs'] project_repo_id: A combination of a project ID and a repo name.
        :param pulumi.Input[str] uid: A server-assigned, globally unique identifier.
        """
        if project_repo_id is not None:
            pulumi.set(__self__, "project_repo_id", project_repo_id)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="projectRepoId")
    def project_repo_id(self) -> Optional[pulumi.Input['ProjectRepoIdArgs']]:
        """
        A combination of a project ID and a repo name.
        """
        return pulumi.get(self, "project_repo_id")

    @project_repo_id.setter
    def project_repo_id(self, value: Optional[pulumi.Input['ProjectRepoIdArgs']]):
        pulumi.set(self, "project_repo_id", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        A server-assigned, globally unique identifier.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ResourceArgs:
    def __init__(__self__, *,
                 content_hash: Optional[pulumi.Input['HashArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        An entity that can have metadata. For example, a Docker image.
        :param pulumi.Input['HashArgs'] content_hash: Deprecated, do not use. Use uri instead. The hash of the resource content. For example, the Docker digest.
        :param pulumi.Input[str] name: Deprecated, do not use. Use uri instead. The name of the resource. For example, the name of a Docker image - "Debian".
        :param pulumi.Input[str] uri: Required. The unique URI of the resource. For example, `https://gcr.io/project/image@sha256:foo` for a Docker image.
        """
        if content_hash is not None:
            pulumi.set(__self__, "content_hash", content_hash)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="contentHash")
    def content_hash(self) -> Optional[pulumi.Input['HashArgs']]:
        """
        Deprecated, do not use. Use uri instead. The hash of the resource content. For example, the Docker digest.
        """
        return pulumi.get(self, "content_hash")

    @content_hash.setter
    def content_hash(self, value: Optional[pulumi.Input['HashArgs']]):
        pulumi.set(self, "content_hash", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Deprecated, do not use. Use uri instead. The name of the resource. For example, the name of a Docker image - "Debian".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The unique URI of the resource. For example, `https://gcr.io/project/image@sha256:foo` for a Docker image.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class SignatureArgs:
    def __init__(__self__, *,
                 public_key_id: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input[str]] = None):
        """
        Verifiers (e.g. Kritis implementations) MUST verify signatures with respect to the trust anchors defined in policy (e.g. a Kritis policy). Typically this means that the verifier has been configured with a map from `public_key_id` to public key material (and any required parameters, e.g. signing algorithm). In particular, verification implementations MUST NOT treat the signature `public_key_id` as anything more than a key lookup hint. The `public_key_id` DOES NOT validate or authenticate a public key; it only provides a mechanism for quickly selecting a public key ALREADY CONFIGURED on the verifier through a trusted channel. Verification implementations MUST reject signatures in any of the following circumstances: * The `public_key_id` is not recognized by the verifier. * The public key that `public_key_id` refers to does not verify the signature with respect to the payload. The `signature` contents SHOULD NOT be "attached" (where the payload is included with the serialized `signature` bytes). Verifiers MUST ignore any "attached" payload and only verify signatures with respect to explicitly provided payload (e.g. a `payload` field on the proto message that holds this Signature, or the canonical serialization of the proto message that holds this signature).
        :param pulumi.Input[str] public_key_id: The identifier for the public key that verifies this signature. * The `public_key_id` is required. * The `public_key_id` SHOULD be an RFC3986 conformant URI. * When possible, the `public_key_id` SHOULD be an immutable reference, such as a cryptographic digest. Examples of valid `public_key_id`s: OpenPGP V4 public key fingerprint: * "openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA" See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr for more details on this scheme. RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER serialization): * "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU" * "nih:///sha-256;703f68f42aba2c6de30f488a5ea122fef76324679c9bf89791ba95a1271589a5"
        :param pulumi.Input[str] signature: The content of the signature, an opaque bytestring. The payload that this signature verifies MUST be unambiguously provided with the Signature during verification. A wrapper message might provide the payload explicitly. Alternatively, a message might have a canonical serialization that can always be unambiguously computed to derive the payload.
        """
        if public_key_id is not None:
            pulumi.set(__self__, "public_key_id", public_key_id)
        if signature is not None:
            pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="publicKeyId")
    def public_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the public key that verifies this signature. * The `public_key_id` is required. * The `public_key_id` SHOULD be an RFC3986 conformant URI. * When possible, the `public_key_id` SHOULD be an immutable reference, such as a cryptographic digest. Examples of valid `public_key_id`s: OpenPGP V4 public key fingerprint: * "openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA" See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr for more details on this scheme. RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER serialization): * "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU" * "nih:///sha-256;703f68f42aba2c6de30f488a5ea122fef76324679c9bf89791ba95a1271589a5"
        """
        return pulumi.get(self, "public_key_id")

    @public_key_id.setter
    def public_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_id", value)

    @property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input[str]]:
        """
        The content of the signature, an opaque bytestring. The payload that this signature verifies MUST be unambiguously provided with the Signature during verification. A wrapper message might provide the payload explicitly. Alternatively, a message might have a canonical serialization that can always be unambiguously computed to derive the payload.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature", value)


@pulumi.input_type
class SigningKeyArgs:
    def __init__(__self__, *,
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_scheme: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 public_key_value: Optional[pulumi.Input[str]] = None):
        """
        This defines the format used to record keys used in the software supply chain. An in-toto link is attested using one or more keys defined in the in-toto layout. An example of this is: { "key_id": "776a00e29f3559e0141b3b096f696abc6cfb0c657ab40f441132b345b0...", "key_type": "rsa", "public_key_value": "-----BEGIN PUBLIC KEY-----\nMIIBojANBgkqhkiG9w0B...", "key_scheme": "rsassa-pss-sha256" } The format for in-toto's key definition can be found in section 4.2 of the in-toto specification.
        :param pulumi.Input[str] key_id: key_id is an identifier for the signing key.
        :param pulumi.Input[str] key_scheme: This field contains the corresponding signature scheme. Eg: "rsassa-pss-sha256".
        :param pulumi.Input[str] key_type: This field identifies the specific signing method. Eg: "rsa", "ed25519", and "ecdsa".
        :param pulumi.Input[str] public_key_value: This field contains the actual public key.
        """
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_scheme is not None:
            pulumi.set(__self__, "key_scheme", key_scheme)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if public_key_value is not None:
            pulumi.set(__self__, "public_key_value", public_key_value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        key_id is an identifier for the signing key.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="keyScheme")
    def key_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        This field contains the corresponding signature scheme. Eg: "rsassa-pss-sha256".
        """
        return pulumi.get(self, "key_scheme")

    @key_scheme.setter
    def key_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_scheme", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[str]]:
        """
        This field identifies the specific signing method. Eg: "rsa", "ed25519", and "ecdsa".
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter(name="publicKeyValue")
    def public_key_value(self) -> Optional[pulumi.Input[str]]:
        """
        This field contains the actual public key.
        """
        return pulumi.get(self, "public_key_value")

    @public_key_value.setter
    def public_key_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_value", value)


@pulumi.input_type
class SourceArgs:
    def __init__(__self__, *,
                 additional_contexts: Optional[pulumi.Input[Sequence[pulumi.Input['SourceContextArgs']]]] = None,
                 artifact_storage_source_uri: Optional[pulumi.Input[str]] = None,
                 context: Optional[pulumi.Input['SourceContextArgs']] = None,
                 file_hashes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Source describes the location of the source used for the build.
        :param pulumi.Input[Sequence[pulumi.Input['SourceContextArgs']]] additional_contexts: If provided, some of the source code used for the build may be found in these locations, in the case where the source repository had multiple remotes or submodules. This list will not include the context specified in the context field.
        :param pulumi.Input[str] artifact_storage_source_uri: If provided, the input binary artifacts for the build came from this location.
        :param pulumi.Input['SourceContextArgs'] context: If provided, the source code used for the build came from this location.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] file_hashes: Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (.tar.gz), the FileHash will be for the single path to that file.
        """
        if additional_contexts is not None:
            pulumi.set(__self__, "additional_contexts", additional_contexts)
        if artifact_storage_source_uri is not None:
            pulumi.set(__self__, "artifact_storage_source_uri", artifact_storage_source_uri)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if file_hashes is not None:
            pulumi.set(__self__, "file_hashes", file_hashes)

    @property
    @pulumi.getter(name="additionalContexts")
    def additional_contexts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourceContextArgs']]]]:
        """
        If provided, some of the source code used for the build may be found in these locations, in the case where the source repository had multiple remotes or submodules. This list will not include the context specified in the context field.
        """
        return pulumi.get(self, "additional_contexts")

    @additional_contexts.setter
    def additional_contexts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourceContextArgs']]]]):
        pulumi.set(self, "additional_contexts", value)

    @property
    @pulumi.getter(name="artifactStorageSourceUri")
    def artifact_storage_source_uri(self) -> Optional[pulumi.Input[str]]:
        """
        If provided, the input binary artifacts for the build came from this location.
        """
        return pulumi.get(self, "artifact_storage_source_uri")

    @artifact_storage_source_uri.setter
    def artifact_storage_source_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_storage_source_uri", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input['SourceContextArgs']]:
        """
        If provided, the source code used for the build came from this location.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input['SourceContextArgs']]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="fileHashes")
    def file_hashes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (.tar.gz), the FileHash will be for the single path to that file.
        """
        return pulumi.get(self, "file_hashes")

    @file_hashes.setter
    def file_hashes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "file_hashes", value)


@pulumi.input_type
class SourceContextArgs:
    def __init__(__self__, *,
                 cloud_repo: Optional[pulumi.Input['CloudRepoSourceContextArgs']] = None,
                 gerrit: Optional[pulumi.Input['GerritSourceContextArgs']] = None,
                 git: Optional[pulumi.Input['GitSourceContextArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A SourceContext is a reference to a tree of files. A SourceContext together with a path point to a unique revision of a single file or directory.
        :param pulumi.Input['CloudRepoSourceContextArgs'] cloud_repo: A SourceContext referring to a revision in a Google Cloud Source Repo.
        :param pulumi.Input['GerritSourceContextArgs'] gerrit: A SourceContext referring to a Gerrit project.
        :param pulumi.Input['GitSourceContextArgs'] git: A SourceContext referring to any third party Git repo (e.g., GitHub).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels with user defined metadata.
        """
        if cloud_repo is not None:
            pulumi.set(__self__, "cloud_repo", cloud_repo)
        if gerrit is not None:
            pulumi.set(__self__, "gerrit", gerrit)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter(name="cloudRepo")
    def cloud_repo(self) -> Optional[pulumi.Input['CloudRepoSourceContextArgs']]:
        """
        A SourceContext referring to a revision in a Google Cloud Source Repo.
        """
        return pulumi.get(self, "cloud_repo")

    @cloud_repo.setter
    def cloud_repo(self, value: Optional[pulumi.Input['CloudRepoSourceContextArgs']]):
        pulumi.set(self, "cloud_repo", value)

    @property
    @pulumi.getter
    def gerrit(self) -> Optional[pulumi.Input['GerritSourceContextArgs']]:
        """
        A SourceContext referring to a Gerrit project.
        """
        return pulumi.get(self, "gerrit")

    @gerrit.setter
    def gerrit(self, value: Optional[pulumi.Input['GerritSourceContextArgs']]):
        pulumi.set(self, "gerrit", value)

    @property
    @pulumi.getter
    def git(self) -> Optional[pulumi.Input['GitSourceContextArgs']]:
        """
        A SourceContext referring to any third party Git repo (e.g., GitHub).
        """
        return pulumi.get(self, "git")

    @git.setter
    def git(self, value: Optional[pulumi.Input['GitSourceContextArgs']]):
        pulumi.set(self, "git", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels with user defined metadata.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class StatusArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[int]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 message: Optional[pulumi.Input[str]] = None):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param pulumi.Input[int] code: The status code, which should be an enum value of google.rpc.Code.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param pulumi.Input[str] message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)


@pulumi.input_type
class VersionArgs:
    def __init__(__self__, *,
                 epoch: Optional[pulumi.Input[int]] = None,
                 inclusive: Optional[pulumi.Input[bool]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 revision: Optional[pulumi.Input[str]] = None):
        """
        Version contains structured information about the version of a package.
        :param pulumi.Input[int] epoch: Used to correct mistakes in the version numbering scheme.
        :param pulumi.Input[bool] inclusive: Whether this version is specifying part of an inclusive range. Grafeas does not have the capability to specify version ranges; instead we have fields that specify start version and end versions. At times this is insufficient - we also need to specify whether the version is included in the range or is excluded from the range. This boolean is expected to be set to true when the version is included in a range.
        :param pulumi.Input[str] kind: Required. Distinguishes between sentinel MIN/MAX versions and normal versions.
        :param pulumi.Input[str] name: Required only when version kind is NORMAL. The main part of the version name.
        :param pulumi.Input[str] revision: The iteration of the package build from the above version.
        """
        if epoch is not None:
            pulumi.set(__self__, "epoch", epoch)
        if inclusive is not None:
            pulumi.set(__self__, "inclusive", inclusive)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def epoch(self) -> Optional[pulumi.Input[int]]:
        """
        Used to correct mistakes in the version numbering scheme.
        """
        return pulumi.get(self, "epoch")

    @epoch.setter
    def epoch(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "epoch", value)

    @property
    @pulumi.getter
    def inclusive(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this version is specifying part of an inclusive range. Grafeas does not have the capability to specify version ranges; instead we have fields that specify start version and end versions. At times this is insufficient - we also need to specify whether the version is included in the range or is excluded from the range. This boolean is expected to be set to true when the version is included in a range.
        """
        return pulumi.get(self, "inclusive")

    @inclusive.setter
    def inclusive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "inclusive", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Distinguishes between sentinel MIN/MAX versions and normal versions.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required only when version kind is NORMAL. The main part of the version name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[str]]:
        """
        The iteration of the package build from the above version.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision", value)


@pulumi.input_type
class VulnerabilityArgs:
    def __init__(__self__, *,
                 cvss_score: Optional[pulumi.Input[float]] = None,
                 cvss_v3: Optional[pulumi.Input['CVSSv3Args']] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input['DetailArgs']]]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 source_update_time: Optional[pulumi.Input[str]] = None,
                 windows_details: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsDetailArgs']]]] = None):
        """
        Vulnerability provides metadata about a security vulnerability in a Note.
        :param pulumi.Input[float] cvss_score: The CVSS score for this vulnerability.
        :param pulumi.Input['CVSSv3Args'] cvss_v3: The full description of the CVSSv3.
        :param pulumi.Input[Sequence[pulumi.Input['DetailArgs']]] details: All information about the package to specifically identify this vulnerability. One entry per (version range and cpe_uri) the package vulnerability has manifested in.
        :param pulumi.Input[str] severity: Note provider assigned impact of the vulnerability.
        :param pulumi.Input[str] source_update_time: The time this information was last changed at the source. This is an upstream timestamp from the underlying information source - e.g. Ubuntu security tracker.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsDetailArgs']]] windows_details: Windows details get their own format because the information format and model don't match a normal detail. Specifically Windows updates are done as patches, thus Windows vulnerabilities really are a missing package, rather than a package being at an incorrect version.
        """
        if cvss_score is not None:
            pulumi.set(__self__, "cvss_score", cvss_score)
        if cvss_v3 is not None:
            pulumi.set(__self__, "cvss_v3", cvss_v3)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if source_update_time is not None:
            pulumi.set(__self__, "source_update_time", source_update_time)
        if windows_details is not None:
            pulumi.set(__self__, "windows_details", windows_details)

    @property
    @pulumi.getter(name="cvssScore")
    def cvss_score(self) -> Optional[pulumi.Input[float]]:
        """
        The CVSS score for this vulnerability.
        """
        return pulumi.get(self, "cvss_score")

    @cvss_score.setter
    def cvss_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cvss_score", value)

    @property
    @pulumi.getter(name="cvssV3")
    def cvss_v3(self) -> Optional[pulumi.Input['CVSSv3Args']]:
        """
        The full description of the CVSSv3.
        """
        return pulumi.get(self, "cvss_v3")

    @cvss_v3.setter
    def cvss_v3(self, value: Optional[pulumi.Input['CVSSv3Args']]):
        pulumi.set(self, "cvss_v3", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetailArgs']]]]:
        """
        All information about the package to specifically identify this vulnerability. One entry per (version range and cpe_uri) the package vulnerability has manifested in.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetailArgs']]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[str]]:
        """
        Note provider assigned impact of the vulnerability.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter(name="sourceUpdateTime")
    def source_update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time this information was last changed at the source. This is an upstream timestamp from the underlying information source - e.g. Ubuntu security tracker.
        """
        return pulumi.get(self, "source_update_time")

    @source_update_time.setter
    def source_update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_update_time", value)

    @property
    @pulumi.getter(name="windowsDetails")
    def windows_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsDetailArgs']]]]:
        """
        Windows details get their own format because the information format and model don't match a normal detail. Specifically Windows updates are done as patches, thus Windows vulnerabilities really are a missing package, rather than a package being at an incorrect version.
        """
        return pulumi.get(self, "windows_details")

    @windows_details.setter
    def windows_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsDetailArgs']]]]):
        pulumi.set(self, "windows_details", value)


@pulumi.input_type
class VulnerabilityLocationArgs:
    def __init__(__self__, *,
                 cpe_uri: Optional[pulumi.Input[str]] = None,
                 package: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input['VersionArgs']] = None):
        """
        The location of the vulnerability.
        :param pulumi.Input[str] cpe_uri: Required. The CPE URI in [cpe format](https://cpe.mitre.org/specification/) format. Examples include distro or storage location for vulnerable jar.
        :param pulumi.Input[str] package: Required. The package being described.
        :param pulumi.Input['VersionArgs'] version: Required. The version of the package being described.
        """
        if cpe_uri is not None:
            pulumi.set(__self__, "cpe_uri", cpe_uri)
        if package is not None:
            pulumi.set(__self__, "package", package)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The CPE URI in [cpe format](https://cpe.mitre.org/specification/) format. Examples include distro or storage location for vulnerable jar.
        """
        return pulumi.get(self, "cpe_uri")

    @cpe_uri.setter
    def cpe_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpe_uri", value)

    @property
    @pulumi.getter
    def package(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The package being described.
        """
        return pulumi.get(self, "package")

    @package.setter
    def package(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        Required. The version of the package being described.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class WindowsDetailArgs:
    def __init__(__self__, *,
                 cpe_uri: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fixing_kbs: Optional[pulumi.Input[Sequence[pulumi.Input['KnowledgeBaseArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cpe_uri: Required. The CPE URI in [cpe format](https://cpe.mitre.org/specification/) in which the vulnerability manifests. Examples include distro or storage location for vulnerable jar.
        :param pulumi.Input[str] description: The description of the vulnerability.
        :param pulumi.Input[Sequence[pulumi.Input['KnowledgeBaseArgs']]] fixing_kbs: Required. The names of the KBs which have hotfixes to mitigate this vulnerability. Note that there may be multiple hotfixes (and thus multiple KBs) that mitigate a given vulnerability. Currently any listed kb's presence is considered a fix.
        :param pulumi.Input[str] name: Required. The name of the vulnerability.
        """
        if cpe_uri is not None:
            pulumi.set(__self__, "cpe_uri", cpe_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fixing_kbs is not None:
            pulumi.set(__self__, "fixing_kbs", fixing_kbs)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The CPE URI in [cpe format](https://cpe.mitre.org/specification/) in which the vulnerability manifests. Examples include distro or storage location for vulnerable jar.
        """
        return pulumi.get(self, "cpe_uri")

    @cpe_uri.setter
    def cpe_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpe_uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the vulnerability.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fixingKbs")
    def fixing_kbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KnowledgeBaseArgs']]]]:
        """
        Required. The names of the KBs which have hotfixes to mitigate this vulnerability. Note that there may be multiple hotfixes (and thus multiple KBs) that mitigate a given vulnerability. Currently any listed kb's presence is considered a fix.
        """
        return pulumi.get(self, "fixing_kbs")

    @fixing_kbs.setter
    def fixing_kbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KnowledgeBaseArgs']]]]):
        pulumi.set(self, "fixing_kbs", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The name of the vulnerability.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


