# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ProviderNote']


class ProviderNote(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attestation_authority: Optional[pulumi.Input[pulumi.InputType['AttestationAuthorityArgs']]] = None,
                 base_image: Optional[pulumi.Input[pulumi.InputType['BasisArgs']]] = None,
                 build_type: Optional[pulumi.Input[pulumi.InputType['BuildTypeArgs']]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 deployable: Optional[pulumi.Input[pulumi.InputType['DeployableArgs']]] = None,
                 discovery: Optional[pulumi.Input[pulumi.InputType['DiscoveryArgs']]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 long_description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notes_id: Optional[pulumi.Input[str]] = None,
                 package: Optional[pulumi.Input[pulumi.InputType['PackageArgs']]] = None,
                 providers_id: Optional[pulumi.Input[str]] = None,
                 related_url: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RelatedUrlArgs']]]]] = None,
                 short_description: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 upgrade: Optional[pulumi.Input[pulumi.InputType['UpgradeNoteArgs']]] = None,
                 vulnerability_type: Optional[pulumi.Input[pulumi.InputType['VulnerabilityTypeArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a new `Note`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AttestationAuthorityArgs']] attestation_authority: A note describing an attestation role.
        :param pulumi.Input[pulumi.InputType['BasisArgs']] base_image: A note describing a base image.
        :param pulumi.Input[pulumi.InputType['BuildTypeArgs']] build_type: Build provenance type for a verifiable build.
        :param pulumi.Input[str] create_time: The time this note was created. This field can be used as a filter in list requests.
        :param pulumi.Input[pulumi.InputType['DeployableArgs']] deployable: A note describing something that can be deployed.
        :param pulumi.Input[pulumi.InputType['DiscoveryArgs']] discovery: A note describing a provider/analysis type.
        :param pulumi.Input[str] expiration_time: Time of expiration for this note, null if note does not expire.
        :param pulumi.Input[str] kind: This explicitly denotes which kind of note is specified. This field can be used as a filter in list requests.
        :param pulumi.Input[str] long_description: A detailed description of this `Note`.
        :param pulumi.Input[str] name: The name of the note in the form "projects/{provider_project_id}/notes/{NOTE_ID}"
        :param pulumi.Input[pulumi.InputType['PackageArgs']] package: A note describing a package hosted by various package managers.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RelatedUrlArgs']]]] related_url: URLs associated with this note
        :param pulumi.Input[str] short_description: A one sentence description of this `Note`.
        :param pulumi.Input[str] update_time: The time this note was last updated. This field can be used as a filter in list requests.
        :param pulumi.Input[pulumi.InputType['UpgradeNoteArgs']] upgrade: A note describing an upgrade.
        :param pulumi.Input[pulumi.InputType['VulnerabilityTypeArgs']] vulnerability_type: A package vulnerability type of note.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['attestation_authority'] = attestation_authority
            __props__['base_image'] = base_image
            __props__['build_type'] = build_type
            __props__['create_time'] = create_time
            __props__['deployable'] = deployable
            __props__['discovery'] = discovery
            __props__['expiration_time'] = expiration_time
            __props__['kind'] = kind
            __props__['long_description'] = long_description
            __props__['name'] = name
            if notes_id is None and not opts.urn:
                raise TypeError("Missing required property 'notes_id'")
            __props__['notes_id'] = notes_id
            __props__['package'] = package
            if providers_id is None and not opts.urn:
                raise TypeError("Missing required property 'providers_id'")
            __props__['providers_id'] = providers_id
            __props__['related_url'] = related_url
            __props__['short_description'] = short_description
            __props__['update_time'] = update_time
            __props__['upgrade'] = upgrade
            __props__['vulnerability_type'] = vulnerability_type
        super(ProviderNote, __self__).__init__(
            'gcp-native:containeranalysis/v1alpha1:ProviderNote',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ProviderNote':
        """
        Get an existing ProviderNote resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["attestation_authority"] = None
        __props__["base_image"] = None
        __props__["build_type"] = None
        __props__["create_time"] = None
        __props__["deployable"] = None
        __props__["discovery"] = None
        __props__["expiration_time"] = None
        __props__["kind"] = None
        __props__["long_description"] = None
        __props__["name"] = None
        __props__["package"] = None
        __props__["related_url"] = None
        __props__["short_description"] = None
        __props__["update_time"] = None
        __props__["upgrade"] = None
        __props__["vulnerability_type"] = None
        return ProviderNote(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attestationAuthority")
    def attestation_authority(self) -> pulumi.Output['outputs.AttestationAuthorityResponse']:
        """
        A note describing an attestation role.
        """
        return pulumi.get(self, "attestation_authority")

    @property
    @pulumi.getter(name="baseImage")
    def base_image(self) -> pulumi.Output['outputs.BasisResponse']:
        """
        A note describing a base image.
        """
        return pulumi.get(self, "base_image")

    @property
    @pulumi.getter(name="buildType")
    def build_type(self) -> pulumi.Output['outputs.BuildTypeResponse']:
        """
        Build provenance type for a verifiable build.
        """
        return pulumi.get(self, "build_type")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time this note was created. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def deployable(self) -> pulumi.Output['outputs.DeployableResponse']:
        """
        A note describing something that can be deployed.
        """
        return pulumi.get(self, "deployable")

    @property
    @pulumi.getter
    def discovery(self) -> pulumi.Output['outputs.DiscoveryResponse']:
        """
        A note describing a provider/analysis type.
        """
        return pulumi.get(self, "discovery")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> pulumi.Output[str]:
        """
        Time of expiration for this note, null if note does not expire.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        This explicitly denotes which kind of note is specified. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="longDescription")
    def long_description(self) -> pulumi.Output[str]:
        """
        A detailed description of this `Note`.
        """
        return pulumi.get(self, "long_description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the note in the form "projects/{provider_project_id}/notes/{NOTE_ID}"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def package(self) -> pulumi.Output['outputs.PackageResponse']:
        """
        A note describing a package hosted by various package managers.
        """
        return pulumi.get(self, "package")

    @property
    @pulumi.getter(name="relatedUrl")
    def related_url(self) -> pulumi.Output[Sequence['outputs.RelatedUrlResponse']]:
        """
        URLs associated with this note
        """
        return pulumi.get(self, "related_url")

    @property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> pulumi.Output[str]:
        """
        A one sentence description of this `Note`.
        """
        return pulumi.get(self, "short_description")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time this note was last updated. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def upgrade(self) -> pulumi.Output['outputs.UpgradeNoteResponse']:
        """
        A note describing an upgrade.
        """
        return pulumi.get(self, "upgrade")

    @property
    @pulumi.getter(name="vulnerabilityType")
    def vulnerability_type(self) -> pulumi.Output['outputs.VulnerabilityTypeResponse']:
        """
        A package vulnerability type of note.
        """
        return pulumi.get(self, "vulnerability_type")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

