# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Job']


class Job(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[pulumi.InputType['JobConfigurationArgs']]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 job_id: Optional[pulumi.Input[str]] = None,
                 job_reference: Optional[pulumi.Input[pulumi.InputType['JobReferenceArgs']]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 statistics: Optional[pulumi.Input[pulumi.InputType['JobStatisticsArgs']]] = None,
                 status: Optional[pulumi.Input[pulumi.InputType['JobStatusArgs']]] = None,
                 user_email: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Starts a new asynchronous job. Requires the Can View project role.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['JobConfigurationArgs']] configuration: [Required] Describes the job configuration.
        :param pulumi.Input[str] etag: [Output-only] A hash of this resource.
        :param pulumi.Input[str] id: [Output-only] Opaque ID field of the job
        :param pulumi.Input[pulumi.InputType['JobReferenceArgs']] job_reference: [Optional] Reference describing the unique-per-user name of the job.
        :param pulumi.Input[str] kind: [Output-only] The type of the resource.
        :param pulumi.Input[str] self_link: [Output-only] A URL that can be used to access this resource again.
        :param pulumi.Input[pulumi.InputType['JobStatisticsArgs']] statistics: [Output-only] Information about the job, including starting time and ending time of the job.
        :param pulumi.Input[pulumi.InputType['JobStatusArgs']] status: [Output-only] The status of this job. Examine this value when polling an asynchronous job to see if the job is complete.
        :param pulumi.Input[str] user_email: [Output-only] Email address of the user who ran the job.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['configuration'] = configuration
            __props__['etag'] = etag
            __props__['id'] = id
            if job_id is None and not opts.urn:
                raise TypeError("Missing required property 'job_id'")
            __props__['job_id'] = job_id
            __props__['job_reference'] = job_reference
            __props__['kind'] = kind
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__['project_id'] = project_id
            __props__['self_link'] = self_link
            __props__['statistics'] = statistics
            __props__['status'] = status
            __props__['user_email'] = user_email
        super(Job, __self__).__init__(
            'gcp-native:bigquery/v2:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["configuration"] = None
        __props__["etag"] = None
        __props__["job_reference"] = None
        __props__["kind"] = None
        __props__["self_link"] = None
        __props__["statistics"] = None
        __props__["status"] = None
        __props__["user_email"] = None
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output['outputs.JobConfigurationResponse']:
        """
        [Required] Describes the job configuration.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        [Output-only] A hash of this resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="jobReference")
    def job_reference(self) -> pulumi.Output['outputs.JobReferenceResponse']:
        """
        [Optional] Reference describing the unique-per-user name of the job.
        """
        return pulumi.get(self, "job_reference")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        [Output-only] The type of the resource.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        [Output-only] A URL that can be used to access this resource again.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def statistics(self) -> pulumi.Output['outputs.JobStatisticsResponse']:
        """
        [Output-only] Information about the job, including starting time and ending time of the job.
        """
        return pulumi.get(self, "statistics")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['outputs.JobStatusResponse']:
        """
        [Output-only] The status of this job. Examine this value when polling an asynchronous job to see if the job is complete.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def user_email(self) -> pulumi.Output[str]:
        """
        [Output-only] Email address of the user who ran the job.
        """
        return pulumi.get(self, "user_email")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

