# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['AppDomainMapping']


class AppDomainMapping(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apps_id: Optional[pulumi.Input[str]] = None,
                 domain_mappings_id: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_records: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ResourceRecordArgs']]]]] = None,
                 ssl_settings: Optional[pulumi.Input[pulumi.InputType['SslSettingsArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Maps a domain to an application. A user must be authorized to administer a domain in order to map it to an application. For a list of available authorized domains, see AuthorizedDomains.ListAuthorizedDomains.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] id: Relative name of the domain serving the application. Example: example.com.
        :param pulumi.Input[str] name: Full path to the DomainMapping resource in the API. Example: apps/myapp/domainMapping/example.com.@OutputOnly
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ResourceRecordArgs']]]] resource_records: The resource records required to configure this domain mapping. These records must be added to the domain's DNS configuration in order to serve the application via this domain mapping.@OutputOnly
        :param pulumi.Input[pulumi.InputType['SslSettingsArgs']] ssl_settings: SSL configuration for this domain. If unconfigured, this domain will not serve with SSL.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if apps_id is None and not opts.urn:
                raise TypeError("Missing required property 'apps_id'")
            __props__['apps_id'] = apps_id
            if domain_mappings_id is None and not opts.urn:
                raise TypeError("Missing required property 'domain_mappings_id'")
            __props__['domain_mappings_id'] = domain_mappings_id
            __props__['id'] = id
            __props__['name'] = name
            __props__['resource_records'] = resource_records
            __props__['ssl_settings'] = ssl_settings
        super(AppDomainMapping, __self__).__init__(
            'gcp-native:appengine/v1:AppDomainMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AppDomainMapping':
        """
        Get an existing AppDomainMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["name"] = None
        __props__["resource_records"] = None
        __props__["ssl_settings"] = None
        return AppDomainMapping(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Full path to the DomainMapping resource in the API. Example: apps/myapp/domainMapping/example.com.@OutputOnly
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceRecords")
    def resource_records(self) -> pulumi.Output[Sequence['outputs.ResourceRecordResponse']]:
        """
        The resource records required to configure this domain mapping. These records must be added to the domain's DNS configuration in order to serve the application via this domain mapping.@OutputOnly
        """
        return pulumi.get(self, "resource_records")

    @property
    @pulumi.getter(name="sslSettings")
    def ssl_settings(self) -> pulumi.Output['outputs.SslSettingsResponse']:
        """
        SSL configuration for this domain. If unconfigured, this domain will not serve with SSL.
        """
        return pulumi.get(self, "ssl_settings")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

