# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['App']


class App(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apps_id: Optional[pulumi.Input[str]] = None,
                 auth_domain: Optional[pulumi.Input[str]] = None,
                 code_bucket: Optional[pulumi.Input[str]] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 default_bucket: Optional[pulumi.Input[str]] = None,
                 default_cookie_expiration: Optional[pulumi.Input[str]] = None,
                 default_hostname: Optional[pulumi.Input[str]] = None,
                 dispatch_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UrlDispatchRuleArgs']]]]] = None,
                 feature_settings: Optional[pulumi.Input[pulumi.InputType['FeatureSettingsArgs']]] = None,
                 gcr_domain: Optional[pulumi.Input[str]] = None,
                 iap: Optional[pulumi.Input[pulumi.InputType['IdentityAwareProxyArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 serving_status: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates an App Engine application for a Google Cloud Platform project. Required fields: id - The ID of the target Cloud Platform project. location - The region (https://cloud.google.com/appengine/docs/locations) where you want the App Engine application located.For more information about App Engine applications, see Managing Projects, Applications, and Billing (https://cloud.google.com/appengine/docs/standard/python/console/).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth_domain: Google Apps authentication domain that controls which users can access this application.Defaults to open access for any Google Account.
        :param pulumi.Input[str] code_bucket: Google Cloud Storage bucket that can be used for storing files associated with this application. This bucket is associated with the application and can be used by the gcloud deployment commands.@OutputOnly
        :param pulumi.Input[str] database_type: The type of the Cloud Firestore or Cloud Datastore database associated with this application.
        :param pulumi.Input[str] default_bucket: Google Cloud Storage bucket that can be used by this application to store content.@OutputOnly
        :param pulumi.Input[str] default_cookie_expiration: Cookie expiration policy for this application.
        :param pulumi.Input[str] default_hostname: Hostname used to reach this application, as resolved by App Engine.@OutputOnly
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UrlDispatchRuleArgs']]]] dispatch_rules: HTTP path dispatch rules for requests to the application that do not explicitly target a service or version. Rules are order-dependent. Up to 20 dispatch rules can be supported.
        :param pulumi.Input[pulumi.InputType['FeatureSettingsArgs']] feature_settings: The feature specific settings to be used in the application.
        :param pulumi.Input[str] gcr_domain: The Google Container Registry domain used for storing managed build docker images for this application.
        :param pulumi.Input[str] id: Identifier of the Application resource. This identifier is equivalent to the project ID of the Google Cloud Platform project where you want to deploy your application. Example: myapp.
        :param pulumi.Input[str] location_id: Location from which this application runs. Application instances run out of the data centers in the specified location, which is also where all of the application's end user content is stored.Defaults to us-central.View the list of supported locations (https://cloud.google.com/appengine/docs/locations).
        :param pulumi.Input[str] name: Full path to the Application resource in the API. Example: apps/myapp.@OutputOnly
        :param pulumi.Input[str] serving_status: Serving status of this application.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if apps_id is None and not opts.urn:
                raise TypeError("Missing required property 'apps_id'")
            __props__['apps_id'] = apps_id
            __props__['auth_domain'] = auth_domain
            __props__['code_bucket'] = code_bucket
            __props__['database_type'] = database_type
            __props__['default_bucket'] = default_bucket
            __props__['default_cookie_expiration'] = default_cookie_expiration
            __props__['default_hostname'] = default_hostname
            __props__['dispatch_rules'] = dispatch_rules
            __props__['feature_settings'] = feature_settings
            __props__['gcr_domain'] = gcr_domain
            __props__['iap'] = iap
            __props__['id'] = id
            __props__['location_id'] = location_id
            __props__['name'] = name
            __props__['serving_status'] = serving_status
        super(App, __self__).__init__(
            'gcp-native:appengine/v1:App',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'App':
        """
        Get an existing App resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["auth_domain"] = None
        __props__["code_bucket"] = None
        __props__["database_type"] = None
        __props__["default_bucket"] = None
        __props__["default_cookie_expiration"] = None
        __props__["default_hostname"] = None
        __props__["dispatch_rules"] = None
        __props__["feature_settings"] = None
        __props__["gcr_domain"] = None
        __props__["iap"] = None
        __props__["location_id"] = None
        __props__["name"] = None
        __props__["serving_status"] = None
        return App(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authDomain")
    def auth_domain(self) -> pulumi.Output[str]:
        """
        Google Apps authentication domain that controls which users can access this application.Defaults to open access for any Google Account.
        """
        return pulumi.get(self, "auth_domain")

    @property
    @pulumi.getter(name="codeBucket")
    def code_bucket(self) -> pulumi.Output[str]:
        """
        Google Cloud Storage bucket that can be used for storing files associated with this application. This bucket is associated with the application and can be used by the gcloud deployment commands.@OutputOnly
        """
        return pulumi.get(self, "code_bucket")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Output[str]:
        """
        The type of the Cloud Firestore or Cloud Datastore database associated with this application.
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="defaultBucket")
    def default_bucket(self) -> pulumi.Output[str]:
        """
        Google Cloud Storage bucket that can be used by this application to store content.@OutputOnly
        """
        return pulumi.get(self, "default_bucket")

    @property
    @pulumi.getter(name="defaultCookieExpiration")
    def default_cookie_expiration(self) -> pulumi.Output[str]:
        """
        Cookie expiration policy for this application.
        """
        return pulumi.get(self, "default_cookie_expiration")

    @property
    @pulumi.getter(name="defaultHostname")
    def default_hostname(self) -> pulumi.Output[str]:
        """
        Hostname used to reach this application, as resolved by App Engine.@OutputOnly
        """
        return pulumi.get(self, "default_hostname")

    @property
    @pulumi.getter(name="dispatchRules")
    def dispatch_rules(self) -> pulumi.Output[Sequence['outputs.UrlDispatchRuleResponse']]:
        """
        HTTP path dispatch rules for requests to the application that do not explicitly target a service or version. Rules are order-dependent. Up to 20 dispatch rules can be supported.
        """
        return pulumi.get(self, "dispatch_rules")

    @property
    @pulumi.getter(name="featureSettings")
    def feature_settings(self) -> pulumi.Output['outputs.FeatureSettingsResponse']:
        """
        The feature specific settings to be used in the application.
        """
        return pulumi.get(self, "feature_settings")

    @property
    @pulumi.getter(name="gcrDomain")
    def gcr_domain(self) -> pulumi.Output[str]:
        """
        The Google Container Registry domain used for storing managed build docker images for this application.
        """
        return pulumi.get(self, "gcr_domain")

    @property
    @pulumi.getter
    def iap(self) -> pulumi.Output['outputs.IdentityAwareProxyResponse']:
        return pulumi.get(self, "iap")

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> pulumi.Output[str]:
        """
        Location from which this application runs. Application instances run out of the data centers in the specified location, which is also where all of the application's end user content is stored.Defaults to us-central.View the list of supported locations (https://cloud.google.com/appengine/docs/locations).
        """
        return pulumi.get(self, "location_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Full path to the Application resource in the API. Example: apps/myapp.@OutputOnly
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="servingStatus")
    def serving_status(self) -> pulumi.Output[str]:
        """
        Serving status of this application.
        """
        return pulumi.get(self, "serving_status")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

