# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['OrganizationEnvironmentQuery']


class OrganizationEnvironmentQuery(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 csv_delimiter: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 envgroup_hostname: Optional[pulumi.Input[str]] = None,
                 environments_id: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 group_by_time_unit: Optional[pulumi.Input[str]] = None,
                 limit: Optional[pulumi.Input[int]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1QueryMetricArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organizations_id: Optional[pulumi.Input[str]] = None,
                 output_format: Optional[pulumi.Input[str]] = None,
                 queries_id: Optional[pulumi.Input[str]] = None,
                 report_definition_id: Optional[pulumi.Input[str]] = None,
                 time_range: Optional[Any] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Submit a query to be processed in the background. If the submission of the query succeeds, the API returns a 201 status and an ID that refer to the query. In addition to the HTTP status 201, the `state` of "enqueued" means that the request succeeded.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] csv_delimiter: Delimiter used in the CSV file, if `outputFormat` is set to `csv`. Defaults to the `,` (comma) character. Supported delimiter characters include comma (`,`), pipe (`|`), and tab (`\t`).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dimensions: A list of dimensions. https://docs.apigee.com/api-platform/analytics/analytics-reference#dimensions
        :param pulumi.Input[str] envgroup_hostname: Hostname needs to be specified if query intends to run at host level. This field is only allowed when query is submitted by CreateHostAsyncQuery where analytics data will be grouped by organization and hostname.
        :param pulumi.Input[str] filter: Boolean expression that can be used to filter data. Filter expressions can be combined using AND/OR terms and should be fully parenthesized to avoid ambiguity. See Analytics metrics, dimensions, and filters reference https://docs.apigee.com/api-platform/analytics/analytics-reference for more information on the fields available to filter on. For more information on the tokens that you use to build filter expressions, see Filter expression syntax. https://docs.apigee.com/api-platform/analytics/asynch-reports-api#filter-expression-syntax
        :param pulumi.Input[str] group_by_time_unit: Time unit used to group the result set. Valid values include: second, minute, hour, day, week, or month. If a query includes groupByTimeUnit, then the result is an aggregation based on the specified time unit and the resultant timestamp does not include milliseconds precision. If a query omits groupByTimeUnit, then the resultant timestamp includes milliseconds precision.
        :param pulumi.Input[int] limit: Maximum number of rows that can be returned in the result.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1QueryMetricArgs']]]] metrics: A list of Metrics.
        :param pulumi.Input[str] name: Asynchronous Query Name.
        :param pulumi.Input[str] output_format: Valid values include: `csv` or `json`. Defaults to `json`. Note: Configure the delimiter for CSV output using the csvDelimiter property.
        :param pulumi.Input[str] report_definition_id: Asynchronous Report ID.
        :param Any time_range: Required. Time range for the query. Can use the following predefined strings to specify the time range: `last60minutes` `last24hours` `last7days` Or, specify the timeRange as a structure describing start and end timestamps in the ISO format: yyyy-mm-ddThh:mm:ssZ. Example: "timeRange": { "start": "2018-07-29T00:13:00Z", "end": "2018-08-01T00:18:00Z" }
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['csv_delimiter'] = csv_delimiter
            __props__['dimensions'] = dimensions
            __props__['envgroup_hostname'] = envgroup_hostname
            if environments_id is None and not opts.urn:
                raise TypeError("Missing required property 'environments_id'")
            __props__['environments_id'] = environments_id
            __props__['filter'] = filter
            __props__['group_by_time_unit'] = group_by_time_unit
            __props__['limit'] = limit
            __props__['metrics'] = metrics
            __props__['name'] = name
            if organizations_id is None and not opts.urn:
                raise TypeError("Missing required property 'organizations_id'")
            __props__['organizations_id'] = organizations_id
            __props__['output_format'] = output_format
            if queries_id is None and not opts.urn:
                raise TypeError("Missing required property 'queries_id'")
            __props__['queries_id'] = queries_id
            __props__['report_definition_id'] = report_definition_id
            __props__['time_range'] = time_range
            __props__['created'] = None
            __props__['error'] = None
            __props__['execution_time'] = None
            __props__['query_params'] = None
            __props__['result'] = None
            __props__['result_file_size'] = None
            __props__['result_rows'] = None
            __props__['self'] = None
            __props__['state'] = None
            __props__['updated'] = None
        super(OrganizationEnvironmentQuery, __self__).__init__(
            'gcp-native:apigee/v1:OrganizationEnvironmentQuery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'OrganizationEnvironmentQuery':
        """
        Get an existing OrganizationEnvironmentQuery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["created"] = None
        __props__["envgroup_hostname"] = None
        __props__["error"] = None
        __props__["execution_time"] = None
        __props__["name"] = None
        __props__["query_params"] = None
        __props__["report_definition_id"] = None
        __props__["result"] = None
        __props__["result_file_size"] = None
        __props__["result_rows"] = None
        __props__["self"] = None
        __props__["state"] = None
        __props__["updated"] = None
        return OrganizationEnvironmentQuery(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        """
        Creation time of the query.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="envgroupHostname")
    def envgroup_hostname(self) -> pulumi.Output[str]:
        """
        Hostname is available only when query is executed at host level.
        """
        return pulumi.get(self, "envgroup_hostname")

    @property
    @pulumi.getter
    def error(self) -> pulumi.Output[str]:
        """
        Error is set when query fails.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="executionTime")
    def execution_time(self) -> pulumi.Output[str]:
        """
        ExecutionTime is available only after the query is completed.
        """
        return pulumi.get(self, "execution_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Asynchronous Query Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="queryParams")
    def query_params(self) -> pulumi.Output['outputs.GoogleCloudApigeeV1QueryMetadataResponse']:
        """
        Contains information like metrics, dimenstions etc of the AsyncQuery.
        """
        return pulumi.get(self, "query_params")

    @property
    @pulumi.getter(name="reportDefinitionId")
    def report_definition_id(self) -> pulumi.Output[str]:
        """
        Asynchronous Report ID.
        """
        return pulumi.get(self, "report_definition_id")

    @property
    @pulumi.getter
    def result(self) -> pulumi.Output['outputs.GoogleCloudApigeeV1AsyncQueryResultResponse']:
        """
        Result is available only after the query is completed.
        """
        return pulumi.get(self, "result")

    @property
    @pulumi.getter(name="resultFileSize")
    def result_file_size(self) -> pulumi.Output[str]:
        """
        ResultFileSize is available only after the query is completed.
        """
        return pulumi.get(self, "result_file_size")

    @property
    @pulumi.getter(name="resultRows")
    def result_rows(self) -> pulumi.Output[str]:
        """
        ResultRows is available only after the query is completed.
        """
        return pulumi.get(self, "result_rows")

    @property
    @pulumi.getter
    def self(self) -> pulumi.Output[str]:
        """
        Self link of the query. Example: `/organizations/myorg/environments/myenv/queries/9cfc0d85-0f30-46d6-ae6f-318d0cb961bd` or following format if query is running at host level: `/organizations/myorg/hostQueries/9cfc0d85-0f30-46d6-ae6f-318d0cb961bd`
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Query state could be "enqueued", "running", "completed", "failed".
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[str]:
        """
        Last updated timestamp for the query.
        """
        return pulumi.get(self, "updated")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

