# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = [
    'GoogleCloudApigeeV1AttributeArgs',
    'GoogleCloudApigeeV1CanaryEvaluationMetricLabelsArgs',
    'GoogleCloudApigeeV1CustomReportMetricArgs',
    'GoogleCloudApigeeV1DatastoreConfigArgs',
    'GoogleCloudApigeeV1DateRangeArgs',
    'GoogleCloudApigeeV1GraphQLOperationArgs',
    'GoogleCloudApigeeV1GraphQLOperationConfigArgs',
    'GoogleCloudApigeeV1GraphQLOperationGroupArgs',
    'GoogleCloudApigeeV1OperationArgs',
    'GoogleCloudApigeeV1OperationConfigArgs',
    'GoogleCloudApigeeV1OperationGroupArgs',
    'GoogleCloudApigeeV1PropertiesArgs',
    'GoogleCloudApigeeV1PropertyArgs',
    'GoogleCloudApigeeV1QueryMetricArgs',
    'GoogleCloudApigeeV1QuotaArgs',
    'GoogleCloudApigeeV1ReportPropertyArgs',
    'GoogleCloudApigeeV1TlsInfoArgs',
    'GoogleCloudApigeeV1TlsInfoCommonNameArgs',
    'GoogleCloudApigeeV1TraceSamplingConfigArgs',
    'GoogleIamV1AuditConfigArgs',
    'GoogleIamV1AuditLogConfigArgs',
    'GoogleIamV1BindingArgs',
    'GoogleTypeExprArgs',
]

@pulumi.input_type
class GoogleCloudApigeeV1AttributeArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Key-value pair to store extra metadata.
        :param pulumi.Input[str] name: API key of the attribute.
        :param pulumi.Input[str] value: Value of the attribute.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        API key of the attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of the attribute.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GoogleCloudApigeeV1CanaryEvaluationMetricLabelsArgs:
    def __init__(__self__, *,
                 env: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None):
        """
        Labels that can be used to filter Apigee metrics.
        :param pulumi.Input[str] env: The environment ID associated with the metrics.
        :param pulumi.Input[str] instance_id: Required. The instance ID associated with the metrics. In Apigee Hybrid, the value is configured during installation.
        :param pulumi.Input[str] location: Required. The location associated with the metrics.
        """
        if env is not None:
            pulumi.set(__self__, "env", env)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[str]]:
        """
        The environment ID associated with the metrics.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The instance ID associated with the metrics. In Apigee Hybrid, the value is configured during installation.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The location associated with the metrics.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class GoogleCloudApigeeV1CustomReportMetricArgs:
    def __init__(__self__, *,
                 function: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        This encapsulates a metric property of the form sum(message_count) where name is message_count and function is sum
        :param pulumi.Input[str] function: aggregate function
        :param pulumi.Input[str] name: name of the metric
        """
        if function is not None:
            pulumi.set(__self__, "function", function)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[str]]:
        """
        aggregate function
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the metric
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class GoogleCloudApigeeV1DatastoreConfigArgs:
    def __init__(__self__, *,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 dataset_name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 table_prefix: Optional[pulumi.Input[str]] = None):
        """
        Configuration detail for datastore
        :param pulumi.Input[str] bucket_name: Name of the Cloud Storage bucket. Required for `gcs` target_type.
        :param pulumi.Input[str] dataset_name: BigQuery dataset name Required for `bigquery` target_type.
        :param pulumi.Input[str] path: Path of Cloud Storage bucket Required for `gcs` target_type.
        :param pulumi.Input[str] project_id: Required. GCP project in which the datastore exists
        :param pulumi.Input[str] table_prefix: Prefix of BigQuery table Required for `bigquery` target_type.
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if dataset_name is not None:
            pulumi.set(__self__, "dataset_name", dataset_name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if table_prefix is not None:
            pulumi.set(__self__, "table_prefix", table_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Cloud Storage bucket. Required for `gcs` target_type.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> Optional[pulumi.Input[str]]:
        """
        BigQuery dataset name Required for `bigquery` target_type.
        """
        return pulumi.get(self, "dataset_name")

    @dataset_name.setter
    def dataset_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path of Cloud Storage bucket Required for `gcs` target_type.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. GCP project in which the datastore exists
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="tablePrefix")
    def table_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix of BigQuery table Required for `bigquery` target_type.
        """
        return pulumi.get(self, "table_prefix")

    @table_prefix.setter
    def table_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_prefix", value)


@pulumi.input_type
class GoogleCloudApigeeV1DateRangeArgs:
    def __init__(__self__, *,
                 end: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[str]] = None):
        """
        Date range of the data to export.
        :param pulumi.Input[str] end: Required. End date (exclusive) of the data to export in the format `yyyy-mm-dd`. The date range ends at 00:00:00 UTC on the end date- which will not be in the output.
        :param pulumi.Input[str] start: Required. Start date of the data to export in the format `yyyy-mm-dd`. The date range begins at 00:00:00 UTC on the start date.
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[str]]:
        """
        Required. End date (exclusive) of the data to export in the format `yyyy-mm-dd`. The date range ends at 00:00:00 UTC on the end date- which will not be in the output.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Start date of the data to export in the format `yyyy-mm-dd`. The date range begins at 00:00:00 UTC on the start date.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class GoogleCloudApigeeV1GraphQLOperationArgs:
    def __init__(__self__, *,
                 operation: Optional[pulumi.Input[str]] = None,
                 operation_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        GraphQLOperation represents the pairing of graphQL operation types and the graphQL operation name.
        :param pulumi.Input[str] operation: GraphQL operation name, along with operation type which will be used to associate quotas with. If no name is specified, the quota will be applied to all graphQL operations irrespective of their operation names in the payload.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] operation_types: Required. `query`, `mutation` and `subscription` are the three operation types offered by graphQL. Currently we support only `query` and `mutation`.
        """
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if operation_types is not None:
            pulumi.set(__self__, "operation_types", operation_types)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[str]]:
        """
        GraphQL operation name, along with operation type which will be used to associate quotas with. If no name is specified, the quota will be applied to all graphQL operations irrespective of their operation names in the payload.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter(name="operationTypes")
    def operation_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required. `query`, `mutation` and `subscription` are the three operation types offered by graphQL. Currently we support only `query` and `mutation`.
        """
        return pulumi.get(self, "operation_types")

    @operation_types.setter
    def operation_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "operation_types", value)


@pulumi.input_type
class GoogleCloudApigeeV1GraphQLOperationConfigArgs:
    def __init__(__self__, *,
                 api_source: Optional[pulumi.Input[str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationArgs']]]] = None,
                 quota: Optional[pulumi.Input['GoogleCloudApigeeV1QuotaArgs']] = None):
        """
        GraphQLOperationConfig binds the resources in a proxy or remote service with the graphQL operation and its associated quota enforcement.
        :param pulumi.Input[str] api_source: Required. API proxy endpoint or remote service name with which the graphQL operation, and quota are associated.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]] attributes: Custom attributes associated with the operation.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationArgs']]] operations: Required. List of graphQL name/Operation type pairs for the proxy/remote service, upon which quota will applied. If GraphQLOperation operation has only the operation type(s), that would imply that quota will be applied on all graphQL requests irrespective of the graphQL name. **Note**: Currently, we can specify only a single GraphQLOperation. Specifying more than one will result in failure of the operation.
        :param pulumi.Input['GoogleCloudApigeeV1QuotaArgs'] quota: Quota parameters to be enforced for the resources, methods, api_source combination. If none are specified, quota enforcement will not be done.
        """
        if api_source is not None:
            pulumi.set(__self__, "api_source", api_source)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)

    @property
    @pulumi.getter(name="apiSource")
    def api_source(self) -> Optional[pulumi.Input[str]]:
        """
        Required. API proxy endpoint or remote service name with which the graphQL operation, and quota are associated.
        """
        return pulumi.get(self, "api_source")

    @api_source.setter
    def api_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_source", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]]:
        """
        Custom attributes associated with the operation.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationArgs']]]]:
        """
        Required. List of graphQL name/Operation type pairs for the proxy/remote service, upon which quota will applied. If GraphQLOperation operation has only the operation type(s), that would imply that quota will be applied on all graphQL requests irrespective of the graphQL name. **Note**: Currently, we can specify only a single GraphQLOperation. Specifying more than one will result in failure of the operation.
        """
        return pulumi.get(self, "operations")

    @operations.setter
    def operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationArgs']]]]):
        pulumi.set(self, "operations", value)

    @property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input['GoogleCloudApigeeV1QuotaArgs']]:
        """
        Quota parameters to be enforced for the resources, methods, api_source combination. If none are specified, quota enforcement will not be done.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input['GoogleCloudApigeeV1QuotaArgs']]):
        pulumi.set(self, "quota", value)


@pulumi.input_type
class GoogleCloudApigeeV1GraphQLOperationGroupArgs:
    def __init__(__self__, *,
                 operation_config_type: Optional[pulumi.Input[str]] = None,
                 operation_configs: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationConfigArgs']]]] = None):
        """
        List of graphQL operation configuration details associated with Apigee API proxies or remote services. Remote services are non-Apigee proxies, such as Istio-Envoy.
        :param pulumi.Input[str] operation_config_type: Flag that specifes whether the configuration is for Apigee API proxy or a remote service. Valid values are `proxy` or `remoteservice`. Defaults to `proxy`. Set to `proxy` when Apigee API proxies are associated with the API product. Set to `remoteservice` when non-Apigee proxies like Istio-Envoy are associated with the API product.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationConfigArgs']]] operation_configs: Required. List of operation configurations for either Apigee API proxies or other remote services that are associated with this API product.
        """
        if operation_config_type is not None:
            pulumi.set(__self__, "operation_config_type", operation_config_type)
        if operation_configs is not None:
            pulumi.set(__self__, "operation_configs", operation_configs)

    @property
    @pulumi.getter(name="operationConfigType")
    def operation_config_type(self) -> Optional[pulumi.Input[str]]:
        """
        Flag that specifes whether the configuration is for Apigee API proxy or a remote service. Valid values are `proxy` or `remoteservice`. Defaults to `proxy`. Set to `proxy` when Apigee API proxies are associated with the API product. Set to `remoteservice` when non-Apigee proxies like Istio-Envoy are associated with the API product.
        """
        return pulumi.get(self, "operation_config_type")

    @operation_config_type.setter
    def operation_config_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation_config_type", value)

    @property
    @pulumi.getter(name="operationConfigs")
    def operation_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationConfigArgs']]]]:
        """
        Required. List of operation configurations for either Apigee API proxies or other remote services that are associated with this API product.
        """
        return pulumi.get(self, "operation_configs")

    @operation_configs.setter
    def operation_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationConfigArgs']]]]):
        pulumi.set(self, "operation_configs", value)


@pulumi.input_type
class GoogleCloudApigeeV1OperationArgs:
    def __init__(__self__, *,
                 methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource: Optional[pulumi.Input[str]] = None):
        """
        Operation represents the pairing of REST resource path and the actions (verbs) allowed on the resource path.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] methods: methods refers to the REST verbs as in https://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html. When none specified, all verb types are allowed.
        :param pulumi.Input[str] resource: Required. resource represents REST resource path associated with the proxy/remote service.
        """
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        methods refers to the REST verbs as in https://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html. When none specified, all verb types are allowed.
        """
        return pulumi.get(self, "methods")

    @methods.setter
    def methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "methods", value)

    @property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input[str]]:
        """
        Required. resource represents REST resource path associated with the proxy/remote service.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource", value)


@pulumi.input_type
class GoogleCloudApigeeV1OperationConfigArgs:
    def __init__(__self__, *,
                 api_source: Optional[pulumi.Input[str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1OperationArgs']]]] = None,
                 quota: Optional[pulumi.Input['GoogleCloudApigeeV1QuotaArgs']] = None):
        """
        OperationConfig binds the resources in a proxy or remote service with the allowed REST methods and its associated quota enforcement.
        :param pulumi.Input[str] api_source: Required. API proxy or remote service name with which the resources, methods, and quota are associated.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]] attributes: Custom attributes associated with the operation.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1OperationArgs']]] operations: List of resource/method pairs for the proxy/remote service, upon which quota will applied. **Note**: Currently, you can specify only a single resource/method pair. The call will fail if more than one resource/method pair is provided.
        :param pulumi.Input['GoogleCloudApigeeV1QuotaArgs'] quota: Quota parameters to be enforced for the resources, methods, api_source combination. If none are specified, quota enforcement will not be done.
        """
        if api_source is not None:
            pulumi.set(__self__, "api_source", api_source)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)

    @property
    @pulumi.getter(name="apiSource")
    def api_source(self) -> Optional[pulumi.Input[str]]:
        """
        Required. API proxy or remote service name with which the resources, methods, and quota are associated.
        """
        return pulumi.get(self, "api_source")

    @api_source.setter
    def api_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_source", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]]:
        """
        Custom attributes associated with the operation.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1OperationArgs']]]]:
        """
        List of resource/method pairs for the proxy/remote service, upon which quota will applied. **Note**: Currently, you can specify only a single resource/method pair. The call will fail if more than one resource/method pair is provided.
        """
        return pulumi.get(self, "operations")

    @operations.setter
    def operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1OperationArgs']]]]):
        pulumi.set(self, "operations", value)

    @property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input['GoogleCloudApigeeV1QuotaArgs']]:
        """
        Quota parameters to be enforced for the resources, methods, api_source combination. If none are specified, quota enforcement will not be done.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input['GoogleCloudApigeeV1QuotaArgs']]):
        pulumi.set(self, "quota", value)


@pulumi.input_type
class GoogleCloudApigeeV1OperationGroupArgs:
    def __init__(__self__, *,
                 operation_config_type: Optional[pulumi.Input[str]] = None,
                 operation_configs: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1OperationConfigArgs']]]] = None):
        """
        List of operation configuration details associated with Apigee API proxies or remote services. Remote services are non-Apigee proxies, such as Istio-Envoy.
        :param pulumi.Input[str] operation_config_type: Flag that specifes whether the configuration is for Apigee API proxy or a remote service. Valid values are `proxy` or `remoteservice`. Defaults to `proxy`. Set to `proxy` when Apigee API proxies are associated with the API product. Set to `remoteservice` when non-Apigee proxies like Istio-Envoy are associated with the API product.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1OperationConfigArgs']]] operation_configs: Required. List of operation configurations for either Apigee API proxies or other remote services that are associated with this API product.
        """
        if operation_config_type is not None:
            pulumi.set(__self__, "operation_config_type", operation_config_type)
        if operation_configs is not None:
            pulumi.set(__self__, "operation_configs", operation_configs)

    @property
    @pulumi.getter(name="operationConfigType")
    def operation_config_type(self) -> Optional[pulumi.Input[str]]:
        """
        Flag that specifes whether the configuration is for Apigee API proxy or a remote service. Valid values are `proxy` or `remoteservice`. Defaults to `proxy`. Set to `proxy` when Apigee API proxies are associated with the API product. Set to `remoteservice` when non-Apigee proxies like Istio-Envoy are associated with the API product.
        """
        return pulumi.get(self, "operation_config_type")

    @operation_config_type.setter
    def operation_config_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation_config_type", value)

    @property
    @pulumi.getter(name="operationConfigs")
    def operation_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1OperationConfigArgs']]]]:
        """
        Required. List of operation configurations for either Apigee API proxies or other remote services that are associated with this API product.
        """
        return pulumi.get(self, "operation_configs")

    @operation_configs.setter
    def operation_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1OperationConfigArgs']]]]):
        pulumi.set(self, "operation_configs", value)


@pulumi.input_type
class GoogleCloudApigeeV1PropertiesArgs:
    def __init__(__self__, *,
                 property: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1PropertyArgs']]]] = None):
        """
        Message for compatibility with legacy Edge specification for Java Properties object in JSON.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1PropertyArgs']]] property: List of all properties in the object
        """
        if property is not None:
            pulumi.set(__self__, "property", property)

    @property
    @pulumi.getter
    def property(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1PropertyArgs']]]]:
        """
        List of all properties in the object
        """
        return pulumi.get(self, "property")

    @property.setter
    def property(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1PropertyArgs']]]]):
        pulumi.set(self, "property", value)


@pulumi.input_type
class GoogleCloudApigeeV1PropertyArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        A single property entry in the Properties message.
        :param pulumi.Input[str] name: The property key
        :param pulumi.Input[str] value: The property value
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The property key
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The property value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GoogleCloudApigeeV1QueryMetricArgs:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[str]] = None,
                 function: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        More info about Metric: https://docs.apigee.com/api-platform/analytics/analytics-reference#metrics
        :param pulumi.Input[str] alias: Alias for the metric. Alias will be used to replace metric name in query results.
        :param pulumi.Input[str] function: Aggregation function: avg, min, max, or sum.
        :param pulumi.Input[str] name: Required. Metric name.
        :param pulumi.Input[str] operator: One of `+`, `-`, `/`, `%`, `*`.
        :param pulumi.Input[str] value: Operand value should be provided when operator is set.
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        Alias for the metric. Alias will be used to replace metric name in query results.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[str]]:
        """
        Aggregation function: avg, min, max, or sum.
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Metric name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[str]]:
        """
        One of `+`, `-`, `/`, `%`, `*`.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Operand value should be provided when operator is set.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GoogleCloudApigeeV1QuotaArgs:
    def __init__(__self__, *,
                 interval: Optional[pulumi.Input[str]] = None,
                 limit: Optional[pulumi.Input[str]] = None,
                 time_unit: Optional[pulumi.Input[str]] = None):
        """
        Quota contains the essential parameters needed that can be applied on a proxy/remote service, resources and methods combination associated with this API product. While setting of Quota is optional, setting it prevents requests from exceeding the provisioned parameters.
        :param pulumi.Input[str] interval: Required. Time interval over which the number of request messages is calculated.
        :param pulumi.Input[str] limit: Required. Upper limit allowed for the time interval and time unit specified. Requests exceeding this limit will be rejected.
        :param pulumi.Input[str] time_unit: Time unit defined for the `interval`. Valid values include `minute`, `hour`, `day`, or `month`. If `limit` and `interval` are valid, the default value is `hour`; otherwise, the default is null.
        """
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if limit is not None:
            pulumi.set(__self__, "limit", limit)
        if time_unit is not None:
            pulumi.set(__self__, "time_unit", time_unit)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Time interval over which the number of request messages is calculated.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def limit(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Upper limit allowed for the time interval and time unit specified. Requests exceeding this limit will be rejected.
        """
        return pulumi.get(self, "limit")

    @limit.setter
    def limit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "limit", value)

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Time unit defined for the `interval`. Valid values include `minute`, `hour`, `day`, or `month`. If `limit` and `interval` are valid, the default value is `hour`; otherwise, the default is null.
        """
        return pulumi.get(self, "time_unit")

    @time_unit.setter
    def time_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_unit", value)


@pulumi.input_type
class GoogleCloudApigeeV1ReportPropertyArgs:
    def __init__(__self__, *,
                 property: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]] = None):
        """
        :param pulumi.Input[str] property: name of the property
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]] value: property values
        """
        if property is not None:
            pulumi.set(__self__, "property", property)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]]:
        """
        property values
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def property(self) -> Optional[pulumi.Input[str]]:
        """
        name of the property
        """
        return pulumi.get(self, "property")

    @property.setter
    def property(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property", value)


@pulumi.input_type
class GoogleCloudApigeeV1TlsInfoArgs:
    def __init__(__self__, *,
                 ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_auth_enabled: Optional[pulumi.Input[bool]] = None,
                 common_name: Optional[pulumi.Input['GoogleCloudApigeeV1TlsInfoCommonNameArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 ignore_validation_errors: Optional[pulumi.Input[bool]] = None,
                 key_alias: Optional[pulumi.Input[str]] = None,
                 key_store: Optional[pulumi.Input[str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 trust_store: Optional[pulumi.Input[str]] = None):
        """
        TLS configuration information for VirtualHosts and TargetServers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ciphers: The SSL/TLS cipher suites to be used. Must be one of the cipher suite names listed in: http://docs.oracle.com/javase/8/docs/technotes/guides/security/StandardNames.html#ciphersuites
        :param pulumi.Input[bool] client_auth_enabled: Optional. Enables two-way TLS.
        :param pulumi.Input['GoogleCloudApigeeV1TlsInfoCommonNameArgs'] common_name: The TLS Common Name of the certificate.
        :param pulumi.Input[bool] enabled: Required. Enables TLS. If false, neither one-way nor two-way TLS will be enabled.
        :param pulumi.Input[bool] ignore_validation_errors: If true, Edge ignores TLS certificate errors. Valid when configuring TLS for target servers and target endpoints, and when configuring virtual hosts that use 2-way TLS. When used with a target endpoint/target server, if the backend system uses SNI and returns a cert with a subject Distinguished Name (DN) that does not match the hostname, there is no way to ignore the error and the connection fails.
        :param pulumi.Input[str] key_alias: Required if `client_auth_enabled` is true. The resource ID for the alias containing the private key and cert.
        :param pulumi.Input[str] key_store: Required if `client_auth_enabled` is true. The resource ID of the keystore. References not yet supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: The TLS versioins to be used.
        :param pulumi.Input[str] trust_store: The resource ID of the truststore. References not yet supported.
        """
        if ciphers is not None:
            pulumi.set(__self__, "ciphers", ciphers)
        if client_auth_enabled is not None:
            pulumi.set(__self__, "client_auth_enabled", client_auth_enabled)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ignore_validation_errors is not None:
            pulumi.set(__self__, "ignore_validation_errors", ignore_validation_errors)
        if key_alias is not None:
            pulumi.set(__self__, "key_alias", key_alias)
        if key_store is not None:
            pulumi.set(__self__, "key_store", key_store)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if trust_store is not None:
            pulumi.set(__self__, "trust_store", trust_store)

    @property
    @pulumi.getter
    def ciphers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The SSL/TLS cipher suites to be used. Must be one of the cipher suite names listed in: http://docs.oracle.com/javase/8/docs/technotes/guides/security/StandardNames.html#ciphersuites
        """
        return pulumi.get(self, "ciphers")

    @ciphers.setter
    def ciphers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ciphers", value)

    @property
    @pulumi.getter(name="clientAuthEnabled")
    def client_auth_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Enables two-way TLS.
        """
        return pulumi.get(self, "client_auth_enabled")

    @client_auth_enabled.setter
    def client_auth_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "client_auth_enabled", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input['GoogleCloudApigeeV1TlsInfoCommonNameArgs']]:
        """
        The TLS Common Name of the certificate.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input['GoogleCloudApigeeV1TlsInfoCommonNameArgs']]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Required. Enables TLS. If false, neither one-way nor two-way TLS will be enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="ignoreValidationErrors")
    def ignore_validation_errors(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, Edge ignores TLS certificate errors. Valid when configuring TLS for target servers and target endpoints, and when configuring virtual hosts that use 2-way TLS. When used with a target endpoint/target server, if the backend system uses SNI and returns a cert with a subject Distinguished Name (DN) that does not match the hostname, there is no way to ignore the error and the connection fails.
        """
        return pulumi.get(self, "ignore_validation_errors")

    @ignore_validation_errors.setter
    def ignore_validation_errors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_validation_errors", value)

    @property
    @pulumi.getter(name="keyAlias")
    def key_alias(self) -> Optional[pulumi.Input[str]]:
        """
        Required if `client_auth_enabled` is true. The resource ID for the alias containing the private key and cert.
        """
        return pulumi.get(self, "key_alias")

    @key_alias.setter
    def key_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_alias", value)

    @property
    @pulumi.getter(name="keyStore")
    def key_store(self) -> Optional[pulumi.Input[str]]:
        """
        Required if `client_auth_enabled` is true. The resource ID of the keystore. References not yet supported.
        """
        return pulumi.get(self, "key_store")

    @key_store.setter
    def key_store(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_store", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The TLS versioins to be used.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="trustStore")
    def trust_store(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the truststore. References not yet supported.
        """
        return pulumi.get(self, "trust_store")

    @trust_store.setter
    def trust_store(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trust_store", value)


@pulumi.input_type
class GoogleCloudApigeeV1TlsInfoCommonNameArgs:
    def __init__(__self__, *,
                 value: Optional[pulumi.Input[str]] = None,
                 wildcard_match: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] value: The TLS Common Name string of the certificate.
        :param pulumi.Input[bool] wildcard_match: Indicates whether the cert should be matched against as a wildcard cert.
        """
        if value is not None:
            pulumi.set(__self__, "value", value)
        if wildcard_match is not None:
            pulumi.set(__self__, "wildcard_match", wildcard_match)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The TLS Common Name string of the certificate.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="wildcardMatch")
    def wildcard_match(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the cert should be matched against as a wildcard cert.
        """
        return pulumi.get(self, "wildcard_match")

    @wildcard_match.setter
    def wildcard_match(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wildcard_match", value)


@pulumi.input_type
class GoogleCloudApigeeV1TraceSamplingConfigArgs:
    def __init__(__self__, *,
                 sampler: Optional[pulumi.Input[str]] = None,
                 sampling_rate: Optional[pulumi.Input[float]] = None):
        """
        TraceSamplingConfig represents the detail settings of distributed tracing. Only the fields that are defined in the distributed trace configuration can be overridden using the distribute trace configuration override APIs.
        :param pulumi.Input[str] sampler: Sampler of distributed tracing. OFF is the default value.
        :param pulumi.Input[float] sampling_rate: Field sampling rate. This value is only applicable when using the PROBABILITY sampler. The supported values are > 0 and <= 0.5.
        """
        if sampler is not None:
            pulumi.set(__self__, "sampler", sampler)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter
    def sampler(self) -> Optional[pulumi.Input[str]]:
        """
        Sampler of distributed tracing. OFF is the default value.
        """
        return pulumi.get(self, "sampler")

    @sampler.setter
    def sampler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sampler", value)

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[pulumi.Input[float]]:
        """
        Field sampling rate. This value is only applicable when using the PROBABILITY sampler. The supported values are > 0 and <= 0.5.
        """
        return pulumi.get(self, "sampling_rate")

    @sampling_rate.setter
    def sampling_rate(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "sampling_rate", value)


@pulumi.input_type
class GoogleIamV1AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleIamV1AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleIamV1AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleIamV1AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleIamV1AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class GoogleIamV1AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input[str]] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input[str] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input[str]]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class GoogleIamV1BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['GoogleTypeExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members` with a `role`.
        :param pulumi.Input['GoogleTypeExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['GoogleTypeExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['GoogleTypeExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class GoogleTypeExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


