# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs

__all__ = [
    'BasicLevelResponse',
    'ConditionResponse',
    'CustomLevelResponse',
    'DevicePolicyResponse',
    'ExprResponse',
    'OsConstraintResponse',
    'ServicePerimeterConfigResponse',
    'VpcAccessibleServicesResponse',
]

@pulumi.output_type
class BasicLevelResponse(dict):
    """
    `BasicLevel` is an `AccessLevel` using a set of recommended features.
    """
    def __init__(__self__, *,
                 combining_function: str,
                 conditions: Sequence['outputs.ConditionResponse']):
        """
        `BasicLevel` is an `AccessLevel` using a set of recommended features.
        :param str combining_function: How the `conditions` list should be combined to determine if a request is granted this `AccessLevel`. If AND is used, each `Condition` in `conditions` must be satisfied for the `AccessLevel` to be applied. If OR is used, at least one `Condition` in `conditions` must be satisfied for the `AccessLevel` to be applied. Default behavior is AND.
        :param Sequence['ConditionResponseArgs'] conditions: Required. A list of requirements for the `AccessLevel` to be granted.
        """
        pulumi.set(__self__, "combining_function", combining_function)
        pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter(name="combiningFunction")
    def combining_function(self) -> str:
        """
        How the `conditions` list should be combined to determine if a request is granted this `AccessLevel`. If AND is used, each `Condition` in `conditions` must be satisfied for the `AccessLevel` to be applied. If OR is used, at least one `Condition` in `conditions` must be satisfied for the `AccessLevel` to be applied. Default behavior is AND.
        """
        return pulumi.get(self, "combining_function")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.ConditionResponse']:
        """
        Required. A list of requirements for the `AccessLevel` to be granted.
        """
        return pulumi.get(self, "conditions")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ConditionResponse(dict):
    """
    A condition necessary for an `AccessLevel` to be granted. The Condition is an AND over its fields. So a Condition is true if: 1) the request IP is from one of the listed subnetworks AND 2) the originating device complies with the listed device policy AND 3) all listed access levels are granted AND 4) the request was sent at a time allowed by the DateTimeRestriction.
    """
    def __init__(__self__, *,
                 device_policy: 'outputs.DevicePolicyResponse',
                 ip_subnetworks: Sequence[str],
                 members: Sequence[str],
                 negate: bool,
                 regions: Sequence[str],
                 required_access_levels: Sequence[str]):
        """
        A condition necessary for an `AccessLevel` to be granted. The Condition is an AND over its fields. So a Condition is true if: 1) the request IP is from one of the listed subnetworks AND 2) the originating device complies with the listed device policy AND 3) all listed access levels are granted AND 4) the request was sent at a time allowed by the DateTimeRestriction.
        :param 'DevicePolicyResponseArgs' device_policy: Device specific restrictions, all restrictions must hold for the Condition to be true. If not specified, all devices are allowed.
        :param Sequence[str] ip_subnetworks: CIDR block IP subnetwork specification. May be IPv4 or IPv6. Note that for a CIDR IP address block, the specified IP address portion must be properly truncated (i.e. all the host bits must be zero) or the input is considered malformed. For example, "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly, for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32" is not. The originating IP of a request must be in one of the listed subnets in order for this Condition to be true. If empty, all IP addresses are allowed.
        :param Sequence[str] members: The request must be made by one of the provided user or service accounts. Groups are not supported. Syntax: `user:{emailid}` `serviceAccount:{emailid}` If not specified, a request may come from any user.
        :param bool negate: Whether to negate the Condition. If true, the Condition becomes a NAND over its non-empty fields, each field must be false for the Condition overall to be satisfied. Defaults to false.
        :param Sequence[str] regions: The request must originate from one of the provided countries/regions. Must be valid ISO 3166-1 alpha-2 codes.
        :param Sequence[str] required_access_levels: A list of other access levels defined in the same `Policy`, referenced by resource name. Referencing an `AccessLevel` which does not exist is an error. All access levels listed must be granted for the Condition to be true. Example: "`accessPolicies/MY_POLICY/accessLevels/LEVEL_NAME"`
        """
        pulumi.set(__self__, "device_policy", device_policy)
        pulumi.set(__self__, "ip_subnetworks", ip_subnetworks)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "negate", negate)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "required_access_levels", required_access_levels)

    @property
    @pulumi.getter(name="devicePolicy")
    def device_policy(self) -> 'outputs.DevicePolicyResponse':
        """
        Device specific restrictions, all restrictions must hold for the Condition to be true. If not specified, all devices are allowed.
        """
        return pulumi.get(self, "device_policy")

    @property
    @pulumi.getter(name="ipSubnetworks")
    def ip_subnetworks(self) -> Sequence[str]:
        """
        CIDR block IP subnetwork specification. May be IPv4 or IPv6. Note that for a CIDR IP address block, the specified IP address portion must be properly truncated (i.e. all the host bits must be zero) or the input is considered malformed. For example, "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly, for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32" is not. The originating IP of a request must be in one of the listed subnets in order for this Condition to be true. If empty, all IP addresses are allowed.
        """
        return pulumi.get(self, "ip_subnetworks")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        The request must be made by one of the provided user or service accounts. Groups are not supported. Syntax: `user:{emailid}` `serviceAccount:{emailid}` If not specified, a request may come from any user.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def negate(self) -> bool:
        """
        Whether to negate the Condition. If true, the Condition becomes a NAND over its non-empty fields, each field must be false for the Condition overall to be satisfied. Defaults to false.
        """
        return pulumi.get(self, "negate")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[str]:
        """
        The request must originate from one of the provided countries/regions. Must be valid ISO 3166-1 alpha-2 codes.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="requiredAccessLevels")
    def required_access_levels(self) -> Sequence[str]:
        """
        A list of other access levels defined in the same `Policy`, referenced by resource name. Referencing an `AccessLevel` which does not exist is an error. All access levels listed must be granted for the Condition to be true. Example: "`accessPolicies/MY_POLICY/accessLevels/LEVEL_NAME"`
        """
        return pulumi.get(self, "required_access_levels")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class CustomLevelResponse(dict):
    """
    `CustomLevel` is an `AccessLevel` using the Cloud Common Expression Language to represent the necessary conditions for the level to apply to a request. See CEL spec at: https://github.com/google/cel-spec
    """
    def __init__(__self__, *,
                 expr: 'outputs.ExprResponse'):
        """
        `CustomLevel` is an `AccessLevel` using the Cloud Common Expression Language to represent the necessary conditions for the level to apply to a request. See CEL spec at: https://github.com/google/cel-spec
        :param 'ExprResponseArgs' expr: Required. A Cloud CEL expression evaluating to a boolean.
        """
        pulumi.set(__self__, "expr", expr)

    @property
    @pulumi.getter
    def expr(self) -> 'outputs.ExprResponse':
        """
        Required. A Cloud CEL expression evaluating to a boolean.
        """
        return pulumi.get(self, "expr")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DevicePolicyResponse(dict):
    """
    `DevicePolicy` specifies device specific restrictions necessary to acquire a given access level. A `DevicePolicy` specifies requirements for requests from devices to be granted access levels, it does not do any enforcement on the device. `DevicePolicy` acts as an AND over all specified fields, and each repeated field is an OR over its elements. Any unset fields are ignored. For example, if the proto is { os_type : DESKTOP_WINDOWS, os_type : DESKTOP_LINUX, encryption_status: ENCRYPTED}, then the DevicePolicy will be true for requests originating from encrypted Linux desktops and encrypted Windows desktops.
    """
    def __init__(__self__, *,
                 allowed_device_management_levels: Sequence[str],
                 allowed_encryption_statuses: Sequence[str],
                 os_constraints: Sequence['outputs.OsConstraintResponse'],
                 require_admin_approval: bool,
                 require_corp_owned: bool,
                 require_screenlock: bool):
        """
        `DevicePolicy` specifies device specific restrictions necessary to acquire a given access level. A `DevicePolicy` specifies requirements for requests from devices to be granted access levels, it does not do any enforcement on the device. `DevicePolicy` acts as an AND over all specified fields, and each repeated field is an OR over its elements. Any unset fields are ignored. For example, if the proto is { os_type : DESKTOP_WINDOWS, os_type : DESKTOP_LINUX, encryption_status: ENCRYPTED}, then the DevicePolicy will be true for requests originating from encrypted Linux desktops and encrypted Windows desktops.
        :param Sequence[str] allowed_device_management_levels: Allowed device management levels, an empty list allows all management levels.
        :param Sequence[str] allowed_encryption_statuses: Allowed encryptions statuses, an empty list allows all statuses.
        :param Sequence['OsConstraintResponseArgs'] os_constraints: Allowed OS versions, an empty list allows all types and all versions.
        :param bool require_admin_approval: Whether the device needs to be approved by the customer admin.
        :param bool require_corp_owned: Whether the device needs to be corp owned.
        :param bool require_screenlock: Whether or not screenlock is required for the DevicePolicy to be true. Defaults to `false`.
        """
        pulumi.set(__self__, "allowed_device_management_levels", allowed_device_management_levels)
        pulumi.set(__self__, "allowed_encryption_statuses", allowed_encryption_statuses)
        pulumi.set(__self__, "os_constraints", os_constraints)
        pulumi.set(__self__, "require_admin_approval", require_admin_approval)
        pulumi.set(__self__, "require_corp_owned", require_corp_owned)
        pulumi.set(__self__, "require_screenlock", require_screenlock)

    @property
    @pulumi.getter(name="allowedDeviceManagementLevels")
    def allowed_device_management_levels(self) -> Sequence[str]:
        """
        Allowed device management levels, an empty list allows all management levels.
        """
        return pulumi.get(self, "allowed_device_management_levels")

    @property
    @pulumi.getter(name="allowedEncryptionStatuses")
    def allowed_encryption_statuses(self) -> Sequence[str]:
        """
        Allowed encryptions statuses, an empty list allows all statuses.
        """
        return pulumi.get(self, "allowed_encryption_statuses")

    @property
    @pulumi.getter(name="osConstraints")
    def os_constraints(self) -> Sequence['outputs.OsConstraintResponse']:
        """
        Allowed OS versions, an empty list allows all types and all versions.
        """
        return pulumi.get(self, "os_constraints")

    @property
    @pulumi.getter(name="requireAdminApproval")
    def require_admin_approval(self) -> bool:
        """
        Whether the device needs to be approved by the customer admin.
        """
        return pulumi.get(self, "require_admin_approval")

    @property
    @pulumi.getter(name="requireCorpOwned")
    def require_corp_owned(self) -> bool:
        """
        Whether the device needs to be corp owned.
        """
        return pulumi.get(self, "require_corp_owned")

    @property
    @pulumi.getter(name="requireScreenlock")
    def require_screenlock(self) -> bool:
        """
        Whether or not screenlock is required for the DevicePolicy to be true. Defaults to `false`.
        """
        return pulumi.get(self, "require_screenlock")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OsConstraintResponse(dict):
    """
    A restriction on the OS type and version of devices making requests.
    """
    def __init__(__self__, *,
                 minimum_version: str,
                 os_type: str,
                 require_verified_chrome_os: bool):
        """
        A restriction on the OS type and version of devices making requests.
        :param str minimum_version: The minimum allowed OS version. If not set, any version of this OS satisfies the constraint. Format: `"major.minor.patch"`. Examples: `"10.5.301"`, `"9.2.1"`.
        :param str os_type: Required. The allowed OS type.
        :param bool require_verified_chrome_os: Only allows requests from devices with a verified Chrome OS. Verifications includes requirements that the device is enterprise-managed, conformant to domain policies, and the caller has permission to call the API targeted by the request.
        """
        pulumi.set(__self__, "minimum_version", minimum_version)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "require_verified_chrome_os", require_verified_chrome_os)

    @property
    @pulumi.getter(name="minimumVersion")
    def minimum_version(self) -> str:
        """
        The minimum allowed OS version. If not set, any version of this OS satisfies the constraint. Format: `"major.minor.patch"`. Examples: `"10.5.301"`, `"9.2.1"`.
        """
        return pulumi.get(self, "minimum_version")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        Required. The allowed OS type.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="requireVerifiedChromeOs")
    def require_verified_chrome_os(self) -> bool:
        """
        Only allows requests from devices with a verified Chrome OS. Verifications includes requirements that the device is enterprise-managed, conformant to domain policies, and the caller has permission to call the API targeted by the request.
        """
        return pulumi.get(self, "require_verified_chrome_os")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServicePerimeterConfigResponse(dict):
    """
    `ServicePerimeterConfig` specifies a set of Google Cloud resources that describe specific Service Perimeter configuration.
    """
    def __init__(__self__, *,
                 access_levels: Sequence[str],
                 resources: Sequence[str],
                 restricted_services: Sequence[str],
                 vpc_accessible_services: 'outputs.VpcAccessibleServicesResponse'):
        """
        `ServicePerimeterConfig` specifies a set of Google Cloud resources that describe specific Service Perimeter configuration.
        :param Sequence[str] access_levels: A list of `AccessLevel` resource names that allow resources within the `ServicePerimeter` to be accessed from the internet. `AccessLevels` listed must be in the same policy as this `ServicePerimeter`. Referencing a nonexistent `AccessLevel` is a syntax error. If no `AccessLevel` names are listed, resources within the perimeter can only be accessed via Google Cloud calls with request origins within the perimeter. Example: `"accessPolicies/MY_POLICY/accessLevels/MY_LEVEL"`. For Service Perimeter Bridge, must be empty.
        :param Sequence[str] resources: A list of Google Cloud resources that are inside of the service perimeter. Currently only projects are allowed. Format: `projects/{project_number}`
        :param Sequence[str] restricted_services: Google Cloud services that are subject to the Service Perimeter restrictions. Must contain a list of services. For example, if `storage.googleapis.com` is specified, access to the storage buckets inside the perimeter must meet the perimeter's access restrictions.
        :param 'VpcAccessibleServicesResponseArgs' vpc_accessible_services: Beta. Configuration for APIs allowed within Perimeter.
        """
        pulumi.set(__self__, "access_levels", access_levels)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "restricted_services", restricted_services)
        pulumi.set(__self__, "vpc_accessible_services", vpc_accessible_services)

    @property
    @pulumi.getter(name="accessLevels")
    def access_levels(self) -> Sequence[str]:
        """
        A list of `AccessLevel` resource names that allow resources within the `ServicePerimeter` to be accessed from the internet. `AccessLevels` listed must be in the same policy as this `ServicePerimeter`. Referencing a nonexistent `AccessLevel` is a syntax error. If no `AccessLevel` names are listed, resources within the perimeter can only be accessed via Google Cloud calls with request origins within the perimeter. Example: `"accessPolicies/MY_POLICY/accessLevels/MY_LEVEL"`. For Service Perimeter Bridge, must be empty.
        """
        return pulumi.get(self, "access_levels")

    @property
    @pulumi.getter
    def resources(self) -> Sequence[str]:
        """
        A list of Google Cloud resources that are inside of the service perimeter. Currently only projects are allowed. Format: `projects/{project_number}`
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="restrictedServices")
    def restricted_services(self) -> Sequence[str]:
        """
        Google Cloud services that are subject to the Service Perimeter restrictions. Must contain a list of services. For example, if `storage.googleapis.com` is specified, access to the storage buckets inside the perimeter must meet the perimeter's access restrictions.
        """
        return pulumi.get(self, "restricted_services")

    @property
    @pulumi.getter(name="vpcAccessibleServices")
    def vpc_accessible_services(self) -> 'outputs.VpcAccessibleServicesResponse':
        """
        Beta. Configuration for APIs allowed within Perimeter.
        """
        return pulumi.get(self, "vpc_accessible_services")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VpcAccessibleServicesResponse(dict):
    """
    Specifies how APIs are allowed to communicate within the Service Perimeter.
    """
    def __init__(__self__, *,
                 allowed_services: Sequence[str],
                 enable_restriction: bool):
        """
        Specifies how APIs are allowed to communicate within the Service Perimeter.
        :param Sequence[str] allowed_services: The list of APIs usable within the Service Perimeter. Must be empty unless 'enable_restriction' is True. You can specify a list of individual services, as well as include the 'RESTRICTED-SERVICES' value, which automatically includes all of the services protected by the perimeter.
        :param bool enable_restriction: Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowed_services'.
        """
        pulumi.set(__self__, "allowed_services", allowed_services)
        pulumi.set(__self__, "enable_restriction", enable_restriction)

    @property
    @pulumi.getter(name="allowedServices")
    def allowed_services(self) -> Sequence[str]:
        """
        The list of APIs usable within the Service Perimeter. Must be empty unless 'enable_restriction' is True. You can specify a list of individual services, as well as include the 'RESTRICTED-SERVICES' value, which automatically includes all of the services protected by the perimeter.
        """
        return pulumi.get(self, "allowed_services")

    @property
    @pulumi.getter(name="enableRestriction")
    def enable_restriction(self) -> bool:
        """
        Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowed_services'.
        """
        return pulumi.get(self, "enable_restriction")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


