# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs

__all__ = [
    'ApiOperationResponse',
    'BasicLevelResponse',
    'ConditionResponse',
    'CustomLevelResponse',
    'DevicePolicyResponse',
    'EgressFromResponse',
    'EgressPolicyResponse',
    'EgressToResponse',
    'ExprResponse',
    'IngressFromResponse',
    'IngressPolicyResponse',
    'IngressSourceResponse',
    'IngressToResponse',
    'MethodSelectorResponse',
    'OsConstraintResponse',
    'ServicePerimeterConfigResponse',
    'VpcAccessibleServicesResponse',
]

@pulumi.output_type
class ApiOperationResponse(dict):
    """
    Identification for an API Operation.
    """
    def __init__(__self__, *,
                 method_selectors: Sequence['outputs.MethodSelectorResponse'],
                 service_name: str):
        """
        Identification for an API Operation.
        :param Sequence['MethodSelectorResponseArgs'] method_selectors: API methods or permissions to allow. Method or permission must belong to the service specified by `service_name` field. A single MethodSelector entry with `*` specified for the `method` field will allow all methods AND permissions for the service specified in `service_name`.
        :param str service_name: The name of the API whose methods or permissions the IngressPolicy or EgressPolicy want to allow. A single ApiOperation with `service_name` field set to `*` will allow all methods AND permissions for all services.
        """
        pulumi.set(__self__, "method_selectors", method_selectors)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="methodSelectors")
    def method_selectors(self) -> Sequence['outputs.MethodSelectorResponse']:
        """
        API methods or permissions to allow. Method or permission must belong to the service specified by `service_name` field. A single MethodSelector entry with `*` specified for the `method` field will allow all methods AND permissions for the service specified in `service_name`.
        """
        return pulumi.get(self, "method_selectors")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The name of the API whose methods or permissions the IngressPolicy or EgressPolicy want to allow. A single ApiOperation with `service_name` field set to `*` will allow all methods AND permissions for all services.
        """
        return pulumi.get(self, "service_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BasicLevelResponse(dict):
    """
    `BasicLevel` is an `AccessLevel` using a set of recommended features.
    """
    def __init__(__self__, *,
                 combining_function: str,
                 conditions: Sequence['outputs.ConditionResponse']):
        """
        `BasicLevel` is an `AccessLevel` using a set of recommended features.
        :param str combining_function: How the `conditions` list should be combined to determine if a request is granted this `AccessLevel`. If AND is used, each `Condition` in `conditions` must be satisfied for the `AccessLevel` to be applied. If OR is used, at least one `Condition` in `conditions` must be satisfied for the `AccessLevel` to be applied. Default behavior is AND.
        :param Sequence['ConditionResponseArgs'] conditions: Required. A list of requirements for the `AccessLevel` to be granted.
        """
        pulumi.set(__self__, "combining_function", combining_function)
        pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter(name="combiningFunction")
    def combining_function(self) -> str:
        """
        How the `conditions` list should be combined to determine if a request is granted this `AccessLevel`. If AND is used, each `Condition` in `conditions` must be satisfied for the `AccessLevel` to be applied. If OR is used, at least one `Condition` in `conditions` must be satisfied for the `AccessLevel` to be applied. Default behavior is AND.
        """
        return pulumi.get(self, "combining_function")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.ConditionResponse']:
        """
        Required. A list of requirements for the `AccessLevel` to be granted.
        """
        return pulumi.get(self, "conditions")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ConditionResponse(dict):
    """
    A condition necessary for an `AccessLevel` to be granted. The Condition is an AND over its fields. So a Condition is true if: 1) the request IP is from one of the listed subnetworks AND 2) the originating device complies with the listed device policy AND 3) all listed access levels are granted AND 4) the request was sent at a time allowed by the DateTimeRestriction.
    """
    def __init__(__self__, *,
                 device_policy: 'outputs.DevicePolicyResponse',
                 ip_subnetworks: Sequence[str],
                 members: Sequence[str],
                 negate: bool,
                 regions: Sequence[str],
                 required_access_levels: Sequence[str]):
        """
        A condition necessary for an `AccessLevel` to be granted. The Condition is an AND over its fields. So a Condition is true if: 1) the request IP is from one of the listed subnetworks AND 2) the originating device complies with the listed device policy AND 3) all listed access levels are granted AND 4) the request was sent at a time allowed by the DateTimeRestriction.
        :param 'DevicePolicyResponseArgs' device_policy: Device specific restrictions, all restrictions must hold for the Condition to be true. If not specified, all devices are allowed.
        :param Sequence[str] ip_subnetworks: CIDR block IP subnetwork specification. May be IPv4 or IPv6. Note that for a CIDR IP address block, the specified IP address portion must be properly truncated (i.e. all the host bits must be zero) or the input is considered malformed. For example, "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly, for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32" is not. The originating IP of a request must be in one of the listed subnets in order for this Condition to be true. If empty, all IP addresses are allowed.
        :param Sequence[str] members: The request must be made by one of the provided user or service accounts. Groups are not supported. Syntax: `user:{emailid}` `serviceAccount:{emailid}` If not specified, a request may come from any user.
        :param bool negate: Whether to negate the Condition. If true, the Condition becomes a NAND over its non-empty fields, each field must be false for the Condition overall to be satisfied. Defaults to false.
        :param Sequence[str] regions: The request must originate from one of the provided countries/regions. Must be valid ISO 3166-1 alpha-2 codes.
        :param Sequence[str] required_access_levels: A list of other access levels defined in the same `Policy`, referenced by resource name. Referencing an `AccessLevel` which does not exist is an error. All access levels listed must be granted for the Condition to be true. Example: "`accessPolicies/MY_POLICY/accessLevels/LEVEL_NAME"`
        """
        pulumi.set(__self__, "device_policy", device_policy)
        pulumi.set(__self__, "ip_subnetworks", ip_subnetworks)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "negate", negate)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "required_access_levels", required_access_levels)

    @property
    @pulumi.getter(name="devicePolicy")
    def device_policy(self) -> 'outputs.DevicePolicyResponse':
        """
        Device specific restrictions, all restrictions must hold for the Condition to be true. If not specified, all devices are allowed.
        """
        return pulumi.get(self, "device_policy")

    @property
    @pulumi.getter(name="ipSubnetworks")
    def ip_subnetworks(self) -> Sequence[str]:
        """
        CIDR block IP subnetwork specification. May be IPv4 or IPv6. Note that for a CIDR IP address block, the specified IP address portion must be properly truncated (i.e. all the host bits must be zero) or the input is considered malformed. For example, "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly, for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32" is not. The originating IP of a request must be in one of the listed subnets in order for this Condition to be true. If empty, all IP addresses are allowed.
        """
        return pulumi.get(self, "ip_subnetworks")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        The request must be made by one of the provided user or service accounts. Groups are not supported. Syntax: `user:{emailid}` `serviceAccount:{emailid}` If not specified, a request may come from any user.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def negate(self) -> bool:
        """
        Whether to negate the Condition. If true, the Condition becomes a NAND over its non-empty fields, each field must be false for the Condition overall to be satisfied. Defaults to false.
        """
        return pulumi.get(self, "negate")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[str]:
        """
        The request must originate from one of the provided countries/regions. Must be valid ISO 3166-1 alpha-2 codes.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="requiredAccessLevels")
    def required_access_levels(self) -> Sequence[str]:
        """
        A list of other access levels defined in the same `Policy`, referenced by resource name. Referencing an `AccessLevel` which does not exist is an error. All access levels listed must be granted for the Condition to be true. Example: "`accessPolicies/MY_POLICY/accessLevels/LEVEL_NAME"`
        """
        return pulumi.get(self, "required_access_levels")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class CustomLevelResponse(dict):
    """
    `CustomLevel` is an `AccessLevel` using the Cloud Common Expression Language to represent the necessary conditions for the level to apply to a request. See CEL spec at: https://github.com/google/cel-spec
    """
    def __init__(__self__, *,
                 expr: 'outputs.ExprResponse'):
        """
        `CustomLevel` is an `AccessLevel` using the Cloud Common Expression Language to represent the necessary conditions for the level to apply to a request. See CEL spec at: https://github.com/google/cel-spec
        :param 'ExprResponseArgs' expr: Required. A Cloud CEL expression evaluating to a boolean.
        """
        pulumi.set(__self__, "expr", expr)

    @property
    @pulumi.getter
    def expr(self) -> 'outputs.ExprResponse':
        """
        Required. A Cloud CEL expression evaluating to a boolean.
        """
        return pulumi.get(self, "expr")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DevicePolicyResponse(dict):
    """
    `DevicePolicy` specifies device specific restrictions necessary to acquire a given access level. A `DevicePolicy` specifies requirements for requests from devices to be granted access levels, it does not do any enforcement on the device. `DevicePolicy` acts as an AND over all specified fields, and each repeated field is an OR over its elements. Any unset fields are ignored. For example, if the proto is { os_type : DESKTOP_WINDOWS, os_type : DESKTOP_LINUX, encryption_status: ENCRYPTED}, then the DevicePolicy will be true for requests originating from encrypted Linux desktops and encrypted Windows desktops.
    """
    def __init__(__self__, *,
                 allowed_device_management_levels: Sequence[str],
                 allowed_encryption_statuses: Sequence[str],
                 os_constraints: Sequence['outputs.OsConstraintResponse'],
                 require_admin_approval: bool,
                 require_corp_owned: bool,
                 require_screenlock: bool):
        """
        `DevicePolicy` specifies device specific restrictions necessary to acquire a given access level. A `DevicePolicy` specifies requirements for requests from devices to be granted access levels, it does not do any enforcement on the device. `DevicePolicy` acts as an AND over all specified fields, and each repeated field is an OR over its elements. Any unset fields are ignored. For example, if the proto is { os_type : DESKTOP_WINDOWS, os_type : DESKTOP_LINUX, encryption_status: ENCRYPTED}, then the DevicePolicy will be true for requests originating from encrypted Linux desktops and encrypted Windows desktops.
        :param Sequence[str] allowed_device_management_levels: Allowed device management levels, an empty list allows all management levels.
        :param Sequence[str] allowed_encryption_statuses: Allowed encryptions statuses, an empty list allows all statuses.
        :param Sequence['OsConstraintResponseArgs'] os_constraints: Allowed OS versions, an empty list allows all types and all versions.
        :param bool require_admin_approval: Whether the device needs to be approved by the customer admin.
        :param bool require_corp_owned: Whether the device needs to be corp owned.
        :param bool require_screenlock: Whether or not screenlock is required for the DevicePolicy to be true. Defaults to `false`.
        """
        pulumi.set(__self__, "allowed_device_management_levels", allowed_device_management_levels)
        pulumi.set(__self__, "allowed_encryption_statuses", allowed_encryption_statuses)
        pulumi.set(__self__, "os_constraints", os_constraints)
        pulumi.set(__self__, "require_admin_approval", require_admin_approval)
        pulumi.set(__self__, "require_corp_owned", require_corp_owned)
        pulumi.set(__self__, "require_screenlock", require_screenlock)

    @property
    @pulumi.getter(name="allowedDeviceManagementLevels")
    def allowed_device_management_levels(self) -> Sequence[str]:
        """
        Allowed device management levels, an empty list allows all management levels.
        """
        return pulumi.get(self, "allowed_device_management_levels")

    @property
    @pulumi.getter(name="allowedEncryptionStatuses")
    def allowed_encryption_statuses(self) -> Sequence[str]:
        """
        Allowed encryptions statuses, an empty list allows all statuses.
        """
        return pulumi.get(self, "allowed_encryption_statuses")

    @property
    @pulumi.getter(name="osConstraints")
    def os_constraints(self) -> Sequence['outputs.OsConstraintResponse']:
        """
        Allowed OS versions, an empty list allows all types and all versions.
        """
        return pulumi.get(self, "os_constraints")

    @property
    @pulumi.getter(name="requireAdminApproval")
    def require_admin_approval(self) -> bool:
        """
        Whether the device needs to be approved by the customer admin.
        """
        return pulumi.get(self, "require_admin_approval")

    @property
    @pulumi.getter(name="requireCorpOwned")
    def require_corp_owned(self) -> bool:
        """
        Whether the device needs to be corp owned.
        """
        return pulumi.get(self, "require_corp_owned")

    @property
    @pulumi.getter(name="requireScreenlock")
    def require_screenlock(self) -> bool:
        """
        Whether or not screenlock is required for the DevicePolicy to be true. Defaults to `false`.
        """
        return pulumi.get(self, "require_screenlock")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class EgressFromResponse(dict):
    """
    Defines the conditions under which an EgressPolicy matches a request. Conditions based on information about the source of the request. Note that if the destination of the request is protected by a ServicePerimeter, then that ServicePerimeter must have an IngressPolicy which allows access in order for this request to succeed.
    """
    def __init__(__self__, *,
                 identities: Sequence[str],
                 identity_type: str):
        """
        Defines the conditions under which an EgressPolicy matches a request. Conditions based on information about the source of the request. Note that if the destination of the request is protected by a ServicePerimeter, then that ServicePerimeter must have an IngressPolicy which allows access in order for this request to succeed.
        :param Sequence[str] identities: A list of identities that are allowed access through this [EgressPolicy]. Should be in the format of email address. The email address should represent individual user or service account only.
        :param str identity_type: Specifies the type of identities that are allowed access to outside the perimeter. If left unspecified, then members of `identities` field will be allowed access.
        """
        pulumi.set(__self__, "identities", identities)
        pulumi.set(__self__, "identity_type", identity_type)

    @property
    @pulumi.getter
    def identities(self) -> Sequence[str]:
        """
        A list of identities that are allowed access through this [EgressPolicy]. Should be in the format of email address. The email address should represent individual user or service account only.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> str:
        """
        Specifies the type of identities that are allowed access to outside the perimeter. If left unspecified, then members of `identities` field will be allowed access.
        """
        return pulumi.get(self, "identity_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class EgressPolicyResponse(dict):
    """
    Policy for egress from perimeter. EgressPolicies match requests based on `egress_from` and `egress_to` stanzas. For an EgressPolicy to match, both `egress_from` and `egress_to` stanzas must be matched. If an EgressPolicy matches a request, the request is allowed to span the ServicePerimeter boundary. For example, an EgressPolicy can be used to allow VMs on networks within the ServicePerimeter to access a defined set of projects outside the perimeter in certain contexts (e.g. to read data from a Cloud Storage bucket or query against a BigQuery dataset). EgressPolicies are concerned with the *resources* that a request relates as well as the API services and API actions being used. They do not related to the direction of data movement. More detailed documentation for this concept can be found in the descriptions of EgressFrom and EgressTo.
    """
    def __init__(__self__, *,
                 egress_from: 'outputs.EgressFromResponse',
                 egress_to: 'outputs.EgressToResponse'):
        """
        Policy for egress from perimeter. EgressPolicies match requests based on `egress_from` and `egress_to` stanzas. For an EgressPolicy to match, both `egress_from` and `egress_to` stanzas must be matched. If an EgressPolicy matches a request, the request is allowed to span the ServicePerimeter boundary. For example, an EgressPolicy can be used to allow VMs on networks within the ServicePerimeter to access a defined set of projects outside the perimeter in certain contexts (e.g. to read data from a Cloud Storage bucket or query against a BigQuery dataset). EgressPolicies are concerned with the *resources* that a request relates as well as the API services and API actions being used. They do not related to the direction of data movement. More detailed documentation for this concept can be found in the descriptions of EgressFrom and EgressTo.
        :param 'EgressFromResponseArgs' egress_from: Defines conditions on the source of a request causing this EgressPolicy to apply.
        :param 'EgressToResponseArgs' egress_to: Defines the conditions on the ApiOperation and destination resources that cause this EgressPolicy to apply.
        """
        pulumi.set(__self__, "egress_from", egress_from)
        pulumi.set(__self__, "egress_to", egress_to)

    @property
    @pulumi.getter(name="egressFrom")
    def egress_from(self) -> 'outputs.EgressFromResponse':
        """
        Defines conditions on the source of a request causing this EgressPolicy to apply.
        """
        return pulumi.get(self, "egress_from")

    @property
    @pulumi.getter(name="egressTo")
    def egress_to(self) -> 'outputs.EgressToResponse':
        """
        Defines the conditions on the ApiOperation and destination resources that cause this EgressPolicy to apply.
        """
        return pulumi.get(self, "egress_to")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class EgressToResponse(dict):
    """
    Defines the conditions under which an EgressPolicy matches a request. Conditions are based on information about the ApiOperation intended to be performed on the `resources` specified. Note that if the destination of the request is protected by a ServicePerimeter, then that ServicePerimeter must have an IngressPolicy which allows access in order for this request to succeed.
    """
    def __init__(__self__, *,
                 operations: Sequence['outputs.ApiOperationResponse'],
                 resources: Sequence[str]):
        """
        Defines the conditions under which an EgressPolicy matches a request. Conditions are based on information about the ApiOperation intended to be performed on the `resources` specified. Note that if the destination of the request is protected by a ServicePerimeter, then that ServicePerimeter must have an IngressPolicy which allows access in order for this request to succeed.
        :param Sequence['ApiOperationResponseArgs'] operations: A list of ApiOperations that this egress rule applies to. A request matches if it contains an operation/service in this list.
        :param Sequence[str] resources: A list of resources, currently only projects in the form `projects/`, that match this to stanza. A request matches if it contains a resource in this list. If `*` is specified for resources, then this EgressTo rule will authorize access to all resources outside the perimeter.
        """
        pulumi.set(__self__, "operations", operations)
        pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def operations(self) -> Sequence['outputs.ApiOperationResponse']:
        """
        A list of ApiOperations that this egress rule applies to. A request matches if it contains an operation/service in this list.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter
    def resources(self) -> Sequence[str]:
        """
        A list of resources, currently only projects in the form `projects/`, that match this to stanza. A request matches if it contains a resource in this list. If `*` is specified for resources, then this EgressTo rule will authorize access to all resources outside the perimeter.
        """
        return pulumi.get(self, "resources")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class IngressFromResponse(dict):
    """
    Defines the conditions under which an IngressPolicy matches a request. Conditions are based on information about the source of the request.
    """
    def __init__(__self__, *,
                 identities: Sequence[str],
                 identity_type: str,
                 sources: Sequence['outputs.IngressSourceResponse']):
        """
        Defines the conditions under which an IngressPolicy matches a request. Conditions are based on information about the source of the request.
        :param Sequence[str] identities: A list of identities that are allowed access through this ingress policy. Should be in the format of email address. The email address should represent individual user or service account only.
        :param str identity_type: Specifies the type of identities that are allowed access from outside the perimeter. If left unspecified, then members of `identities` field will be allowed access.
        :param Sequence['IngressSourceResponseArgs'] sources: Sources that this IngressPolicy authorizes access from.
        """
        pulumi.set(__self__, "identities", identities)
        pulumi.set(__self__, "identity_type", identity_type)
        pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def identities(self) -> Sequence[str]:
        """
        A list of identities that are allowed access through this ingress policy. Should be in the format of email address. The email address should represent individual user or service account only.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> str:
        """
        Specifies the type of identities that are allowed access from outside the perimeter. If left unspecified, then members of `identities` field will be allowed access.
        """
        return pulumi.get(self, "identity_type")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.IngressSourceResponse']:
        """
        Sources that this IngressPolicy authorizes access from.
        """
        return pulumi.get(self, "sources")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class IngressPolicyResponse(dict):
    """
    Policy for ingress into ServicePerimeter. IngressPolicies match requests based on `ingress_from` and `ingress_to` stanzas. For an ingress policy to match, both the `ingress_from` and `ingress_to` stanzas must be matched. If an IngressPolicy matches a request, the request is allowed through the perimeter boundary from outside the perimeter. For example, access from the internet can be allowed either based on an AccessLevel or, for traffic hosted on Google Cloud, the project of the source network. For access from private networks, using the project of the hosting network is required. Individual ingress policies can be limited by restricting which services and/or actions they match using the `ingress_to` field.
    """
    def __init__(__self__, *,
                 ingress_from: 'outputs.IngressFromResponse',
                 ingress_to: 'outputs.IngressToResponse'):
        """
        Policy for ingress into ServicePerimeter. IngressPolicies match requests based on `ingress_from` and `ingress_to` stanzas. For an ingress policy to match, both the `ingress_from` and `ingress_to` stanzas must be matched. If an IngressPolicy matches a request, the request is allowed through the perimeter boundary from outside the perimeter. For example, access from the internet can be allowed either based on an AccessLevel or, for traffic hosted on Google Cloud, the project of the source network. For access from private networks, using the project of the hosting network is required. Individual ingress policies can be limited by restricting which services and/or actions they match using the `ingress_to` field.
        :param 'IngressFromResponseArgs' ingress_from: Defines the conditions on the source of a request causing this IngressPolicy to apply.
        :param 'IngressToResponseArgs' ingress_to: Defines the conditions on the ApiOperation and request destination that cause this IngressPolicy to apply.
        """
        pulumi.set(__self__, "ingress_from", ingress_from)
        pulumi.set(__self__, "ingress_to", ingress_to)

    @property
    @pulumi.getter(name="ingressFrom")
    def ingress_from(self) -> 'outputs.IngressFromResponse':
        """
        Defines the conditions on the source of a request causing this IngressPolicy to apply.
        """
        return pulumi.get(self, "ingress_from")

    @property
    @pulumi.getter(name="ingressTo")
    def ingress_to(self) -> 'outputs.IngressToResponse':
        """
        Defines the conditions on the ApiOperation and request destination that cause this IngressPolicy to apply.
        """
        return pulumi.get(self, "ingress_to")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class IngressSourceResponse(dict):
    """
    The source that IngressPolicy authorizes access from.
    """
    def __init__(__self__, *,
                 access_level: str,
                 resource: str):
        """
        The source that IngressPolicy authorizes access from.
        :param str access_level: An AccessLevel resource name that allow resources within the ServicePerimeters to be accessed from the internet. AccessLevels listed must be in the same policy as this ServicePerimeter. Referencing a nonexistent AccessLevel will cause an error. If no AccessLevel names are listed, resources within the perimeter can only be accessed via Google Cloud calls with request origins within the perimeter. Example: `accessPolicies/MY_POLICY/accessLevels/MY_LEVEL`. If `*` is specified, then all IngressSources will be allowed.
        :param str resource: A Google Cloud resource that is allowed to ingress the perimeter. Requests from these resources will be allowed to access perimeter data. Currently only projects are allowed. Format: `projects/{project_number}` The project may be in any Google Cloud organization, not just the organization that the perimeter is defined in. `*` is not allowed, the case of allowing all Google Cloud resources only is not supported.
        """
        pulumi.set(__self__, "access_level", access_level)
        pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> str:
        """
        An AccessLevel resource name that allow resources within the ServicePerimeters to be accessed from the internet. AccessLevels listed must be in the same policy as this ServicePerimeter. Referencing a nonexistent AccessLevel will cause an error. If no AccessLevel names are listed, resources within the perimeter can only be accessed via Google Cloud calls with request origins within the perimeter. Example: `accessPolicies/MY_POLICY/accessLevels/MY_LEVEL`. If `*` is specified, then all IngressSources will be allowed.
        """
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter
    def resource(self) -> str:
        """
        A Google Cloud resource that is allowed to ingress the perimeter. Requests from these resources will be allowed to access perimeter data. Currently only projects are allowed. Format: `projects/{project_number}` The project may be in any Google Cloud organization, not just the organization that the perimeter is defined in. `*` is not allowed, the case of allowing all Google Cloud resources only is not supported.
        """
        return pulumi.get(self, "resource")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class IngressToResponse(dict):
    """
    Defines the conditions under which an IngressPolicy matches a request. Conditions are based on information about the ApiOperation intended to be performed on the destination of the request.
    """
    def __init__(__self__, *,
                 operations: Sequence['outputs.ApiOperationResponse'],
                 resources: Sequence[str]):
        """
        Defines the conditions under which an IngressPolicy matches a request. Conditions are based on information about the ApiOperation intended to be performed on the destination of the request.
        :param Sequence['ApiOperationResponseArgs'] operations: A list of ApiOperations the sources specified in corresponding IngressFrom are allowed to perform in this ServicePerimeter.
        :param Sequence[str] resources: A list of resources, currently only projects in the form `projects/`, protected by this ServicePerimeter that are allowed to be accessed by sources defined in the corresponding IngressFrom. A request matches if it contains a resource in this list. If `*` is specified for resources, then this IngressTo rule will authorize access to all resources inside the perimeter, provided that the request also matches the `operations` field.
        """
        pulumi.set(__self__, "operations", operations)
        pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def operations(self) -> Sequence['outputs.ApiOperationResponse']:
        """
        A list of ApiOperations the sources specified in corresponding IngressFrom are allowed to perform in this ServicePerimeter.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter
    def resources(self) -> Sequence[str]:
        """
        A list of resources, currently only projects in the form `projects/`, protected by this ServicePerimeter that are allowed to be accessed by sources defined in the corresponding IngressFrom. A request matches if it contains a resource in this list. If `*` is specified for resources, then this IngressTo rule will authorize access to all resources inside the perimeter, provided that the request also matches the `operations` field.
        """
        return pulumi.get(self, "resources")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class MethodSelectorResponse(dict):
    """
    An allowed method or permission of a service specified in ApiOperation.
    """
    def __init__(__self__, *,
                 method: str,
                 permission: str):
        """
        An allowed method or permission of a service specified in ApiOperation.
        :param str method: Value for `method` should be a valid method name for the corresponding `service_name` in ApiOperation. If `*` used as value for `method`, then ALL methods and permissions are allowed.
        :param str permission: Value for `permission` should be a valid Cloud IAM permission for the corresponding `service_name` in ApiOperation.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def method(self) -> str:
        """
        Value for `method` should be a valid method name for the corresponding `service_name` in ApiOperation. If `*` used as value for `method`, then ALL methods and permissions are allowed.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def permission(self) -> str:
        """
        Value for `permission` should be a valid Cloud IAM permission for the corresponding `service_name` in ApiOperation.
        """
        return pulumi.get(self, "permission")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OsConstraintResponse(dict):
    """
    A restriction on the OS type and version of devices making requests.
    """
    def __init__(__self__, *,
                 minimum_version: str,
                 os_type: str,
                 require_verified_chrome_os: bool):
        """
        A restriction on the OS type and version of devices making requests.
        :param str minimum_version: The minimum allowed OS version. If not set, any version of this OS satisfies the constraint. Format: `"major.minor.patch"`. Examples: `"10.5.301"`, `"9.2.1"`.
        :param str os_type: Required. The allowed OS type.
        :param bool require_verified_chrome_os: Only allows requests from devices with a verified Chrome OS. Verifications includes requirements that the device is enterprise-managed, conformant to domain policies, and the caller has permission to call the API targeted by the request.
        """
        pulumi.set(__self__, "minimum_version", minimum_version)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "require_verified_chrome_os", require_verified_chrome_os)

    @property
    @pulumi.getter(name="minimumVersion")
    def minimum_version(self) -> str:
        """
        The minimum allowed OS version. If not set, any version of this OS satisfies the constraint. Format: `"major.minor.patch"`. Examples: `"10.5.301"`, `"9.2.1"`.
        """
        return pulumi.get(self, "minimum_version")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        Required. The allowed OS type.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="requireVerifiedChromeOs")
    def require_verified_chrome_os(self) -> bool:
        """
        Only allows requests from devices with a verified Chrome OS. Verifications includes requirements that the device is enterprise-managed, conformant to domain policies, and the caller has permission to call the API targeted by the request.
        """
        return pulumi.get(self, "require_verified_chrome_os")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServicePerimeterConfigResponse(dict):
    """
    `ServicePerimeterConfig` specifies a set of Google Cloud resources that describe specific Service Perimeter configuration.
    """
    def __init__(__self__, *,
                 access_levels: Sequence[str],
                 egress_policies: Sequence['outputs.EgressPolicyResponse'],
                 ingress_policies: Sequence['outputs.IngressPolicyResponse'],
                 resources: Sequence[str],
                 restricted_services: Sequence[str],
                 vpc_accessible_services: 'outputs.VpcAccessibleServicesResponse'):
        """
        `ServicePerimeterConfig` specifies a set of Google Cloud resources that describe specific Service Perimeter configuration.
        :param Sequence[str] access_levels: A list of `AccessLevel` resource names that allow resources within the `ServicePerimeter` to be accessed from the internet. `AccessLevels` listed must be in the same policy as this `ServicePerimeter`. Referencing a nonexistent `AccessLevel` is a syntax error. If no `AccessLevel` names are listed, resources within the perimeter can only be accessed via Google Cloud calls with request origins within the perimeter. Example: `"accessPolicies/MY_POLICY/accessLevels/MY_LEVEL"`. For Service Perimeter Bridge, must be empty.
        :param Sequence['EgressPolicyResponseArgs'] egress_policies: List of EgressPolicies to apply to the perimeter. A perimeter may have multiple EgressPolicies, each of which is evaluated separately. Access is granted if any EgressPolicy grants it. Must be empty for a perimeter bridge.
        :param Sequence['IngressPolicyResponseArgs'] ingress_policies: List of IngressPolicies to apply to the perimeter. A perimeter may have multiple IngressPolicies, each of which is evaluated separately. Access is granted if any Ingress Policy grants it. Must be empty for a perimeter bridge.
        :param Sequence[str] resources: A list of Google Cloud resources that are inside of the service perimeter. Currently only projects are allowed. Format: `projects/{project_number}`
        :param Sequence[str] restricted_services: Google Cloud services that are subject to the Service Perimeter restrictions. For example, if `storage.googleapis.com` is specified, access to the storage buckets inside the perimeter must meet the perimeter's access restrictions.
        :param 'VpcAccessibleServicesResponseArgs' vpc_accessible_services: Configuration for APIs allowed within Perimeter.
        """
        pulumi.set(__self__, "access_levels", access_levels)
        pulumi.set(__self__, "egress_policies", egress_policies)
        pulumi.set(__self__, "ingress_policies", ingress_policies)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "restricted_services", restricted_services)
        pulumi.set(__self__, "vpc_accessible_services", vpc_accessible_services)

    @property
    @pulumi.getter(name="accessLevels")
    def access_levels(self) -> Sequence[str]:
        """
        A list of `AccessLevel` resource names that allow resources within the `ServicePerimeter` to be accessed from the internet. `AccessLevels` listed must be in the same policy as this `ServicePerimeter`. Referencing a nonexistent `AccessLevel` is a syntax error. If no `AccessLevel` names are listed, resources within the perimeter can only be accessed via Google Cloud calls with request origins within the perimeter. Example: `"accessPolicies/MY_POLICY/accessLevels/MY_LEVEL"`. For Service Perimeter Bridge, must be empty.
        """
        return pulumi.get(self, "access_levels")

    @property
    @pulumi.getter(name="egressPolicies")
    def egress_policies(self) -> Sequence['outputs.EgressPolicyResponse']:
        """
        List of EgressPolicies to apply to the perimeter. A perimeter may have multiple EgressPolicies, each of which is evaluated separately. Access is granted if any EgressPolicy grants it. Must be empty for a perimeter bridge.
        """
        return pulumi.get(self, "egress_policies")

    @property
    @pulumi.getter(name="ingressPolicies")
    def ingress_policies(self) -> Sequence['outputs.IngressPolicyResponse']:
        """
        List of IngressPolicies to apply to the perimeter. A perimeter may have multiple IngressPolicies, each of which is evaluated separately. Access is granted if any Ingress Policy grants it. Must be empty for a perimeter bridge.
        """
        return pulumi.get(self, "ingress_policies")

    @property
    @pulumi.getter
    def resources(self) -> Sequence[str]:
        """
        A list of Google Cloud resources that are inside of the service perimeter. Currently only projects are allowed. Format: `projects/{project_number}`
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="restrictedServices")
    def restricted_services(self) -> Sequence[str]:
        """
        Google Cloud services that are subject to the Service Perimeter restrictions. For example, if `storage.googleapis.com` is specified, access to the storage buckets inside the perimeter must meet the perimeter's access restrictions.
        """
        return pulumi.get(self, "restricted_services")

    @property
    @pulumi.getter(name="vpcAccessibleServices")
    def vpc_accessible_services(self) -> 'outputs.VpcAccessibleServicesResponse':
        """
        Configuration for APIs allowed within Perimeter.
        """
        return pulumi.get(self, "vpc_accessible_services")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VpcAccessibleServicesResponse(dict):
    """
    Specifies how APIs are allowed to communicate within the Service Perimeter.
    """
    def __init__(__self__, *,
                 allowed_services: Sequence[str],
                 enable_restriction: bool):
        """
        Specifies how APIs are allowed to communicate within the Service Perimeter.
        :param Sequence[str] allowed_services: The list of APIs usable within the Service Perimeter. Must be empty unless 'enable_restriction' is True. You can specify a list of individual services, as well as include the 'RESTRICTED-SERVICES' value, which automatically includes all of the services protected by the perimeter.
        :param bool enable_restriction: Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowed_services'.
        """
        pulumi.set(__self__, "allowed_services", allowed_services)
        pulumi.set(__self__, "enable_restriction", enable_restriction)

    @property
    @pulumi.getter(name="allowedServices")
    def allowed_services(self) -> Sequence[str]:
        """
        The list of APIs usable within the Service Perimeter. Must be empty unless 'enable_restriction' is True. You can specify a list of individual services, as well as include the 'RESTRICTED-SERVICES' value, which automatically includes all of the services protected by the perimeter.
        """
        return pulumi.get(self, "allowed_services")

    @property
    @pulumi.getter(name="enableRestriction")
    def enable_restriction(self) -> bool:
        """
        Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowed_services'.
        """
        return pulumi.get(self, "enable_restriction")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


