# coding: utf-8

"""
    3Di API

    3Di simulation API (latest version: 3.0)   Framework release: 1.0.10   3Di core release: 2.0.10  deployed on:  09:44AM (UTC) on July 02, 2020  # noqa: E501

    The version of the OpenAPI document: 3.0
    Contact: info@nelen-schuurmans.nl
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class SimulationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def simulations_actions_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Post an action to the simulation to start, pause or end it.  # noqa: E501

        Example usage:  To initialize a simulation (and pause) ``` {\"name\": \"initialize\"} ```  To initialize and directly run a simulation ``` {\"name\": \"start\"} ``` Also use \"start\" to resume a paused simulation.  If you want to pause the simulation automatically after a given duration use the duration parameter ``` {   \"name\": \"start\",   \"duration\": 2500 } ```  To pause a simulation ``` {\"name\": \"pause\"} ``` Please note: The simulation will automatically be shut down after the default timeout of 300 seconds has been reached. You can customize this value by specifying the timeout parameter ``` {   \"name\": \"pause\",   \"timeout\": 999 } ```  To end a simulation ``` {\"name\": \"shutdown\"} ```  To queue a simulation ``` {\"name\": \"queue\"} ``` Queued simulations will be started as soon as a session spot becomes available. If a session spot is directly is available the simulation will also be started immediately. The response body will then contain `{\"name\": \"start\"}` ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_actions_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Action data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Action
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_actions_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_actions_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Post an action to the simulation to start, pause or end it.  # noqa: E501

        Example usage:  To initialize a simulation (and pause) ``` {\"name\": \"initialize\"} ```  To initialize and directly run a simulation ``` {\"name\": \"start\"} ``` Also use \"start\" to resume a paused simulation.  If you want to pause the simulation automatically after a given duration use the duration parameter ``` {   \"name\": \"start\",   \"duration\": 2500 } ```  To pause a simulation ``` {\"name\": \"pause\"} ``` Please note: The simulation will automatically be shut down after the default timeout of 300 seconds has been reached. You can customize this value by specifying the timeout parameter ``` {   \"name\": \"pause\",   \"timeout\": 999 } ```  To end a simulation ``` {\"name\": \"shutdown\"} ```  To queue a simulation ``` {\"name\": \"queue\"} ``` Queued simulations will be started as soon as a session spot becomes available. If a session spot is directly is available the simulation will also be started immediately. The response body will then contain `{\"name\": \"start\"}` ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_actions_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Action data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Action, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_actions_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_actions_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_actions_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/actions/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Action',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create(self, data, **kwargs):  # noqa: E501
        """Create a simulation resource  # noqa: E501

        There are two options to specify the desired duration for the simulation, either by using the ``end_datetime`` **or** the ``duration`` parameter.  ``` {   \"name\":           # give the simualtion a name (optional)   \"threedimodel\":   # The model schema to use for the simulation by                     referring to the id of the threedimodel resource   \"organisation\":   # uuid of the organisation for which the                     simulation is run   \"start_datetime\": # datetime (in ISO 8601 (UTC) format) for the                     simulation start, e.g. \"YYYY-MM-DDThh:mm:ss\"   \"end_datetime\":   # datetime (in ISO 8601 (UTC) format) for the                     simulation end, e.g. \"YYYY-MM-DDThh:mm:ss\"   \"duration\":       # in seconds, can be used instead of end_datetime } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Simulation data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Simulation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_with_http_info(data, **kwargs)  # noqa: E501

    def simulations_create_with_http_info(self, data, **kwargs):  # noqa: E501
        """Create a simulation resource  # noqa: E501

        There are two options to specify the desired duration for the simulation, either by using the ``end_datetime`` **or** the ``duration`` parameter.  ``` {   \"name\":           # give the simualtion a name (optional)   \"threedimodel\":   # The model schema to use for the simulation by                     referring to the id of the threedimodel resource   \"organisation\":   # uuid of the organisation for which the                     simulation is run   \"start_datetime\": # datetime (in ISO 8601 (UTC) format) for the                     simulation start, e.g. \"YYYY-MM-DDThh:mm:ss\"   \"end_datetime\":   # datetime (in ISO 8601 (UTC) format) for the                     simulation end, e.g. \"YYYY-MM-DDThh:mm:ss\"   \"duration\":       # in seconds, can be used instead of end_datetime } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_with_http_info(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Simulation data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Simulation, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Simulation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_stable_threshold_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Save the state of the simulation to file when a given (set of) variable(s) becomes stable  # noqa: E501

        Example ``` {   \"expiry\": \"2020-08-15T13:02:30.317Z\",   \"thresholds\": [     {       \"variable\": \"s1\",       \"value\": 0.005     }   ] } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param StableThresholdSavedState data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StableThresholdSavedState
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_stable_threshold_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_create_saved_states_stable_threshold_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Save the state of the simulation to file when a given (set of) variable(s) becomes stable  # noqa: E501

        Example ``` {   \"expiry\": \"2020-08-15T13:02:30.317Z\",   \"thresholds\": [     {       \"variable\": \"s1\",       \"value\": 0.005     }   ] } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param StableThresholdSavedState data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StableThresholdSavedState, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_stable_threshold_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_stable_threshold_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create_saved_states_stable_threshold_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/create-saved-states/stable-threshold/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StableThresholdSavedState',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_stable_threshold_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_delete  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_stable_threshold_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_create_saved_states_stable_threshold_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_delete  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_stable_threshold_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_stable_threshold_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_stable_threshold_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/create-saved-states/stable-threshold/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_stable_threshold_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_list  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20011
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_stable_threshold_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_create_saved_states_stable_threshold_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_list  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20011, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_stable_threshold_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_stable_threshold_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/create-saved-states/stable-threshold/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20011',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_stable_threshold_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_partial_update  # noqa: E501

        When the simulation has started this resource can not be patched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param StableThresholdSavedState data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_stable_threshold_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_create_saved_states_stable_threshold_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_partial_update  # noqa: E501

        When the simulation has started this resource can not be patched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param StableThresholdSavedState data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_stable_threshold_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_stable_threshold_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_stable_threshold_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create_saved_states_stable_threshold_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/create-saved-states/stable-threshold/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_stable_threshold_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_read  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StableThresholdSavedState
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_stable_threshold_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_create_saved_states_stable_threshold_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_read  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StableThresholdSavedState, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_stable_threshold_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_stable_threshold_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_stable_threshold_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/create-saved-states/stable-threshold/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StableThresholdSavedState',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_stable_threshold_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_update  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param StableThresholdSavedState data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StableThresholdSavedState
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_stable_threshold_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_create_saved_states_stable_threshold_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_update  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param StableThresholdSavedState data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StableThresholdSavedState, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_stable_threshold_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_stable_threshold_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_stable_threshold_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create_saved_states_stable_threshold_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/create-saved-states/stable-threshold/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StableThresholdSavedState',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_stable_threshold_upload(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_upload  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_upload(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_stable_threshold_upload_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_create_saved_states_stable_threshold_upload_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_upload  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_upload_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_stable_threshold_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_stable_threshold_upload`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_stable_threshold_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create_saved_states_stable_threshold_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/create-saved-states/stable-threshold/{id}/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_timed_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Save the state at a given time of the simulation to file  # noqa: E501

        ```     {       \"name\":   # custom name for the saved state (optional)       \"tags\":   # add tags to the resource. Either space or comma                 separated (optional)       \"expiry\": # datetime (in ISO 8601 (UTC) format) until the saved                 state file will be kept       \"time\":   # the state at this given time of the simulation will                  be saved to file     } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimedSavedStateUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimedSavedStateUpdate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_timed_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_create_saved_states_timed_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Save the state at a given time of the simulation to file  # noqa: E501

        ```     {       \"name\":   # custom name for the saved state (optional)       \"tags\":   # add tags to the resource. Either space or comma                 separated (optional)       \"expiry\": # datetime (in ISO 8601 (UTC) format) until the saved                 state file will be kept       \"time\":   # the state at this given time of the simulation will                  be saved to file     } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimedSavedStateUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimedSavedStateUpdate, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_timed_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_timed_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create_saved_states_timed_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/create-saved-states/timed/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimedSavedStateUpdate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_timed_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_delete  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_timed_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_create_saved_states_timed_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_delete  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_timed_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_timed_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_timed_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/create-saved-states/timed/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_timed_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_list  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20012
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_timed_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_create_saved_states_timed_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_list  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20012, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_timed_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_timed_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/create-saved-states/timed/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20012',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_timed_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_partial_update  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param TimedSavedStateUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_timed_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_create_saved_states_timed_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_partial_update  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param TimedSavedStateUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_timed_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_timed_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_timed_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create_saved_states_timed_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/create-saved-states/timed/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_timed_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_read  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimedSavedStateUpdate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_timed_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_create_saved_states_timed_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_read  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimedSavedStateUpdate, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_timed_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_timed_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_timed_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/create-saved-states/timed/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimedSavedStateUpdate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_timed_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_update  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param TimedSavedStateUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimedSavedStateUpdate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_timed_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_create_saved_states_timed_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_update  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param TimedSavedStateUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimedSavedStateUpdate, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_timed_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_timed_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_timed_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create_saved_states_timed_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/create-saved-states/timed/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimedSavedStateUpdate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_timed_upload(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_upload  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_upload(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_timed_upload_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_create_saved_states_timed_upload_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_upload  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_upload_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_timed_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_timed_upload`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_timed_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create_saved_states_timed_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/create-saved-states/timed/{id}/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_delete(self, id, **kwargs):  # noqa: E501
        """simulations_delete  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this simulation. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_delete_with_http_info(id, **kwargs)  # noqa: E501

    def simulations_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """simulations_delete  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this simulation. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events(self, id, **kwargs):  # noqa: E501
        """simulations_events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this simulation. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Event
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_with_http_info(id, **kwargs)  # noqa: E501

    def simulations_events_with_http_info(self, id, **kwargs):  # noqa: E501
        """simulations_events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this simulation. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Event, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{id}/events/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Event',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_breaches_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_breaches_create  # noqa: E501

        A simple ViewSet for viewing Breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Breach data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Breach
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_breaches_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_breaches_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_breaches_create  # noqa: E501

        A simple ViewSet for viewing Breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Breach data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Breach, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_breaches_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_breaches_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_breaches_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/breaches/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Breach',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_breaches_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_breaches_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this breach. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_breaches_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_breaches_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_breaches_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this breach. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_breaches_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_breaches_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_breaches_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/breaches/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_breaches_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_breaches_list  # noqa: E501

        A simple ViewSet for viewing Breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20013
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_breaches_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_breaches_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_breaches_list  # noqa: E501

        A simple ViewSet for viewing Breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20013, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_breaches_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_breaches_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/breaches/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20013',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_breaches_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_breaches_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this breach. (required)
        :param str simulation_pk: (required)
        :param Breach data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_breaches_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_breaches_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_breaches_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this breach. (required)
        :param str simulation_pk: (required)
        :param Breach data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_breaches_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_breaches_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_breaches_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_breaches_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/breaches/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_breaches_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_breaches_read  # noqa: E501

        A simple ViewSet for viewing Breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this breach. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Breach
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_breaches_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_breaches_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_breaches_read  # noqa: E501

        A simple ViewSet for viewing Breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this breach. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Breach, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_breaches_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_breaches_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_breaches_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/breaches/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Breach',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_breaches_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_breaches_update  # noqa: E501

        A simple ViewSet for viewing Breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this breach. (required)
        :param str simulation_pk: (required)
        :param Breach data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Breach
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_breaches_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_breaches_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_breaches_update  # noqa: E501

        A simple ViewSet for viewing Breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this breach. (required)
        :param str simulation_pk: (required)
        :param Breach data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Breach, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_breaches_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_breaches_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_breaches_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_breaches_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/breaches/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Breach',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_constant_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_create  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantLateral data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantLateral
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_constant_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_constant_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_create  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantLateral data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantLateral, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_constant_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_constant_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_constant_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/lateral/constant/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantLateral',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_constant_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_constant_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_lateral_constant_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_constant_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_constant_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_constant_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/lateral/constant/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_constant_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_list  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20014
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_constant_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_lateral_constant_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_list  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20014, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_constant_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_constant_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/lateral/constant/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20014',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_constant_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param ConstantLateral data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_constant_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_constant_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param ConstantLateral data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_constant_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_constant_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/lateral/constant/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_constant_processed(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_processed  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_processed(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param GridEventState data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_constant_processed_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_constant_processed_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_processed  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_processed_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param GridEventState data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_constant_processed" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_constant_processed`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_constant_processed`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_constant_processed`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/lateral/constant/{id}/processed/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_constant_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_read  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantLateral
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_constant_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_lateral_constant_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_read  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantLateral, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_constant_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_constant_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_constant_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/lateral/constant/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantLateral',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_constant_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_update  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param ConstantLateral data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantLateral
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_constant_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_constant_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_update  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param ConstantLateral data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantLateral, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_constant_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_constant_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_constant_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_constant_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/lateral/constant/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantLateral',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_timeseries_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimeseriesLateral data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesLateral
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_timeseries_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_timeseries_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimeseriesLateral data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesLateral, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_timeseries_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_timeseries_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_timeseries_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/lateral/timeseries/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesLateral',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_timeseries_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_timeseries_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_lateral_timeseries_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_timeseries_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_timeseries_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_timeseries_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/lateral/timeseries/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_timeseries_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20015
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_timeseries_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_lateral_timeseries_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20015, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_timeseries_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_timeseries_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/lateral/timeseries/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20015',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_timeseries_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLateral data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_timeseries_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_timeseries_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLateral data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_timeseries_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_timeseries_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_timeseries_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_timeseries_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/lateral/timeseries/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_timeseries_processed(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_processed  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_processed(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param GridEventState data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_timeseries_processed_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_timeseries_processed_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_processed  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_processed_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param GridEventState data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_timeseries_processed" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_timeseries_processed`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_timeseries_processed`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_timeseries_processed`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/lateral/timeseries/{id}/processed/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_timeseries_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesLateral
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_timeseries_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_lateral_timeseries_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesLateral, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_timeseries_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_timeseries_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_timeseries_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/lateral/timeseries/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesLateral',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_timeseries_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLateral data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesLateral
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_timeseries_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_timeseries_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLateral data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesLateral, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_timeseries_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_timeseries_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_timeseries_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_timeseries_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/lateral/timeseries/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesLateral',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_constant_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_constant_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_constant_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_constant_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_constant_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_constant_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/constant/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_constant_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_constant_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_constant_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_constant_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_constant_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_constant_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/constant/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_constant_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20016
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_constant_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_constant_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20016, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_constant_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_constant_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/constant/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20016',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_constant_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param ConstantRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_constant_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_constant_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param ConstantRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_constant_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_constant_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/constant/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_constant_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_constant_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_constant_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_constant_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_constant_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_constant_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/constant/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_constant_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param ConstantRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_constant_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_constant_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param ConstantRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_constant_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_constant_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_constant_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_constant_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/constant/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_constant_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantLocalRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantLocalRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_constant_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_local_constant_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantLocalRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantLocalRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_constant_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_constant_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_local_constant_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/local/constant/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantLocalRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_constant_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_constant_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_local_constant_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_constant_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_local_constant_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_constant_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/local/constant/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_constant_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20017
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_constant_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_local_constant_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20017, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_constant_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_constant_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/local/constant/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20017',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_constant_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param ConstantLocalRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_constant_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_local_constant_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param ConstantLocalRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_constant_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_local_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_local_constant_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/local/constant/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_constant_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantLocalRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_constant_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_local_constant_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantLocalRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_constant_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_local_constant_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_constant_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/local/constant/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantLocalRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_constant_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param ConstantLocalRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantLocalRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_constant_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_local_constant_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param ConstantLocalRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantLocalRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_constant_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_local_constant_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_constant_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_local_constant_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/local/constant/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantLocalRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_timeseries_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimeseriesLocalRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesLocalRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_timeseries_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_local_timeseries_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimeseriesLocalRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesLocalRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_timeseries_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_timeseries_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_local_timeseries_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/local/timeseries/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesLocalRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_timeseries_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_timeseries_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_local_timeseries_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_timeseries_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_local_timeseries_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_timeseries_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/local/timeseries/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_timeseries_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20018
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_timeseries_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_local_timeseries_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20018, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_timeseries_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_timeseries_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/local/timeseries/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20018',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_timeseries_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLocalRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_timeseries_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_local_timeseries_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLocalRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_timeseries_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_local_timeseries_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_timeseries_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_local_timeseries_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/local/timeseries/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_timeseries_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesLocalRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_timeseries_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_local_timeseries_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesLocalRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_timeseries_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_local_timeseries_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_timeseries_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/local/timeseries/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesLocalRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_timeseries_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLocalRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesLocalRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_timeseries_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_local_timeseries_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLocalRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesLocalRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_timeseries_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_local_timeseries_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_timeseries_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_local_timeseries_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/local/timeseries/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesLocalRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_lizard_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_create  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param LizardRasterRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LizardRasterRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_lizard_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_lizard_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_create  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param LizardRasterRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LizardRasterRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_lizard_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_lizard_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_rasters_lizard_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/rasters/lizard/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LizardRasterRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_lizard_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_lizard_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_lizard_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_lizard_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_rasters_lizard_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_lizard_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/rasters/lizard/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_lizard_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_list  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20019
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_lizard_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_lizard_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_list  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20019, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_lizard_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_lizard_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/rasters/lizard/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20019',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_lizard_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster rain. (required)
        :param str simulation_pk: (required)
        :param LizardRasterRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_lizard_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_lizard_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster rain. (required)
        :param str simulation_pk: (required)
        :param LizardRasterRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_lizard_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_rasters_lizard_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_lizard_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_rasters_lizard_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/rasters/lizard/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_lizard_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_read  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LizardRasterRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_lizard_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_lizard_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_read  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LizardRasterRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_lizard_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_rasters_lizard_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_lizard_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/rasters/lizard/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LizardRasterRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_lizard_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_update  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster rain. (required)
        :param str simulation_pk: (required)
        :param LizardRasterRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LizardRasterRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_lizard_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_lizard_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_update  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster rain. (required)
        :param str simulation_pk: (required)
        :param LizardRasterRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LizardRasterRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_lizard_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_rasters_lizard_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_lizard_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_rasters_lizard_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/rasters/lizard/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LizardRasterRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_netcdf_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_netcdf_create  # noqa: E501

        NetCDF 4 raster rain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_netcdf_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_netcdf_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_netcdf_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_netcdf_create  # noqa: E501

        NetCDF 4 raster rain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_netcdf_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_netcdf_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_netcdf_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_rasters_netcdf_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/rasters/netcdf/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_netcdf_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_netcdf_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_netcdf_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_netcdf_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_netcdf_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_netcdf_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_netcdf_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_netcdf_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_rasters_netcdf_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_netcdf_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/rasters/netcdf/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_netcdf_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_netcdf_list  # noqa: E501

        NetCDF 4 raster rain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_netcdf_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20020
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_netcdf_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_netcdf_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_netcdf_list  # noqa: E501

        NetCDF 4 raster rain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_netcdf_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20020, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_netcdf_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_netcdf_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/rasters/netcdf/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20020',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_netcdf_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_netcdf_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_netcdf_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster rain. (required)
        :param str simulation_pk: (required)
        :param NetCDFRasterRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_netcdf_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_netcdf_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_netcdf_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_netcdf_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster rain. (required)
        :param str simulation_pk: (required)
        :param NetCDFRasterRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_netcdf_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_rasters_netcdf_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_netcdf_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_rasters_netcdf_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/rasters/netcdf/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_netcdf_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_netcdf_read  # noqa: E501

        NetCDF 4 raster rain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_netcdf_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NetCDFRasterRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_netcdf_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_netcdf_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_netcdf_read  # noqa: E501

        NetCDF 4 raster rain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_netcdf_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NetCDFRasterRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_netcdf_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_rasters_netcdf_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_netcdf_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/rasters/netcdf/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetCDFRasterRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_netcdf_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_netcdf_update  # noqa: E501

        NetCDF 4 raster rain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_netcdf_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster rain. (required)
        :param str simulation_pk: (required)
        :param NetCDFRasterRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NetCDFRasterRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_netcdf_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_netcdf_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_netcdf_update  # noqa: E501

        NetCDF 4 raster rain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_netcdf_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster rain. (required)
        :param str simulation_pk: (required)
        :param NetCDFRasterRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NetCDFRasterRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_netcdf_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_rasters_netcdf_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_netcdf_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_rasters_netcdf_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/rasters/netcdf/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetCDFRasterRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimeseriesRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimeseriesRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_timeseries_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_timeseries_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20021
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20021, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20021',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_lizard_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_lizard_create  # noqa: E501

        A simple ViewSet for viewing LizardTimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_lizard_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param LizardTimeseriesRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LizardTimeseriesRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_lizard_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_lizard_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_lizard_create  # noqa: E501

        A simple ViewSet for viewing LizardTimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_lizard_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param LizardTimeseriesRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LizardTimeseriesRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_lizard_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_lizard_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_timeseries_lizard_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/lizard/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LizardTimeseriesRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_lizard_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_lizard_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_lizard_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_lizard_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_lizard_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_lizard_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_lizard_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_lizard_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_timeseries_lizard_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_lizard_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/lizard/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_lizard_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_lizard_list  # noqa: E501

        A simple ViewSet for viewing LizardTimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_lizard_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20022
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_lizard_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_lizard_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_lizard_list  # noqa: E501

        A simple ViewSet for viewing LizardTimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_lizard_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20022, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_lizard_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_lizard_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/lizard/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20022',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_lizard_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_lizard_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_lizard_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard timeseries rain. (required)
        :param str simulation_pk: (required)
        :param LizardTimeseriesRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_lizard_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_lizard_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_lizard_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_lizard_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard timeseries rain. (required)
        :param str simulation_pk: (required)
        :param LizardTimeseriesRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_lizard_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_timeseries_lizard_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_lizard_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_timeseries_lizard_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/lizard/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_lizard_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_lizard_read  # noqa: E501

        A simple ViewSet for viewing LizardTimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_lizard_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LizardTimeseriesRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_lizard_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_lizard_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_lizard_read  # noqa: E501

        A simple ViewSet for viewing LizardTimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_lizard_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LizardTimeseriesRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_lizard_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_timeseries_lizard_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_lizard_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/lizard/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LizardTimeseriesRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_lizard_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_lizard_update  # noqa: E501

        A simple ViewSet for viewing LizardTimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_lizard_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard timeseries rain. (required)
        :param str simulation_pk: (required)
        :param LizardTimeseriesRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LizardTimeseriesRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_lizard_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_lizard_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_lizard_update  # noqa: E501

        A simple ViewSet for viewing LizardTimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_lizard_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard timeseries rain. (required)
        :param str simulation_pk: (required)
        :param LizardTimeseriesRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LizardTimeseriesRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_lizard_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_timeseries_lizard_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_lizard_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_timeseries_lizard_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/lizard/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LizardTimeseriesRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_netcdf_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_netcdf_create  # noqa: E501

        NetCDF 4 timeseries rain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_netcdf_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_netcdf_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_netcdf_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_netcdf_create  # noqa: E501

        NetCDF 4 timeseries rain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_netcdf_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_netcdf_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_netcdf_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_timeseries_netcdf_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/netcdf/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_netcdf_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_netcdf_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_netcdf_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_netcdf_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_netcdf_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_netcdf_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_netcdf_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_netcdf_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_timeseries_netcdf_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_netcdf_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/netcdf/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_netcdf_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_netcdf_list  # noqa: E501

        NetCDF 4 timeseries rain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_netcdf_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20023
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_netcdf_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_netcdf_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_netcdf_list  # noqa: E501

        NetCDF 4 timeseries rain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_netcdf_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20023, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_netcdf_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_netcdf_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/netcdf/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20023',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_netcdf_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_netcdf_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_netcdf_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries rain. (required)
        :param str simulation_pk: (required)
        :param NetCDFTimeseriesRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_netcdf_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_netcdf_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_netcdf_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_netcdf_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries rain. (required)
        :param str simulation_pk: (required)
        :param NetCDFTimeseriesRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_netcdf_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_timeseries_netcdf_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_netcdf_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_timeseries_netcdf_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/netcdf/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_netcdf_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_netcdf_read  # noqa: E501

        NetCDF 4 timeseries rain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_netcdf_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NetCDFTimeseriesRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_netcdf_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_netcdf_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_netcdf_read  # noqa: E501

        NetCDF 4 timeseries rain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_netcdf_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NetCDFTimeseriesRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_netcdf_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_timeseries_netcdf_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_netcdf_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/netcdf/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetCDFTimeseriesRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_netcdf_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_netcdf_update  # noqa: E501

        NetCDF 4 timeseries rain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_netcdf_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries rain. (required)
        :param str simulation_pk: (required)
        :param NetCDFTimeseriesRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NetCDFTimeseriesRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_netcdf_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_netcdf_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_netcdf_update  # noqa: E501

        NetCDF 4 timeseries rain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_netcdf_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries rain. (required)
        :param str simulation_pk: (required)
        :param NetCDFTimeseriesRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NetCDFTimeseriesRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_netcdf_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_timeseries_netcdf_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_netcdf_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_timeseries_netcdf_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/netcdf/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetCDFTimeseriesRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param TimeseriesRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param TimeseriesRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_timeseries_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_timeseries_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_timeseries_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_timeseries_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param TimeseriesRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_timeseries_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_timeseries_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_timeseries_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_timeseries_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param TimeseriesRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_timeseries_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_timeseries_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_timeseries_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_timeseries_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/rain/timeseries/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_raster_edits_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_raster_edits_create  # noqa: E501

        A simple ViewSet for viewing raster edits  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_raster_edits_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param RasterEdit data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RasterEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_raster_edits_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_raster_edits_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_raster_edits_create  # noqa: E501

        A simple ViewSet for viewing raster edits  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_raster_edits_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param RasterEdit data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RasterEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_raster_edits_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_raster_edits_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_raster_edits_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/raster-edits/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RasterEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_raster_edits_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_raster_edits_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_raster_edits_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster edit. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_raster_edits_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_raster_edits_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_raster_edits_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_raster_edits_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster edit. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_raster_edits_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_raster_edits_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_raster_edits_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/raster-edits/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_raster_edits_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_raster_edits_list  # noqa: E501

        A simple ViewSet for viewing raster edits  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_raster_edits_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20024
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_raster_edits_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_raster_edits_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_raster_edits_list  # noqa: E501

        A simple ViewSet for viewing raster edits  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_raster_edits_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20024, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_raster_edits_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_raster_edits_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/raster-edits/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20024',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_raster_edits_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_raster_edits_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_raster_edits_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster edit. (required)
        :param str simulation_pk: (required)
        :param RasterEdit data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_raster_edits_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_raster_edits_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_raster_edits_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_raster_edits_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster edit. (required)
        :param str simulation_pk: (required)
        :param RasterEdit data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_raster_edits_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_raster_edits_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_raster_edits_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_raster_edits_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/raster-edits/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_raster_edits_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_raster_edits_read  # noqa: E501

        A simple ViewSet for viewing raster edits  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_raster_edits_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster edit. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RasterEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_raster_edits_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_raster_edits_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_raster_edits_read  # noqa: E501

        A simple ViewSet for viewing raster edits  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_raster_edits_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster edit. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RasterEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_raster_edits_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_raster_edits_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_raster_edits_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/raster-edits/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RasterEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_raster_edits_register_related_rasters(self, id, simulation_pk, **kwargs):  # noqa: E501
        """Register all related rasters in the results-api and return read_bbox urls of the registered rasters  # noqa: E501

        Skips registering of related rasters when the simulation is not in the state 'starting' or 'initialized'. In this case the urls will be empty  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_raster_edits_register_related_rasters(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster edit. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[RasterEditUrls]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_raster_edits_register_related_rasters_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_raster_edits_register_related_rasters_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """Register all related rasters in the results-api and return read_bbox urls of the registered rasters  # noqa: E501

        Skips registering of related rasters when the simulation is not in the state 'starting' or 'initialized'. In this case the urls will be empty  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_raster_edits_register_related_rasters_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster edit. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[RasterEditUrls], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_raster_edits_register_related_rasters" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_raster_edits_register_related_rasters`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_raster_edits_register_related_rasters`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/raster-edits/{id}/register_related_rasters/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RasterEditUrls]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_raster_edits_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_raster_edits_update  # noqa: E501

        A simple ViewSet for viewing raster edits  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_raster_edits_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster edit. (required)
        :param str simulation_pk: (required)
        :param RasterEdit data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RasterEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_raster_edits_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_raster_edits_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_raster_edits_update  # noqa: E501

        A simple ViewSet for viewing raster edits  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_raster_edits_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster edit. (required)
        :param str simulation_pk: (required)
        :param RasterEdit data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RasterEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_raster_edits_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_raster_edits_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_raster_edits_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_raster_edits_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/raster-edits/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RasterEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_constant_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_constant_create  # noqa: E501

        A simple ViewSet for viewing ConstantSourcesSinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_constant_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantSourcesSinks data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantSourcesSinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_constant_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_constant_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_constant_create  # noqa: E501

        A simple ViewSet for viewing ConstantSourcesSinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_constant_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantSourcesSinks data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantSourcesSinks, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_constant_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_constant_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_constant_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/constant/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantSourcesSinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_constant_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_constant_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_constant_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_constant_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_constant_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_constant_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_constant_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_constant_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_constant_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_constant_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/constant/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_constant_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_constant_list  # noqa: E501

        A simple ViewSet for viewing ConstantSourcesSinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_constant_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20025
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_constant_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_constant_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_constant_list  # noqa: E501

        A simple ViewSet for viewing ConstantSourcesSinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_constant_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20025, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_constant_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_constant_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/constant/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20025',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_constant_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_constant_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_constant_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param ConstantSourcesSinks data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_constant_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_constant_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_constant_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_constant_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param ConstantSourcesSinks data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_constant_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_constant_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/constant/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_constant_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_constant_read  # noqa: E501

        A simple ViewSet for viewing ConstantSourcesSinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_constant_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantSourcesSinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_constant_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_constant_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_constant_read  # noqa: E501

        A simple ViewSet for viewing ConstantSourcesSinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_constant_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantSourcesSinks, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_constant_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_constant_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_constant_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/constant/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantSourcesSinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_constant_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_constant_update  # noqa: E501

        A simple ViewSet for viewing ConstantSourcesSinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_constant_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param ConstantSourcesSinks data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantSourcesSinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_constant_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_constant_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_constant_update  # noqa: E501

        A simple ViewSet for viewing ConstantSourcesSinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_constant_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param ConstantSourcesSinks data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantSourcesSinks, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_constant_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_constant_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_constant_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_constant_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/constant/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantSourcesSinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_rasters_lizard_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_lizard_create  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_lizard_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param LizardRasterSourcesSinks data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LizardRasterSourcesSinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_rasters_lizard_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_rasters_lizard_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_lizard_create  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_lizard_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param LizardRasterSourcesSinks data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LizardRasterSourcesSinks, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_rasters_lizard_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_rasters_lizard_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_rasters_lizard_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/rasters/lizard/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LizardRasterSourcesSinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_rasters_lizard_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_lizard_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_lizard_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster sources sinks. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_rasters_lizard_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_rasters_lizard_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_lizard_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_lizard_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster sources sinks. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_rasters_lizard_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_rasters_lizard_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_rasters_lizard_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/rasters/lizard/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_rasters_lizard_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_lizard_list  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_lizard_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20026
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_rasters_lizard_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_rasters_lizard_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_lizard_list  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_lizard_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20026, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_rasters_lizard_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_rasters_lizard_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/rasters/lizard/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20026',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_rasters_lizard_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_lizard_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_lizard_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster sources sinks. (required)
        :param str simulation_pk: (required)
        :param LizardRasterSourcesSinks data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_rasters_lizard_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_rasters_lizard_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_lizard_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_lizard_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster sources sinks. (required)
        :param str simulation_pk: (required)
        :param LizardRasterSourcesSinks data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_rasters_lizard_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_rasters_lizard_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_rasters_lizard_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_rasters_lizard_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/rasters/lizard/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_rasters_lizard_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_lizard_read  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_lizard_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster sources sinks. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LizardRasterSourcesSinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_rasters_lizard_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_rasters_lizard_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_lizard_read  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_lizard_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster sources sinks. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LizardRasterSourcesSinks, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_rasters_lizard_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_rasters_lizard_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_rasters_lizard_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/rasters/lizard/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LizardRasterSourcesSinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_rasters_lizard_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_lizard_update  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_lizard_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster sources sinks. (required)
        :param str simulation_pk: (required)
        :param LizardRasterSourcesSinks data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LizardRasterSourcesSinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_rasters_lizard_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_rasters_lizard_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_lizard_update  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_lizard_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster sources sinks. (required)
        :param str simulation_pk: (required)
        :param LizardRasterSourcesSinks data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LizardRasterSourcesSinks, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_rasters_lizard_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_rasters_lizard_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_rasters_lizard_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_rasters_lizard_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/rasters/lizard/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LizardRasterSourcesSinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_rasters_netcdf_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_netcdf_create  # noqa: E501

        NetCDF 4 raster sources & sinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_netcdf_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_rasters_netcdf_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_rasters_netcdf_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_netcdf_create  # noqa: E501

        NetCDF 4 raster sources & sinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_netcdf_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_rasters_netcdf_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_rasters_netcdf_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_rasters_netcdf_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/rasters/netcdf/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_rasters_netcdf_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_netcdf_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_netcdf_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster sources sinks. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_rasters_netcdf_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_rasters_netcdf_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_netcdf_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_netcdf_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster sources sinks. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_rasters_netcdf_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_rasters_netcdf_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_rasters_netcdf_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/rasters/netcdf/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_rasters_netcdf_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_netcdf_list  # noqa: E501

        NetCDF 4 raster sources & sinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_netcdf_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20027
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_rasters_netcdf_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_rasters_netcdf_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_netcdf_list  # noqa: E501

        NetCDF 4 raster sources & sinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_netcdf_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20027, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_rasters_netcdf_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_rasters_netcdf_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/rasters/netcdf/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20027',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_rasters_netcdf_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_netcdf_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_netcdf_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster sources sinks. (required)
        :param str simulation_pk: (required)
        :param NetCDFRasterSourcesSinks data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_rasters_netcdf_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_rasters_netcdf_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_netcdf_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_netcdf_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster sources sinks. (required)
        :param str simulation_pk: (required)
        :param NetCDFRasterSourcesSinks data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_rasters_netcdf_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_rasters_netcdf_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_rasters_netcdf_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_rasters_netcdf_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/rasters/netcdf/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_rasters_netcdf_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_netcdf_read  # noqa: E501

        NetCDF 4 raster sources & sinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_netcdf_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster sources sinks. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NetCDFRasterSourcesSinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_rasters_netcdf_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_rasters_netcdf_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_netcdf_read  # noqa: E501

        NetCDF 4 raster sources & sinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_netcdf_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster sources sinks. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NetCDFRasterSourcesSinks, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_rasters_netcdf_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_rasters_netcdf_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_rasters_netcdf_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/rasters/netcdf/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetCDFRasterSourcesSinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_rasters_netcdf_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_netcdf_update  # noqa: E501

        NetCDF 4 raster sources & sinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_netcdf_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster sources sinks. (required)
        :param str simulation_pk: (required)
        :param NetCDFRasterSourcesSinks data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NetCDFRasterSourcesSinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_rasters_netcdf_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_rasters_netcdf_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_rasters_netcdf_update  # noqa: E501

        NetCDF 4 raster sources & sinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_rasters_netcdf_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster sources sinks. (required)
        :param str simulation_pk: (required)
        :param NetCDFRasterSourcesSinks data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NetCDFRasterSourcesSinks, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_rasters_netcdf_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_rasters_netcdf_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_rasters_netcdf_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_rasters_netcdf_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/rasters/netcdf/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetCDFRasterSourcesSinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_create  # noqa: E501

        Example payload: ```     {       \"offset\": 0,       \"values\": [         [           0,           0.0005         ],         [           300,           0.0002         ]       ],       \"units\": \"m/s\"     } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimeseriesSourcesSinks data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesSourcesSinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_create  # noqa: E501

        Example payload: ```     {       \"offset\": 0,       \"values\": [         [           0,           0.0005         ],         [           300,           0.0002         ]       ],       \"units\": \"m/s\"     } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimeseriesSourcesSinks data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesSourcesSinks, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_timeseries_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesSourcesSinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_timeseries_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesSourcesSinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20028
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesSourcesSinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20028, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20028',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_lizard_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_lizard_create  # noqa: E501

        A simple ViewSet for viewing LizardTimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_lizard_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param LizardTimeseriesSourcesSinks data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LizardTimeseriesSourcesSinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_lizard_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_lizard_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_lizard_create  # noqa: E501

        A simple ViewSet for viewing LizardTimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_lizard_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param LizardTimeseriesSourcesSinks data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LizardTimeseriesSourcesSinks, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_lizard_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_lizard_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_timeseries_lizard_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/lizard/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LizardTimeseriesSourcesSinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_lizard_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_lizard_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_lizard_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_lizard_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_lizard_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_lizard_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_lizard_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_lizard_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_timeseries_lizard_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_lizard_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/lizard/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_lizard_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_lizard_list  # noqa: E501

        A simple ViewSet for viewing LizardTimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_lizard_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20029
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_lizard_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_lizard_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_lizard_list  # noqa: E501

        A simple ViewSet for viewing LizardTimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_lizard_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20029, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_lizard_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_lizard_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/lizard/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20029',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_lizard_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_lizard_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_lizard_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param LizardTimeseriesSourcesSinks data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_lizard_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_lizard_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_lizard_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_lizard_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param LizardTimeseriesSourcesSinks data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_lizard_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_timeseries_lizard_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_lizard_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_timeseries_lizard_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/lizard/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_lizard_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_lizard_read  # noqa: E501

        A simple ViewSet for viewing LizardTimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_lizard_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LizardTimeseriesSourcesSinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_lizard_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_lizard_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_lizard_read  # noqa: E501

        A simple ViewSet for viewing LizardTimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_lizard_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LizardTimeseriesSourcesSinks, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_lizard_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_timeseries_lizard_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_lizard_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/lizard/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LizardTimeseriesSourcesSinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_lizard_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_lizard_update  # noqa: E501

        A simple ViewSet for viewing LizardTimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_lizard_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param LizardTimeseriesSourcesSinks data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LizardTimeseriesSourcesSinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_lizard_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_lizard_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_lizard_update  # noqa: E501

        A simple ViewSet for viewing LizardTimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_lizard_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param LizardTimeseriesSourcesSinks data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LizardTimeseriesSourcesSinks, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_lizard_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_timeseries_lizard_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_lizard_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_timeseries_lizard_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/lizard/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LizardTimeseriesSourcesSinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_netcdf_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_netcdf_create  # noqa: E501

        NetCDF 4 timeseries sources & sinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_netcdf_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_netcdf_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_netcdf_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_netcdf_create  # noqa: E501

        NetCDF 4 timeseries sources & sinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_netcdf_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_netcdf_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_netcdf_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_timeseries_netcdf_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/netcdf/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_netcdf_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_netcdf_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_netcdf_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_netcdf_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_netcdf_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_netcdf_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_netcdf_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_netcdf_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_timeseries_netcdf_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_netcdf_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/netcdf/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_netcdf_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_netcdf_list  # noqa: E501

        NetCDF 4 timeseries sources & sinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_netcdf_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20030
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_netcdf_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_netcdf_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_netcdf_list  # noqa: E501

        NetCDF 4 timeseries sources & sinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_netcdf_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20030, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_netcdf_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_netcdf_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/netcdf/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20030',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_netcdf_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_netcdf_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_netcdf_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param NetCDFTimeseriesSourcesSinks data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_netcdf_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_netcdf_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_netcdf_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_netcdf_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param NetCDFTimeseriesSourcesSinks data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_netcdf_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_timeseries_netcdf_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_netcdf_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_timeseries_netcdf_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/netcdf/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_netcdf_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_netcdf_read  # noqa: E501

        NetCDF 4 timeseries sources & sinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_netcdf_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NetCDFTimeseriesSourcesSinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_netcdf_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_netcdf_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_netcdf_read  # noqa: E501

        NetCDF 4 timeseries sources & sinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_netcdf_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NetCDFTimeseriesSourcesSinks, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_netcdf_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_timeseries_netcdf_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_netcdf_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/netcdf/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetCDFTimeseriesSourcesSinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_netcdf_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_netcdf_update  # noqa: E501

        NetCDF 4 timeseries sources & sinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_netcdf_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param NetCDFTimeseriesSourcesSinks data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NetCDFTimeseriesSourcesSinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_netcdf_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_netcdf_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_netcdf_update  # noqa: E501

        NetCDF 4 timeseries sources & sinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_netcdf_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param NetCDFTimeseriesSourcesSinks data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NetCDFTimeseriesSourcesSinks, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_netcdf_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_timeseries_netcdf_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_netcdf_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_timeseries_netcdf_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/netcdf/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetCDFTimeseriesSourcesSinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param TimeseriesSourcesSinks data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param TimeseriesSourcesSinks data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_timeseries_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_timeseries_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesSourcesSinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesSourcesSinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesSourcesSinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesSourcesSinks, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_timeseries_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesSourcesSinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_sources_sinks_timeseries_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesSourcesSinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param TimeseriesSourcesSinks data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesSourcesSinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_sources_sinks_timeseries_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_sources_sinks_timeseries_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_sources_sinks_timeseries_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesSourcesSinks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_sources_sinks_timeseries_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries sources sinks. (required)
        :param str simulation_pk: (required)
        :param TimeseriesSourcesSinks data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesSourcesSinks, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_sources_sinks_timeseries_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_sources_sinks_timeseries_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_sources_sinks_timeseries_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_sources_sinks_timeseries_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/sources-sinks/timeseries/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesSourcesSinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_structure_control_timed_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_structure_control_timed_create  # noqa: E501

        A timed structure control allows for actively altering parameters of structures at a given point in time of the simulation for a given period of time. The ``type`` parameter specifies which action should be applied to the structure. Not all valid action types can be applied to every structure. An overview of valid combinations:     set_discharge_coefficients: v2_orifice, v2_weir, v2_pipe,                                v2_channel, v2_culvert    set_crest_level: v2_orifice, v2_weir    set_pump_capacity: v2_pumpstation  The value parameter must contain 1 value, except for the ``set_discharge_coefficients``action that expects a value for both flow directions.  Example payload:  ```     {       \"offset\": 0,       \"duration\": 100,       \"value\": [         0.4, 0.8       ],       \"type\": \"set_discharge_coefficients\",       \"structure_id\": 21,       \"structure_type\": \"v2_weir\"     } ```  **v2_channel and v2_pipe are for internal use only. They expect a grid_id instead of a structure_id!**  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_structure_control_timed_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimedStructureControl data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimedStructureControl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_structure_control_timed_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_structure_control_timed_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_structure_control_timed_create  # noqa: E501

        A timed structure control allows for actively altering parameters of structures at a given point in time of the simulation for a given period of time. The ``type`` parameter specifies which action should be applied to the structure. Not all valid action types can be applied to every structure. An overview of valid combinations:     set_discharge_coefficients: v2_orifice, v2_weir, v2_pipe,                                v2_channel, v2_culvert    set_crest_level: v2_orifice, v2_weir    set_pump_capacity: v2_pumpstation  The value parameter must contain 1 value, except for the ``set_discharge_coefficients``action that expects a value for both flow directions.  Example payload:  ```     {       \"offset\": 0,       \"duration\": 100,       \"value\": [         0.4, 0.8       ],       \"type\": \"set_discharge_coefficients\",       \"structure_id\": 21,       \"structure_type\": \"v2_weir\"     } ```  **v2_channel and v2_pipe are for internal use only. They expect a grid_id instead of a structure_id!**  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_structure_control_timed_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimedStructureControl data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimedStructureControl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_structure_control_timed_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_structure_control_timed_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_structure_control_timed_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/structure-control/timed/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimedStructureControl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_structure_control_timed_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_structure_control_timed_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_structure_control_timed_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timed structure control. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_structure_control_timed_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_structure_control_timed_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_structure_control_timed_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_structure_control_timed_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timed structure control. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_structure_control_timed_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_structure_control_timed_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_structure_control_timed_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/structure-control/timed/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_structure_control_timed_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_structure_control_timed_list  # noqa: E501

        A simple ViewSet for viewing TimedStructureControls  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_structure_control_timed_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20031
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_structure_control_timed_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_structure_control_timed_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_structure_control_timed_list  # noqa: E501

        A simple ViewSet for viewing TimedStructureControls  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_structure_control_timed_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20031, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_structure_control_timed_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_structure_control_timed_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/structure-control/timed/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20031',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_structure_control_timed_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_structure_control_timed_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_structure_control_timed_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timed structure control. (required)
        :param str simulation_pk: (required)
        :param TimedStructureControl data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_structure_control_timed_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_structure_control_timed_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_structure_control_timed_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_structure_control_timed_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timed structure control. (required)
        :param str simulation_pk: (required)
        :param TimedStructureControl data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_structure_control_timed_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_structure_control_timed_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_structure_control_timed_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_structure_control_timed_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/structure-control/timed/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_structure_control_timed_processed(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_structure_control_timed_processed  # noqa: E501

        A simple ViewSet for viewing TimedStructureControls  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_structure_control_timed_processed(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timed structure control. (required)
        :param str simulation_pk: (required)
        :param GridEventState data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_structure_control_timed_processed_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_structure_control_timed_processed_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_structure_control_timed_processed  # noqa: E501

        A simple ViewSet for viewing TimedStructureControls  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_structure_control_timed_processed_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timed structure control. (required)
        :param str simulation_pk: (required)
        :param GridEventState data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_structure_control_timed_processed" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_structure_control_timed_processed`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_structure_control_timed_processed`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_structure_control_timed_processed`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/structure-control/timed/{id}/processed/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_structure_control_timed_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_structure_control_timed_read  # noqa: E501

        A simple ViewSet for viewing TimedStructureControls  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_structure_control_timed_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timed structure control. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimedStructureControl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_structure_control_timed_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_structure_control_timed_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_structure_control_timed_read  # noqa: E501

        A simple ViewSet for viewing TimedStructureControls  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_structure_control_timed_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timed structure control. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimedStructureControl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_structure_control_timed_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_structure_control_timed_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_structure_control_timed_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/structure-control/timed/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimedStructureControl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_structure_control_timed_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_structure_control_timed_update  # noqa: E501

        A simple ViewSet for viewing TimedStructureControls  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_structure_control_timed_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timed structure control. (required)
        :param str simulation_pk: (required)
        :param TimedStructureControl data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimedStructureControl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_structure_control_timed_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_structure_control_timed_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_structure_control_timed_update  # noqa: E501

        A simple ViewSet for viewing TimedStructureControls  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_structure_control_timed_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timed structure control. (required)
        :param str simulation_pk: (required)
        :param TimedStructureControl data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimedStructureControl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_structure_control_timed_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_structure_control_timed_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_structure_control_timed_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_structure_control_timed_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/structure-control/timed/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimedStructureControl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_wind_constant_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_wind_constant_create  # noqa: E501

        A constant wind event allows for wind forcing at a given point in time of the simulation for a given period of time. No distinction is made (yet) between the 1D and 2D model domain.  The ``units`` parameter is the wind speed unit ('m/s' or 'km/h').  The ``direction_value`` parameter is the wind direction in degrees (0-360) from the north - meteorological standard. Thus, a direction_value of 180 represents a south wind (which comes from the south and blows your hat towards the north.  The ``speed_value`` parameter as well as the ``direction_value`` must contain 1 value. Behind the the scenes these are converted into nested array [time, speed_value, direction_value]. This means that this payload (example):  ``` {     \"offset\": 100,     \"duration\": 400,     \"units\": \"m/s\",     \"speed_value\": 80,     \"direction_value\": 220 } ```  becomes an Timeseries object with values:  ``` {     \"values\": [         [ 0, 80, 220],    # time, speed, direction         [ 400, 0, 0]      # time, speed, direction     ], } ```  Note that the (dimensionless) ``drag-coefficient`` is not part of a simulation event, but part of simulation initial condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_constant_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantWind data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantWind
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_wind_constant_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_wind_constant_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_wind_constant_create  # noqa: E501

        A constant wind event allows for wind forcing at a given point in time of the simulation for a given period of time. No distinction is made (yet) between the 1D and 2D model domain.  The ``units`` parameter is the wind speed unit ('m/s' or 'km/h').  The ``direction_value`` parameter is the wind direction in degrees (0-360) from the north - meteorological standard. Thus, a direction_value of 180 represents a south wind (which comes from the south and blows your hat towards the north.  The ``speed_value`` parameter as well as the ``direction_value`` must contain 1 value. Behind the the scenes these are converted into nested array [time, speed_value, direction_value]. This means that this payload (example):  ``` {     \"offset\": 100,     \"duration\": 400,     \"units\": \"m/s\",     \"speed_value\": 80,     \"direction_value\": 220 } ```  becomes an Timeseries object with values:  ``` {     \"values\": [         [ 0, 80, 220],    # time, speed, direction         [ 400, 0, 0]      # time, speed, direction     ], } ```  Note that the (dimensionless) ``drag-coefficient`` is not part of a simulation event, but part of simulation initial condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_constant_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantWind data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantWind, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_wind_constant_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_wind_constant_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_wind_constant_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/wind/constant/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantWind',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_wind_constant_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_wind_constant_delete  # noqa: E501

        A simple ViewSet for viewing Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_constant_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this wind. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_wind_constant_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_wind_constant_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_wind_constant_delete  # noqa: E501

        A simple ViewSet for viewing Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_constant_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this wind. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_wind_constant_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_wind_constant_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_wind_constant_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/wind/constant/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_wind_constant_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_wind_constant_list  # noqa: E501

        A simple ViewSet for viewing Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_constant_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20032
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_wind_constant_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_wind_constant_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_wind_constant_list  # noqa: E501

        A simple ViewSet for viewing Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_constant_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20032, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_wind_constant_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_wind_constant_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/wind/constant/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20032',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_wind_constant_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_wind_constant_partial_update  # noqa: E501

        A simple ViewSet for viewing Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_constant_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this wind. (required)
        :param str simulation_pk: (required)
        :param ConstantWind data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantWind
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_wind_constant_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_wind_constant_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_wind_constant_partial_update  # noqa: E501

        A simple ViewSet for viewing Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_constant_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this wind. (required)
        :param str simulation_pk: (required)
        :param ConstantWind data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantWind, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_wind_constant_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_wind_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_wind_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_wind_constant_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/wind/constant/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantWind',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_wind_constant_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_wind_constant_read  # noqa: E501

        A simple ViewSet for viewing Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_constant_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this wind. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantWind
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_wind_constant_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_wind_constant_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_wind_constant_read  # noqa: E501

        A simple ViewSet for viewing Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_constant_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this wind. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantWind, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_wind_constant_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_wind_constant_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_wind_constant_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/wind/constant/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantWind',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_wind_constant_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_wind_constant_update  # noqa: E501

        A simple ViewSet for viewing Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_constant_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this wind. (required)
        :param str simulation_pk: (required)
        :param ConstantWind data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantWind
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_wind_constant_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_wind_constant_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_wind_constant_update  # noqa: E501

        A simple ViewSet for viewing Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_constant_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this wind. (required)
        :param str simulation_pk: (required)
        :param ConstantWind data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantWind, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_wind_constant_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_wind_constant_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_wind_constant_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_wind_constant_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/wind/constant/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantWind',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_wind_timeseries_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_wind_timeseries_create  # noqa: E501

        Same as constant wind event but now without separate fields for ``speed_value`` and ``direction_value``. Instead - to avoid time-mapping issues - the field ``values`` holds the speed and direction values: ``` [     [time, speed1, direction1],     [time, speed2, direction2], ] ```  example payload: ``` {     \"offset\": 2,     \"values\": [         [0, 40, 180],         [60, 35, 181]     ],     \"units\": \"m/s\", } ```  becomes an Timeseries object with values: ``` {     \"values\": [         [ 0, 40, 180 ],         [60, 35, 181 ]     ] } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_timeseries_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimeseriesWind data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesWind
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_wind_timeseries_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_wind_timeseries_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_wind_timeseries_create  # noqa: E501

        Same as constant wind event but now without separate fields for ``speed_value`` and ``direction_value``. Instead - to avoid time-mapping issues - the field ``values`` holds the speed and direction values: ``` [     [time, speed1, direction1],     [time, speed2, direction2], ] ```  example payload: ``` {     \"offset\": 2,     \"values\": [         [0, 40, 180],         [60, 35, 181]     ],     \"units\": \"m/s\", } ```  becomes an Timeseries object with values: ``` {     \"values\": [         [ 0, 40, 180 ],         [60, 35, 181 ]     ] } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_timeseries_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimeseriesWind data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesWind, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_wind_timeseries_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_wind_timeseries_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_wind_timeseries_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/wind/timeseries/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesWind',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_wind_timeseries_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_wind_timeseries_delete  # noqa: E501

        A simple ViewSet for viewig Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_timeseries_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this wind. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_wind_timeseries_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_wind_timeseries_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_wind_timeseries_delete  # noqa: E501

        A simple ViewSet for viewig Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_timeseries_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this wind. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_wind_timeseries_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_wind_timeseries_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_wind_timeseries_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/wind/timeseries/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_wind_timeseries_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_wind_timeseries_list  # noqa: E501

        A simple ViewSet for viewig Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_timeseries_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20033
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_wind_timeseries_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_wind_timeseries_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_wind_timeseries_list  # noqa: E501

        A simple ViewSet for viewig Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_timeseries_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20033, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_wind_timeseries_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_wind_timeseries_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/wind/timeseries/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20033',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_wind_timeseries_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_wind_timeseries_partial_update  # noqa: E501

        A simple ViewSet for viewig Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_timeseries_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this wind. (required)
        :param str simulation_pk: (required)
        :param TimeseriesWind data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesWind
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_wind_timeseries_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_wind_timeseries_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_wind_timeseries_partial_update  # noqa: E501

        A simple ViewSet for viewig Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_timeseries_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this wind. (required)
        :param str simulation_pk: (required)
        :param TimeseriesWind data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesWind, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_wind_timeseries_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_wind_timeseries_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_wind_timeseries_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_wind_timeseries_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/wind/timeseries/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesWind',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_wind_timeseries_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_wind_timeseries_read  # noqa: E501

        A simple ViewSet for viewig Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_timeseries_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this wind. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesWind
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_wind_timeseries_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_wind_timeseries_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_wind_timeseries_read  # noqa: E501

        A simple ViewSet for viewig Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_timeseries_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this wind. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesWind, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_wind_timeseries_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_wind_timeseries_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_wind_timeseries_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/wind/timeseries/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesWind',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_wind_timeseries_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_wind_timeseries_update  # noqa: E501

        A simple ViewSet for viewig Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_timeseries_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this wind. (required)
        :param str simulation_pk: (required)
        :param TimeseriesWind data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesWind
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_wind_timeseries_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_wind_timeseries_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_wind_timeseries_update  # noqa: E501

        A simple ViewSet for viewig Wind.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_wind_timeseries_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this wind. (required)
        :param str simulation_pk: (required)
        :param TimeseriesWind data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesWind, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_wind_timeseries_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_wind_timeseries_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_wind_timeseries_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_wind_timeseries_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/events/wind/timeseries/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesWind',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_initial1d_water_level_constant_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_initial1d_water_level_constant_create  # noqa: E501

        Start the simulation with a global 1D water level  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_initial1d_water_level_constant_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param OneDWaterLevel data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OneDWaterLevel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_initial1d_water_level_constant_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_initial1d_water_level_constant_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_initial1d_water_level_constant_create  # noqa: E501

        Start the simulation with a global 1D water level  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_initial1d_water_level_constant_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param OneDWaterLevel data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OneDWaterLevel, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_initial1d_water_level_constant_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_initial1d_water_level_constant_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_initial1d_water_level_constant_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/initial/1d_water_level/constant/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OneDWaterLevel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_initial1d_water_level_constant_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_initial1d_water_level_constant_delete  # noqa: E501

        Initial 1D water levels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_initial1d_water_level_constant_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this one d water level. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_initial1d_water_level_constant_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_initial1d_water_level_constant_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_initial1d_water_level_constant_delete  # noqa: E501

        Initial 1D water levels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_initial1d_water_level_constant_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this one d water level. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_initial1d_water_level_constant_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_initial1d_water_level_constant_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_initial1d_water_level_constant_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/initial/1d_water_level/constant/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_initial1d_water_level_constant_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_initial1d_water_level_constant_list  # noqa: E501

        Initial 1D water levels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_initial1d_water_level_constant_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20034
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_initial1d_water_level_constant_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_initial1d_water_level_constant_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_initial1d_water_level_constant_list  # noqa: E501

        Initial 1D water levels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_initial1d_water_level_constant_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20034, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_initial1d_water_level_constant_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_initial1d_water_level_constant_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/initial/1d_water_level/constant/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20034',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_initial1d_water_level_constant_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_initial1d_water_level_constant_partial_update  # noqa: E501

        Initial 1D water levels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_initial1d_water_level_constant_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this one d water level. (required)
        :param str simulation_pk: (required)
        :param OneDWaterLevel data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OneDWaterLevel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_initial1d_water_level_constant_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_initial1d_water_level_constant_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_initial1d_water_level_constant_partial_update  # noqa: E501

        Initial 1D water levels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_initial1d_water_level_constant_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this one d water level. (required)
        :param str simulation_pk: (required)
        :param OneDWaterLevel data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OneDWaterLevel, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_initial1d_water_level_constant_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_initial1d_water_level_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_initial1d_water_level_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_initial1d_water_level_constant_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/initial/1d_water_level/constant/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OneDWaterLevel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_initial1d_water_level_constant_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_initial1d_water_level_constant_read  # noqa: E501

        Initial 1D water levels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_initial1d_water_level_constant_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this one d water level. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OneDWaterLevel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_initial1d_water_level_constant_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_initial1d_water_level_constant_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_initial1d_water_level_constant_read  # noqa: E501

        Initial 1D water levels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_initial1d_water_level_constant_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this one d water level. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OneDWaterLevel, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_initial1d_water_level_constant_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_initial1d_water_level_constant_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_initial1d_water_level_constant_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/initial/1d_water_level/constant/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OneDWaterLevel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_initial1d_water_level_constant_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_initial1d_water_level_constant_update  # noqa: E501

        Initial 1D water levels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_initial1d_water_level_constant_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this one d water level. (required)
        :param str simulation_pk: (required)
        :param OneDWaterLevel data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OneDWaterLevel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_initial1d_water_level_constant_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_initial1d_water_level_constant_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_initial1d_water_level_constant_update  # noqa: E501

        Initial 1D water levels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_initial1d_water_level_constant_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this one d water level. (required)
        :param str simulation_pk: (required)
        :param OneDWaterLevel data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OneDWaterLevel, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_initial1d_water_level_constant_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_initial1d_water_level_constant_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_initial1d_water_level_constant_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_initial1d_water_level_constant_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/initial/1d_water_level/constant/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OneDWaterLevel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_initial1d_water_level_predefined_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_initial1d_water_level_predefined_create  # noqa: E501

        Start the simulation with predefined 1D water levels. That is, use the initial water levels that have been specified in the ``v2_connection_nodes`` schema.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_initial1d_water_level_predefined_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param OneDWaterLevelPredefined data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OneDWaterLevelPredefined
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_initial1d_water_level_predefined_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_initial1d_water_level_predefined_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_initial1d_water_level_predefined_create  # noqa: E501

        Start the simulation with predefined 1D water levels. That is, use the initial water levels that have been specified in the ``v2_connection_nodes`` schema.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_initial1d_water_level_predefined_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param OneDWaterLevelPredefined data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OneDWaterLevelPredefined, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_initial1d_water_level_predefined_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_initial1d_water_level_predefined_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_initial1d_water_level_predefined_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/simulations/{simulation_pk}/initial/1d_water_level/predefined/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OneDWaterLevelPredefined',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_initial1d_water_level_predefined_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_initial1d_water_level_predefined_delete  # noqa: E501

        A simple ViewSet for initial 2D water levels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_initial1d_water_level_predefined_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this one d water level predefined. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_initial1d_water_level_predefined_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_initial1d_water_level_predefined_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_initial1d_water_level_predefined_delete  # noqa: E501

        A simple ViewSet for initial 2D water levels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_initial1d_water_level_predefined_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this one d water level predefined. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_initial1d_water_level_predefined_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                 