import os
from typing import Dict

def load_dotenv(path=".env") -> Dict[str, str]:
    """Simple .env parser: reads KEY=VALUE lines."""
    env = {}
    try:
        with open(path, "r", encoding="utf-8") as f:
            for raw in f:
                line = raw.strip()
                if not line or line.startswith("#"):
                    continue
                if "=" in line:
                    key, val = line.split("=", 1)
                    env[key.strip()] = val.strip().strip('"').strip("'")
    except FileNotFoundError:
        pass
    return env
