from typing import Any, Dict

class SchemaError(Exception):
    pass

def validate(schema: Dict[str, type], data: Dict[str, Any]) -> None:
    """Check required keys exist and are the correct type."""
    for key, expected_type in schema.items():
        if key not in data or data[key] is None:
            raise SchemaError(f"Missing required config: {key}")
        val = data[key]
        try:
            if expected_type is bool:
                if isinstance(val, str):
                    if val.lower() in ("1", "true", "yes", "on", "0", "false", "no", "off"):
                        continue
                    raise ValueError()
            elif expected_type in (int, float):
                expected_type(val)
        except Exception:
            raise SchemaError(f"{key} should be {expected_type.__name__}, got {val!r}")
