"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const ec2 = require("@aws-cdk/aws-ec2");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const targets = require("../lib");
let stack;
let listener;
let fn;
beforeEach(() => {
    stack = new core_1.Stack();
    const vpc = new ec2.Vpc(stack, 'Stack');
    const lb = new elbv2.ApplicationLoadBalancer(stack, 'LB', { vpc });
    listener = lb.addListener('Listener', { port: 80 });
    fn = new lambda.Function(stack, 'Fun', {
        code: lambda.Code.inline('foo'),
        runtime: lambda.Runtime.PYTHON_3_6,
        handler: 'index.handler',
    });
});
test('Can create target groups with lambda targets', () => {
    // WHEN
    listener.addTargets('Targets', {
        targets: [new targets.LambdaTarget(fn)],
    });
    // THEN
    assert_1.expect(stack).to(assert_1.haveResource('AWS::ElasticLoadBalancingV2::TargetGroup', {
        TargetType: 'lambda',
        Targets: [
            { Id: { 'Fn::GetAtt': ['FunA2CCED21', 'Arn'] } },
        ],
    }));
});
test('Lambda targets create dependency on Invoke permission', () => {
    // WHEN
    listener.addTargets('Targets', {
        targets: [new targets.LambdaTarget(fn)],
    });
    // THEN
    assert_1.expect(stack).to(assert_1.haveResource('AWS::ElasticLoadBalancingV2::TargetGroup', (def) => {
        var _a;
        return ((_a = def.DependsOn) !== null && _a !== void 0 ? _a : []).includes('FunInvokeServicePrincipalelasticloadbalancingamazonawscomD2CAC0C4');
    }, assert_1.ResourcePart.CompleteDefinition));
});
//# sourceMappingURL=data:application/json;base64,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