"""
    Lob

    The Lob API is organized around REST. Our API is designed to have predictable, resource-oriented URLs and uses HTTP response codes to indicate any API errors. <p> Looking for our [previous documentation](https://lob.github.io/legacy-docs/)?   # noqa: E501

    The version of the OpenAPI document: 1.3.0
    Contact: lob-openapi@lob.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from lob_python.api_client import ApiClient, Endpoint as _Endpoint
from lob_python.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from lob_python.model.include_model import IncludeModel
from lob_python.model.lob_error import LobError
from lob_python.model.mail_type import MailType
from lob_python.model.metadata_model import MetadataModel
from lob_python.model.self_mailer import SelfMailer
from lob_python.model.self_mailer_deletion import SelfMailerDeletion
from lob_python.model.self_mailer_editable import SelfMailerEditable
from lob_python.model.self_mailer_list import SelfMailerList
from lob_python.model.self_mailer_size import SelfMailerSize
from lob_python.model.sfm_id import SfmId
from lob_python.model.sort_by3 import SortBy3


class SelfMailersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_endpoint = _Endpoint(
            settings={
                'response_type': (SelfMailer,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/self_mailers',
                'operation_id': 'create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'self_mailer_editable',
                    'idempotency_key',
                ],
                'required': [
                    'self_mailer_editable',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'idempotency_key',
                ]
            },
            root_map={
                'validations': {
                    ('idempotency_key',): {
                        'max_length': 256,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'self_mailer_editable':
                        (SelfMailerEditable,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'idempotency_key': 'Idempotency-Key',
                },
                'location_map': {
                    'self_mailer_editable': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.delete_endpoint = _Endpoint(
            settings={
                'response_type': (SelfMailerDeletion,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/self_mailers/{sfm_id}',
                'operation_id': 'delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'sfm_id',
                ],
                'required': [
                    'sfm_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sfm_id':
                        (SfmId,),
                },
                'attribute_map': {
                    'sfm_id': 'sfm_id',
                },
                'location_map': {
                    'sfm_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_endpoint = _Endpoint(
            settings={
                'response_type': (SelfMailer,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/self_mailers/{sfm_id}',
                'operation_id': 'get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'sfm_id',
                ],
                'required': [
                    'sfm_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sfm_id':
                        (SfmId,),
                },
                'attribute_map': {
                    'sfm_id': 'sfm_id',
                },
                'location_map': {
                    'sfm_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_endpoint = _Endpoint(
            settings={
                'response_type': (SelfMailerList,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/self_mailers',
                'operation_id': 'list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'before',
                    'after',
                    'include',
                    'date_created',
                    'metadata',
                    'size',
                    'scheduled',
                    'send_date',
                    'mail_type',
                    'sort_by',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'before':
                        (str,),
                    'after':
                        (str,),
                    'include':
                        (IncludeModel,),
                    'date_created':
                        ({str: (datetime,)},),
                    'metadata':
                        (MetadataModel,),
                    'size':
                        ([SelfMailerSize],),
                    'scheduled':
                        (bool,),
                    'send_date':
                        ({str: (str,)},),
                    'mail_type':
                        (MailType,),
                    'sort_by':
                        (SortBy3,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'before': 'before',
                    'after': 'after',
                    'include': 'include',
                    'date_created': 'date_created',
                    'metadata': 'metadata',
                    'size': 'size',
                    'scheduled': 'scheduled',
                    'send_date': 'send_date',
                    'mail_type': 'mail_type',
                    'sort_by': 'sort_by',
                },
                'location_map': {
                    'limit': 'query',
                    'before': 'query',
                    'after': 'query',
                    'include': 'query',
                    'date_created': 'query',
                    'metadata': 'query',
                    'size': 'query',
                    'scheduled': 'query',
                    'send_date': 'query',
                    'mail_type': 'query',
                    'sort_by': 'query',
                },
                'collection_format_map': {
                    'size': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create(
        self,
        self_mailer_editable,
        **kwargs
    ):
        """create  # noqa: E501

        Creates a new self_mailer given information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create(self_mailer_editable, async_req=True)
        >>> result = thread.get()

        Args:
            self_mailer_editable (SelfMailerEditable):

        Keyword Args:
            idempotency_key (str): A string of no longer than 256 characters that uniquely identifies this resource. For more help integrating idempotency keys, refer to our [implementation guide](https://www.lob.com/guides#idempotent_request). . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SelfMailer
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['self_mailer_editable'] = \
            self_mailer_editable
        return self.create_endpoint.call_with_http_info(**kwargs)

    def delete(
        self,
        sfm_id,
        **kwargs
    ):
        """delete  # noqa: E501

        Completely removes a self mailer from production. This can only be done if the self mailer's `send_date` has not yet passed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete(sfm_id, async_req=True)
        >>> result = thread.get()

        Args:
            sfm_id (SfmId): id of the self_mailer

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SelfMailerDeletion
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['sfm_id'] = \
            sfm_id
        return self.delete_endpoint.call_with_http_info(**kwargs)

    def get(
        self,
        sfm_id,
        **kwargs
    ):
        """get  # noqa: E501

        Retrieves the details of an existing self_mailer. You need only supply the unique self_mailer identifier that was returned upon self_mailer creation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get(sfm_id, async_req=True)
        >>> result = thread.get()

        Args:
            sfm_id (SfmId): id of the self_mailer

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SelfMailer
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['sfm_id'] = \
            sfm_id
        return self.get_endpoint.call_with_http_info(**kwargs)

    def list(
        self,
        **kwargs
    ):
        """list  # noqa: E501

        Returns a list of your self_mailers. The self_mailers are returned sorted by creation date, with the most recently created self_mailers appearing first.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            limit (int): How many results to return.. [optional] if omitted the server will use the default value of 10
            before (str): A reference to a list entry used for paginating to the previous set of entries. This field is pre-populated in the `previous_url` field in the return response. . [optional]
            after (str): A reference to a list entry used for paginating to the next set of entries. This field is pre-populated in the `next_url` field in the return response. . [optional]
            include (IncludeModel): Request that the response include the total count by specifying `include[]=total_count`. . [optional]
            date_created ({str: (datetime,)}): Filter by date created.. [optional]
            metadata (MetadataModel): Filter by metadata key-value pair`.. [optional]
            size ([SelfMailerSize]): The self mailer sizes to be returned.. [optional]
            scheduled (bool): * `true` - only return orders (past or future) where `send_date` is greater than `date_created` * `false` - only return orders where `send_date` is equal to `date_created` . [optional]
            send_date ({str: (str,)}): Filter by date sent.. [optional]
            mail_type (MailType): A string designating the mail postage type: * `usps_first_class` - (default) * `usps_standard` - a [cheaper option](https://lob.com/pricing/print-mail#compare) which is less predictable and takes longer to deliver. `usps_standard` cannot be used with `4x6` postcards or for any postcards sent outside of the United States. . [optional]
            sort_by (SortBy3): Sorts items by ascending or descending dates. Use either `date_created` or `send_date`, not both. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SelfMailerList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_endpoint.call_with_http_info(**kwargs)

