"""
    Lob

    The Lob API is organized around REST. Our API is designed to have predictable, resource-oriented URLs and uses HTTP response codes to indicate any API errors. <p> Looking for our [previous documentation](https://lob.github.io/legacy-docs/)?   # noqa: E501

    The version of the OpenAPI document: 1.3.0
    Contact: lob-openapi@lob.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from lob_python.api_client import ApiClient, Endpoint as _Endpoint
from lob_python.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from lob_python.model.intl_verification import IntlVerification
from lob_python.model.intl_verification_writable import IntlVerificationWritable
from lob_python.model.intl_verifications import IntlVerifications
from lob_python.model.intl_verifications_payload import IntlVerificationsPayload
from lob_python.model.lob_error import LobError


class IntlVerificationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.verifyBulk_endpoint = _Endpoint(
            settings={
                'response_type': (IntlVerifications,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/bulk/intl_verifications',
                'operation_id': 'verifyBulk',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'intl_verifications_payload',
                ],
                'required': [
                    'intl_verifications_payload',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'intl_verifications_payload':
                        (IntlVerificationsPayload,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'intl_verifications_payload': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.verifySingle_endpoint = _Endpoint(
            settings={
                'response_type': (IntlVerification,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/intl_verifications',
                'operation_id': 'verifySingle',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'intl_verification_writable',
                    'x_lang_output',
                ],
                'required': [
                    'intl_verification_writable',
                ],
                'nullable': [
                ],
                'enum': [
                    'x_lang_output',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('x_lang_output',): {

                        "NATIVE": "native",
                        "MATCH": "match"
                    },
                },
                'openapi_types': {
                    'intl_verification_writable':
                        (IntlVerificationWritable,),
                    'x_lang_output':
                        (str,),
                },
                'attribute_map': {
                    'x_lang_output': 'x-lang-output',
                },
                'location_map': {
                    'intl_verification_writable': 'body',
                    'x_lang_output': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

    def verifyBulk(
        self,
        intl_verifications_payload,
        **kwargs
    ):
        """verifyBulk  # noqa: E501

        Verify a list of international (except US or US territories) address with a live API key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.verifyBulk(intl_verifications_payload, async_req=True)
        >>> result = thread.get()

        Args:
            intl_verifications_payload (IntlVerificationsPayload):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            IntlVerifications
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['intl_verifications_payload'] = \
            intl_verifications_payload
        return self.verifyBulk_endpoint.call_with_http_info(**kwargs)

    def verifySingle(
        self,
        intl_verification_writable,
        **kwargs
    ):
        """verifySingle  # noqa: E501

        Verify an international (except US or US territories) address with a live API key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.verifySingle(intl_verification_writable, async_req=True)
        >>> result = thread.get()

        Args:
            intl_verification_writable (IntlVerificationWritable):

        Keyword Args:
            x_lang_output (str): * `native` - Translate response to the native language of the country in the request * `match` - match the response to the language in the request  Default response is in English. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            IntlVerification
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['intl_verification_writable'] = \
            intl_verification_writable
        return self.verifySingle_endpoint.call_with_http_info(**kwargs)

