#
# author: Jungtaek Kim (jtkim@postech.ac.kr)
# last updated: February 8, 2021
#

import numpy as np

from bayeso_benchmarks.benchmark_base import Function


def fun_target(bx, dim_bx):
    assert len(bx.shape) == 1
    assert bx.shape[0] == dim_bx

    y = 2 * bx[0]**2 - 1.05 * bx[0]**4 + 1.0 / 6.0 * bx[0]**6 + bx[0] * bx[1] + bx[1]**2
    return y


class ThreeHumpCamel(Function):
    def __init__(self, seed=None):
        assert isinstance(seed, (type(None), int))

        dim_bx = 2
        bounds = np.array([
            [-5.0, 5.0],
            [-5.0, 5.0],
        ])
        assert bounds.shape[0] == dim_bx
        assert bounds.shape[1] == 2

        global_minimizers = np.array([
            [0.0, 0.0],
        ])
        global_minimum = 0.0
        function = lambda bx: fun_target(bx, dim_bx)

        try:
            super().__init__(dim_bx, bounds, global_minimizers, global_minimum, function, seed=seed)
        except:
            super(ThreeHumpCamel, self).__init__(dim_bx, bounds, global_minimizers, global_minimum, function, seed=seed)
