'''
@lanhuage: python
@Descripttion:  (1)get a json file, an origin image \n
                (2)make a convertion \n
                (3)get corresponding json file and converted image
@version: beta
@Author: xiaoshuyui
@Date: 2020-07-17 15:09:27
LastEditors: xiaoshuyui
LastEditTime: 2020-08-19 10:58:50
'''

import sys
sys.path.append('..')
# import warnings
from skimage import io
import skimage.util.noise as snoise
# from skimage import morphology
import cv2
import os
from .convert import processor
from .getMultiShapes import getMultiShapes
# from utils.img2base64 import imgEncode
from .methods.img2base64 import imgEncode
from .methods import rmQ
import traceback
# from .entity import *
from .methods.entity import *
import numpy as np
import shutil
import json
# from .logger import logger
from .methods.logger import logger
import random



def imgFlip(oriImg:str,oriLabel:str,flip_list=[1,0,-1],flag=True):
    """
    flipList: flip type. see cv2.flip :
    1: 水平翻转 \n
    0: 垂直翻转 \n
    -1: 同时翻转 \n
    >>> import cv2
    >>> help(cv2.flip)
    """
    if isinstance(oriImg,str) :
        if os.path.exists(oriImg):
            img = io.imread(oriImg)
        else:
            raise FileNotFoundError('Original image not found')
    else:
        img = oriImg

    try:
        if len(flip_list)>1 and (1 in flip_list or 0 in flip_list or -1 in flip_list):
            # mask = processor(oriLabel,flag=True)
            if isinstance(oriLabel,str):
                mask = processor(oriLabel,flag=True)
            elif isinstance(oriLabel,np.ndarray):
                mask = oriLabel
            else:
                raise TypeError("input parameter 'oriLabel' type is not supported")
            # print(type(mask))
            h_ori = cv2.flip(img,1)
            v_ori = cv2.flip(img,0)
            h_v_ori = cv2.flip(img,-1)

            h_mask = cv2.flip(mask,1) if 1 in flip_list else None
            v_mask = cv2.flip(mask,0) if 0 in flip_list else None
            h_v_mask = cv2.flip(mask,-1) if -1 in flip_list else None

            """
            maybe dict zip is better :)
            """

            if flag:
                parent_path = os.path.dirname(oriLabel)
                if os.path.exists(parent_path+os.sep+'jsons_'):
                    pass
                else:
                    os.makedirs(parent_path+os.sep+'jsons_')
                fileName = oriLabel.split(os.sep)[-1].replace('.json','')

                io.imsave(parent_path+os.sep+'jsons_'+os.sep+fileName+'_h.jpg',h_ori) if 1 in flip_list else print()
                io.imsave(parent_path+os.sep+'jsons_'+os.sep+fileName+'_v.jpg',v_ori) if 0 in flip_list else print()
                io.imsave(parent_path+os.sep+'jsons_'+os.sep+fileName+'_h_v.jpg',h_v_ori) if -1 in flip_list else print()


                h_j = getMultiShapes(parent_path+os.sep+'jsons_'+os.sep+fileName+'_h.jpg',h_mask,flag=True,labelYamlPath='') if h_mask is not None else None
                # h_j = getMultiShapes(parent_path+os.sep+'jsons_'+os.sep+fileName+'_h.jpg',h_mask,flag=True,labelYamlPath='D:\\testALg\\mask2json\\mask2json\\multi_objs_json\\info.yaml')
                v_j = getMultiShapes(parent_path+os.sep+'jsons_'+os.sep+fileName+'_v.jpg',v_mask,flag=True,labelYamlPath='') if v_mask is not None else None
                h_v_j = getMultiShapes(parent_path+os.sep+'jsons_'+os.sep+fileName+'_h_v.jpg',h_v_mask,flag=True,labelYamlPath='') if h_v_mask is not None else None

                for saveJsonPath in [parent_path+os.sep+'jsons_'+os.sep+fileName+'_h.json',
                                    parent_path+os.sep+'jsons_'+os.sep+fileName+'_v.json',
                                    parent_path+os.sep+'jsons_'+os.sep+fileName+'_H_V.json']:
                    
                    # if saveJsonPath is not None:
                        # print(saveJsonPath)
                    if saveJsonPath.endswith('_h.json')  :   
                        if h_j is not None:
                            with open(saveJsonPath,'w') as f:
                                f.write(h_j)
                        else:
                            pass
                    elif saveJsonPath.endswith('_v.json')  :  
                        if v_j is not None:
                            with open(saveJsonPath,'w') as f:
                                f.write(v_j)
                        else:
                            pass
                    elif saveJsonPath.endswith('_H_V.json') :
                        if h_v_j is not None:
                            with open(saveJsonPath,'w') as f:
                                f.write(h_v_j) 
                        else:
                            pass
                
                    rmQ.rm(saveJsonPath) if os.path.exists(saveJsonPath) else print()
                
                return ""
            else:

                d = dict()
                d['h'] = Ori_Pro(h_ori,h_mask)
                d['v'] = Ori_Pro(v_ori,v_mask)
                d['h_v'] = Ori_Pro(h_v_ori,h_v_mask)

                return d
                
        else:
            logger.warning("<===== param:flip_list is not valid =====>")



    except Exception :
        # print(e)
        print(traceback.format_exc())


            

def imgNoise(oriImg:str,oriLabel:str,flag=True):
    """
    see skimage.util.random_noise    
    """ 
    noise_type = ['gaussian','poisson','s&p','speckle']
    
    l = np.random.randint(2,size=len(noise_type)).tolist()
    # print(l)
    p = list(zip(noise_type,l))

    if isinstance(oriImg,str) :
        if os.path.exists(oriImg):
            img = io.imread(oriImg)
        else:
            raise FileNotFoundError('Original image not found')
    else:
        img = oriImg
    
    for i in p:
        if i[1]!=0:
            img = snoise.random_noise(img,mode=i[0])
    
    if flag:
        parent_path = os.path.dirname(oriLabel)
        if os.path.exists(parent_path+os.sep+'jsons_'):
            pass
        else:
            os.makedirs(parent_path+os.sep+'jsons_')
        fileName = oriLabel.split(os.sep)[-1].replace('.json','')

        io.imsave(parent_path+os.sep+'jsons_'+os.sep+fileName+'_noise.jpg',img) 
        
        try:
            if isinstance(oriLabel,str):
                shutil.copyfile(oriLabel,parent_path+os.sep+'jsons_'+os.sep+fileName+'_noise.json')

                base64code = imgEncode(parent_path+os.sep+'jsons_'+os.sep+fileName+'_noise.jpg')

                with open(parent_path+os.sep+'jsons_'+os.sep+fileName+'_noise.json','r') as f:
                    load_dict = json.load(f)
                
                load_dict['imageData'] = base64code
                
                with open(parent_path+os.sep+'jsons_'+os.sep+fileName+'_noise.json','w') as f:
                    # json.dump(load_dict,parent_path+os.sep+'jsons_'+os.sep+fileName+'_noise.json')
                    f.write(json.dumps(load_dict))

            elif isinstance(oriLabel,np.ndarray):
                """
                labeled file can be an Image
                """
                noisedMask_j = getMultiShapes(parent_path+os.sep+'jsons_'+os.sep+fileName+'_noise.jpg',oriLabel,flag=True,labelYamlPath='')
                with open(parent_path+os.sep+'jsons_'+os.sep+fileName+'_noise.json','w') as f:
                    f.write(json.dumps(noisedMask_j))
        
        except Exception :
            print(traceback.format_exc())
    
    else:
        d = dict()
        # mask = processor(oriLabel,flag=True)
        if isinstance(oriLabel,str):
            mask = processor(oriLabel,flag=True)
        elif isinstance(oriLabel,np.ndarray):
            mask = oriLabel
        else:
            raise TypeError("input parameter 'oriLabel' type is not supported")
        d['noise'] = Ori_Pro(img,mask)

        return d


def imgRotation(oriImg:str,oriLabel:str,angle=30,scale=1,flag=True):
    """
    旋转
    """
    logger.warning('rotation may cause salt-and-pepper noise. in order to solve this issue, small objects may be missing!')
    if isinstance(oriImg,str) :
        if os.path.exists(oriImg):
            img = io.imread(oriImg)
        else:
            raise FileNotFoundError('Original image not found')
    else:
        img = oriImg

    imgShape = img.shape

    if isinstance(oriLabel,str):
        mask = processor(oriLabel,flag=True)
    elif isinstance(oriLabel,np.ndarray):
        mask = oriLabel
    else:
        raise TypeError("input parameter 'oriLabel' type is not supported")


    center = (0.5*imgShape[1],0.5*imgShape[0])
    mat = cv2.getRotationMatrix2D(center,angle,scale)

    affedImg = cv2.warpAffine(img,mat,(imgShape[1],imgShape[0]))
    affedMask = cv2.warpAffine(mask,mat,(imgShape[1],imgShape[0]))
     

    if flag:
        parent_path = os.path.dirname(oriLabel)

        if os.path.exists(parent_path+os.sep+'jsons_'):
            pass
        else:
            os.makedirs(parent_path+os.sep+'jsons_')
        fileName = oriLabel.split(os.sep)[-1].replace('.json','')

        io.imsave(parent_path+os.sep+'jsons_'+os.sep+fileName+'_rotation.jpg',affedImg) 

        affedMask_j = getMultiShapes(parent_path+os.sep+'jsons_'+os.sep+fileName+'_rotation.jpg',affedMask,flag=True,labelYamlPath='') 
        
        saveJsonPath = parent_path+os.sep+'jsons_'+os.sep+fileName+'_rotation.json'
        
        if affedMask_j is not None:
            with open(saveJsonPath,'w') as f:
                f.write(affedMask_j)
        else:
            pass
    
    else:
        d = dict()
        d['rotation'] = Ori_Pro(affedImg,affedMask)

        return d


    
def imgTranslation(oriImg:str,oriLabel:str,flag=True):
    """
    image translation
    """
    if isinstance(oriImg,str) :
        if os.path.exists(oriImg):
            img = io.imread(oriImg)
        else:
            raise FileNotFoundError('Original image not found')
    else:
        img = oriImg

    imgShape = img.shape

    if isinstance(oriLabel,str):
        mask = processor(oriLabel,flag=True)
    elif isinstance(oriLabel,np.ndarray):
        mask = oriLabel
    else:
        raise TypeError("input parameter 'oriLabel' type is not supported")

    
    trans_h = random.randint(0,int(0.5*imgShape[1]))
    trans_v = random.randint(0,int(0.5*imgShape[0]))

    trans_mat = np.float32([[1,0,trans_h],[0,1,trans_v]])

    transImg = cv2.warpAffine(img,trans_mat,(imgShape[1],imgShape[0]))
    transMask = cv2.warpAffine(mask,trans_mat,(imgShape[1],imgShape[0]))

    if flag:
        parent_path = os.path.dirname(oriLabel)

        if os.path.exists(parent_path+os.sep+'jsons_'):
            pass
        else:
            os.makedirs(parent_path+os.sep+'jsons_')
        fileName = oriLabel.split(os.sep)[-1].replace('.json','')

        io.imsave(parent_path+os.sep+'jsons_'+os.sep+fileName+'_translation.jpg',transImg)
        transMask_j = getMultiShapes(parent_path+os.sep+'jsons_'+os.sep+fileName+'_translation.jpg',transMask,flag=True,labelYamlPath='')

        saveJsonPath = parent_path+os.sep+'jsons_'+os.sep+fileName+'_translation.json'

        if transMask_j is not None:
            with open(saveJsonPath,'w') as f:
                f.write(transMask_j)
        else:
            pass
    
    else:
        d = dict()
        d['trans'] = Ori_Pro(transImg,transMask)

        return d


    





def aug_labelme(filepath,jsonpath,augs:list):
    """
    augs: ['flip','noise','affine','rotate','...']
    """

    default_augs =set(['flip','noise','affine','rotate'])
    tmp = set(augs)
    tmp = tmp.difference(default_augs)

    if len(list(tmp))>0:
        logger.warning("some methods not supported right now")
        methods = list(default_augs & set(augs))
    else:
        methods = augs

    if not len(methods)>0:
        pass
    else:
        pass





