"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AzIdToNameMappingFunctionCodeCache = exports.AzIdToNameMapping = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class AzIdToNameMapping extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const handlerPolicy = new aws_cdk_lib_1.aws_iam.ManagedPolicy(this, 'handlerPolicy', {
            statements: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    sid: 'AllowSSMParameterEdit',
                    actions: [
                        'ssm:PutParameter',
                        'ssm:DeleteParameter',
                        'ssm:AddTagsToResource',
                    ],
                    resources: [
                        '*',
                    ],
                    conditions: {
                        StringEquals: {
                            'aws:ResourceTag/CdkAzMappingParameter': 'True',
                        },
                    },
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    sid: 'AllowDescribeAZs',
                    actions: [
                        'ec2:DescribeAvailabilityZones',
                    ],
                    resources: [
                        '*',
                    ],
                }),
            ],
        });
        const role = new aws_cdk_lib_1.aws_iam.Role(this, 'handlerRole', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
            managedPolicies: [
                handlerPolicy,
            ],
        });
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'handler', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
            code: props.lambdaCode ?? aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '../lambda')),
            handler: 'index.handler',
            description: 'Stores VPC mappings into parameter store',
            timeout: aws_cdk_lib_1.Duration.seconds(5),
            logRetention: props.logRetention ?? aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
            role,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'provider', {
            onEventHandler,
            logRetention: props.logRetention ?? aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
        });
        const mapping = new aws_cdk_lib_1.CustomResource(this, 'mapping', {
            serviceToken: provider.serviceToken,
            properties: {
                azIds: props.azIds || ['use1-az2', 'use1-az4', 'use1-az6'],
                prefix: props.ssmParameterPrefix || '/az-mapping/',
            },
        });
        this.mapping = mapping.getAtt('azIds').toString();
    }
}
exports.AzIdToNameMapping = AzIdToNameMapping;
_a = JSII_RTTI_SYMBOL_1;
AzIdToNameMapping[_a] = { fqn: "@renovosolutions/cdk-library-multi-account-az-mapping.AzIdToNameMapping", version: "0.0.42" };
class AzIdToNameMappingFunctionCodeCache extends aws_cdk_lib_1.aws_s3.Bucket {
    constructor(scope, id, props) {
        const removalPolicy = props.removalPolicy ?? aws_cdk_lib_1.RemovalPolicy.DESTROY;
        const autoDeleteObjects = removalPolicy === aws_cdk_lib_1.RemovalPolicy.DESTROY;
        super(scope, id, {
            removalPolicy,
            autoDeleteObjects,
            ...props,
        });
        /** Force the final unzipped asset to be a zip by nesting zips */
        const bundlingCmds = [
            'mkdir -p /asset-output',
            'mkdir -p temp',
            // 'pip install -r /asset-input/requirements.txt -t /asset-input/temp',
            'cp index.py /asset-input/temp/index.py',
            'cd temp',
            'zip -r lambda.zip .',
            'zip -r /asset-output/temp.zip lambda.zip',
            'cd ..',
            'rm -rf ./temp',
        ];
        new aws_cdk_lib_1.aws_s3_deployment.BucketDeployment(this, 'Deployment', {
            sources: [aws_cdk_lib_1.aws_s3_deployment.Source.asset(path.join(__dirname, '../lambda'), {
                    bundling: {
                        image: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9.bundlingImage,
                        command: [
                            'bash', '-c', bundlingCmds.join(' && '),
                        ],
                    },
                })],
            destinationBucket: this,
            exclude: ['__pycache__/*', '*.pyc'],
            include: ['*.py'],
        });
        this.lambdaCode = aws_cdk_lib_1.aws_lambda.Code.fromBucket(this, 'index.py');
    }
    /**
     * Add access to the whole organization to get
     * the lambda function code from the bucket.
     *
     * @param principalOrgId The organization ID to require for any accounts accessing the bucket.
     */
    addOrgWideAccessPolicy(principalOrgId) {
        return this.addToResourcePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            principals: [new aws_cdk_lib_1.aws_iam.StarPrincipal],
            actions: [
                's3:GetObject',
            ],
            resources: [this.arnForObjects('*')],
            conditions: {
                StringEquals: {
                    'aws:PrincipalOrgID': principalOrgId,
                },
            },
        }));
    }
    ;
    /**
     * Add access to the specified accounts to get
     * the lambda function code from the bucket.
     *
     * @param principalAccountId The account ID to add access for.
     * @param principalOrgId (Optional) The organization ID to require for the account accessing the bucket.
     */
    addAccountAccessPolicy(principalAccountId, principalOrgId) {
        return this.addToResourcePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            principals: [new aws_cdk_lib_1.aws_iam.AccountPrincipal(principalAccountId)],
            actions: ['s3:GetObject'],
            resources: [this.arnForObjects('*')],
            conditions: principalOrgId === undefined ? undefined : {
                StringEquals: {
                    'aws:PrincipalOrgID': principalOrgId,
                },
            },
        }));
    }
    ;
    /**
     * Add access to the specified organizational units to get
     * the lambda function code from the bucket.
     *
     * @param principalOrgPaths The organizational unit paths to add access for.
     */
    addOrgOuAccessPolicy(principalOrgPaths) {
        return this.addToResourcePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            principals: [new aws_cdk_lib_1.aws_iam.StarPrincipal],
            actions: ['s3:GetObject'],
            resources: [this.arnForObjects('*')],
            conditions: {
                StringLike: {
                    'aws:PrincipalOrgPaths': principalOrgPaths,
                },
            },
        }));
    }
}
exports.AzIdToNameMappingFunctionCodeCache = AzIdToNameMappingFunctionCodeCache;
_b = JSII_RTTI_SYMBOL_1;
AzIdToNameMappingFunctionCodeCache[_b] = { fqn: "@renovosolutions/cdk-library-multi-account-az-mapping.AzIdToNameMappingFunctionCodeCache", version: "0.0.42" };
;
//# sourceMappingURL=data:application/json;base64,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