# Notes
Procedure vs. Function

- https://www.enterprisedb.com/postgres-tutorials/everything-you-need-know-about-postgres-stored-procedures-and-functions
- sqlalchemy has `func`, but no `proc` AFAICT

Postgres `RAISE`
https://www.postgresql.org/docs/9.6/plpgsql-errors-and-messages.html

## Handling specific psycopg2 Errors with SQLAlchemy
See
[tests/test_handle_psycopg2_errors.py](tests/test_handle_psycopg2_errors.py).

## Postgres: log more.
Get sample config
```
docker-compose exec db cat /usr/share/postgresql/postgresql.conf.sample > /tmp/postgresql.conf
```

Edit config, apply, check logs:
```
vi env/dev/etc_postgresql/postgresql.conf
make db_reload
make db_logs
```


# Running mampf as systemd user service
https://wiki.archlinux.org/index.php/Systemd/User
```
mkdir -p ~/.config/systemd/user/
cat <<EOF > ~/.config/systemd/user/mampf.service
[Unit]
Description=puddl mampf run

[Service]
ExecStart=%h/.pyenv/shims/puddl mampf run

[Install]
WantedBy=default.target
EOF

systemctl --user enable mampf
systemctl --user status mampf
journalctl --user -fu mampf
```
