# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/sklegos.ipynb (unless otherwise specified).

__all__ = ['train_test_split', 'ColumnSelector', 'MakeFrame', 'ImputeMissingValues', 'MakeFrame', 'Cat2Num']

# Cell
from .loader import  *

try:
    from sklearn.model_selection import train_test_split
except ModuleNotFoundError:
    logger.Exception('Please `pip install scikit-learn sklego` to use this submodule')

train_test_split = train_test_split

# Cell
from sklearn.base import BaseEstimator, TransformerMixin, MetaEstimatorMixin
from sklego.preprocessing import ColumnSelector
ColumnSelector = ColumnSelector

# Cell
class MakeFrame(BaseEstimator, TransformerMixin):
    '''Convert sklearn's output to a pandas dataframe
    Especially useful when working with an ensemble of models
    '''
    def __init__(self, column_names):
        self.column_names = column_names

    def fit(self, X, y=None):
        return X

    def transform(self, X, y=None):
        return pd.DataFrame(X, columns=self.column_names)


# Cell
class ImputeMissingValues(BaseEstimator, TransformerMixin):
    '''DataFrame input - DataFrame output
    During fit -
    1. Automatically identify columns with missing values
    2. Store imputable value for each column
    During transform -
    3. Impute missing values
    4. Create a '{col}_na' boolean column to tell if it contained missing value
    '''
    def __init__(self, num_mode=np.mean, cat_mode='MISSING'):
        self.num_mode = num_mode
        self.cat_mode = lambda x: cat_mode if isinstance(cat_mode, str) else cat_mode

    def fit(self, trn_df, y=None):
        assert isinstance(df, pd.DataFrame), '''
        Transform is a df-input df-output transform
        '''.strip()
        x = trn_df.isna().mean()
        x = x[x != 0].index.tolist()
        self.missing_value_columns = x
        logger.info(f'Identified {self.missing_value_columns} to have missing values')
        self.imputable_values = {}
        for col in self.missing_value_columns:
            _col = trn_df[col]
            a = (~_col.isna())
            ixs = a[a].index
            _col = _col[ixs]
            if _col.dtype != 'object':
                self.imputable_values[col] = self.num_mode(_col.values)
            else:
                self.imputable_values[col] = self.cat_mode(_col.values)
        return trn_df

    def transform(self, X, y=None):
        X = X.copy()
        for col in self.missing_value_columns:
            ixs = X[col].isna()
            jxs = ixs[ixs].index
            X.loc[jxs, col] = [self.imputable_values[col]]*len(jxs)
            X[f'{col}_na'] = ixs
        return X

    def fit_transform(self, trn_df, y=None):
        return self.transform(self.fit(trn_df, y))

# Cell
class MakeFrame(BaseEstimator, TransformerMixin):
    def __init__(self, column_names):
        self.column_names = column_names

    def fit(self, X, y=None):
        return X

    def transform(self, X, y=None):
        return pd.DataFrame(X, columns=self.column_names)

    def predict_proba(self, X, y=None):
        return self.transform(X)

    def predict(self, X, y=None):
        return self.transform(X)

# Cell
from collections import defaultdict
class Cat2Num(BaseEstimator, TransformerMixin):
    def __init__(self): ...

    def fit(self, df, y=None):
        self.cat_cols = df.select_dtypes('object').columns
        self.ids = {}
        for col in self.cat_cols:
            _d = defaultdict(lambda : 0) # 0 is reserved for the unknown
            _d.update({id:ix+1 for ix,id in enumerate(df[col].unique())})
            self.ids[col] = _d
        return df

    def transform(self, df, y=None):
        for col in self.cat_cols:
            df.loc[:, col] = df[col].map(lambda x: self.ids[col][x])
        return df

    def fit_transform(self, trn_df, y=None):
        return self.transform(self.fit(trn_df, y))