# Copyright (c) 2021 Emanuele Bellocchia
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

#
# Imports
#
from telegram_payment_bot.bot.bot_base import BotBase
from telegram_payment_bot.bot.bot_config_cfg import BotConfigCfg
from telegram_payment_bot.bot.bot_handlers_cfg import BotHandlersCfg
from telegram_payment_bot.payment.payments_check_scheduler import PaymentsCheckScheduler


#
# Classes
#

# Payment bot class
class PaymentBot(BotBase):

    payments_check_scheduler: PaymentsCheckScheduler

    # Constructor
    def __init__(self,
                 config_file: str) -> None:
        super().__init__(config_file,
                         BotConfigCfg,
                         BotHandlersCfg)
        # Initialize payment check scheduler
        self.payments_check_scheduler = PaymentsCheckScheduler(self.client,
                                                               self.config,
                                                               self.logger,
                                                               self.translator)
